/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.startup.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;

public final class StartupDialog {
    public static JDialog create(String caption, String message, int messageType) {
        JDialog d;
        Window[] windows = Window.getWindows();
        JDialog jDialog = d = windows == null || windows.length == 0 ? new JDialog(null, caption, Dialog.ModalityType.APPLICATION_MODAL) : new JDialog((Frame)null, caption, true);
        if (message != null) {
            StartupDialog.initDialog(d, message, messageType);
        }
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame.gif", (boolean)true));
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame24.gif", (boolean)true));
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame32.gif", (boolean)true));
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame48.gif", (boolean)true));
        d.setIconImages(icons);
        d.setDefaultCloseOperation(2);
        d.setResizable(false);
        d.setLocationRelativeTo(null);
        d.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && d.isShowing()) {
                    d.removeHierarchyListener(this);
                    d.setAlwaysOnTop(true);
                    d.toFront();
                    d.setAlwaysOnTop(false);
                }
            }
        });
        return d;
    }

    private static void initDialog(final JDialog dialog, String message, int messageType) {
        boolean supportsWindowDecorations;
        final JOptionPane content = new JOptionPane(message, messageType);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)content, "Center");
        dialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            content.getRootPane().setWindowDecorationStyle(StartupDialog.styleFromMessageType(messageType));
        }
        dialog.pack();
        final PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == content && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                }
            }
        };
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                content.setValue(null);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                content.removePropertyChangeListener(listener);
                dialog.getContentPane().removeAll();
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    content.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                content.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        content.addPropertyChangeListener(listener);
    }

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }
}

