/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.component;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.memory.event.InstancesTrackerListener;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InstancesTracker", storages={@Storage(value="$WORKSPACE_FILE$")})
public class InstancesTracker
implements PersistentStateComponent<MyState> {
    private final EventDispatcher<InstancesTrackerListener> myDispatcher = EventDispatcher.create(InstancesTrackerListener.class);
    private MyState myState = new MyState();

    public static InstancesTracker getInstance(@NotNull Project project) {
        if (project == null) {
            InstancesTracker.$$$reportNull$$$0(0);
        }
        return (InstancesTracker)ServiceManager.getService((Project)project, InstancesTracker.class);
    }

    public boolean isTracked(@NotNull String className) {
        if (className == null) {
            InstancesTracker.$$$reportNull$$$0(1);
        }
        return this.myState.classes.containsKey(className);
    }

    public boolean isBackgroundTrackingEnabled() {
        return this.myState.isBackgroundTrackingEnabled;
    }

    @Nullable
    public TrackingType getTrackingType(@NotNull String className) {
        if (className == null) {
            InstancesTracker.$$$reportNull$$$0(2);
        }
        return this.myState.classes.getOrDefault(className, null);
    }

    @NotNull
    public Map<String, TrackingType> getTrackedClasses() {
        HashMap<String, TrackingType> hashMap = new HashMap<String, TrackingType>(this.myState.classes);
        if (hashMap == null) {
            InstancesTracker.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    public void add(@NotNull String name, @NotNull TrackingType type) {
        if (name == null) {
            InstancesTracker.$$$reportNull$$$0(4);
        }
        if (type == null) {
            InstancesTracker.$$$reportNull$$$0(5);
        }
        if (type.equals(this.myState.classes.getOrDefault(name, null))) {
            return;
        }
        this.myState.classes.put(name, type);
        ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).classChanged(name, type);
    }

    public void remove(@NotNull String name) {
        TrackingType removed;
        if (name == null) {
            InstancesTracker.$$$reportNull$$$0(6);
        }
        if ((removed = this.myState.classes.remove(name)) != null) {
            ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).classRemoved(name);
        }
    }

    public void addTrackerListener(@NotNull InstancesTrackerListener listener2) {
        if (listener2 == null) {
            InstancesTracker.$$$reportNull$$$0(7);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addTrackerListener(@NotNull InstancesTrackerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            InstancesTracker.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            InstancesTracker.$$$reportNull$$$0(9);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeTrackerListener(@NotNull InstancesTrackerListener listener2) {
        if (listener2 == null) {
            InstancesTracker.$$$reportNull$$$0(10);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void setBackgroundTackingEnabled(boolean state) {
        boolean oldState = this.myState.isBackgroundTrackingEnabled;
        if (state != oldState) {
            this.myState.isBackgroundTrackingEnabled = state;
            ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).backgroundTrackingValueChanged(state);
        }
    }

    @Nullable
    public MyState getState() {
        return new MyState(this.myState);
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            InstancesTracker.$$$reportNull$$$0(11);
        }
        this.myState = new MyState(state);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/memory/component/InstancesTracker";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/memory/component/InstancesTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTracked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTrackingType";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTrackerListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeTrackerListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyState {
        boolean isBackgroundTrackingEnabled;
        @XCollection(elementTypes={Map.Entry.class})
        final Map<String, TrackingType> classes;

        MyState() {
            this.isBackgroundTrackingEnabled = false;
            this.classes = new ConcurrentHashMap<String, TrackingType>();
        }

        MyState(@NotNull MyState state) {
            if (state == null) {
                MyState.$$$reportNull$$$0(0);
            }
            this.isBackgroundTrackingEnabled = false;
            this.classes = new ConcurrentHashMap<String, TrackingType>();
            this.isBackgroundTrackingEnabled = state.isBackgroundTrackingEnabled;
            for (Map.Entry<String, TrackingType> classState : state.classes.entrySet()) {
                this.classes.put(classState.getKey(), classState.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/xdebugger/memory/component/InstancesTracker$MyState", "<init>"));
        }
    }
}

