/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceUsageTransformer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SliceUsage
extends UsageInfo2UsageAdapter {
    private final SliceUsage myParent;
    public final SliceAnalysisParams params;

    public SliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent) {
        if (element == null) {
            SliceUsage.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            SliceUsage.$$$reportNull$$$0(1);
        }
        super(new UsageInfo(element));
        this.myParent = parent;
        this.params = parent.params;
        assert (this.params != null);
    }

    protected SliceUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            SliceUsage.$$$reportNull$$$0(2);
        }
        if (params == null) {
            SliceUsage.$$$reportNull$$$0(3);
        }
        super(new UsageInfo(element));
        this.myParent = null;
        this.params = params;
    }

    @NotNull
    private static Collection<SliceUsage> transformToLanguageSpecificUsage(@NotNull SliceUsage usage) {
        PsiElement element;
        if (usage == null) {
            SliceUsage.$$$reportNull$$$0(4);
        }
        if ((element = usage.getElement()) == null) {
            List<SliceUsage> list2 = Collections.singletonList(usage);
            if (list2 == null) {
                SliceUsage.$$$reportNull$$$0(5);
            }
            return list2;
        }
        SliceLanguageSupportProvider provider = LanguageSlicing.getProvider(element);
        if (!(provider instanceof SliceUsageTransformer)) {
            List<SliceUsage> list3 = Collections.singletonList(usage);
            if (list3 == null) {
                SliceUsage.$$$reportNull$$$0(6);
            }
            return list3;
        }
        Collection<SliceUsage> transformedUsages = ((SliceUsageTransformer)((Object)provider)).transform(usage);
        Collection<SliceUsage> collection = transformedUsages != null ? transformedUsages : Collections.singletonList(usage);
        if (collection == null) {
            SliceUsage.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public void processChildren(@NotNull Processor<? super SliceUsage> processor2) {
        if (processor2 == null) {
            SliceUsage.$$$reportNull$$$0(8);
        }
        PsiElement element = (PsiElement)ReadAction.compute(() -> ((SliceUsage)this).getElement());
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.checkCanceled();
        CommonProcessors.UniqueProcessor<SliceUsage> uniqueProcessor = new CommonProcessors.UniqueProcessor<SliceUsage>(processor2, (TObjectHashingStrategy)new TObjectHashingStrategy<SliceUsage>(){

            public int computeHashCode(SliceUsage object) {
                return object.getUsageInfo().hashCode();
            }

            public boolean equals(SliceUsage o1, SliceUsage o2) {
                return o1.getUsageInfo().equals((Object)o2.getUsageInfo());
            }
        }){

            public boolean process(SliceUsage usage) {
                return SliceUsage.transformToLanguageSpecificUsage(usage).stream().allMatch(x$0 -> super.process(x$0));
            }
        };
        ApplicationManager.getApplication().runReadAction(() -> this.lambda$processChildren$0(element, (Processor)uniqueProcessor));
    }

    protected abstract void processUsagesFlownFromThe(PsiElement var1, Processor<SliceUsage> var2);

    protected abstract void processUsagesFlownDownTo(PsiElement var1, Processor<SliceUsage> var2);

    public SliceUsage getParent() {
        return this.myParent;
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.params.scope;
        if (analysisScope == null) {
            SliceUsage.$$$reportNull$$$0(9);
        }
        return analysisScope;
    }

    @NotNull
    protected abstract SliceUsage copy();

    public boolean canBeLeaf() {
        return this.getElement() != null;
    }

    private /* synthetic */ void lambda$processChildren$0(PsiElement element, Processor uniqueProcessor) {
        if (this.params.dataFlowToThis) {
            this.processUsagesFlownDownTo(element, (Processor<SliceUsage>)uniqueProcessor);
        } else {
            this.processUsagesFlownFromThe(element, (Processor<SliceUsage>)uniqueProcessor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceUsage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceUsage";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "transformToLanguageSpecificUsage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "transformToLanguageSpecificUsage";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

