/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.ide.TwoPaneIdeView;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.copy.CopyHandlerDelegate;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyHandler {
    private CopyHandler() {
    }

    public static boolean canCopy(PsiElement[] elements2) {
        return CopyHandler.canCopy(elements2, null);
    }

    public static boolean canCopy(PsiElement[] elements2, @Nullable Ref<String> actionName) {
        if (elements2.length > 0) {
            for (CopyHandlerDelegate delegate : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!(delegate instanceof CopyHandlerDelegateBase ? ((CopyHandlerDelegateBase)delegate).canCopy(elements2, true) : delegate.canCopy(elements2))) continue;
                if (actionName != null) {
                    actionName.set((Object)delegate.getActionName(elements2));
                }
                return true;
            }
        }
        return false;
    }

    public static void doCopy(PsiElement[] elements2, PsiDirectory defaultTargetDirectory) {
        if (elements2.length == 0) {
            return;
        }
        for (CopyHandlerDelegate delegate : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canCopy(elements2)) continue;
            delegate.doCopy(elements2, defaultTargetDirectory);
            break;
        }
    }

    public static boolean canClone(PsiElement[] elements2) {
        if (elements2.length > 0) {
            for (CopyHandlerDelegate delegate : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!(delegate instanceof CopyHandlerDelegateBase ? ((CopyHandlerDelegateBase)delegate).canCopy(elements2, true) : delegate.canCopy(elements2))) continue;
                return !(delegate instanceof CopyHandlerDelegateBase) || !((CopyHandlerDelegateBase)delegate).forbidToClone(elements2, true);
            }
        }
        return false;
    }

    public static void doClone(PsiElement element) {
        PsiElement[] elements2 = new PsiElement[]{element};
        for (CopyHandlerDelegate delegate : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canCopy(elements2)) continue;
            if (delegate instanceof CopyHandlerDelegateBase && ((CopyHandlerDelegateBase)delegate).forbidToClone(elements2, false)) {
                return;
            }
            delegate.doClone(element);
            break;
        }
    }

    public static void updateSelectionInActiveProjectView(@NotNull PsiElement newElement, Project project, boolean selectInActivePanel) {
        JComponent component;
        ToolWindow window;
        Content selectedContent;
        String id;
        if (newElement == null) {
            CopyHandler.$$$reportNull$$$0(0);
        }
        if ((id = ToolWindowManager.getInstance((Project)project).getActiveToolWindowId()) != null && (selectedContent = (window = ToolWindowManager.getInstance((Project)project).getToolWindow(id)).getContentManager().getSelectedContent()) != null && (component = selectedContent.getComponent()) instanceof TwoPaneIdeView) {
            ((TwoPaneIdeView)((Object)component)).selectElement(newElement, selectInActivePanel);
            return;
        }
        if (ToolWindowId.PROJECT_VIEW.equals(id)) {
            ProjectView.getInstance(project).selectPsiElement(newElement, true);
        } else if (ToolWindowId.STRUCTURE_VIEW.equals(id)) {
            VirtualFile virtualFile = newElement.getContainingFile().getVirtualFile();
            FileEditor editor = FileEditorManager.getInstance((Project)newElement.getProject()).getSelectedEditor(virtualFile);
            StructureViewFactoryEx.getInstanceEx(project).getStructureViewWrapper().selectCurrentElement(editor, virtualFile, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/refactoring/copy/CopyHandler", "updateSelectionInActiveProjectView"));
    }
}

