/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class OpenedInEditorWeigher
extends ProximityWeigher {
    private static final NotNullLazyKey<VirtualFile[], ProximityLocation> OPENED_EDITORS = NotNullLazyKey.create((String)"openedEditors", location -> FileEditorManager.getInstance((Project)location.getProject()).getOpenFiles());

    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        Project project;
        if (element == null) {
            OpenedInEditorWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            OpenedInEditorWeigher.$$$reportNull$$$0(1);
        }
        if ((project = location.getProject()) == null || project.isDefault()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return Boolean.valueOf(false);
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        return Boolean.valueOf(virtualFile != null && ArrayUtil.find((Object[])((Object[])OPENED_EDITORS.getValue((UserDataHolder)location)), (Object)virtualFile) != -1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/util/proximity/OpenedInEditorWeigher";
        objectArray[2] = "weigh";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

