/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.ide.plugins.newui.ErrorComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.GridCellPluginComponent;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.TextHorizontalLayout;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewListPluginComponent
extends CellPluginComponent {
    private final MyPluginModel myPluginModel;
    private final boolean myMarketplace;
    private boolean myUninstalled;
    public IdeaPluginDescriptor myUpdateDescriptor;
    private final JLabel myNameComponent;
    private final JLabel myIconComponent;
    private final BaselineLayout myLayout;
    private JButton myRestartButton;
    private JButton myInstallButton;
    private JButton myUpdateButton;
    private JCheckBox myEnableDisableButton;
    private JLabel myRating;
    private JLabel myDownloads;
    private JLabel myVersion;
    private JLabel myVendor;
    private JPanel myErrorPanel;
    private JComponent myErrorComponent;
    private OneLineProgressIndicator myIndicator;
    private EventHandler myEventHandler;

    public NewListPluginComponent(@NotNull MyPluginModel pluginModel, @NotNull IdeaPluginDescriptor plugin, boolean marketplace) {
        if (pluginModel == null) {
            NewListPluginComponent.$$$reportNull$$$0(0);
        }
        if (plugin == null) {
            NewListPluginComponent.$$$reportNull$$$0(1);
        }
        super(plugin);
        this.myNameComponent = new JLabel();
        this.myIconComponent = new JLabel(AllIcons.Plugins.PluginLogo_40);
        this.myLayout = new BaselineLayout();
        this.myPluginModel = pluginModel;
        this.myMarketplace = marketplace;
        pluginModel.addComponent(this);
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.setLayout((LayoutManager)((Object)this.myLayout));
        this.myIconComponent.setVerticalAlignment(1);
        this.myIconComponent.setOpaque(false);
        this.myLayout.setIconComponent(this.myIconComponent);
        this.myNameComponent.setText(this.myPlugin.getName());
        this.myLayout.setNameComponent((JLabel)RelativeFont.BOLD.install((Component)this.myNameComponent));
        this.createButtons();
        this.createMetricsPanel();
        if (marketplace) {
            this.updateIcon(false, false);
        } else {
            this.updateErrors();
        }
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress(false);
        }
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    private void createButtons() {
        if (this.myMarketplace) {
            if (InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId())) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myLayout.addButtonComponent(this.myRestartButton);
            } else {
                this.myInstallButton = new InstallButton(false);
                this.myLayout.addButtonComponent(this.myInstallButton);
                this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, null));
                this.myInstallButton.setEnabled(PluginManager.getPlugin(this.myPlugin.getPluginId()) == null);
                ColorButton.setWidth72(this.myInstallButton);
            }
        } else if (this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted()) {
            this.myRestartButton = new RestartButton(this.myPluginModel);
            this.myLayout.addButtonComponent(this.myRestartButton);
            this.myUninstalled = true;
        } else {
            PluginId id;
            InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
            if (pluginsState.wasInstalled(id = this.myPlugin.getPluginId()) || pluginsState.wasUpdated(id)) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myLayout.addButtonComponent(this.myRestartButton);
            } else {
                this.myEnableDisableButton = new JCheckBox(){
                    int myBaseline = -1;

                    @Override
                    public int getBaseline(int width, int height) {
                        if (this.myBaseline == -1) {
                            JCheckBox checkBox2 = new JCheckBox("Foo", true);
                            Dimension size = checkBox2.getPreferredSize();
                            this.myBaseline = checkBox2.getBaseline(size.width, size.height) - JBUIScale.scale((int)1);
                        }
                        return this.myBaseline;
                    }

                    @Override
                    public void setUI(ButtonUI ui) {
                        this.myBaseline = -1;
                        super.setUI(ui);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension size = super.getPreferredSize();
                        int scale = JBUIScale.scale((int)2);
                        return new Dimension(size.width + scale, size.height + scale);
                    }
                };
                this.myLayout.addButtonComponent(this.myEnableDisableButton);
                this.myEnableDisableButton.setOpaque(false);
                this.myEnableDisableButton.setSelected(this.isEnabledState());
                this.myEnableDisableButton.addActionListener(e -> this.myPluginModel.changeEnableDisable(this.myPlugin));
            }
        }
    }

    private void createMetricsPanel() {
        String vendor;
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new TextHorizontalLayout(JBUIScale.scale((int)7))));
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myLayout.addLineComponent((JComponent)panel2);
        if (this.myMarketplace) {
            String rating;
            String downloads = PluginManagerConfigurableNew.getDownloads(this.myPlugin);
            if (downloads != null) {
                this.myDownloads = GridCellPluginComponent.createRatingLabel((JPanel)panel2, downloads, AllIcons.Plugins.Downloads);
            }
            if ((rating = PluginManagerConfigurableNew.getRating(this.myPlugin)) != null) {
                this.myRating = GridCellPluginComponent.createRatingLabel((JPanel)panel2, rating, AllIcons.Plugins.Rating);
            }
        } else {
            String version2;
            String string = version2 = !this.myPlugin.isBundled() || this.myPlugin.allowBundledUpdate() ? this.myPlugin.getVersion() : "bundled";
            if (!StringUtil.isEmptyOrSpaces((String)version2)) {
                this.myVersion = GridCellPluginComponent.createRatingLabel((JPanel)panel2, version2, null);
            }
        }
        String string = vendor = this.myPlugin.isBundled() ? null : StringUtil.trim((String)this.myPlugin.getVendor());
        if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
            this.myVendor = GridCellPluginComponent.createRatingLabel((JPanel)panel2, "fix_label", vendor, null, null, true);
        }
    }

    public void setUpdateDescriptor(@Nullable IdeaPluginDescriptor descriptor2) {
        if (this.myUpdateDescriptor == null && descriptor2 == null) {
            return;
        }
        this.myUpdateDescriptor = descriptor2;
        if (descriptor2 == null) {
            if (this.myVersion != null) {
                this.myVersion.setText(this.myPlugin.getVersion());
            }
            if (this.myUpdateButton != null) {
                this.myUpdateButton.setVisible(false);
            }
        } else {
            if (this.myVersion != null) {
                this.myVersion.setText(this.myPlugin.getVersion() + " " + UIUtil.rightArrow() + " " + descriptor2.getVersion());
            }
            if (this.myUpdateButton == null) {
                this.myUpdateButton = new UpdateButton();
                this.myLayout.addButtonComponent(this.myUpdateButton, 0);
                this.myUpdateButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this.myPlugin, this.myUpdateDescriptor));
            } else {
                this.myUpdateButton.setVisible(true);
            }
        }
        this.doLayout();
    }

    @Override
    public void setListeners(@NotNull LinkListener<? super IdeaPluginDescriptor> listener2, @NotNull LinkListener<String> searchListener, @NotNull EventHandler eventHandler) {
        if (listener2 == null) {
            NewListPluginComponent.$$$reportNull$$$0(2);
        }
        if (searchListener == null) {
            NewListPluginComponent.$$$reportNull$$$0(3);
        }
        if (eventHandler == null) {
            NewListPluginComponent.$$$reportNull$$$0(4);
        }
        this.myEventHandler = eventHandler;
        eventHandler.addAll(this);
    }

    @Override
    protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        Color color;
        if (grayedFg == null) {
            NewListPluginComponent.$$$reportNull$$$0(5);
        }
        if (background == null) {
            NewListPluginComponent.$$$reportNull$$$0(6);
        }
        this.setBackground(background);
        Color nameForeground = null;
        Color otherForeground = grayedFg;
        boolean calcColor = true;
        if (this.mySelection != EventHandler.SelectionType.NONE && (color = UIManager.getColor("Plugins.selectionForeground")) != null) {
            nameForeground = otherForeground = color;
            calcColor = false;
        }
        if (calcColor && !this.myMarketplace) {
            boolean enabled;
            boolean bl = enabled = !this.myUninstalled && (MyPluginModel.isInstallingOrUpdate(this.myPlugin) || this.myPluginModel.isEnabled(this.myPlugin));
            if (!enabled) {
                nameForeground = otherForeground = ListPluginComponent.DisabledColor;
            }
        }
        this.myNameComponent.setForeground(nameForeground);
        if (this.myRating != null) {
            this.myRating.setForeground(otherForeground);
        }
        if (this.myDownloads != null) {
            this.myDownloads.setForeground(otherForeground);
        }
        if (this.myVersion != null) {
            this.myVersion.setForeground(otherForeground);
        }
        if (this.myVendor != null) {
            this.myVendor.setForeground(otherForeground);
        }
    }

    @Override
    public void updateErrors() {
        boolean errors = this.myPluginModel.hasErrors(this.myPlugin);
        this.updateIcon(errors, this.myUninstalled || !this.myPluginModel.isEnabled(this.myPlugin));
        if (this.myUpdateButton != null) {
            this.myUpdateButton.setVisible(this.myUpdateDescriptor != null && !errors);
        }
        if (this.myEnableDisableButton != null) {
            this.myEnableDisableButton.setVisible(!errors);
        }
        if (errors) {
            boolean addListeners;
            boolean bl = addListeners = this.myErrorComponent == null && this.myEventHandler != null;
            if (this.myErrorPanel == null) {
                this.myErrorPanel = new NonOpaquePanel();
                this.myLayout.addLineComponent(this.myErrorPanel);
            }
            Ref enableAction = new Ref();
            String message = this.myPluginModel.getErrorMessage((PluginDescriptor)this.myPlugin, (Ref<? super String>)enableAction);
            this.myErrorComponent = ErrorComponent.show(this.myErrorPanel, "Center", this.myErrorComponent, message, (String)enableAction.get(), enableAction.isNull() ? null : () -> this.myPluginModel.enableRequiredPlugins(this.myPlugin));
            this.myErrorComponent.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            if (addListeners) {
                this.myEventHandler.add(this.myErrorPanel);
                this.myEventHandler.add(this.myErrorComponent);
            }
        } else if (this.myErrorPanel != null) {
            this.myLayout.removeLineComponent(this.myErrorPanel);
            this.myErrorPanel = null;
            this.myErrorComponent = null;
        }
    }

    @Override
    protected void updateIcon(boolean errors, boolean disabled) {
        this.myIconComponent.setIcon(PluginLogo.getIcon(this.myPlugin, false, PluginManagerConfigurableNew.isJBPlugin(this.myPlugin), errors, disabled));
    }

    @Override
    public void showProgress() {
        this.showProgress(true);
    }

    private void showProgress(boolean repaint) {
        this.myIndicator = new OneLineProgressIndicator(false);
        this.myIndicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, false, false));
        this.myLayout.setProgressComponent(this.myIndicator.createBaselineWrapper());
        MyPluginModel.addProgress(this.myPlugin, this.myIndicator);
        if (repaint) {
            this.fullRepaint();
        }
    }

    @Override
    public void hideProgress(boolean success) {
        this.myIndicator = null;
        this.myLayout.removeProgressComponent();
        if (success) {
            this.enableRestart();
        }
        this.fullRepaint();
    }

    @Override
    public void clearProgress() {
        this.myIndicator = null;
    }

    @Override
    public void enableRestart() {
        if (this.myInstallButton != null) {
            this.myLayout.removeButtonComponent(this.myInstallButton);
            this.myInstallButton = null;
        }
        if (this.myUpdateButton != null) {
            this.myLayout.removeButtonComponent(this.myUpdateButton);
            this.myUpdateButton = null;
        }
        if (this.myEnableDisableButton != null) {
            this.myLayout.removeButtonComponent(this.myEnableDisableButton);
            this.myEnableDisableButton = null;
        }
        if (this.myRestartButton == null) {
            this.myRestartButton = new RestartButton(this.myPluginModel);
            this.myLayout.addButtonComponent(this.myRestartButton);
        }
    }

    @Override
    public void updateEnabledState() {
        if (!this.myUninstalled && this.myEnableDisableButton != null) {
            this.myEnableDisableButton.setSelected(this.isEnabledState());
        }
        this.updateErrors();
        this.setSelection(this.mySelection, false);
    }

    @Override
    public void updateAfterUninstall() {
        this.myUninstalled = true;
        this.updateColors(this.mySelection);
        this.enableRestart();
    }

    public void updatePlugin() {
        if (!this.myMarketplace && this.myUpdateButton != null && this.myUpdateButton.isVisible()) {
            this.myUpdateButton.doClick();
        }
    }

    private boolean isEnabledState() {
        return this.myPluginModel.isEnabled(this.myPlugin);
    }

    @Override
    public boolean isMarketplace() {
        return this.myMarketplace;
    }

    @Override
    public void close() {
        if (this.myIndicator != null) {
            MyPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.myIndicator = null;
        }
        this.myPluginModel.removeComponent(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createPopupMenu(@NotNull DefaultActionGroup group, final @NotNull List<? extends CellPluginComponent> selection) {
        boolean bl;
        if (group == null) {
            NewListPluginComponent.$$$reportNull$$$0(7);
        }
        if (selection == null) {
            NewListPluginComponent.$$$reportNull$$$0(8);
        }
        for (CellPluginComponent cellPluginComponent : selection) {
            if (!MyPluginModel.isInstallingOrUpdate(cellPluginComponent.myPlugin)) continue;
            return;
        }
        boolean restart2 = true;
        for (CellPluginComponent cellPluginComponent : selection) {
            if (((NewListPluginComponent)cellPluginComponent).myRestartButton != null) continue;
            restart2 = false;
            break;
        }
        if (restart2) {
            group.add((AnAction)new ListPluginComponent.ButtonAnAction(((NewListPluginComponent)selection.get((int)0)).myRestartButton));
            return;
        }
        int n = selection.size();
        if (this.myMarketplace) {
            JButton[] jButtonArray = new JButton[n];
            for (int i = 0; i < n; ++i) {
                JButton jButton = ((NewListPluginComponent)selection.get((int)i)).myInstallButton;
                if (jButton == null || !jButton.isVisible() || !jButton.isEnabled()) {
                    return;
                }
                jButtonArray[i] = jButton;
            }
            group.add((AnAction)new ListPluginComponent.ButtonAnAction(jButtonArray));
            return;
        }
        boolean bl2 = true;
        for (CellPluginComponent cellPluginComponent : selection) {
            if (!this.myPluginModel.hasErrors(cellPluginComponent.myPlugin)) continue;
            bl = false;
            break;
        }
        if (bl) {
            void var7_17;
            JButton[] updateButtons = new JButton[n];
            boolean bl3 = false;
            while (var7_17 < n) {
                JButton button3 = ((NewListPluginComponent)selection.get((int)var7_17)).myUpdateButton;
                if (button3 == null || !button3.isVisible()) {
                    updateButtons = null;
                    break;
                }
                updateButtons[var7_17] = button3;
                ++var7_17;
            }
            if (updateButtons != null) {
                group.add((AnAction)new ListPluginComponent.ButtonAnAction(updateButtons));
                if (n > 1) {
                    return;
                }
            }
            final Pair<Boolean, IdeaPluginDescriptor[]> pair = NewListPluginComponent.getSelectionNewState(selection);
            group.add((AnAction)new ListPluginComponent.MyAnAction((Boolean)pair.first != false ? "Enable" : "Disable", null, 32){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    NewListPluginComponent.this.myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])pair.second, (Boolean)pair.first);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/NewListPluginComponent$2", "actionPerformed"));
                }
            });
        }
        for (CellPluginComponent cellPluginComponent : selection) {
            if (!((NewListPluginComponent)cellPluginComponent).myUninstalled && !cellPluginComponent.myPlugin.isBundled()) continue;
            return;
        }
        if (group.getChildrenCount() > 0) {
            group.addSeparator();
        }
        group.add((AnAction)new ListPluginComponent.MyAnAction("Uninstall", "EditorDelete", EventHandler.DELETE_CODE){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!MyPluginModel.showUninstallDialog(selection)) {
                    return;
                }
                for (CellPluginComponent component : selection) {
                    NewListPluginComponent.this.myPluginModel.doUninstall(component, component.myPlugin, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/NewListPluginComponent$3", "actionPerformed"));
            }
        });
    }

    @Override
    public void handleKeyAction(int keyCode, @NotNull List<? extends CellPluginComponent> selection) {
        block22: {
            boolean bl;
            boolean restart2;
            block20: {
                block21: {
                    if (selection == null) {
                        NewListPluginComponent.$$$reportNull$$$0(9);
                    }
                    for (CellPluginComponent cellPluginComponent : selection) {
                        if (!MyPluginModel.isInstallingOrUpdate(cellPluginComponent.myPlugin)) continue;
                        return;
                    }
                    restart2 = true;
                    for (CellPluginComponent cellPluginComponent : selection) {
                        if (((NewListPluginComponent)cellPluginComponent).myRestartButton != null) continue;
                        restart2 = false;
                        break;
                    }
                    if (this.myMarketplace) {
                        if (keyCode == 10) {
                            if (restart2) {
                                ((NewListPluginComponent)selection.get((int)0)).myRestartButton.doClick();
                            }
                            for (CellPluginComponent cellPluginComponent : selection) {
                                JButton jButton = ((NewListPluginComponent)cellPluginComponent).myInstallButton;
                                if (jButton != null && jButton.isVisible() && jButton.isEnabled()) continue;
                                return;
                            }
                            for (CellPluginComponent cellPluginComponent : selection) {
                                ((NewListPluginComponent)cellPluginComponent).myInstallButton.doClick();
                            }
                        }
                        return;
                    }
                    boolean bl2 = true;
                    for (CellPluginComponent cellPluginComponent : selection) {
                        JButton button3 = ((NewListPluginComponent)cellPluginComponent).myUpdateButton;
                        if (button3 != null && button3.isVisible()) continue;
                        bl = false;
                        break;
                    }
                    if (keyCode != 10) break block20;
                    if (!restart2) break block21;
                    ((NewListPluginComponent)selection.get((int)0)).myRestartButton.doClick();
                    break block22;
                }
                if (!bl) break block22;
                for (CellPluginComponent cellPluginComponent : selection) {
                    ((NewListPluginComponent)cellPluginComponent).myUpdateButton.doClick();
                }
                break block22;
            }
            if (!restart2 && !bl) {
                if (keyCode == 32) {
                    for (CellPluginComponent cellPluginComponent : selection) {
                        if (!this.myPluginModel.hasErrors(cellPluginComponent.myPlugin)) continue;
                        return;
                    }
                    if (selection.size() == 1) {
                        this.myPluginModel.changeEnableDisable(selection.get((int)0).myPlugin);
                    } else {
                        Pair<Boolean, IdeaPluginDescriptor[]> pair = NewListPluginComponent.getSelectionNewState(selection);
                        this.myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])pair.second, (Boolean)pair.first);
                    }
                } else if (keyCode == EventHandler.DELETE_CODE) {
                    for (CellPluginComponent cellPluginComponent : selection) {
                        if (!((NewListPluginComponent)cellPluginComponent).myUninstalled && !cellPluginComponent.myPlugin.isBundled()) continue;
                        return;
                    }
                    if (!MyPluginModel.showUninstallDialog(selection)) {
                        return;
                    }
                    for (CellPluginComponent cellPluginComponent : selection) {
                        this.myPluginModel.doUninstall(this, cellPluginComponent.myPlugin, null);
                    }
                }
            }
        }
    }

    @NotNull
    private static Pair<Boolean, IdeaPluginDescriptor[]> getSelectionNewState(@NotNull List<? extends CellPluginComponent> selection) {
        if (selection == null) {
            NewListPluginComponent.$$$reportNull$$$0(10);
        }
        boolean state = ((NewListPluginComponent)selection.get(0)).isEnabledState();
        boolean setTrue = false;
        ListIterator<? extends CellPluginComponent> I = selection.listIterator(1);
        while (I.hasNext()) {
            if (state == ((NewListPluginComponent)I.next()).isEnabledState()) continue;
            setTrue = true;
            break;
        }
        int size = selection.size();
        IdeaPluginDescriptor[] plugins2 = new IdeaPluginDescriptor[size];
        for (int i = 0; i < size; ++i) {
            plugins2[i] = selection.get((int)i).myPlugin;
        }
        Pair pair = Pair.create((Object)(setTrue || !state ? 1 : 0), (Object)plugins2);
        if (pair == null) {
            NewListPluginComponent.$$$reportNull$$$0(11);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grayedFg";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/NewListPluginComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/NewListPluginComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionNewState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPopupMenu";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionNewState";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BaselineLayout
    extends AbstractLayoutManager {
        private final JBValue myHGap = new JBValue.Float(10.0f);
        private final JBValue myHOffset = new JBValue.Float(8.0f);
        private final JBValue myButtonOffset = new JBValue.Float(6.0f);
        private JComponent myIconComponent;
        private JLabel myNameComponent;
        private JComponent myProgressComponent;
        private final List<JComponent> myButtonComponents = new ArrayList<JComponent>();
        private final List<JComponent> myLineComponents = new ArrayList<JComponent>();
        private boolean[] myButtonEnableStates;

        private BaselineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result2 = new Dimension(this.myNameComponent.getPreferredSize());
            if (this.myProgressComponent == null) {
                int count = this.myButtonComponents.size();
                if (count > 0) {
                    int visibleCount = 0;
                    for (Component component : this.myButtonComponents) {
                        if (!component.isVisible()) continue;
                        Dimension size = component.getPreferredSize();
                        result2.width += size.width;
                        result2.height = Math.max(result2.height, size.height);
                        ++visibleCount;
                    }
                    if (visibleCount > 0) {
                        result2.width += this.myHOffset.get();
                        result2.width += (visibleCount - 1) * this.myButtonOffset.get();
                    }
                }
            } else {
                Dimension size = this.myProgressComponent.getPreferredSize();
                result2.width += this.myHOffset.get() + size.width;
                result2.height = Math.max(result2.height, size.height);
            }
            for (JComponent component : this.myLineComponents) {
                Dimension size = component.getPreferredSize();
                result2.width = Math.max(result2.width, size.width);
                result2.height += size.height;
            }
            Dimension iconSize = this.myIconComponent.getPreferredSize();
            result2.width += iconSize.width + this.myHGap.get();
            result2.height = Math.max(result2.height, iconSize.height);
            JBInsets.addTo((Dimension)result2, (Insets)NewListPluginComponent.this.getInsets());
            return result2;
        }

        public void layoutContainer(Container parent) {
            Insets insets = NewListPluginComponent.this.getInsets();
            int x = insets.left;
            int y = insets.top;
            Dimension iconSize = this.myIconComponent.getPreferredSize();
            this.myIconComponent.setBounds(x, y, iconSize.width, iconSize.height);
            x += iconSize.width + this.myHGap.get();
            int calcNameWidth = this.calculateNameWidth();
            Dimension nameSize = this.myNameComponent.getPreferredSize();
            int baseline = (y += JBUIScale.scale((int)2)) + this.myNameComponent.getBaseline(nameSize.width, nameSize.height);
            this.myNameComponent.setToolTipText(calcNameWidth < nameSize.width ? this.myNameComponent.getText() : null);
            nameSize.width = Math.min(nameSize.width, calcNameWidth);
            this.myNameComponent.setBounds(x, y, nameSize.width, nameSize.height);
            y += nameSize.height;
            int width = NewListPluginComponent.this.getWidth();
            if (this.myProgressComponent == null) {
                int lastX = width - insets.right;
                for (int i = this.myButtonComponents.size() - 1; i >= 0; --i) {
                    Component component = this.myButtonComponents.get(i);
                    if (!component.isVisible()) continue;
                    Dimension size = component.getPreferredSize();
                    this.setBaselineBounds(lastX -= size.width, baseline, component, size);
                    lastX -= this.myButtonOffset.get();
                }
            } else {
                Dimension size = this.myProgressComponent.getPreferredSize();
                this.setBaselineBounds(width - size.width - insets.right, baseline, this.myProgressComponent, size);
            }
            int lineWidth = width - x - insets.right;
            for (JComponent jComponent : this.myLineComponents) {
                int lineHeight = jComponent.getPreferredSize().height;
                jComponent.setBounds(x, y, lineWidth, lineHeight);
                y += lineHeight;
            }
        }

        private int calculateNameWidth() {
            Insets insets = NewListPluginComponent.this.getInsets();
            int width = NewListPluginComponent.this.getWidth() - insets.left - insets.right - this.myIconComponent.getPreferredSize().width - this.myHGap.get();
            if (this.myProgressComponent != null) {
                return width - this.myProgressComponent.getPreferredSize().width - this.myHOffset.get();
            }
            int visibleCount = 0;
            for (Component component : this.myButtonComponents) {
                if (!component.isVisible()) continue;
                width -= component.getPreferredSize().width;
                ++visibleCount;
            }
            width -= this.myButtonOffset.get() * (visibleCount - 1);
            if (visibleCount > 0) {
                width -= this.myHOffset.get();
            }
            return width;
        }

        private void setBaselineBounds(int x, int y, @NotNull Component component, @NotNull Dimension size) {
            if (component == null) {
                BaselineLayout.$$$reportNull$$$0(0);
            }
            if (size == null) {
                BaselineLayout.$$$reportNull$$$0(1);
            }
            component.setBounds(x, y - component.getBaseline(size.width, size.height), size.width, size.height);
        }

        public void setIconComponent(@NotNull JComponent iconComponent) {
            if (iconComponent == null) {
                BaselineLayout.$$$reportNull$$$0(2);
            }
            assert (this.myIconComponent == null);
            this.myIconComponent = iconComponent;
            NewListPluginComponent.this.add(iconComponent);
        }

        public void setNameComponent(@NotNull JLabel nameComponent) {
            if (nameComponent == null) {
                BaselineLayout.$$$reportNull$$$0(3);
            }
            assert (this.myNameComponent == null);
            this.myNameComponent = nameComponent;
            NewListPluginComponent.this.add(this.myNameComponent);
        }

        public void addLineComponent(@NotNull JComponent component) {
            if (component == null) {
                BaselineLayout.$$$reportNull$$$0(4);
            }
            this.myLineComponents.add(component);
            NewListPluginComponent.this.add(component);
        }

        public void removeLineComponent(@NotNull JComponent component) {
            if (component == null) {
                BaselineLayout.$$$reportNull$$$0(5);
            }
            this.myLineComponents.remove(component);
            NewListPluginComponent.this.remove(component);
        }

        public void addButtonComponent(@NotNull JComponent component) {
            if (component == null) {
                BaselineLayout.$$$reportNull$$$0(6);
            }
            this.addButtonComponent(component, -1);
        }

        public void addButtonComponent(@NotNull JComponent component, int index) {
            if (component == null) {
                BaselineLayout.$$$reportNull$$$0(7);
            }
            if (this.myButtonComponents.isEmpty() || index == -1) {
                this.myButtonComponents.add(component);
            } else {
                this.myButtonComponents.add(index, component);
            }
            NewListPluginComponent.this.add(component);
            this.updateVisibleOther();
        }

        public void removeButtonComponent(@NotNull JComponent component) {
            if (component == null) {
                BaselineLayout.$$$reportNull$$$0(8);
            }
            this.myButtonComponents.remove(component);
            NewListPluginComponent.this.remove(component);
            this.updateVisibleOther();
        }

        public void setProgressComponent(@NotNull JComponent progressComponent) {
            if (progressComponent == null) {
                BaselineLayout.$$$reportNull$$$0(9);
            }
            assert (this.myProgressComponent == null);
            this.myProgressComponent = progressComponent;
            NewListPluginComponent.this.add(progressComponent);
            if (NewListPluginComponent.this.myEventHandler != null) {
                NewListPluginComponent.this.myEventHandler.addAll(progressComponent);
                NewListPluginComponent.this.myEventHandler.updateHover(NewListPluginComponent.this);
            }
            this.setVisibleOther(false);
            NewListPluginComponent.this.doLayout();
        }

        public void removeProgressComponent() {
            assert (this.myProgressComponent != null);
            NewListPluginComponent.this.remove(this.myProgressComponent);
            this.myProgressComponent = null;
            this.setVisibleOther(true);
            NewListPluginComponent.this.doLayout();
        }

        private void updateVisibleOther() {
            if (this.myProgressComponent != null) {
                this.myButtonEnableStates = null;
                this.setVisibleOther(false);
            }
        }

        private void setVisibleOther(boolean value) {
            if (this.myButtonComponents.isEmpty()) {
                return;
            }
            if (value) {
                assert (this.myButtonEnableStates != null && this.myButtonEnableStates.length == this.myButtonComponents.size());
                int size = this.myButtonComponents.size();
                for (int i = 0; i < size; ++i) {
                    this.myButtonComponents.get(i).setVisible(this.myButtonEnableStates[i]);
                }
                this.myButtonEnableStates = null;
            } else {
                assert (this.myButtonEnableStates == null);
                this.myButtonEnableStates = new boolean[this.myButtonComponents.size()];
                int size = this.myButtonComponents.size();
                for (int i = 0; i < size; ++i) {
                    Component component = this.myButtonComponents.get(i);
                    this.myButtonEnableStates[i] = component.isVisible();
                    component.setVisible(false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconComponent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameComponent";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressComponent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/NewListPluginComponent$BaselineLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBaselineBounds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setIconComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setNameComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addLineComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeLineComponent";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addButtonComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeButtonComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProgressComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

