/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DoNotShowInspectionIntentionMenuContributor
implements IntentionMenuContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DoNotShowInspectionIntentionMenuContributor");

    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset) {
        if (hostEditor == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(0);
        }
        if (hostFile == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(1);
        }
        if (intentions == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(2);
        }
        Project project = hostFile.getProject();
        PsiElement psiElement = hostFile.findElementAt(offset);
        if (HighlightingLevelManager.getInstance(project).shouldInspect((PsiElement)hostFile)) {
            PsiElement prev;
            PsiElement intentionElement = psiElement;
            int intentionOffset = offset;
            if (psiElement instanceof PsiWhiteSpace && offset == psiElement.getTextRange().getStartOffset() && offset > 0 && (prev = hostFile.findElementAt(offset - 1)) != null && prev.isValid()) {
                intentionElement = prev;
                intentionOffset = offset - 1;
            }
            if (intentionElement != null && intentionElement.getManager().isInProject(intentionElement)) {
                DoNotShowInspectionIntentionMenuContributor.collectIntentionsFromDoNotShowLeveledInspections(project, hostFile, intentionElement, intentionOffset, intentions);
            }
        }
    }

    private static void collectIntentionsFromDoNotShowLeveledInspections(@NotNull Project project, @NotNull PsiFile hostFile, @NotNull PsiElement psiElement, final int offset, final @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        InspectionToolWrapper[] tools;
        if (project == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(3);
        }
        if (hostFile == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(4);
        }
        if (psiElement == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(5);
        }
        if (intentions == null) {
            DoNotShowInspectionIntentionMenuContributor.$$$reportNull$$$0(6);
        }
        if (!psiElement.isPhysical()) {
            VirtualFile virtualFile = hostFile.getVirtualFile();
            String text2 = hostFile.getText();
            LOG.error("not physical: '" + psiElement.getText() + "' @" + offset + " " + psiElement.getTextRange() + " elem:" + psiElement + " (" + psiElement.getClass().getName() + ") in:" + psiElement.getContainingFile() + " host:" + hostFile + "(" + hostFile.getClass().getName() + ")", new Attachment[]{new Attachment(virtualFile != null ? virtualFile.getPresentableUrl() : "null", text2 != null ? text2 : "null")});
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        ArrayList<LocalInspectionToolWrapper> intentionTools = new ArrayList<LocalInspectionToolWrapper>();
        InspectionProfile profile2 = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        for (InspectionToolWrapper toolWrapper2 : tools = profile2.getInspectionTools((PsiElement)hostFile)) {
            HighlightDisplayKey key;
            if (toolWrapper2 instanceof GlobalInspectionToolWrapper) {
                toolWrapper2 = ((GlobalInspectionToolWrapper)toolWrapper2).getSharedLocalInspectionToolWrapper();
            }
            if (!(toolWrapper2 instanceof LocalInspectionToolWrapper) || ((LocalInspectionToolWrapper)toolWrapper2).isUnfair() || !profile2.isToolEnabled(key = HighlightDisplayKey.find((String)toolWrapper2.getShortName()), (PsiElement)hostFile) || !HighlightDisplayLevel.DO_NOT_SHOW.equals(profile2.getErrorLevel(key, (PsiElement)hostFile))) continue;
            intentionTools.add((LocalInspectionToolWrapper)toolWrapper2);
        }
        if (intentionTools.isEmpty()) {
            return;
        }
        List elements2 = PsiTreeUtil.collectParents((PsiElement)psiElement, PsiElement.class, (boolean)true, e -> e instanceof PsiDirectory);
        PsiElement elementToTheLeft = psiElement.getContainingFile().findElementAt(offset - 1);
        if (elementToTheLeft != psiElement && elementToTheLeft != null) {
            List parentsOnTheLeft = PsiTreeUtil.collectParents((PsiElement)elementToTheLeft, PsiElement.class, (boolean)true, e -> e instanceof PsiDirectory || elements2.contains(e));
            elements2.addAll(parentsOnTheLeft);
        }
        Set<String> dialectIds = InspectionEngine.calcElementDialectIds(elements2);
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(hostFile, 0, hostFile.getTextLength());
        Processor processor2 = toolWrapper -> {
            LocalInspectionTool localInspectionTool = (LocalInspectionTool)toolWrapper.getTool();
            final HighlightDisplayKey key = HighlightDisplayKey.find((String)toolWrapper.getShortName());
            final String displayName = toolWrapper.getDisplayName();
            ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance((Project)project), hostFile, true){

                public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
                    QuickFix[] fixes;
                    TextRange range2;
                    if (problemDescriptor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.registerProblem(problemDescriptor);
                    if (problemDescriptor instanceof ProblemDescriptorBase && (range2 = ((ProblemDescriptorBase)problemDescriptor).getTextRange()) != null && range2.containsOffset(offset) && (fixes = problemDescriptor.getFixes()) != null) {
                        for (int k = 0; k < fixes.length; ++k) {
                            IntentionAction intentionAction = QuickFixWrapper.wrap(problemDescriptor, k);
                            HighlightInfo.IntentionActionDescriptor actionDescriptor = new HighlightInfo.IntentionActionDescriptor(intentionAction, null, displayName, null, key, null, HighlightSeverity.INFORMATION);
                            (problemDescriptor.getHighlightType() == ProblemHighlightType.ERROR ? intentions.errorFixesToShow : intentions.intentionsToShow).add(actionDescriptor);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/codeInsight/daemon/impl/DoNotShowInspectionIntentionMenuContributor$1", "registerProblem"));
                }
            };
            InspectionEngine.createVisitorAndAcceptElements(localInspectionTool, holder, true, session2, elements2, dialectIds, InspectionEngine.getDialectIdsSpecifiedForTool(toolWrapper));
            localInspectionTool.inspectionFinished(session2, holder);
            return true;
        };
        ProgressIndicator progress = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressIndicatorProvider.getGlobalProgressIndicator(), (Object)((Object)new DaemonProgressIndicator()));
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(intentionTools, progress, processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DoNotShowInspectionIntentionMenuContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectActions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectIntentionsFromDoNotShowLeveledInspections";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

