/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytestLegacy;

import com.google.common.collect.Lists;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.PythonConfigurationFactoryBase;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonLegacyTestRunConfiguration;
import com.jetbrains.python.testing.PyTestFrameworkService;
import com.jetbrains.python.testing.PyTestLegacyInteropKt;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.PythonTestLegacyConfigurationProducer;
import com.jetbrains.python.testing.TestRunnerService;
import com.jetbrains.python.testing.pytest.PyTestUtil;
import com.jetbrains.python.testing.pytestLegacy.PyTestRunConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTestConfigurationProducer
extends PythonTestLegacyConfigurationProducer<PyTestRunConfiguration> {
    public PyTestConfigurationProducer() {
        if (PyTestLegacyInteropKt.isNewTestsModeEnabled()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        PythonConfigurationFactoryBase pythonConfigurationFactoryBase = PythonTestConfigurationType.getInstance().LEGACY_PYTEST_FACTORY;
        if (pythonConfigurationFactoryBase == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(0);
        }
        return pythonConfigurationFactoryBase;
    }

    @Override
    protected boolean setupConfigurationFromContext(@NotNull AbstractPythonLegacyTestRunConfiguration<PyTestRunConfiguration> configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiDirectory file;
        if (configuration == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(3);
        }
        PsiElement element = (PsiElement)sourceElement.get();
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (!(configuration instanceof PyTestRunConfiguration)) {
            return false;
        }
        if (module2 == null) {
            return false;
        }
        if (!TestRunnerService.getInstance(module2).getProjectConfiguration().equals(PyTestFrameworkService.getSdkReadableNameByFramework("pytest"))) {
            return false;
        }
        Object object = file = element instanceof PsiDirectory ? (PsiDirectory)element : element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file instanceof PyFile || file instanceof PsiDirectory) {
            List<PyStatement> testCases = PyTestConfigurationProducer.getPyTestCasesFromFile((PsiFileSystemItem)file, TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile()));
            if (testCases.isEmpty()) {
                return false;
            }
        } else {
            return false;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(context.getModule());
        if (sdk == null) {
            return false;
        }
        configuration.setUseModuleSdk(true);
        configuration.setModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
        ((PyTestRunConfiguration)configuration).setTestToRun(virtualFile.getPath());
        String keywords = PyTestConfigurationProducer.getKeywords(element, sdk);
        if (keywords != null) {
            ((PyTestRunConfiguration)configuration).useKeyword(true);
            ((PyTestRunConfiguration)configuration).setKeywords(keywords);
            configuration.setName("pytest in " + keywords);
        } else {
            configuration.setName("pytest in " + file.getName());
        }
        return true;
    }

    @Nullable
    private static String getKeywords(@NotNull PsiElement element, @NotNull Sdk sdk) {
        if (element == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(5);
        }
        PyFunction pyFunction = PyTestConfigurationProducer.findTestFunction(element);
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        String keywords = null;
        if (pyFunction != null) {
            keywords = pyFunction.getName();
            if (pyClass != null) {
                PyPackage pytestPackage;
                List<PyPackage> packages = PyPackageManager.getInstance(sdk).getPackages();
                PyPackage pyPackage = pytestPackage = packages != null ? PyPackageUtil.findPackage(packages, "pytest") : null;
                keywords = pytestPackage != null && PyPackageVersionComparator.getSTR_COMPARATOR().compare(pytestPackage.getVersion(), "2.3.3") >= 0 ? pyClass.getName() + " and " + keywords : pyClass.getName() + "." + keywords;
            }
        } else if (pyClass != null) {
            keywords = pyClass.getName();
        }
        return keywords;
    }

    @Nullable
    private static PyFunction findTestFunction(PsiElement element) {
        String name;
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function != null && (name = function.getName()) != null && name.startsWith("test")) {
            return function;
        }
        return null;
    }

    @Override
    public boolean isConfigurationFromContext(@NotNull AbstractPythonLegacyTestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiDirectory file;
        Location location;
        if (configuration == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        if (!(configuration instanceof PyTestRunConfiguration)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        Object object = file = element instanceof PsiDirectory ? (PsiDirectory)element : element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file instanceof PyFile || file instanceof PsiDirectory) {
            List<PyStatement> testCases = PyTestConfigurationProducer.getPyTestCasesFromFile((PsiFileSystemItem)file, TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile()));
            if (testCases.isEmpty()) {
                return false;
            }
        } else {
            return false;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(context.getModule());
        if (sdk == null) {
            return false;
        }
        String keywords = PyTestConfigurationProducer.getKeywords(element, sdk);
        String scriptName = ((PyTestRunConfiguration)configuration).getTestToRun();
        String workingDirectory = configuration.getWorkingDirectory();
        String path = virtualFile.getPath();
        boolean isTestFileEquals = scriptName.equals(path) || path.equals(new File(workingDirectory, scriptName).getAbsolutePath());
        String configurationKeywords = ((PyTestRunConfiguration)configuration).getKeywords();
        return isTestFileEquals && (configurationKeywords.equals(keywords) || StringUtil.isEmptyOrSpaces((String)((PyTestRunConfiguration)configuration).getKeywords()) && keywords == null);
    }

    public static List<PyStatement> getPyTestCasesFromFile(PsiFileSystemItem file, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(8);
        }
        List<Object> result = Lists.newArrayList();
        if (file instanceof PyFile) {
            result = PyTestConfigurationProducer.getResult((PyFile)file, context);
        } else if (file instanceof PsiDirectory) {
            for (PsiFile f : ((PsiDirectory)file).getFiles()) {
                if (!(f instanceof PyFile)) continue;
                result.addAll(PyTestConfigurationProducer.getResult((PyFile)f, context));
            }
        }
        return result;
    }

    private static List<PyStatement> getResult(PyFile file, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTestConfigurationProducer.$$$reportNull$$$0(9);
        }
        ArrayList result = Lists.newArrayList();
        for (PyClass pyClass : file.getTopLevelClasses()) {
            if (!PyTestUtil.isPyTestClass(pyClass, context)) continue;
            result.add(pyClass);
        }
        for (PyFunction pyFunction : file.getTopLevelFunctions()) {
            if (!PyTestUtil.isPyTestFunction(pyFunction)) continue;
            result.add(pyFunction);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/pytestLegacy/PyTestConfigurationProducer";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/pytestLegacy/PyTestConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeywords";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPyTestCasesFromFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

