/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.TypeFieldPair;
import org.jetbrains.yaml.meta.model.YamlMetaClass;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@ApiStatus.Experimental
public class Field {
    private final String myName;
    private final YamlMetaType myMainType;
    private boolean myIsRequired;
    private boolean myEditable;
    private boolean myDeprecated;
    private boolean myAnyNameAllowed;
    private boolean myEmptyValueAllowed;
    private boolean myIsMany;
    private Relation myOverriddenDefaultRelation;
    private final Map<Relation, YamlMetaType> myPerRelationTypes;

    public Field(@NotNull String name, @NotNull YamlMetaType mainType) {
        if (name == null) {
            Field.$$$reportNull$$$0(0);
        }
        if (mainType == null) {
            Field.$$$reportNull$$$0(1);
        }
        this.myEditable = true;
        this.myDeprecated = false;
        this.myPerRelationTypes = new HashMap<Relation, YamlMetaType>();
        this.myName = name;
        this.myMainType = mainType;
    }

    @NotNull
    public Field withDefaultRelation(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(2);
        }
        this.myOverriddenDefaultRelation = relation;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(3);
        }
        return field;
    }

    public Field withRelationSpecificType(@NotNull Relation relation, @NotNull YamlMetaType specificType) {
        if (relation == null) {
            Field.$$$reportNull$$$0(4);
        }
        if (specificType == null) {
            Field.$$$reportNull$$$0(5);
        }
        this.myPerRelationTypes.put(relation, specificType);
        return this;
    }

    @NotNull
    public Field withMultiplicityMany() {
        Field field = this.withMultiplicityManyNotOne(true);
        if (field == null) {
            Field.$$$reportNull$$$0(6);
        }
        return field;
    }

    @NotNull
    public Field withMultiplicityManyNotOne(boolean manyNotOne) {
        this.myIsMany = manyNotOne;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(7);
        }
        return field;
    }

    @Contract(pure=true)
    public boolean isMany() {
        return this.myIsMany;
    }

    @NotNull
    public Field setRequired() {
        this.myIsRequired = true;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(8);
        }
        return field;
    }

    @NotNull
    public Field setDeprecated() {
        this.myDeprecated = true;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(9);
        }
        return field;
    }

    @NotNull
    public Field setNonEditable() {
        this.myEditable = false;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(10);
        }
        return field;
    }

    @Contract(pure=true)
    public final boolean isRequired() {
        return this.myIsRequired;
    }

    @Contract(pure=true)
    public final boolean isEditable() {
        return this.myEditable;
    }

    @Contract(pure=true)
    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    @Contract(pure=true)
    public final String getName() {
        return this.myName;
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getType(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(11);
        }
        YamlMetaType yamlMetaType = this.myPerRelationTypes.getOrDefault((Object)relation, this.myMainType);
        if (yamlMetaType == null) {
            Field.$$$reportNull$$$0(12);
        }
        return yamlMetaType;
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getDefaultType() {
        YamlMetaType yamlMetaType = this.getType(this.getDefaultRelation());
        if (yamlMetaType == null) {
            Field.$$$reportNull$$$0(13);
        }
        return yamlMetaType;
    }

    @NotNull
    public Relation getDefaultRelation() {
        if (this.myOverriddenDefaultRelation != null) {
            Relation relation = this.myOverriddenDefaultRelation;
            if (relation == null) {
                Field.$$$reportNull$$$0(14);
            }
            return relation;
        }
        if (this.myIsMany) {
            Relation relation = Relation.SEQUENCE_ITEM;
            if (relation == null) {
                Field.$$$reportNull$$$0(15);
            }
            return relation;
        }
        Relation relation = this.myMainType instanceof YamlScalarType ? Relation.SCALAR_VALUE : Relation.OBJECT_CONTENTS;
        if (relation == null) {
            Field.$$$reportNull$$$0(16);
        }
        return relation;
    }

    @NotNull
    public Field withEmptyValueAllowed(boolean allow) {
        this.myEmptyValueAllowed = allow;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(17);
        }
        return field;
    }

    @NotNull
    public final Field withAnyName() {
        Field field = this.withAnyName(true);
        if (field == null) {
            Field.$$$reportNull$$$0(18);
        }
        return field;
    }

    @NotNull
    public Field withAnyName(boolean allowAnyName) {
        this.myAnyNameAllowed = allowAnyName;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(19);
        }
        return field;
    }

    public final boolean isAnyNameAllowed() {
        return this.myAnyNameAllowed;
    }

    public final boolean isEmptyValueAllowed() {
        return this.myEmptyValueAllowed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.getName()).append("]@");
        result.append(Integer.toHexString(this.hashCode()));
        result.append(" : ");
        result.append(this.myMainType.getTypeName());
        List nonDefaultTypes = this.myPerRelationTypes.entrySet().stream().filter(e -> e.getValue() == this.myMainType).map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.toList());
        if (!nonDefaultTypes.isEmpty()) {
            result.append(nonDefaultTypes);
        }
        return result.toString();
    }

    @NotNull
    public List<LookupElementBuilder> getKeyLookups(@NotNull YamlMetaClass ownerClass, @NotNull PsiElement insertedScalar) {
        if (ownerClass == null) {
            Field.$$$reportNull$$$0(20);
        }
        if (insertedScalar == null) {
            Field.$$$reportNull$$$0(21);
        }
        if (this.isAnyNameAllowed()) {
            List<LookupElementBuilder> list = Collections.emptyList();
            if (list == null) {
                Field.$$$reportNull$$$0(22);
            }
            return list;
        }
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)new TypeFieldPair(ownerClass, this), (String)this.getName()).withTypeText(this.myMainType.getDisplayName(), true).withIcon(this.getLookupIcon()).withStrikeoutness(this.isDeprecated());
        if (this.isRequired()) {
            lookup = lookup.bold();
        }
        List<LookupElementBuilder> list = Collections.singletonList(lookup);
        if (list == null) {
            Field.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    public PsiReference getReferenceFromKey(@NotNull YAMLKeyValue keyValue) {
        if (keyValue == null) {
            Field.$$$reportNull$$$0(24);
        }
        return null;
    }

    public boolean hasRelationSpecificType(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(25);
        }
        return relation == this.getDefaultRelation() || this.myPerRelationTypes.containsKey((Object)relation);
    }

    @Nullable
    public Icon getLookupIcon() {
        return this.myIsMany ? AllIcons.Json.Array : this.myMainType.getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainType";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/Field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedScalar";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/Field";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withDefaultRelation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withMultiplicityMany";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withMultiplicityManyNotOne";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setRequired";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setDeprecated";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setNonEditable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRelation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withEmptyValueAllowed";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withAnyName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyLookups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withDefaultRelation";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withRelationSpecificType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getKeyLookups";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceFromKey";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasRelationSpecificType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Relation {
        SCALAR_VALUE,
        SEQUENCE_ITEM,
        OBJECT_CONTENTS;

    }
}

