/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Alarm;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeVfsListener
implements BulkFileListener,
Disposable {
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    private boolean myForbid;
    @NotNull
    private final ZipperUpdater myZipperUpdater;
    private final List<FilesAndDirs> myQueue;
    private final Object myLock;
    @NotNull
    private final Runnable myDirtReporter;

    public VcsDirtyScopeVfsListener(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager, @NotNull VcsDirtyScopeManager dirtyScopeManager) {
        if (project == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(0);
        }
        if (vcsManager == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(1);
        }
        if (dirtyScopeManager == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(2);
        }
        this.myVcsManager = vcsManager;
        this.myLock = new Object();
        this.myQueue = new ArrayList<FilesAndDirs>();
        this.myDirtReporter = () -> {
            ArrayList<FilesAndDirs> list;
            Object object = this.myLock;
            synchronized (object) {
                list = new ArrayList<FilesAndDirs>(this.myQueue);
                this.myQueue.clear();
            }
            HashSet<FilePath> dirtyFiles = new HashSet<FilePath>();
            HashSet<FilePath> dirtyDirs = new HashSet<FilePath>();
            for (FilesAndDirs filesAndDirs : list) {
                dirtyFiles.addAll(filesAndDirs.dirtyFiles);
                dirtyDirs.addAll(filesAndDirs.dirtyDirs);
            }
            if (!dirtyFiles.isEmpty() || !dirtyDirs.isEmpty()) {
                dirtyScopeManager.filePathsDirty(dirtyFiles, dirtyDirs);
            }
        };
        this.myZipperUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        Disposer.register((Disposable)project, (Disposable)this);
        project.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
    }

    public static VcsDirtyScopeVfsListener getInstance(@NotNull Project project) {
        if (project == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(3);
        }
        return (VcsDirtyScopeVfsListener)ServiceManager.getService((Project)project, VcsDirtyScopeVfsListener.class);
    }

    public static void install(@NotNull Project project) {
        if (project == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(4);
        }
        if (!project.isOpen()) {
            throw new RuntimeException("Already closed: " + project);
        }
        VcsDirtyScopeVfsListener.getInstance(project);
    }

    public void setForbid(boolean forbid) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myForbid = forbid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myQueue.clear();
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.waitForAsyncTaskCompletion();
        }
    }

    void waitForAsyncTaskCompletion() {
        this.myZipperUpdater.waitForAllExecuted(10L, TimeUnit.SECONDS);
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(5);
        }
        if (this.myForbid || !this.myVcsManager.hasAnyMappings()) {
            return;
        }
        FilesAndDirs dirtyFilesAndDirs = new FilesAndDirs();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (vFileEvent instanceof VFileCreateEvent || (file = vFileEvent.getFile()) == null || !file.isInLocalFileSystem() || !(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            dirtyFilesAndDirs.add(file);
        }
        this.markDirtyOnPooled(dirtyFilesAndDirs);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(6);
        }
        if (this.myForbid || !this.myVcsManager.hasAnyMappings()) {
            return;
        }
        FilesAndDirs dirtyFilesAndDirs = new FilesAndDirs();
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (vFileEvent instanceof VFileDeleteEvent || (file = vFileEvent.getFile()) == null || !file.isInLocalFileSystem()) continue;
            if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileMoveEvent) {
                dirtyFilesAndDirs.add(file);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                dirtyFilesAndDirs.add(copyEvent.getNewParent().findChild(copyEvent.getNewChildName()));
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            if (pce.isRename()) {
                dirtyFilesAndDirs.add(file);
                dirtyFilesAndDirs.addToFiles(file.getParent());
                continue;
            }
            dirtyFilesAndDirs.addToFiles(file);
        }
        this.markDirtyOnPooled(dirtyFilesAndDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirtyOnPooled(@NotNull FilesAndDirs dirtyFilesAndDirs) {
        if (dirtyFilesAndDirs == null) {
            VcsDirtyScopeVfsListener.$$$reportNull$$$0(7);
        }
        if (!dirtyFilesAndDirs.isEmpty()) {
            Object object = this.myLock;
            synchronized (object) {
                this.myQueue.add(dirtyFilesAndDirs);
            }
            this.myZipperUpdater.queue(this.myDirtReporter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScopeManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyFilesAndDirs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "markDirtyOnPooled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FilesAndDirs {
        @NotNull
        HashSet<FilePath> dirtyFiles = new HashSet();
        @NotNull
        HashSet<FilePath> dirtyDirs = new HashSet();

        private FilesAndDirs() {
        }

        private void add(@Nullable VirtualFile file, boolean addToFiles) {
            if (file == null) {
                return;
            }
            boolean isDirectory = file.isDirectory();
            FilePath path = VcsUtil.getFilePath((String)file.getPath(), (boolean)isDirectory);
            if (addToFiles || !isDirectory) {
                this.dirtyFiles.add(path);
            } else {
                this.dirtyDirs.add(path);
            }
        }

        private void add(@Nullable VirtualFile file) {
            this.add(file, false);
        }

        private void addToFiles(@Nullable VirtualFile file) {
            this.add(file, true);
        }

        private boolean isEmpty() {
            return this.dirtyFiles.isEmpty() && this.dirtyDirs.isEmpty();
        }
    }
}

