/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitContentRevision;
import git4idea.GitFormatException;
import git4idea.GitRevisionNumber;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitUntrackedFilesHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class GitChangesCollector {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final VirtualFile myVcsRoot;
    private final Collection<Change> myChanges;
    private final Set<VirtualFile> myUnversionedFiles;
    private final Collection<GitConflict> myConflicts;

    @NotNull
    static GitChangesCollector collect(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, @NotNull Collection<FilePath> dirtyPaths) throws VcsException {
        if (project == null) {
            GitChangesCollector.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitChangesCollector.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            GitChangesCollector.$$$reportNull$$$0(2);
        }
        if (dirtyPaths == null) {
            GitChangesCollector.$$$reportNull$$$0(3);
        }
        GitChangesCollector gitChangesCollector = new GitChangesCollector(project, git, repository, dirtyPaths);
        if (gitChangesCollector == null) {
            GitChangesCollector.$$$reportNull$$$0(4);
        }
        return gitChangesCollector;
    }

    @NotNull
    Collection<VirtualFile> getUnversionedFiles() {
        Set<VirtualFile> set = this.myUnversionedFiles;
        if (set == null) {
            GitChangesCollector.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    Collection<Change> getChanges() {
        Collection<Change> collection = this.myChanges;
        if (collection == null) {
            GitChangesCollector.$$$reportNull$$$0(6);
        }
        return collection;
    }

    Collection<GitConflict> getConflicts() {
        return this.myConflicts;
    }

    private GitChangesCollector(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, @NotNull Collection<FilePath> dirtyPaths) throws VcsException {
        if (project == null) {
            GitChangesCollector.$$$reportNull$$$0(7);
        }
        if (git == null) {
            GitChangesCollector.$$$reportNull$$$0(8);
        }
        if (repository == null) {
            GitChangesCollector.$$$reportNull$$$0(9);
        }
        if (dirtyPaths == null) {
            GitChangesCollector.$$$reportNull$$$0(10);
        }
        this.myChanges = new HashSet<Change>();
        this.myUnversionedFiles = new HashSet<VirtualFile>();
        this.myConflicts = new HashSet<GitConflict>();
        this.myProject = project;
        this.myGit = git;
        this.myRepository = repository;
        this.myVcsRoot = repository.getRoot();
        if (!dirtyPaths.isEmpty()) {
            this.collectChanges(dirtyPaths);
            this.collectUnversionedFiles();
        }
    }

    @NotNull
    static Map<VirtualFile, List<FilePath>> collectDirtyPaths(@NotNull AbstractVcs vcs, @NotNull VcsDirtyScope dirtyScope, @NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager vcsManager) {
        if (vcs == null) {
            GitChangesCollector.$$$reportNull$$$0(11);
        }
        if (dirtyScope == null) {
            GitChangesCollector.$$$reportNull$$$0(12);
        }
        if (changeListManager == null) {
            GitChangesCollector.$$$reportNull$$$0(13);
        }
        if (vcsManager == null) {
            GitChangesCollector.$$$reportNull$$$0(14);
        }
        HashMap<VirtualFile, List<FilePath>> result2 = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath p : dirtyScope.getRecursivelyDirtyDirectories()) {
            GitChangesCollector.addToPaths(p, result2, vcs, vcsManager);
        }
        for (FilePath p : dirtyScope.getDirtyFilesNoExpand()) {
            GitChangesCollector.addToPaths(p, result2, vcs, vcsManager);
        }
        for (Change c : changeListManager.getAllChanges()) {
            switch (c.getType()) {
                case NEW: 
                case DELETED: 
                case MOVED: {
                    FilePath beforePath;
                    FilePath afterPath = ChangesUtil.getAfterPath((Change)c);
                    if (afterPath != null) {
                        GitChangesCollector.addToPaths(afterPath, result2, vcs, vcsManager);
                    }
                    if ((beforePath = ChangesUtil.getBeforePath((Change)c)) == null) break;
                    GitChangesCollector.addToPaths(beforePath, result2, vcs, vcsManager);
                }
            }
        }
        for (VirtualFile root : result2.keySet()) {
            List paths = (List)result2.get(root);
            GitChangesCollector.removeCommonParents(paths);
        }
        HashMap<VirtualFile, List<FilePath>> hashMap = result2;
        if (hashMap == null) {
            GitChangesCollector.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    private static void addToPaths(@NotNull FilePath filePath, @NotNull Map<VirtualFile, List<FilePath>> result2, @NotNull AbstractVcs vcs, @NotNull ProjectLevelVcsManager vcsManager) {
        VcsRoot vcsRoot;
        if (filePath == null) {
            GitChangesCollector.$$$reportNull$$$0(16);
        }
        if (result2 == null) {
            GitChangesCollector.$$$reportNull$$$0(17);
        }
        if (vcs == null) {
            GitChangesCollector.$$$reportNull$$$0(18);
        }
        if (vcsManager == null) {
            GitChangesCollector.$$$reportNull$$$0(19);
        }
        if ((vcsRoot = vcsManager.getVcsRootObjectFor(filePath)) != null && vcs.equals((Object)vcsRoot.getVcs())) {
            VirtualFile root = vcsRoot.getPath();
            List paths = result2.computeIfAbsent(root, key -> new ArrayList());
            paths.add(filePath);
        }
    }

    private static void removeCommonParents(List<FilePath> paths) {
        Collections.sort(paths, Comparator.comparing(FilePath::getPath));
        FilePath prevPath = null;
        Iterator<FilePath> it = paths.iterator();
        while (it.hasNext()) {
            FilePath path = it.next();
            if (prevPath != null && FileUtil.startsWith((String)path.getPath(), (String)prevPath.getPath(), (boolean)true)) {
                it.remove();
                continue;
            }
            prevPath = path;
        }
    }

    private void collectChanges(Collection<? extends FilePath> dirtyPaths) throws VcsException {
        GitLineHandler handler = this.statusHandler(dirtyPaths);
        String output = this.myGit.runCommand(handler).getOutputOrThrow(new int[0]);
        this.parseOutput(output, handler);
    }

    private void collectUnversionedFiles() throws VcsException {
        GitUntrackedFilesHolder untrackedFilesHolder = this.myRepository.getUntrackedFilesHolder();
        this.myUnversionedFiles.addAll(untrackedFilesHolder.retrieveUntrackedFiles());
    }

    private GitLineHandler statusHandler(Collection<? extends FilePath> dirtyPaths) {
        GitLineHandler handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.STATUS);
        String[] params = new String[]{"--porcelain", "-z", "--untracked-files=no"};
        handler.addParameters(params);
        handler.endOptions();
        handler.addRelativePaths(dirtyPaths);
        if (handler.isLargeCommandLine()) {
            handler = new GitLineHandler(this.myProject, this.myVcsRoot, GitCommand.STATUS);
            handler.addParameters(params);
            handler.endOptions();
        }
        handler.setSilent(true);
        return handler;
    }

    private void parseOutput(@NotNull String output, @NotNull GitHandler handler) throws VcsException {
        if (output == null) {
            GitChangesCollector.$$$reportNull$$$0(20);
        }
        if (handler == null) {
            GitChangesCollector.$$$reportNull$$$0(21);
        }
        VcsRevisionNumber head = this.getHead();
        String[] split = output.split("\u0000");
        block11: for (int pos = 0; pos < split.length; ++pos) {
            String line = split[pos];
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (line.length() < 4) {
                GitChangesCollector.throwGFE("Line is too short.", handler, output, line, '0', '0');
            }
            String xyStatus = line.substring(0, 2);
            String path = line.substring(3);
            char xStatus = xyStatus.charAt(0);
            char yStatus = xyStatus.charAt(1);
            FilePath filepath = GitContentRevision.createPath(this.myVcsRoot, path);
            Object oldFilepath = xStatus == 'R' || xStatus == 'C' || yStatus == 'R' || yStatus == 'C' ? GitContentRevision.createPath(this.myVcsRoot, split[++pos]) : null;
            switch (xStatus) {
                case ' ': {
                    if (yStatus == 'M') {
                        this.reportModified(filepath, head);
                        continue block11;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath, head);
                        continue block11;
                    }
                    if (yStatus == 'A' || yStatus == 'C') {
                        this.reportAdded(filepath);
                        continue block11;
                    }
                    if (yStatus == 'T') {
                        this.reportTypeChanged(filepath, head);
                        continue block11;
                    }
                    if (yStatus == 'U') {
                        this.reportConflict(filepath, head, GitConflict.Status.MODIFIED, GitConflict.Status.MODIFIED);
                        continue block11;
                    }
                    if (yStatus == 'R') {
                        this.reportRename(filepath, (FilePath)oldFilepath, head);
                        continue block11;
                    }
                    GitChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block11;
                }
                case 'M': {
                    if (yStatus == ' ' || yStatus == 'M' || yStatus == 'T') {
                        this.reportModified(filepath, head);
                        continue block11;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath, head);
                        continue block11;
                    }
                    GitChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block11;
                }
                case 'A': 
                case 'C': {
                    if (yStatus == 'M' || yStatus == ' ' || yStatus == 'T') {
                        this.reportAdded(filepath);
                        continue block11;
                    }
                    if (yStatus == 'D') continue block11;
                    if (yStatus == 'U') {
                        this.reportConflict(filepath, head, GitConflict.Status.ADDED, GitConflict.Status.MODIFIED);
                        continue block11;
                    }
                    if (yStatus == 'A') {
                        this.reportConflict(filepath, head, GitConflict.Status.ADDED, GitConflict.Status.ADDED);
                        continue block11;
                    }
                    GitChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block11;
                }
                case 'D': {
                    if (yStatus == 'M' || yStatus == ' ' || yStatus == 'T') {
                        this.reportDeleted(filepath, head);
                        continue block11;
                    }
                    if (yStatus == 'U') {
                        this.reportConflict(filepath, head, GitConflict.Status.DELETED, GitConflict.Status.MODIFIED);
                        continue block11;
                    }
                    if (yStatus == 'D') {
                        this.reportConflict(filepath, head, GitConflict.Status.DELETED, GitConflict.Status.DELETED);
                        continue block11;
                    }
                    if (yStatus == 'C') {
                        this.reportModified(filepath, head);
                        continue block11;
                    }
                    if (yStatus == 'R') {
                        this.reportRename(filepath, (FilePath)oldFilepath, head);
                        continue block11;
                    }
                    GitChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block11;
                }
                case 'U': {
                    if (yStatus == 'U' || yStatus == 'T') {
                        this.reportConflict(filepath, head, GitConflict.Status.MODIFIED, GitConflict.Status.MODIFIED);
                        continue block11;
                    }
                    if (yStatus == 'A') {
                        this.reportConflict(filepath, head, GitConflict.Status.MODIFIED, GitConflict.Status.ADDED);
                        continue block11;
                    }
                    if (yStatus == 'D') {
                        this.reportConflict(filepath, head, GitConflict.Status.MODIFIED, GitConflict.Status.DELETED);
                        continue block11;
                    }
                    GitChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block11;
                }
                case 'R': {
                    if (yStatus == 'D') {
                        this.reportDeleted((FilePath)oldFilepath, head);
                        continue block11;
                    }
                    if (yStatus == ' ' || yStatus == 'M' || yStatus == 'T') {
                        this.reportRename(filepath, (FilePath)oldFilepath, head);
                        continue block11;
                    }
                    GitChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block11;
                }
                case 'T': {
                    if (yStatus == ' ' || yStatus == 'M') {
                        this.reportTypeChanged(filepath, head);
                        continue block11;
                    }
                    if (yStatus == 'D') {
                        this.reportDeleted(filepath, head);
                        continue block11;
                    }
                    GitChangesCollector.throwYStatus(output, handler, line, xStatus, yStatus);
                    continue block11;
                }
                case '?': {
                    GitChangesCollector.throwGFE("Unexpected unversioned file flag.", handler, output, line, xStatus, yStatus);
                    continue block11;
                }
                case '!': {
                    GitChangesCollector.throwGFE("Unexpected ignored file flag.", handler, output, line, xStatus, yStatus);
                }
                default: {
                    GitChangesCollector.throwGFE("Unexpected symbol as xStatus.", handler, output, line, xStatus, yStatus);
                }
            }
        }
    }

    @NotNull
    private VcsRevisionNumber getHead() throws VcsException {
        this.myRepository.update();
        String rev = this.myRepository.getCurrentRevision();
        Object object = rev != null ? new GitRevisionNumber(rev) : VcsRevisionNumber.NULL;
        if (object == null) {
            GitChangesCollector.$$$reportNull$$$0(22);
        }
        return object;
    }

    private static void throwYStatus(String output, GitHandler handler, String line, char xStatus, char yStatus) {
        GitChangesCollector.throwGFE("Unexpected symbol as yStatus.", handler, output, line, xStatus, yStatus);
    }

    private static void throwGFE(String message, GitHandler handler, String output, String line, char xStatus, char yStatus) {
        throw new GitFormatException(String.format("%s\n xStatus=[%s], yStatus=[%s], line=[%s], \nhandler:\n%s\n output: \n%s", message, Character.valueOf(xStatus), Character.valueOf(yStatus), line.replace('\u0000', '!'), handler, output));
    }

    private void reportModified(FilePath filepath, VcsRevisionNumber head) {
        ContentRevision before = GitContentRevision.createRevision(filepath, head, this.myProject);
        ContentRevision after = GitContentRevision.createRevision(filepath, null, this.myProject);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportTypeChanged(FilePath filepath, VcsRevisionNumber head) {
        ContentRevision before = GitContentRevision.createRevision(filepath, head, this.myProject);
        ContentRevision after = GitContentRevision.createRevisionForTypeChange(filepath, null, this.myProject);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportAdded(FilePath filepath) {
        ContentRevision before = null;
        ContentRevision after = GitContentRevision.createRevision(filepath, null, this.myProject);
        this.reportChange(FileStatus.ADDED, before, after);
    }

    private void reportDeleted(FilePath filepath, VcsRevisionNumber head) {
        ContentRevision before = GitContentRevision.createRevision(filepath, head, this.myProject);
        ContentRevision after = null;
        this.reportChange(FileStatus.DELETED, before, after);
    }

    private void reportRename(FilePath filepath, FilePath oldFilepath, VcsRevisionNumber head) {
        ContentRevision before = GitContentRevision.createRevision(oldFilepath, head, this.myProject);
        ContentRevision after = GitContentRevision.createRevision(filepath, null, this.myProject);
        this.reportChange(FileStatus.MODIFIED, before, after);
    }

    private void reportConflict(FilePath filepath, VcsRevisionNumber head, GitConflict.Status oursStatus, GitConflict.Status theirsStatus) {
        this.myConflicts.add(new GitConflict(this.myVcsRoot, filepath, oursStatus, theirsStatus));
        if (oursStatus != GitConflict.Status.DELETED || theirsStatus != GitConflict.Status.DELETED) {
            ContentRevision before = GitContentRevision.createRevision(filepath, head, this.myProject);
            ContentRevision after = GitContentRevision.createRevision(filepath, null, this.myProject);
            this.reportChange(FileStatus.MERGED_WITH_CONFLICTS, before, after);
        }
    }

    private void reportChange(FileStatus status, ContentRevision before, ContentRevision after) {
        this.myChanges.add(new Change(before, after, status));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyPaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/status/GitChangesCollector";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/status/GitChangesCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDirtyPaths";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getHead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectDirtyPaths";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addToPaths";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

