/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.prefix;

import java.util.Optional;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.ResettableView;
import org.sejda.model.prefix.Prefix;

public class PrefixField
extends TextField
implements ResettableView {
    private Menu menu;

    public PrefixField() {
        super("PDFsam_");
        this.setPromptText(DefaultI18nContext.getInstance().i18n("Prefix for the generated files names"));
        this.menu = new Menu(DefaultI18nContext.getInstance().i18n("Add prefix"));
        this.menu.setId("addPrefixMenu");
        this.menu.getItems().addAll((Object[])new MenuItem[]{new PrefixMenuItem(Prefix.TIMESTAMP), new PrefixMenuItem(Prefix.BASENAME)});
        this.setContextMenu(new ContextMenu(new MenuItem[]{this.menu}));
        this.setPrefWidth(300.0);
    }

    public void addMenuItemFor(Prefix ... prefixes) {
        for (Prefix current : prefixes) {
            this.menu.getItems().add((Object)new PrefixMenuItem(current));
        }
    }

    public void addMenuItemFor(String ... prefixes) {
        for (String current : prefixes) {
            this.menu.getItems().add((Object)new PrefixMenuItem(current));
        }
    }

    public void resetView() {
        this.setText("PDFsam_");
    }

    private final class PrefixMenuItem
    extends MenuItem {
        private PrefixMenuItem(Prefix prefix) {
            this(Optional.ofNullable(prefix).map(Prefix::getFriendlyName).orElseThrow(() -> new IllegalArgumentException("Prefix cannot be null")));
        }

        private PrefixMenuItem(String prefix) {
            RequireUtils.requireNotBlank((String)prefix, (String)"Prefix cannot be blank");
            this.setText(prefix);
            this.setOnAction(e -> PrefixField.this.replaceSelection(prefix));
            this.setMnemonicParsing(false);
        }
    }
}

