# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_processing_pass import ImageProcessingPass


class ToneMappingPass(ImageProcessingPass):
    """
    ToneMappingPass - Implement a post-processing Tone Mapping.
    
    Superclass: ImageProcessingPass
    
    Tone mapping is the process of mapping HDR colors to [0;1] range.
    This render pass supports three different modes:
    - Clamp: clamps the color to [0;1] range
    - Reinhard: maps the color using formula: x/(x+1)
    - Exponential: maps the colors using a coefficient and the formula:
      1-exp(-a*x)
    
    Advanced tone maping like Reinhard or Exponential can be useful when
    several lights are added to the renderer.
    
    @sa
    RenderPass
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkToneMappingPass, obj, update, **traits)
    
    exposure = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set Exposure coefficient used for exponential tone mapping.
        Default is 1.0
        """
    )

    def _exposure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExposure,
                        self.exposure)

    tone_mapping_type = traits.Trait(0, traits.Range(0, 2, enter_set=True, auto_set=False), desc=\
        """
        Get/Set the tone mapping type Default is Clamp
        """
    )

    def _tone_mapping_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetToneMappingType,
                        self.tone_mapping_type)

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('exposure', 'GetExposure'),
    ('tone_mapping_type', 'GetToneMappingType'), ('active_draw_buffers',
    'GetActiveDrawBuffers'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'active_draw_buffers',
    'exposure', 'tone_mapping_type'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ToneMappingPass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ToneMappingPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['active_draw_buffers', 'exposure',
            'tone_mapping_type']),
            title='Edit ToneMappingPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ToneMappingPass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

