/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm;

import org.jetbrains.org.objectweb.asm.ByteVector;

public final class TypePath {
    private final byte[] typePathContainer;
    private final int typePathOffset;

    TypePath(byte[] typePathContainer, int typePathOffset) {
        this.typePathContainer = typePathContainer;
        this.typePathOffset = typePathOffset;
    }

    public int getLength() {
        return this.typePathContainer[this.typePathOffset];
    }

    public int getStep(int index2) {
        return this.typePathContainer[this.typePathOffset + 2 * index2 + 1];
    }

    public int getStepArgument(int index2) {
        return this.typePathContainer[this.typePathOffset + 2 * index2 + 2];
    }

    public String toString() {
        int length = this.getLength();
        StringBuilder result2 = new StringBuilder(length * 2);
        block6: for (int i = 0; i < length; ++i) {
            switch (this.getStep(i)) {
                case 0: {
                    result2.append('[');
                    continue block6;
                }
                case 1: {
                    result2.append('.');
                    continue block6;
                }
                case 2: {
                    result2.append('*');
                    continue block6;
                }
                case 3: {
                    result2.append(this.getStepArgument(i)).append(';');
                    continue block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return result2.toString();
    }

    static void put(TypePath typePath, ByteVector output) {
        if (typePath == null) {
            output.putByte(0);
        } else {
            int length = typePath.typePathContainer[typePath.typePathOffset] * 2 + 1;
            output.putByteArray(typePath.typePathContainer, typePath.typePathOffset, length);
        }
    }
}

