/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataOutput;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\u0018\u0010\u001e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0010H\u0002J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0002J\u0015\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/CachingLazyStorage;", "K", "V", "Lorg/jetbrains/kotlin/incremental/storage/LazyStorage;", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "(Ljava/io/File;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;)V", "keys", "", "getKeys", "()Ljava/util/Collection;", "storage", "Lcom/intellij/util/io/PersistentHashMap;", "append", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "clean", "close", "contains", "", "(Ljava/lang/Object;)Z", "createMap", "flush", "memoryCachesOnly", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getStorageIfExists", "getStorageOrCreateNew", "remove", "(Ljava/lang/Object;)V", "set", "kotlin-build-common"})
public final class CachingLazyStorage<K, V>
implements LazyStorage<K, V> {
    private volatile PersistentHashMap<K, V> storage;
    private final File storageFile;
    private final KeyDescriptor<K> keyDescriptor;
    private final DataExternalizer<V> valueExternalizer;

    private final synchronized PersistentHashMap<K, V> getStorageIfExists() {
        if (this.storage != null) {
            return this.storage;
        }
        if (this.storageFile.exists()) {
            this.storage = this.createMap();
            return this.storage;
        }
        return null;
    }

    private final synchronized PersistentHashMap<K, V> getStorageOrCreateNew() {
        if (this.storage == null) {
            this.storage = this.createMap();
        }
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            Intrinsics.throwNpe();
        }
        return persistentHashMap;
    }

    @Override
    @NotNull
    public Collection<K> getKeys() {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        if (persistentHashMap == null || (persistentHashMap = persistentHashMap.getAllKeysWithExistingMapping()) == null) {
            boolean bl = false;
            persistentHashMap = CollectionsKt.emptyList();
        }
        return persistentHashMap;
    }

    @Override
    public boolean contains(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return persistentHashMap != null ? persistentHashMap.containsMapping(key) : false;
    }

    @Override
    @Nullable
    public V get(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return (V)(persistentHashMap != null ? persistentHashMap.get(key) : null);
    }

    @Override
    public void set(K key, V value2) {
        this.getStorageOrCreateNew().put(key, value2);
    }

    @Override
    public void remove(K key) {
        block0: {
            PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
            if (persistentHashMap == null) break block0;
            persistentHashMap.remove(key);
        }
    }

    @Override
    public void append(K key, V value2) {
        this.getStorageOrCreateNew().appendData(key, new PersistentHashMap.ValueDataAppender(this, value2){
            final /* synthetic */ CachingLazyStorage this$0;
            final /* synthetic */ Object $value;

            public final void append(DataOutput it) {
                CachingLazyStorage.access$getValueExternalizer$p(this.this$0).save(it, this.$value);
            }
            {
                this.this$0 = cachingLazyStorage;
                this.$value = object;
            }
        });
    }

    @Override
    public synchronized void clean() {
        try {
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith(this.storageFile);
        this.storage = null;
    }

    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            return;
        }
        PersistentHashMap<K, V> existingStorage = persistentHashMap;
        if (memoryCachesOnly) {
            if (existingStorage.isDirty()) {
                existingStorage.dropMemoryCaches();
            }
        } else {
            existingStorage.force();
        }
    }

    @Override
    public synchronized void close() {
        block0: {
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap == null) break block0;
            persistentHashMap.close();
        }
    }

    private final PersistentHashMap<K, V> createMap() {
        return new PersistentHashMap<K, V>(this.storageFile, this.keyDescriptor, this.valueExternalizer);
    }

    public CachingLazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
        Intrinsics.checkParameterIsNotNull(keyDescriptor, "keyDescriptor");
        Intrinsics.checkParameterIsNotNull(valueExternalizer, "valueExternalizer");
        this.storageFile = storageFile;
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
    }

    public static final /* synthetic */ DataExternalizer access$getValueExternalizer$p(CachingLazyStorage $this) {
        return $this.valueExternalizer;
    }
}

