/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\"\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0019H&J\b\u0010!\u001a\u00020\u0005H&J\b\u0010\"\u001a\u00020\u0000H\u0016J\u0006\u0010#\u001a\u00020\u0003R\u001a\u0010\u0007\u001a\u00020\u00038VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibility;", "", "name", "", "isPublicAPI", "", "(Ljava/lang/String;Z)V", "displayName", "displayName$annotations", "()V", "getDisplayName", "()Ljava/lang/String;", "externalDisplayName", "getExternalDisplayName", "internalDisplayName", "getInternalDisplayName", "()Z", "getName", "compareTo", "", "visibility", "(Lorg/jetbrains/kotlin/descriptors/Visibility;)Ljava/lang/Integer;", "effectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkPublishedApi", "isVisible", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "what", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "from", "mustCheckInImports", "normalize", "toString", "descriptors"})
public abstract class Visibility {
    @NotNull
    private final String name;
    private final boolean isPublicAPI;

    public abstract boolean isVisible(@Nullable ReceiverValue var1, @NotNull DeclarationDescriptorWithVisibility var2, @NotNull DeclarationDescriptor var3);

    public abstract boolean mustCheckInImports();

    @Nullable
    protected Integer compareTo(@NotNull Visibility visibility) {
        Intrinsics.checkParameterIsNotNull(visibility, "visibility");
        return Visibilities.compareLocal(this, visibility);
    }

    @NotNull
    public String getInternalDisplayName() {
        return this.name;
    }

    @NotNull
    public String getExternalDisplayName() {
        return this.getInternalDisplayName();
    }

    @Deprecated(message="Visibility.displayName is deprecated, use internalDisplayName instead", replaceWith=@ReplaceWith(imports={}, expression="internalDisplayName"), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void displayName$annotations() {
    }

    @NotNull
    public String getDisplayName() {
        return this.getInternalDisplayName();
    }

    @NotNull
    public final String toString() {
        return this.getInternalDisplayName();
    }

    @NotNull
    public Visibility normalize() {
        return this;
    }

    @NotNull
    public EffectiveVisibility effectiveVisibility(@NotNull DeclarationDescriptor descriptor2, boolean checkPublishedApi) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        return EffectiveVisibilityKt.effectiveVisibility(this.normalize(), descriptor2, checkPublishedApi);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean isPublicAPI() {
        return this.isPublicAPI;
    }

    protected Visibility(@NotNull String name, boolean isPublicAPI) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        this.name = name;
        this.isPublicAPI = isPublicAPI;
    }
}

