/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "scopeOwnerSymbol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;Lkotlin/jvm/functions/Function0;)V", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "processHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "ensureNotNullable", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "expression", "ir.backend.common"})
public final class HeaderProcessor {
    private final Symbols<CommonBackendContext> symbols;
    private final CommonBackendContext context;
    private final HeaderInfoBuilder headerInfoBuilder;
    private final Function0<IrSymbol> scopeOwnerSymbol;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ForLoopHeader processHeader(@NotNull IrVariable variable2) {
        ForLoopHeader forLoopHeader;
        IrElement iterable;
        IrElement irElement;
        Intrinsics.checkParameterIsNotNull(variable2, "variable");
        boolean bl = Intrinsics.areEqual(variable2.getOrigin(), IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (!IrTypeUtilsKt.isSubtypeOfClass(variable2.getType(), this.symbols.getIterator())) {
            return null;
        }
        IrExpression irExpression = variable2.getInitializer();
        if (!(irExpression instanceof IrCall)) {
            irExpression = null;
        }
        IrCall irCall = (IrCall)irExpression;
        if (irCall == null) return null;
        IrCall irCall2 = irCall;
        bl3 = false;
        boolean bl5 = false;
        IrCall it = irCall2;
        boolean bl6 = false;
        IrExpression extensionReceiver = it.getExtensionReceiver();
        if (extensionReceiver != null) {
            IrFunction function2 = it.getSymbol().getOwner();
            if (it.getValueArgumentsCount() != 0) return null;
            if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isTopLevel(function2)) return null;
            IrPackageFragment irPackageFragment = IrUtilsKt.getPackageFragment(function2);
            if (!Intrinsics.areEqual(irPackageFragment != null ? irPackageFragment.getFqName() : null, new FqName("kotlin.text"))) return null;
            if (!Intrinsics.areEqual(function2.getName(), OperatorNameConventions.ITERATOR)) return null;
            irElement = extensionReceiver;
        } else {
            irElement = it.getDispatchReceiver();
        }
        IrElement irElement2 = iterable = irElement;
        Object object = irElement2;
        if (irElement2 == null) return null;
        HeaderInfo headerInfo = (HeaderInfo)object.accept(this.headerInfoBuilder, null);
        object = headerInfo;
        if (headerInfo == null) return null;
        Object headerInfo2 = object;
        DeclarationIrBuilder builder = LowerUtilsKt.createIrBuilder(this.context, this.scopeOwnerSymbol.invoke(), variable2.getStartOffset(), variable2.getEndOffset());
        bl5 = false;
        boolean bl7 = false;
        DeclarationIrBuilder $this$with = builder;
        boolean bl8 = false;
        IrVariable inductionVariable = Scope.createTemporaryVariable$default($this$with.getScope(), UtilsKt.castIfNecessary(((HeaderInfo)headerInfo2).getFirst(), ((HeaderInfo)headerInfo2).getProgressionType().elementType($this$with.getContext().getIrBuiltIns()), ((HeaderInfo)headerInfo2).getProgressionType().getElementCastFunctionName()), "inductionVariable", true, null, null, null, 56, null);
        IrExpression lastExpression = this.ensureNotNullable($this$with, UtilsKt.castIfNecessary(((HeaderInfo)headerInfo2).getLast(), ((HeaderInfo)headerInfo2).getProgressionType().elementType($this$with.getContext().getIrBuiltIns()), ((HeaderInfo)headerInfo2).getProgressionType().getElementCastFunctionName()));
        IrVariable lastVariableIfCanCacheLast = ((HeaderInfo)headerInfo2).getCanCacheLast() ? Scope.createTemporaryVariable$default($this$with.getScope(), lastExpression, "last", false, null, null, null, 60, null) : null;
        IrVariable stepVariable = Scope.createTemporaryVariable$default($this$with.getScope(), this.ensureNotNullable($this$with, UtilsKt.castIfNecessary(((HeaderInfo)headerInfo2).getStep(), ((HeaderInfo)headerInfo2).getProgressionType().stepType($this$with.getContext().getIrBuiltIns()), ((HeaderInfo)headerInfo2).getProgressionType().getStepCastFunctionName())), "step", false, null, null, null, 60, null);
        Object object2 = headerInfo2;
        if (object2 instanceof IndexedGetHeaderInfo) {
            IrExpression irExpression2;
            IndexedGetHeaderInfo indexedGetHeaderInfo = (IndexedGetHeaderInfo)headerInfo2;
            if (((HeaderInfo)headerInfo2).getCanCacheLast()) {
                IrBuilderWithScope irBuilderWithScope = $this$with;
                IrVariable irVariable2 = lastVariableIfCanCacheLast;
                if (irVariable2 == null) {
                    Intrinsics.throwNpe();
                }
                irExpression2 = ExpressionHelpersKt.irGet(irBuilderWithScope, irVariable2);
            } else {
                irExpression2 = lastExpression;
            }
            forLoopHeader = new IndexedGetLoopHeader(indexedGetHeaderInfo, inductionVariable, irExpression2, stepVariable, CollectionsKt.listOfNotNull(((IndexedGetHeaderInfo)headerInfo2).getObjectVariable(), inductionVariable, lastVariableIfCanCacheLast, stepVariable));
            return forLoopHeader;
        } else {
            IrExpression irExpression3;
            if (!(object2 instanceof ProgressionHeaderInfo)) throw new NoWhenBranchMatchedException();
            List<IrVariable> declarations2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((ProgressionHeaderInfo)headerInfo2).getAdditionalVariables(), (Iterable)(((HeaderInfo)headerInfo2).isReversed() ? CollectionsKt.listOfNotNull(lastVariableIfCanCacheLast, inductionVariable) : CollectionsKt.listOfNotNull(inductionVariable, lastVariableIfCanCacheLast))), stepVariable);
            ProgressionHeaderInfo progressionHeaderInfo = (ProgressionHeaderInfo)headerInfo2;
            if (((HeaderInfo)headerInfo2).getCanCacheLast()) {
                IrBuilderWithScope irBuilderWithScope = $this$with;
                IrVariable irVariable3 = lastVariableIfCanCacheLast;
                if (irVariable3 == null) {
                    Intrinsics.throwNpe();
                }
                irExpression3 = ExpressionHelpersKt.irGet(irBuilderWithScope, irVariable3);
            } else {
                irExpression3 = lastExpression;
            }
            forLoopHeader = new ProgressionLoopHeader(progressionHeaderInfo, inductionVariable, irExpression3, stepVariable, declarations2);
        }
        return forLoopHeader;
    }

    private final IrExpression ensureNotNullable(@NotNull DeclarationIrBuilder $this$ensureNotNullable, IrExpression expression2) {
        return expression2.getType() instanceof IrSimpleType && IrTypeUtilsKt.isNullable(expression2.getType()) ? (IrExpression)ExpressionHelpersKt.irImplicitCast($this$ensureNotNullable, expression2, IrTypesKt.makeNotNull(expression2.getType())) : expression2;
    }

    public HeaderProcessor(@NotNull CommonBackendContext context2, @NotNull HeaderInfoBuilder headerInfoBuilder2, @NotNull Function0<? extends IrSymbol> scopeOwnerSymbol) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Intrinsics.checkParameterIsNotNull(headerInfoBuilder2, "headerInfoBuilder");
        Intrinsics.checkParameterIsNotNull(scopeOwnerSymbol, "scopeOwnerSymbol");
        this.context = context2;
        this.headerInfoBuilder = headerInfoBuilder2;
        this.scopeOwnerSymbol = scopeOwnerSymbol;
        this.symbols = this.context.getIr().getSymbols();
    }
}

