/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.ant.internal.launching.AntLaunching;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.URLFieldEditor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class AntPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private List fConsoleColorList;
    private ColorSelector fConsoleColorSelector;
    private IntegerFieldEditor timeout;
    private BooleanFieldEditor workspacejre = null;
    private BooleanFieldEditor fToolsWarningEditor = null;
    private final String[][] fAppearanceColorListModel;

    public AntPreferencePage() {
        super(1);
        String[][] stringArrayArray = new String[5][];
        String[] stringArray = new String[3];
        stringArray[0] = AntPreferencesMessages.AntPreferencePage__Error__2;
        stringArray[1] = "org.eclipse.ant.ui.errorColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = AntPreferencesMessages.AntPreferencePage__Warning__3;
        stringArray2[1] = "org.eclipse.ant.ui.warningColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = AntPreferencesMessages.AntPreferencePage_I_nformation__4;
        stringArray3[1] = "org.eclipse.ant.ui.informationColor";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = AntPreferencesMessages.AntPreferencePage_Ve_rbose__5;
        stringArray4[1] = "org.eclipse.ant.ui.verboseColor";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = AntPreferencesMessages.AntPreferencePage_Deb_ug__6;
        stringArray5[1] = "org.eclipse.ant.ui.debugColor";
        stringArrayArray[4] = stringArray5;
        this.fAppearanceColorListModel = stringArrayArray;
        this.setDescription(AntPreferencesMessages.AntPreferencePage_General);
        this.setPreferenceStore(AntUIPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.storeAppliedValues();
        Font font = this.getFieldEditorParent().getFont();
        Label label = new Label(this.getFieldEditorParent(), 64);
        label.setText(AntPreferencesMessages.AntPreferencePage_Enter);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        label.setLayoutData((Object)gd);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        Object editor = new StringFieldEditor("ant.findBuildFileNames", AntPreferencesMessages.AntPreferencePage__Names__3, this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
        this.timeout = new AntIntegerFieldEditor(AntLaunching.getUniqueIdentifier(), "timeout", AntPreferencesMessages.AntPreferencePage_13, this.getFieldEditorParent(), 20000);
        int minValue = DefaultScope.INSTANCE.getNode(AntLaunching.getUniqueIdentifier()).getInt("timeout", 20000);
        int maxValue = 1200000;
        this.timeout.setValidRange(minValue, maxValue);
        this.timeout.setValidateStrategy(0);
        this.timeout.setErrorMessage(MessageFormat.format((String)AntPreferencesMessages.AntPreferencePage_14, (Object[])new Object[]{minValue, maxValue}));
        this.addField((FieldEditor)this.timeout);
        editor = new URLFieldEditor("documentation.url", AntPreferencesMessages.AntPreferencePage_2, this.getFieldEditorParent());
        this.addField((FieldEditor)editor);
        this.workspacejre = new BooleanFieldEditor("workspacejre", AntPreferencesMessages.always_run_in_workspace_jre, this.getFieldEditorParent());
        this.workspacejre.fillIntoGrid(this.getFieldEditorParent(), 3);
        this.addField((FieldEditor)this.workspacejre);
        this.createSpace();
        if (!AntUIPlugin.isMacOS()) {
            label = new Label(this.getFieldEditorParent(), 64);
            label.setText(AntPreferencesMessages.AntPreferencePage_0);
            gd = new GridData(256);
            gd.horizontalSpan = 3;
            gd.widthHint = this.convertWidthInCharsToPixels(60);
            label.setLayoutData((Object)gd);
            label.setFont(font);
            this.fToolsWarningEditor = new BooleanFieldEditor("toolsJAR", AntPreferencesMessages.AntPreferencePage_1, this.getFieldEditorParent());
            this.addField((FieldEditor)this.fToolsWarningEditor);
            this.createSpace();
        }
        this.addField((FieldEditor)new BooleanFieldEditor("errorDialog", AntPreferencesMessages.AntPreferencePage_12, this.getFieldEditorParent()));
        this.createSpace();
        this.addField((FieldEditor)new BooleanFieldEditor("createMarkers", AntPreferencesMessages.AntPreferencePage_15, this.getFieldEditorParent()));
        label = new Label(this.getFieldEditorParent(), 64);
        label.setText(AntPreferencesMessages.AntPreferencePage_16);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.createSpace();
        this.createColorComposite();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void createSpace() {
        Label label = new Label(this.getFieldEditorParent(), 0);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
    }

    private void storeAppliedValues() {
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            String preference = this.fAppearanceColorListModel[i][1];
            this.fAppearanceColorListModel[i][2] = store.getString(preference);
            ++i;
        }
    }

    private void createColorComposite() {
        Font font = this.getFieldEditorParent().getFont();
        Label label = new Label(this.getFieldEditorParent(), 16384);
        label.setText(AntPreferencesMessages.AntPreferencePage_Ant_Color_Options__6);
        label.setFont(font);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        editorComposite.setFont(font);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fConsoleColorList = new List(editorComposite, 2820);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fConsoleColorList.setLayoutData((Object)gd);
        this.fConsoleColorList.setFont(font);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        stylesComposite.setFont(font);
        label = new Label(stylesComposite, 16384);
        label.setText(AntPreferencesMessages.AntPreferencePage_Color__7);
        label.setFont(font);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fConsoleColorSelector = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fConsoleColorSelector.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        foregroundColorButton.setFont(font);
        this.fConsoleColorList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = AntPreferencePage.this.fConsoleColorList.getSelectionIndex();
                if (i == -1) {
                    return;
                }
                String key = AntPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntPreferencePage.this.getPreferenceStore(), (String)key, (RGB)AntPreferencePage.this.fConsoleColorSelector.getColorValue());
            }
        });
    }

    public boolean performCancel() {
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            String preference = this.fAppearanceColorListModel[i][1];
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)preference, (RGB)StringConverter.asRGB((String)this.fAppearanceColorListModel[i][2]));
            ++i;
        }
        return super.performCancel();
    }

    public boolean performOk() {
        this.storeAppliedValues();
        return super.performOk();
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fConsoleColorList.getSelectionIndex();
        if (i == -1) {
            return;
        }
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)key);
        this.fConsoleColorSelector.setColorValue(rgb);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ant.ui.ant_preference_page_context");
        return super.createContents(parent);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fConsoleColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fConsoleColorList.getDisplay().asyncExec(() -> {
            if (this.fConsoleColorList != null && !this.fConsoleColorList.isDisposed()) {
                this.fConsoleColorList.select(0);
                this.handleAppearanceColorListSelection();
            }
        });
    }

    protected void performDefaults() {
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            String key = this.fAppearanceColorListModel[i][1];
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)key, (RGB)PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)key));
            ++i;
        }
        this.handleAppearanceColorListSelection();
        super.performDefaults();
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("toolsJAR")) {
            if (this.fToolsWarningEditor != null) {
                this.fToolsWarningEditor.load();
            }
        } else {
            super.propertyChange(event);
        }
    }

    class AntIntegerFieldEditor
    extends IntegerFieldEditor {
        String node;
        String key;
        int defaultvalue;

        public AntIntegerFieldEditor(String node, String key, String title, Composite parent, int defaultvalue) {
            super(key, title, parent);
            this.node = null;
            this.key = null;
            this.defaultvalue = -1;
            this.node = node;
            this.key = key;
            this.defaultvalue = defaultvalue;
        }

        protected void doStore() {
            InstanceScope.INSTANCE.getNode(this.node).putInt(this.key, Integer.parseInt(this.getStringValue()));
        }

        public void load() {
            this.setStringValue(Integer.toString(Platform.getPreferencesService().getInt(this.node, this.key, this.defaultvalue, null)));
        }

        public void loadDefault() {
            this.setStringValue(Integer.toString(DefaultScope.INSTANCE.getNode(AntLaunching.getUniqueIdentifier()).getInt(this.key, this.defaultvalue)));
        }
    }
}

