/*
	Copyright (c) 2004-2016, The JS Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

//>>built
require({cache:{"dijit/form/TextBox":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_1,_2,_3,_4,_5,on,_6,_7,_8,_9,_a){var _b=_1("dijit.form.TextBox"+(_6("dojo-bidi")?"_NoBidi":""),[_7,_8],{templateString:_9,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:_6("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){var _c=this.type.toLowerCase();if(this.templateString&&this.templateString.toLowerCase()=="input"||((_c=="hidden"||_c=="file")&&this.templateString==this.constructor.prototype.templateString)){this.templateString=this._singleNodeTemplate;}this.inherited(arguments);},postCreate:function(){this.inherited(arguments);if(_6("ie")<9){this.defer(function(){try{var s=_3.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _d=this.domNode.getElementsByTagName("INPUT");if(_d){for(var i=0;i<_d.length;i++){_d[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setPlaceHolderAttr:function(v){this._set("placeHolder",v);if(!this._phspan){this._attachPoints.push("_phspan");this._phspan=_2.create("span",{className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");this.own(on(this._phspan,"mousedown",function(_e){_e.preventDefault();}),on(this._phspan,"touchend, pointerup, MSPointerUp",_5.hitch(this,function(){this.focus();})));}this._phspan.innerHTML="";this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));this._updatePlaceHolder();},_onInput:function(_f){this.inherited(arguments);this._updatePlaceHolder();},_updatePlaceHolder:function(){if(this._phspan){this._phspan.style.display=(this.placeHolder&&!this.textbox.value)?"":"none";}},_setValueAttr:function(_10,_11,_12){this.inherited(arguments);this._updatePlaceHolder();},getDisplayedValue:function(){_4.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");return this.get("displayedValue");},setDisplayedValue:function(_13){_4.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");this.set("displayedValue",_13);},_onBlur:function(e){if(this.disabled){return;}this.inherited(arguments);this._updatePlaceHolder();if(_6("mozilla")){if(this.selectOnClick){this.textbox.selectionStart=this.textbox.selectionEnd=undefined;}}},_onFocus:function(by){if(this.disabled||this.readOnly){return;}this.inherited(arguments);this._updatePlaceHolder();}});if(_6("ie")<9){_b.prototype._isTextSelected=function(){var _14=this.ownerDocument.selection.createRange();var _15=_14.parentElement();return _15==this.textbox&&_14.text.length>0;};_a._setSelectionRange=_8._setSelectionRange=function(_16,_17,_18){if(_16.createTextRange){var r=_16.createTextRange();r.collapse(true);r.moveStart("character",-99999);r.moveStart("character",_17);r.moveEnd("character",_18-_17);r.select();}};}if(_6("dojo-bidi")){_b=_1("dijit.form.TextBox",_b,{_setPlaceHolderAttr:function(v){this.inherited(arguments);this.applyTextDir(this._phspan);}});}return _b;});},"dijit/_base/scroll":function(){define(["dojo/window","../main"],function(_19,_1a){_1a.scrollIntoView=function(_1b,pos){_19.scrollIntoView(_1b,pos);};});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_1c,_1d,_1e,_1f,on,has,_20,_21){var _22=_1d("dijit._TemplatedMixin",_21,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(_23){var _24=this.declaredClass,_25=this;return _20.substitute(_23,this,function(_26,key){if(key.charAt(0)=="!"){_26=_1f.getObject(key.substr(1),false,_25);}if(typeof _26=="undefined"){throw new Error(_24+" template:"+key);}if(_26==null){return "";}return key.charAt(0)=="!"?_26:this._escapeValue(""+_26);},this);},_escapeValue:function(val){return val.replace(/["'<>&]/g,function(val){return {"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;"}[val];});},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_1c(this.templatePath,{sanitize:true});}var _27=_22.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var _28;if(_1f.isString(_27)){_28=_1e.toDom(this._stringRepl(_27),this.ownerDocument);if(_28.nodeType!=1){throw new Error("Invalid template: "+_27);}}else{_28=_27.cloneNode(true);}this.domNode=_28;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_29){var _2a=this.containerNode;if(_29&&_2a){while(_29.hasChildNodes()){_2a.appendChild(_29.firstChild);}}}});_22._templateCache={};_22.getCachedTemplate=function(_2b,_2c,doc){var _2d=_22._templateCache;var key=_2b;var _2e=_2d[key];if(_2e){try{if(!_2e.ownerDocument||_2e.ownerDocument==(doc||document)){return _2e;}}catch(e){}_1e.destroy(_2e);}_2b=_20.trim(_2b);if(_2c||_2b.match(/\$\{([^\}]+)\}/g)){return (_2d[key]=_2b);}else{var _2f=_1e.toDom(_2b,doc);if(_2f.nodeType!=1){throw new Error("Invalid template: "+_2b);}return (_2d[key]=_2f);}};if(has("ie")){on(window,"unload",function(){var _30=_22._templateCache;for(var key in _30){var _31=_30[key];if(typeof _31=="object"){_1e.destroy(_31);}delete _30[key];}});}return _22;});},"dijit/_CssStateMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/domReady","dojo/touch","dojo/_base/window","./a11yclick","./registry"],function(_32,_33,dom,_34,has,_35,on,_36,_37,win,_38,_39){var _3a=_33("dijit._CssStateMixin",[],{hovering:false,active:false,_applyAttributes:function(){this.inherited(arguments);_32.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(_3b){this.watch(_3b,_35.hitch(this,"_setStateClass"));},this);for(var ap in this.cssStateNodes||{}){this._trackMouseState(this[ap],this.cssStateNodes[ap]);}this._trackMouseState(this.domNode,this.baseClass);this._setStateClass();},_cssMouseEvent:function(_3c){if(!this.disabled){switch(_3c.type){case "mouseover":case "MSPointerOver":case "pointerover":this._set("hovering",true);this._set("active",this._mouseDown);break;case "mouseout":case "MSPointerOut":case "pointerout":this._set("hovering",false);this._set("active",false);break;case "mousedown":case "touchstart":case "MSPointerDown":case "pointerdown":case "keydown":this._set("active",true);break;case "mouseup":case "dojotouchend":case "MSPointerUp":case "pointerup":case "keyup":this._set("active",false);break;}}},_setStateClass:function(){var _3d=this.baseClass.split(" ");function _3e(_3f){_3d=_3d.concat(_32.map(_3d,function(c){return c+_3f;}),"dijit"+_3f);};if(!this.isLeftToRight()){_3e("Rtl");}var _40=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");if(this.checked){_3e(_40);}if(this.state){_3e(this.state);}if(this.selected){_3e("Selected");}if(this._opened){_3e("Opened");}if(this.disabled){_3e("Disabled");}else{if(this.readOnly){_3e("ReadOnly");}else{if(this.active){_3e("Active");}else{if(this.hovering){_3e("Hover");}}}}if(this.focused){_3e("Focused");}var tn=this.stateNode||this.domNode,_41={};_32.forEach(tn.className.split(" "),function(c){_41[c]=true;});if("_stateClasses" in this){_32.forEach(this._stateClasses,function(c){delete _41[c];});}_32.forEach(_3d,function(c){_41[c]=true;});var _42=[];for(var c in _41){_42.push(c);}tn.className=_42.join(" ");this._stateClasses=_3d;},_subnodeCssMouseEvent:function(_43,_44,evt){if(this.disabled||this.readOnly){return;}function _45(_46){_34.toggle(_43,_44+"Hover",_46);};function _47(_48){_34.toggle(_43,_44+"Active",_48);};function _49(_4a){_34.toggle(_43,_44+"Focused",_4a);};switch(evt.type){case "mouseover":case "MSPointerOver":case "pointerover":_45(true);break;case "mouseout":case "MSPointerOut":case "pointerout":_45(false);_47(false);break;case "mousedown":case "touchstart":case "MSPointerDown":case "pointerdown":case "keydown":_47(true);break;case "mouseup":case "MSPointerUp":case "pointerup":case "dojotouchend":case "keyup":_47(false);break;case "focus":case "focusin":_49(true);break;case "blur":case "focusout":_49(false);break;}},_trackMouseState:function(_4b,_4c){_4b._cssState=_4c;}});_36(function(){function _4d(evt,_4e,_4f){if(_4f&&dom.isDescendant(_4f,_4e)){return;}for(var _50=_4e;_50&&_50!=_4f;_50=_50.parentNode){if(_50._cssState){var _51=_39.getEnclosingWidget(_50);if(_51){if(_50==_51.domNode){_51._cssMouseEvent(evt);}else{_51._subnodeCssMouseEvent(_50,_50._cssState,evt);}}}}};var _52=win.body(),_53;on(_52,_37.over,function(evt){_4d(evt,evt.target,evt.relatedTarget);});on(_52,_37.out,function(evt){_4d(evt,evt.target,evt.relatedTarget);});on(_52,_38.press,function(evt){_53=evt.target;_4d(evt,_53);});on(_52,_38.release,function(evt){_4d(evt,_53);_53=null;});on(_52,"focusin, focusout",function(evt){var _54=evt.target;if(_54._cssState&&!_54.getAttribute("widgetId")){var _55=_39.getEnclosingWidget(_54);if(_55){_55._subnodeCssMouseEvent(_54,_54._cssState,evt);}}});});return _3a;});},"dijit/layout/ScrollingTabController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/_base/lang","dojo/on","dojo/query","dojo/sniff","../registry","dojo/text!./templates/ScrollingTabController.html","dojo/text!./templates/_ScrollingTabControllerButton.html","./TabController","./utils","../_WidgetsInTemplateMixin","../Menu","../MenuItem","../form/Button","../_HasDropDown","dojo/NodeList-dom","../a11yclick"],function(_56,_57,_58,_59,_5a,fx,_5b,on,_5c,has,_5d,_5e,_5f,_60,_61,_62,_63,_64,_65,_66){var _67=_57("dijit.layout.ScrollingTabController",[_60,_62],{baseClass:"dijitTabController dijitScrollingTabController",templateString:_5e,useMenu:true,useSlider:true,tabStripClass:"",_minScroll:5,_setClassAttr:{node:"containerNode",type:"class"},buildRendering:function(){this.inherited(arguments);var n=this.domNode;this.scrollNode=this.tablistWrapper;this._initButtons();if(!this.tabStripClass){this.tabStripClass="dijitTabContainer"+this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"")+"None";_58.add(n,"tabStrip-disabled");}_58.add(this.tablistWrapper,this.tabStripClass);},onStartup:function(){this.inherited(arguments);_5a.set(this.domNode,"visibility","");this._postStartup=true;this.own(on(this.containerNode,"attrmodified-label, attrmodified-iconclass",_5b.hitch(this,function(evt){if(this._dim){this.resize(this._dim);}})));},onAddChild:function(_68,_69){this.inherited(arguments);_5a.set(this.containerNode,"width",(_5a.get(this.containerNode,"width")+200)+"px");},onRemoveChild:function(_6a,_6b){var _6c=this.pane2button(_6a.id);if(this._selectedTab===_6c.domNode){this._selectedTab=null;}this.inherited(arguments);},_initButtons:function(){this._btnWidth=0;this._buttons=_5c("> .tabStripButton",this.domNode).filter(function(btn){if((this.useMenu&&btn==this._menuBtn.domNode)||(this.useSlider&&(btn==this._rightBtn.domNode||btn==this._leftBtn.domNode))){this._btnWidth+=_59.getMarginSize(btn).w;return true;}else{_5a.set(btn,"display","none");return false;}},this);},_getTabsWidth:function(){var _6d=this.getChildren();if(_6d.length){var _6e=_6d[this.isLeftToRight()?0:_6d.length-1].domNode,_6f=_6d[this.isLeftToRight()?_6d.length-1:0].domNode;return _6f.offsetLeft+_6f.offsetWidth-_6e.offsetLeft;}else{return 0;}},_enableBtn:function(_70){var _71=this._getTabsWidth();_70=_70||_5a.get(this.scrollNode,"width");return _71>0&&_70<_71;},resize:function(dim){this._dim=dim;this.scrollNode.style.height="auto";var cb=this._contentBox=_61.marginBox2contentBox(this.domNode,{h:0,w:dim.w});cb.h=this.scrollNode.offsetHeight;_59.setContentSize(this.domNode,cb);var _72=this._enableBtn(this._contentBox.w);this._buttons.style("display",_72?"":"none");this._leftBtn.region="left";this._rightBtn.region="right";this._menuBtn.region=this.isLeftToRight()?"right":"left";_61.layoutChildren(this.domNode,this._contentBox,[this._menuBtn,this._leftBtn,this._rightBtn,{domNode:this.scrollNode,region:"center"}]);if(this._selectedTab){if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}this.scrollNode.scrollLeft=this._convertToScrollLeft(this._getScrollForSelectedTab());}this._setButtonClass(this._getScroll());this._postResize=true;return {h:this._contentBox.h,w:dim.w};},_getScroll:function(){return (this.isLeftToRight()||has("ie")<8||(has("trident")&&has("quirks"))||has("webkit"))?this.scrollNode.scrollLeft:_5a.get(this.containerNode,"width")-_5a.get(this.scrollNode,"width")+(has("trident")||has("edge")?-1:1)*this.scrollNode.scrollLeft;},_convertToScrollLeft:function(val){if(this.isLeftToRight()||has("ie")<8||(has("trident")&&has("quirks"))||has("webkit")){return val;}else{var _73=_5a.get(this.containerNode,"width")-_5a.get(this.scrollNode,"width");return (has("trident")||has("edge")?-1:1)*(val-_73);}},onSelectChild:function(_74,_75){var tab=this.pane2button(_74.id);if(!tab){return;}var _76=tab.domNode;if(_76!=this._selectedTab){this._selectedTab=_76;if(this._postResize){var sl=this._getScroll();if(sl>_76.offsetLeft||sl+_5a.get(this.scrollNode,"width")<_76.offsetLeft+_5a.get(_76,"width")){var _77=this.createSmoothScroll();if(_75){_77.onEnd=function(){tab.focus();};}_77.play();}else{if(_75){tab.focus();}}}}this.inherited(arguments);},_getScrollBounds:function(){var _78=this.getChildren(),_79=_5a.get(this.scrollNode,"width"),_7a=_5a.get(this.containerNode,"width"),_7b=_7a-_79,_7c=this._getTabsWidth();if(_78.length&&_7c>_79){return {min:this.isLeftToRight()?0:_78[_78.length-1].domNode.offsetLeft,max:this.isLeftToRight()?(_78[_78.length-1].domNode.offsetLeft+_78[_78.length-1].domNode.offsetWidth)-_79:_7b};}else{var _7d=this.isLeftToRight()?0:_7b;return {min:_7d,max:_7d};}},_getScrollForSelectedTab:function(){var w=this.scrollNode,n=this._selectedTab,_7e=_5a.get(this.scrollNode,"width"),_7f=this._getScrollBounds();var pos=(n.offsetLeft+_5a.get(n,"width")/2)-_7e/2;pos=Math.min(Math.max(pos,_7f.min),_7f.max);return pos;},createSmoothScroll:function(x){if(arguments.length>0){var _80=this._getScrollBounds();x=Math.min(Math.max(x,_80.min),_80.max);}else{x=this._getScrollForSelectedTab();}if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}var _81=this,w=this.scrollNode,_82=new fx.Animation({beforeBegin:function(){if(this.curve){delete this.curve;}var _83=w.scrollLeft,_84=_81._convertToScrollLeft(x);_82.curve=new fx._Line(_83,_84);},onAnimate:function(val){w.scrollLeft=val;}});this._anim=_82;this._setButtonClass(x);return _82;},_getBtnNode:function(e){var n=e.target;while(n&&!_58.contains(n,"tabStripButton")){n=n.parentNode;}return n;},doSlideRight:function(e){this.doSlide(1,this._getBtnNode(e));},doSlideLeft:function(e){this.doSlide(-1,this._getBtnNode(e));},doSlide:function(_85,_86){if(_86&&_58.contains(_86,"dijitTabDisabled")){return;}var _87=_5a.get(this.scrollNode,"width");var d=(_87*0.75)*_85;var to=this._getScroll()+d;this._setButtonClass(to);this.createSmoothScroll(to).play();},_setButtonClass:function(_88){var _89=this._getScrollBounds();this._leftBtn.set("disabled",_88<=_89.min);this._rightBtn.set("disabled",_88>=_89.max);}});var _8a=_57("dijit.layout._ScrollingTabControllerButtonMixin",null,{baseClass:"dijitTab tabStripButton",templateString:_5f,tabIndex:"",isFocusable:function(){return false;}});_57("dijit.layout._ScrollingTabControllerButton",[_65,_8a]);_57("dijit.layout._ScrollingTabControllerMenuButton",[_65,_66,_8a],{containerId:"",tabIndex:"-1",isLoaded:function(){return false;},loadDropDown:function(_8b){this.dropDown=new _63({id:this.containerId+"_menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir});var _8c=_5d.byId(this.containerId);_56.forEach(_8c.getChildren(),function(_8d){var _8e=new _64({id:_8d.id+"_stcMi",label:_8d.title,iconClass:_8d.iconClass,disabled:_8d.disabled,ownerDocument:this.ownerDocument,dir:_8d.dir,lang:_8d.lang,textDir:_8d.textDir||_8c.textDir,onClick:function(){_8c.selectChild(_8d);}});this.dropDown.addChild(_8e);},this);_8b();},closeDropDown:function(_8f){this.inherited(arguments);if(this.dropDown){this._popupStateNode.removeAttribute("aria-owns");this.dropDown.destroyRecursive();delete this.dropDown;}}});return _67;});},"dijit/DialogUnderlay":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/aspect","dojo/dom-attr","dojo/dom-style","dojo/on","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe","./Viewport","./main"],function(_90,_91,_92,_93,_94,on,_95,_96,_97,_98,_99,_9a){var _9b=_90("dijit.DialogUnderlay",[_96,_97],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' tabIndex='-1' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_modalConnects:[],_setDialogIdAttr:function(id){_93.set(this.node,"id",id+"_underlay");this._set("dialogId",id);},_setClassAttr:function(_9c){this.node.className="dijitDialogUnderlay "+_9c;this._set("class",_9c);},postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.own(on(this.domNode,"keydown",_91.hitch(this,"_onKeyDown")));this.inherited(arguments);},layout:function(){var is=this.node.style,os=this.domNode.style;os.display="none";var _9d=_95.getBox(this.ownerDocument);os.top=_9d.t+"px";os.left=_9d.l+"px";is.width=_9d.w+"px";is.height=_9d.h+"px";os.display="block";},show:function(){this.domNode.style.display="block";this.open=true;this.layout();this.bgIframe=new _98(this.domNode);var win=_95.get(this.ownerDocument);this._modalConnects=[_99.on("resize",_91.hitch(this,"layout")),on(win,"scroll",_91.hitch(this,"layout"))];},hide:function(){this.bgIframe.destroy();delete this.bgIframe;this.domNode.style.display="none";while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.open=false;},destroy:function(){while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.inherited(arguments);},_onKeyDown:function(){}});_9b.show=function(_9e,_9f){var _a0=_9b._singleton;if(!_a0||_a0._destroyed){_a0=_9a._underlay=_9b._singleton=new _9b(_9e);}else{if(_9e){_a0.set(_9e);}}_94.set(_a0.domNode,"zIndex",_9f);if(!_a0.open){_a0.show();}};_9b.hide=function(){var _a1=_9b._singleton;if(_a1&&!_a1._destroyed){_a1.hide();}};return _9b;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_a2,_a3,_a4,_a5,win,_a6,_a7){function _a8(_a9,_aa,_ab,_ac){var _ad=_a6.getEffectiveBox(_a9.ownerDocument);if(!_a9.parentNode||String(_a9.parentNode.tagName).toLowerCase()!="body"){win.body(_a9.ownerDocument).appendChild(_a9);}var _ae=null;_a2.some(_aa,function(_af){var _b0=_af.corner;var pos=_af.pos;var _b1=0;var _b2={w:{"L":_ad.l+_ad.w-pos.x,"R":pos.x-_ad.l,"M":_ad.w}[_b0.charAt(1)],h:{"T":_ad.t+_ad.h-pos.y,"B":pos.y-_ad.t,"M":_ad.h}[_b0.charAt(0)]};var s=_a9.style;s.left=s.right="auto";if(_ab){var res=_ab(_a9,_af.aroundCorner,_b0,_b2,_ac);_b1=typeof res=="undefined"?0:res;}var _b3=_a9.style;var _b4=_b3.display;var _b5=_b3.visibility;if(_b3.display=="none"){_b3.visibility="hidden";_b3.display="";}var bb=_a3.position(_a9);_b3.display=_b4;_b3.visibility=_b5;var _b6={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(_ad.l,Math.min(_ad.l+_ad.w,pos.x+(bb.w>>1))-bb.w)}[_b0.charAt(1)],_b7={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(_ad.t,Math.min(_ad.t+_ad.h,pos.y+(bb.h>>1))-bb.h)}[_b0.charAt(0)],_b8=Math.max(_ad.l,_b6),_b9=Math.max(_ad.t,_b7),_ba=Math.min(_ad.l+_ad.w,_b6+bb.w),_bb=Math.min(_ad.t+_ad.h,_b7+bb.h),_bc=_ba-_b8,_bd=_bb-_b9;_b1+=(bb.w-_bc)+(bb.h-_bd);if(_ae==null||_b1<_ae.overflow){_ae={corner:_b0,aroundCorner:_af.aroundCorner,x:_b8,y:_b9,w:_bc,h:_bd,overflow:_b1,spaceAvailable:_b2};}return !_b1;});if(_ae.overflow&&_ab){_ab(_a9,_ae.aroundCorner,_ae.corner,_ae.spaceAvailable,_ac);}var top=_ae.y,_be=_ae.x,_bf=win.body(_a9.ownerDocument);if(/relative|absolute/.test(_a4.get(_bf,"position"))){top-=_a4.get(_bf,"marginTop");_be-=_a4.get(_bf,"marginLeft");}var s=_a9.style;s.top=top+"px";s.left=_be+"px";s.right="auto";return _ae;};var _c0={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _c1={at:function(_c2,pos,_c3,_c4,_c5){var _c6=_a2.map(_c3,function(_c7){var c={corner:_c7,aroundCorner:_c0[_c7],pos:{x:pos.x,y:pos.y}};if(_c4){c.pos.x+=_c7.charAt(1)=="L"?_c4.x:-_c4.x;c.pos.y+=_c7.charAt(0)=="T"?_c4.y:-_c4.y;}return c;});return _a8(_c2,_c6,_c5);},around:function(_c8,_c9,_ca,_cb,_cc){var _cd;if(typeof _c9=="string"||"offsetWidth" in _c9||"ownerSVGElement" in _c9){_cd=_a3.position(_c9,true);if(/^(above|below)/.test(_ca[0])){var _ce=_a3.getBorderExtents(_c9),_cf=_c9.firstChild?_a3.getBorderExtents(_c9.firstChild):{t:0,l:0,b:0,r:0},_d0=_a3.getBorderExtents(_c8),_d1=_c8.firstChild?_a3.getBorderExtents(_c8.firstChild):{t:0,l:0,b:0,r:0};_cd.y+=Math.min(_ce.t+_cf.t,_d0.t+_d1.t);_cd.h-=Math.min(_ce.t+_cf.t,_d0.t+_d1.t)+Math.min(_ce.b+_cf.b,_d0.b+_d1.b);}}else{_cd=_c9;}if(_c9.parentNode){var _d2=_a4.getComputedStyle(_c9).position=="absolute";var _d3=_c9.parentNode;while(_d3&&_d3.nodeType==1&&_d3.nodeName!="BODY"){var _d4=_a3.position(_d3,true),pcs=_a4.getComputedStyle(_d3);if(/relative|absolute/.test(pcs.position)){_d2=false;}if(!_d2&&/hidden|auto|scroll/.test(pcs.overflow)){var _d5=Math.min(_cd.y+_cd.h,_d4.y+_d4.h);var _d6=Math.min(_cd.x+_cd.w,_d4.x+_d4.w);_cd.x=Math.max(_cd.x,_d4.x);_cd.y=Math.max(_cd.y,_d4.y);_cd.h=_d5-_cd.y;_cd.w=_d6-_cd.x;}if(pcs.position=="absolute"){_d2=true;}_d3=_d3.parentNode;}}var x=_cd.x,y=_cd.y,_d7="w" in _cd?_cd.w:(_cd.w=_cd.width),_d8="h" in _cd?_cd.h:(_a5.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_cd.height+", width:"+_d7+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_cd.height+", w:"+_d7+" }","","2.0"),_cd.h=_cd.height);var _d9=[];function _da(_db,_dc){_d9.push({aroundCorner:_db,corner:_dc,pos:{x:{"L":x,"R":x+_d7,"M":x+(_d7>>1)}[_db.charAt(1)],y:{"T":y,"B":y+_d8,"M":y+(_d8>>1)}[_db.charAt(0)]}});};_a2.forEach(_ca,function(pos){var ltr=_cb;switch(pos){case "above-centered":_da("TM","BM");break;case "below-centered":_da("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":_da(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":_da(ltr?"TL":"TR",ltr?"TR":"TL");_da(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":_da(ltr?"BL":"BR",ltr?"TL":"TR");_da(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":_da(ltr?"TL":"TR",ltr?"BL":"BR");_da(ltr?"TR":"TL",ltr?"BR":"BL");break;default:_da(pos.aroundCorner,pos.corner);}});var _dd=_a8(_c8,_d9,_cc,{w:_d7,h:_d8});_dd.aroundNodePos=_cd;return _dd;}};return _a7.place=_c1;});},"dijit/_HasDropDown":function(){define(["dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","./registry","./focus","./popup","./_FocusMixin"],function(_de,_df,dom,_e0,_e1,_e2,_e3,has,_e4,_e5,on,_e6,_e7,_e8,_e9,_ea){return _de("dijit._HasDropDown",_ea,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:-1,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){if(this.disabled||this.readOnly){return;}if(e.type!="MSPointerDown"){e.preventDefault();}this.own(on.once(this.ownerDocument,_e6.release,_e5.hitch(this,"_onDropDownMouseUp")));this.toggleDropDown();},_onDropDownMouseUp:function(e){var _eb=this.dropDown,_ec=false;if(e&&this._opened){var c=_e2.position(this._buttonNode,true);if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){var t=e.target;while(t&&!_ec){if(_e1.contains(t,"dijitPopup")){_ec=true;}else{t=t.parentNode;}}if(_ec){t=e.target;if(_eb.onItemClick){var _ed;while(t&&!(_ed=_e7.byNode(t))){t=t.parentNode;}if(_ed&&_ed.onClick&&_ed.getParent){_ed.getParent().onItemClick(_ed,e);}}return;}}}if(this._opened){if(_eb.focus&&(_eb.autoFocus!==false||(e.type=="mouseup"&&!this.hovering))){this._focusDropDownTimer=this.defer(function(){_eb.focus();delete this._focusDropDownTimer;});}}else{if(this.focus){this.defer("focus");}}},_onDropDownClick:function(e){if(this._stopClickEvents){e.stopPropagation();e.preventDefault();}},buildRendering:function(){this.inherited(arguments);this._buttonNode=this._buttonNode||this.focusNode||this.domNode;this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;var _ee={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";_e1.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_ee+"ArrowButton");},postCreate:function(){this.inherited(arguments);var _ef=this.focusNode||this.domNode;this.own(on(this._buttonNode,_e6.press,_e5.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",_e5.hitch(this,"_onDropDownClick")),on(_ef,"keydown",_e5.hitch(this,"_onKey")),on(_ef,"keyup",_e5.hitch(this,"_onKeyUp")));},destroy:function(){if(this._opened){this.closeDropDown(true);}if(this.dropDown){if(!this.dropDown._destroyed){this.dropDown.destroyRecursive();}delete this.dropDown;}this.inherited(arguments);},_onKey:function(e){if(this.disabled||this.readOnly){return;}var d=this.dropDown,_f0=e.target;if(d&&this._opened&&d.handleKey){if(d.handleKey(e)===false){e.stopPropagation();e.preventDefault();return;}}if(d&&this._opened&&e.keyCode==_e4.ESCAPE){this.closeDropDown();e.stopPropagation();e.preventDefault();}else{if(!this._opened&&(e.keyCode==_e4.DOWN_ARROW||((e.keyCode==_e4.ENTER||(e.keyCode==_e4.SPACE&&(!this._searchTimer||(e.ctrlKey||e.altKey||e.metaKey))))&&((_f0.tagName||"").toLowerCase()!=="input"||(_f0.type&&_f0.type.toLowerCase()!=="text"))))){this._toggleOnKeyUp=true;e.stopPropagation();e.preventDefault();}}},_onKeyUp:function(){if(this._toggleOnKeyUp){delete this._toggleOnKeyUp;this.toggleDropDown();var d=this.dropDown;if(d&&d.focus){this.defer(_e5.hitch(d,"focus"),1);}}},_onBlur:function(){this.closeDropDown(false);this.inherited(arguments);},isLoaded:function(){return true;},loadDropDown:function(_f1){_f1();},loadAndOpenDropDown:function(){var d=new _df(),_f2=_e5.hitch(this,function(){this.openDropDown();d.resolve(this.dropDown);});if(!this.isLoaded()){this.loadDropDown(_f2);}else{_f2();}return d;},toggleDropDown:function(){if(this.disabled||this.readOnly){return;}if(!this._opened){this.loadAndOpenDropDown();}else{this.closeDropDown(true);}},openDropDown:function(){var _f3=this.dropDown,_f4=_f3.domNode,_f5=this._aroundNode||this.domNode,_f6=this;var _f7=_e9.open({parent:this,popup:_f3,around:_f5,orient:this.dropDownPosition,maxHeight:this.maxHeight,onExecute:function(){_f6.closeDropDown(true);},onCancel:function(){_f6.closeDropDown(true);},onClose:function(){_e0.set(_f6._popupStateNode,"popupActive",false);_e1.remove(_f6._popupStateNode,"dijitHasDropDownOpen");_f6._set("_opened",false);}});if(this.forceWidth||(this.autoWidth&&_f5.offsetWidth>_f3._popupWrapper.offsetWidth)){var _f8=_f5.offsetWidth-_f3._popupWrapper.offsetWidth;var _f9={w:_f3.domNode.offsetWidth+_f8};this._origStyle=_f4.style.cssText;if(_e5.isFunction(_f3.resize)){_f3.resize(_f9);}else{_e2.setMarginBox(_f4,_f9);}if(_f7.corner[1]=="R"){_f3._popupWrapper.style.left=(_f3._popupWrapper.style.left.replace("px","")-_f8)+"px";}}_e0.set(this._popupStateNode,"popupActive","true");_e1.add(this._popupStateNode,"dijitHasDropDownOpen");this._set("_opened",true);this._popupStateNode.setAttribute("aria-expanded","true");this._popupStateNode.setAttribute("aria-owns",_f3.id);if(_f4.getAttribute("role")!=="presentation"&&!_f4.getAttribute("aria-labelledby")){_f4.setAttribute("aria-labelledby",this.id);}return _f7;},closeDropDown:function(_fa){if(this._focusDropDownTimer){this._focusDropDownTimer.remove();delete this._focusDropDownTimer;}if(this._opened){this._popupStateNode.setAttribute("aria-expanded","false");if(_fa&&this.focus){this.focus();}_e9.close(this.dropDown);this._opened=false;}if(this._origStyle){this.dropDown.domNode.style.cssText=this._origStyle;delete this._origStyle;}}});});},"dijit/tree/TreeStoreModel":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang"],function(_fb,_fc,_fd,_fe){return _fd("dijit.tree.TreeStoreModel",null,{store:null,childrenAttrs:["children"],newItemIdAttr:"id",labelAttr:"",root:null,query:null,deferItemLoadingUntilExpand:false,constructor:function(_ff){_fe.mixin(this,_ff);this.connects=[];var _100=this.store;if(!_100.getFeatures()["dojo.data.api.Identity"]){throw new Error("dijit.tree.TreeStoreModel: store must support dojo.data.Identity");}if(_100.getFeatures()["dojo.data.api.Notification"]){this.connects=this.connects.concat([_fc.after(_100,"onNew",_fe.hitch(this,"onNewItem"),true),_fc.after(_100,"onDelete",_fe.hitch(this,"onDeleteItem"),true),_fc.after(_100,"onSet",_fe.hitch(this,"onSetItem"),true)]);}},destroy:function(){var h;while(h=this.connects.pop()){h.remove();}},getRoot:function(_101,_102){if(this.root){_101(this.root);}else{this.store.fetch({query:this.query,onComplete:_fe.hitch(this,function(_103){if(_103.length!=1){throw new Error("dijit.tree.TreeStoreModel: root query returned "+_103.length+" items, but must return exactly one");}this.root=_103[0];_101(this.root);}),onError:_102});}},mayHaveChildren:function(item){return _fb.some(this.childrenAttrs,function(attr){return this.store.hasAttribute(item,attr);},this);},getChildren:function(_104,_105,_106){var _107=this.store;if(!_107.isItemLoaded(_104)){var _108=_fe.hitch(this,arguments.callee);_107.loadItem({item:_104,onItem:function(_109){_108(_109,_105,_106);},onError:_106});return;}var _10a=[];for(var i=0;i<this.childrenAttrs.length;i++){var vals=_107.getValues(_104,this.childrenAttrs[i]);_10a=_10a.concat(vals);}var _10b=0;if(!this.deferItemLoadingUntilExpand){_fb.forEach(_10a,function(item){if(!_107.isItemLoaded(item)){_10b++;}});}if(_10b==0){_105(_10a);}else{_fb.forEach(_10a,function(item,idx){if(!_107.isItemLoaded(item)){_107.loadItem({item:item,onItem:function(item){_10a[idx]=item;if(--_10b==0){_105(_10a);}},onError:_106});}});}},isItem:function(_10c){return this.store.isItem(_10c);},fetchItemByIdentity:function(_10d){this.store.fetchItemByIdentity(_10d);},getIdentity:function(item){return this.store.getIdentity(item);},getLabel:function(item){if(this.labelAttr){return this.store.getValue(item,this.labelAttr);}else{return this.store.getLabel(item);}},newItem:function(args,_10e,_10f){var _110={parent:_10e,attribute:this.childrenAttrs[0]},_111;if(this.newItemIdAttr&&args[this.newItemIdAttr]){this.fetchItemByIdentity({identity:args[this.newItemIdAttr],scope:this,onItem:function(item){if(item){this.pasteItem(item,null,_10e,true,_10f);}else{_111=this.store.newItem(args,_110);if(_111&&(_10f!=undefined)){this.pasteItem(_111,_10e,_10e,false,_10f);}}}});}else{_111=this.store.newItem(args,_110);if(_111&&(_10f!=undefined)){this.pasteItem(_111,_10e,_10e,false,_10f);}}},pasteItem:function(_112,_113,_114,_115,_116){var _117=this.store,_118=this.childrenAttrs[0];if(_113){_fb.forEach(this.childrenAttrs,function(attr){if(_117.containsValue(_113,attr,_112)){if(!_115){var _119=_fb.filter(_117.getValues(_113,attr),function(x){return x!=_112;});_117.setValues(_113,attr,_119);}_118=attr;}});}if(_114){if(typeof _116=="number"){var _11a=_117.getValues(_114,_118).slice();_11a.splice(_116,0,_112);_117.setValues(_114,_118,_11a);}else{_117.setValues(_114,_118,_117.getValues(_114,_118).concat(_112));}}},onChange:function(){},onChildrenChange:function(){},onDelete:function(){},onNewItem:function(item,_11b){if(!_11b){return;}this.getChildren(_11b.item,_fe.hitch(this,function(_11c){this.onChildrenChange(_11b.item,_11c);}));},onDeleteItem:function(item){this.onDelete(item);},onSetItem:function(item,_11d){if(_fb.indexOf(this.childrenAttrs,_11d)!=-1){this.getChildren(item,_fe.hitch(this,function(_11e){this.onChildrenChange(item,_11e);}));}else{this.onChange(item);}}});});},"dijit/_MenuBase":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./registry","./_Widget","./_CssStateMixin","./_KeyNavContainer","./_TemplatedMixin"],function(_11f,_120,dom,_121,_122,lang,_123,on,_124,_125,_126,_127,_128,_129,_12a){return _120("dijit._MenuBase",[_127,_12a,_129,_128],{selected:null,_setSelectedAttr:function(item){if(this.selected!=item){if(this.selected){this.selected._setSelected(false);this._onChildDeselect(this.selected);}if(item){item._setSelected(true);}this._set("selected",item);}},activated:false,_setActivatedAttr:function(val){_122.toggle(this.domNode,"dijitMenuActive",val);_122.toggle(this.domNode,"dijitMenuPassive",!val);this._set("activated",val);},parentMenu:null,popupDelay:500,passivePopupDelay:Infinity,autoFocus:false,childSelector:function(node){var _12b=_126.byNode(node);return node.parentNode==this.containerNode&&_12b&&_12b.focus;},postCreate:function(){var self=this,_12c=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.containerNode,on.selector(_12c,_123.enter),function(){self.onItemHover(_126.byNode(this));}),on(this.containerNode,on.selector(_12c,_123.leave),function(){self.onItemUnhover(_126.byNode(this));}),on(this.containerNode,on.selector(_12c,_125),function(evt){self.onItemClick(_126.byNode(this),evt);evt.stopPropagation();}),on(this.containerNode,on.selector(_12c,"focusin"),function(){self._onItemFocus(_126.byNode(this));}));this.inherited(arguments);},onKeyboardSearch:function(item,evt,_12d,_12e){this.inherited(arguments);if(!!item&&(_12e==-1||(!!item.popup&&_12e==1))){this.onItemClick(item,evt);}},_keyboardSearchCompare:function(item,_12f){if(!!item.shortcutKey){return _12f==item.shortcutKey.toLowerCase()?-1:0;}return this.inherited(arguments)?1:0;},onExecute:function(){},onCancel:function(){},_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}else{var _130=this._getTopMenu();if(_130&&_130._isMenuBar){_130.focusNext();}}},_onPopupHover:function(){this.set("selected",this.currentPopupItem);this._stopPendingCloseTimer();},onItemHover:function(item){if(this.activated){this.set("selected",item);if(item.popup&&!item.disabled&&!this.hover_timer){this.hover_timer=this.defer(function(){this._openItemPopup(item);},this.popupDelay);}}else{if(this.passivePopupDelay<Infinity){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.passive_hover_timer=this.defer(function(){this.onItemClick(item,{type:"click"});},this.passivePopupDelay);}}this._hoveredChild=item;item._set("hovering",true);},_onChildDeselect:function(item){this._stopPopupTimer();if(this.currentPopupItem==item){this._stopPendingCloseTimer();this._pendingClose_timer=this.defer(function(){this._pendingClose_timer=null;this.currentPopupItem=null;item._closePopup();},this.popupDelay);}},onItemUnhover:function(item){if(this._hoveredChild==item){this._hoveredChild=null;}if(this.passive_hover_timer){this.passive_hover_timer.remove();this.passive_hover_timer=null;}item._set("hovering",false);},_stopPopupTimer:function(){if(this.hover_timer){this.hover_timer=this.hover_timer.remove();}},_stopPendingCloseTimer:function(){if(this._pendingClose_timer){this._pendingClose_timer=this._pendingClose_timer.remove();}},_getTopMenu:function(){for(var top=this;top.parentMenu;top=top.parentMenu){}return top;},onItemClick:function(item,evt){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.focusChild(item);if(item.disabled){return false;}if(item.popup){this.set("selected",item);this.set("activated",true);var _131=/^key/.test(evt._origType||evt.type)||(evt.clientX==0&&evt.clientY==0);this._openItemPopup(item,_131);}else{this.onExecute();item._onClick?item._onClick(evt):item.onClick(evt);}},_openItemPopup:function(_132,_133){if(_132==this.currentPopupItem){return;}if(this.currentPopupItem){this._stopPendingCloseTimer();this.currentPopupItem._closePopup();}this._stopPopupTimer();var _134=_132.popup;_134.parentMenu=this;this.own(this._mouseoverHandle=on.once(_134.domNode,"mouseover",lang.hitch(this,"_onPopupHover")));var self=this;_132._openPopup({parent:this,orient:this._orient||["after","before"],onCancel:function(){if(_133){self.focusChild(_132);}self._cleanUp();},onExecute:lang.hitch(this,"_cleanUp",true),onClose:function(){if(self._mouseoverHandle){self._mouseoverHandle.remove();delete self._mouseoverHandle;}}},_133);this.currentPopupItem=_132;},onOpen:function(){this.isShowingNow=true;this.set("activated",true);},onClose:function(){this.set("activated",false);this.set("selected",null);this.isShowingNow=false;this.parentMenu=null;},_closeChild:function(){this._stopPopupTimer();if(this.currentPopupItem){if(this.focused){_121.set(this.selected.focusNode,"tabIndex",this.tabIndex);this.selected.focusNode.focus();}this.currentPopupItem._closePopup();this.currentPopupItem=null;}},_onItemFocus:function(item){if(this._hoveredChild&&this._hoveredChild!=item){this.onItemUnhover(this._hoveredChild);}this.set("selected",item);},_onBlur:function(){this._cleanUp(true);this.inherited(arguments);},_cleanUp:function(_135){this._closeChild();if(typeof this.isShowingNow=="undefined"){this.set("activated",false);}if(_135){this.set("selected",null);}}});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_136,_137,dom,_138,_139,_13a,_13b,lang,on,_13c,has,_13d,win,_13e,a11y,_13f,_140){var _141;var _142;var _143=_137([_13d,_13b],{curNode:null,activeStack:[],constructor:function(){var _144=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_136.before(_13a,"empty",_144);_136.before(_13a,"destroy",_144);},registerIframe:function(_145){return this.registerWin(_145.contentWindow,_145);},registerWin:function(_146,_147){var _148=this,body=_146.document&&_146.document.body;if(body){var _149=has("pointer-events")?"pointerdown":has("MSPointer")?"MSPointerDown":has("touch-events")?"mousedown, touchstart":"mousedown";var mdh=on(_146.document,_149,function(evt){if(evt&&evt.target&&evt.target.parentNode==null){return;}_148._onTouchNode(_147||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_148._onFocusNode(_147||evt.target);}else{_148._onTouchNode(_147||evt.target);}});var foh=on(body,"focusout",function(evt){_148._onBlurNode(_147||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){var now=(new Date()).getTime();if(now<_141+100){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}if(now<_142+100){return;}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){_142=(new Date()).getTime();if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}if(_139.contains(node,"dijitPopup")){node=node.firstChild;}var _14a=[];try{while(node){var _14b=_138.get(node,"dijitPopupParent");if(_14b){node=_13f.byId(_14b).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_13e.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_14c=id&&_13f.byId(id);if(_14c&&!(by=="mouse"&&_14c.get("disabled"))){_14a.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_14a,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}_141=(new Date()).getTime();if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_14d,by){var _14e=this.activeStack,_14f=_14e.length-1,_150=_14d.length-1;if(_14d[_150]==_14e[_14f]){return;}this.set("activeStack",_14d);var _151,i;for(i=_14f;i>=0&&_14e[i]!=_14d[i];i--){_151=_13f.byId(_14e[i]);if(_151){_151._hasBeenBlurred=true;_151.set("focused",false);if(_151._focusManager==this){_151._onBlur(by);}this.emit("widget-blur",_151,by);}}for(i++;i<=_150;i++){_151=_13f.byId(_14d[i]);if(_151){_151.set("focused",true);if(_151._focusManager==this){_151._onFocus(by);}this.emit("widget-focus",_151,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _152=new _143();_13c(function(){var _153=_152.registerWin(_13e.get(document));if(has("ie")){on(window,"unload",function(){if(_153){_153.remove();_153=null;}});}});_140.focus=function(node){_152.focus(node);};for(var attr in _152){if(!/^_/.test(attr)){_140.focus[attr]=typeof _152[attr]=="function"?lang.hitch(_152,attr):_152[attr];}}_152.watch(function(attr,_154,_155){_140.focus[attr]=_155;});return _152;});},"dojo/i18n":function(){define(["./_base/kernel","require","./has","./_base/array","./_base/config","./_base/lang","./_base/xhr","./json","module"],function(dojo,_156,has,_157,_158,lang,xhr,json,_159){has.add("dojo-preload-i18n-Api",1);1||has.add("dojo-v1x-i18n-Api",1);var _15a=dojo.i18n={},_15b=/(^.*(^|\/)nls)(\/|$)([^\/]*)\/?([^\/]*)/,_15c=function(root,_15d,_15e,_15f){for(var _160=[_15e+_15f],_161=_15d.split("-"),_162="",i=0;i<_161.length;i++){_162+=(_162?"-":"")+_161[i];if(!root||root[_162]){_160.push(_15e+_162+"/"+_15f);_160.specificity=_162;}}return _160;},_163={},_164=function(_165,_166,_167){_167=_167?_167.toLowerCase():dojo.locale;_165=_165.replace(/\./g,"/");_166=_166.replace(/\./g,"/");return (/root/i.test(_167))?(_165+"/nls/"+_166):(_165+"/nls/"+_167+"/"+_166);},_168=dojo.getL10nName=function(_169,_16a,_16b){return _169=_159.id+"!"+_164(_169,_16a,_16b);},_16c=function(_16d,_16e,_16f,_170,_171,load){_16d([_16e],function(root){var _172=lang.clone(root.root||root.ROOT),_173=_15c(!root._v1x&&root,_171,_16f,_170);_16d(_173,function(){for(var i=1;i<_173.length;i++){_172=lang.mixin(lang.clone(_172),arguments[i]);}var _174=_16e+"/"+_171;_163[_174]=_172;_172.$locale=_173.specificity;load();});});},_175=function(id,_176){return /^\./.test(id)?_176(id):id;},_177=function(_178){var list=_158.extraLocale||[];list=lang.isArray(list)?list:[list];list.push(_178);return list;},load=function(id,_179,load){var _17a=_15b.exec(id),_17b=_17a[1]+"/",_17c=_17a[5]||_17a[4],_17d=_17b+_17c,_17e=(_17a[5]&&_17a[4]),_17f=_17e||dojo.locale||"",_180=_17d+"/"+_17f,_181=_17e?[_17f]:_177(_17f),_182=_181.length,_183=function(){if(!--_182){load(lang.delegate(_163[_180]));}},_184=id.split("*"),_185=_184[1]=="preload";if(has("dojo-preload-i18n-Api")){if(_185){if(!_163[id]){_163[id]=1;_18f(_184[2],json.parse(_184[3]),1,_179);}load(1);}if(_185||(_1ac(id,_179,load)&&!_163[_180])){return;}}else{if(_185){load(1);return;}}_157.forEach(_181,function(_186){var _187=_17d+"/"+_186;if(has("dojo-preload-i18n-Api")){_188(_187);}if(!_163[_187]){_16c(_179,_17d,_17b,_17c,_186,_183);}else{_183();}});};if(has("dojo-preload-i18n-Api")||1){var _189=_15a.normalizeLocale=function(_18a){var _18b=_18a?_18a.toLowerCase():dojo.locale;return _18b=="root"?"ROOT":_18b;},isXd=function(mid,_18c){return (1&&1)?_18c.isXdUrl(_156.toUrl(mid+".js")):true;},_18d=0,_18e=[],_18f=_15a._preloadLocalizations=function(_190,_191,_192,_193){_193=_193||_156;function _194(mid,_195){if(isXd(mid,_193)||_192){_193([mid],_195);}else{_1b0([mid],_195,_193);}};function _196(_197,func){var _198=_197.split("-");while(_198.length){if(func(_198.join("-"))){return;}_198.pop();}func("ROOT");};function _199(){_18d++;};function _19a(){--_18d;while(!_18d&&_18e.length){load.apply(null,_18e.shift());}};function _19b(path,name,loc,_19c){return _19c.toAbsMid(path+name+"/"+loc);};function _19d(_19e){_19e=_189(_19e);_196(_19e,function(loc){if(_157.indexOf(_191,loc)>=0){var mid=_190.replace(/\./g,"/")+"_"+loc;_199();_194(mid,function(_19f){for(var p in _19f){var _1a0=_19f[p],_1a1=p.match(/(.+)\/([^\/]+)$/),_1a2,_1a3;if(!_1a1){continue;}_1a2=_1a1[2];_1a3=_1a1[1]+"/";if(!_1a0._localized){continue;}var _1a4;if(loc==="ROOT"){var root=_1a4=_1a0._localized;delete _1a0._localized;root.root=_1a0;_163[_156.toAbsMid(p)]=root;}else{_1a4=_1a0._localized;_163[_19b(_1a3,_1a2,loc,_156)]=_1a0;}if(loc!==_19e){function _1a5(_1a6,_1a7,_1a8,_1a9){var _1aa=[],_1ab=[];_196(_19e,function(loc){if(_1a9[loc]){_1aa.push(_156.toAbsMid(_1a6+loc+"/"+_1a7));_1ab.push(_19b(_1a6,_1a7,loc,_156));}});if(_1aa.length){_199();_193(_1aa,function(){for(var i=_1aa.length-1;i>=0;i--){_1a8=lang.mixin(lang.clone(_1a8),arguments[i]);_163[_1ab[i]]=_1a8;}_163[_19b(_1a6,_1a7,_19e,_156)]=lang.clone(_1a8);_19a();});}else{_163[_19b(_1a6,_1a7,_19e,_156)]=_1a8;}};_1a5(_1a3,_1a2,_1a0,_1a4);}}_19a();});return true;}return false;});};_19d();_157.forEach(dojo.config.extraLocale,_19d);},_1ac=function(id,_1ad,load){if(_18d){_18e.push([id,_1ad,load]);}return _18d;},_188=function(){};}if(1){var _1ae={},_1af,_1b0=function(deps,_1b1,_1b2){var _1b3=[];_157.forEach(deps,function(mid){var url=_1b2.toUrl(mid+".js");function load(text){if(!_1af){_1af=new Function("__bundle","__checkForLegacyModules","__mid","__amdValue","var define = function(mid, factory){define.called = 1; __amdValue.result = factory || mid;},"+"\t   require = function(){define.called = 1;};"+"try{"+"define.called = 0;"+"eval(__bundle);"+"if(define.called==1)"+"return __amdValue;"+"if((__checkForLegacyModules = __checkForLegacyModules(__mid)))"+"return __checkForLegacyModules;"+"}catch(e){}"+"try{"+"return eval('('+__bundle+')');"+"}catch(e){"+"return e;"+"}");}var _1b4=_1af(text,_188,mid,_1ae);if(_1b4===_1ae){_1b3.push(_163[url]=_1ae.result);}else{if(_1b4 instanceof Error){console.error("failed to evaluate i18n bundle; url="+url,_1b4);_1b4={};}_1b3.push(_163[url]=(/nls\/[^\/]+\/[^\/]+$/.test(url)?_1b4:{root:_1b4,_v1x:1}));}};if(_163[url]){_1b3.push(_163[url]);}else{var _1b5=_1b2.syncLoadNls(mid);if(!_1b5){_1b5=_188(mid.replace(/nls\/([^\/]*)\/([^\/]*)$/,"nls/$2/$1"));}if(_1b5){_1b3.push(_1b5);}else{if(!xhr){try{_1b2.getText(url,true,load);}catch(e){_1b3.push(_163[url]={});}}else{xhr.get({url:url,sync:true,load:load,error:function(){_1b3.push(_163[url]={});}});}}}});_1b1&&_1b1.apply(null,_1b3);};_188=function(_1b6){for(var _1b7,_1b8=_1b6.split("/"),_1b9=dojo.global[_1b8[0]],i=1;_1b9&&i<_1b8.length-1;_1b9=_1b9[_1b8[i++]]){}if(_1b9){_1b7=_1b9[_1b8[i]];if(!_1b7){_1b7=_1b9[_1b8[i].replace(/-/g,"_")];}if(_1b7){_163[_1b6]=_1b7;}}return _1b7;};_15a.getLocalization=function(_1ba,_1bb,_1bc){var _1bd,_1be=_164(_1ba,_1bb,_1bc);load(_1be,(!isXd(_1be,_156)?function(deps,_1bf){_1b0(deps,_1bf,_156);}:_156),function(_1c0){_1bd=_1c0;});return _1bd;};}return lang.mixin(_15a,{dynamic:true,normalize:_175,load:load,cache:_163,getL10nName:_168});});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_1c1,has,_1c2,win){_1c2(function(){if(has("highcontrast")){_1c1.add(win.body(),"dijit_a11y");}});return has;});},"dijit/tree/ForestStoreModel":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./TreeStoreModel"],function(_1c3,_1c4,_1c5,lang,_1c6){return _1c4("dijit.tree.ForestStoreModel",_1c6,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_1c7){this.root={store:this,root:true,id:_1c7.rootId,label:_1c7.rootLabel,children:_1c7.rootChildren};},mayHaveChildren:function(item){return item===this.root||this.inherited(arguments);},getChildren:function(_1c8,_1c9,_1ca){if(_1c8===this.root){if(this.root.children){_1c9(this.root.children);}else{this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_1cb){this.root.children=_1cb;_1c9(_1cb);}),onError:_1ca});}}else{this.inherited(arguments);}},isItem:function(_1cc){return (_1cc===this.root)?true:this.inherited(arguments);},fetchItemByIdentity:function(_1cd){if(_1cd.identity==this.root.id){var _1ce=_1cd.scope||_1c5.global;if(_1cd.onItem){_1cd.onItem.call(_1ce,this.root);}}else{this.inherited(arguments);}},getIdentity:function(item){return (item===this.root)?this.root.id:this.inherited(arguments);},getLabel:function(item){return (item===this.root)?this.root.label:this.inherited(arguments);},newItem:function(args,_1cf,_1d0){if(_1cf===this.root){this.onNewRootItem(args);return this.store.newItem(args);}else{return this.inherited(arguments);}},onNewRootItem:function(){},pasteItem:function(_1d1,_1d2,_1d3,_1d4,_1d5){if(_1d2===this.root){if(!_1d4){this.onLeaveRoot(_1d1);}}this.inherited(arguments,[_1d1,_1d2===this.root?null:_1d2,_1d3===this.root?null:_1d3,_1d4,_1d5]);if(_1d3===this.root){this.onAddToRoot(_1d1);}},onAddToRoot:function(item){},onLeaveRoot:function(item){},_requeryTop:function(){var _1d6=this.root.children||[];this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_1d7){this.root.children=_1d7;if(_1d6.length!=_1d7.length||_1c3.some(_1d6,function(item,idx){return _1d7[idx]!=item;})){this.onChildrenChange(this.root,_1d7);}})});},onNewItem:function(item,_1d8){this._requeryTop();this.inherited(arguments);},onDeleteItem:function(item){if(_1c3.indexOf(this.root.children,item)!=-1){this._requeryTop();}this.inherited(arguments);},onSetItem:function(item,_1d9,_1da,_1db){this._requeryTop();this.inherited(arguments);}});});},"dojo/node":function(){define(["./_base/kernel","./has","require"],function(_1dc,has,_1dd){var _1de=_1dc.global.require&&_1dc.global.require.nodeRequire;if(!_1de){throw new Error("Cannot find the Node.js require");}var _1df=_1de("module");return {load:function(id,_1e0,load){if(_1df._findPath&&_1df._nodeModulePaths){var _1e1=_1df._findPath(id,_1df._nodeModulePaths(_1e0.toUrl(".")));if(_1e1!==false){id=_1e1;}}var _1e2=define,_1e3;define=undefined;try{_1e3=_1de(id);}finally{define=_1e2;}load(_1e3);},normalize:function(id,_1e4){if(id.charAt(0)==="."){id=_1dd.toUrl(_1e4("./"+id));}return id;}};});},"dijit/form/_ComboBoxMenuMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/i18n","dojo/i18n!./nls/ComboBox"],function(_1e5,_1e6,_1e7,has,i18n){var _1e8=_1e6("dijit.form._ComboBoxMenuMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{_messages:null,postMixInProperties:function(){this.inherited(arguments);this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);},buildRendering:function(){this.inherited(arguments);this.previousButton.innerHTML=this._messages["previousMessage"];this.nextButton.innerHTML=this._messages["nextMessage"];},_setValueAttr:function(_1e9){this._set("value",_1e9);this.onChange(_1e9);},onClick:function(node){if(node==this.previousButton){this._setSelectedAttr(null);this.onPage(-1);}else{if(node==this.nextButton){this._setSelectedAttr(null);this.onPage(1);}else{this.onChange(node);}}},onChange:function(){},onPage:function(){},onClose:function(){this._setSelectedAttr(null);},_createOption:function(item,_1ea){var _1eb=this._createMenuItem();var _1ec=_1ea(item);if(_1ec.html){_1eb.innerHTML=_1ec.label;}else{_1eb.appendChild(_1eb.ownerDocument.createTextNode(_1ec.label));}if(_1eb.innerHTML==""){_1eb.innerHTML="&#160;";}return _1eb;},createOptions:function(_1ed,_1ee,_1ef){this.items=_1ed;this.previousButton.style.display=(_1ee.start==0)?"none":"";_1e7.set(this.previousButton,"id",this.id+"_prev");_1e5.forEach(_1ed,function(item,i){var _1f0=this._createOption(item,_1ef);_1f0.setAttribute("item",i);_1e7.set(_1f0,"id",this.id+i);this.nextButton.parentNode.insertBefore(_1f0,this.nextButton);},this);var _1f1=false;if(_1ed.total&&!_1ed.total.then&&_1ed.total!=-1){if((_1ee.start+_1ee.count)<_1ed.total){_1f1=true;}else{if((_1ee.start+_1ee.count)>_1ed.total&&_1ee.count==_1ed.length){_1f1=true;}}}else{if(_1ee.count==_1ed.length){_1f1=true;}}this.nextButton.style.display=_1f1?"":"none";_1e7.set(this.nextButton,"id",this.id+"_next");},clearResultList:function(){var _1f2=this.containerNode;while(_1f2.childNodes.length>2){_1f2.removeChild(_1f2.childNodes[_1f2.childNodes.length-2]);}this._setSelectedAttr(null);},highlightFirstOption:function(){this.selectFirstNode();},highlightLastOption:function(){this.selectLastNode();},selectFirstNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.previousButton){this.selectNextNode();}},selectLastNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.nextButton){this.selectPreviousNode();}},getHighlightedOption:function(){return this.selected;}});if(has("dojo-bidi")){_1e8=_1e6("dijit.form._ComboBoxMenuMixin",_1e8,{_createOption:function(){var _1f3=this.inherited(arguments);this.applyTextDir(_1f3);return _1f3;}});}return _1e8;});},"dijit/form/_SearchMixin":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/query","dojo/string","dojo/when","../registry"],function(_1f4,keys,lang,_1f5,_1f6,when,_1f7){return _1f4("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},list:"",_setListAttr:function(list){this._set("list",list);},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_patternToRegExp:function(_1f8){return new RegExp("^"+_1f8.replace(/(\\.)|(\*)|(\?)|\W/g,function(str,_1f9,star,_1fa){return star?".*":_1fa?".":_1f9?_1f9:"\\"+str;})+"$",this.ignoreCase?"mi":"m");},_abortQuery:function(){if(this.searchTimer){this.searchTimer=this.searchTimer.remove();}if(this._queryDeferHandle){this._queryDeferHandle=this._queryDeferHandle.remove();}if(this._fetchHandle){if(this._fetchHandle.abort){this._cancelingQuery=true;this._fetchHandle.abort();this._cancelingQuery=false;}if(this._fetchHandle.cancel){this._cancelingQuery=true;this._fetchHandle.cancel();this._cancelingQuery=false;}this._fetchHandle=null;}},_processInput:function(evt){if(this.disabled||this.readOnly){return;}var key=evt.charOrCode;this._prev_key_backspace=false;if(key==keys.DELETE||key==keys.BACKSPACE){this._prev_key_backspace=true;this._maskValidSubsetError=true;}if(!this.store){this.onSearch();}else{this.searchTimer=this.defer("_startSearchFromInput",1);}},onSearch:function(){},_startSearchFromInput:function(){this._startSearch(this.focusNode.value);},_startSearch:function(text){this._abortQuery();var _1fb=this,_1f5=lang.clone(this.query),_1fc={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_1f6.substitute(this.queryExpr,[text.replace(/([\\\*\?])/g,"\\$1")]),q,_1fd=function(){var _1fe=_1fb._fetchHandle=_1fb.store.query(_1f5,_1fc);if(_1fb.disabled||_1fb.readOnly||(q!==_1fb._lastQuery)){return;}when(_1fe,function(res){_1fb._fetchHandle=null;if(!_1fb.disabled&&!_1fb.readOnly&&(q===_1fb._lastQuery)){when(_1fe.total,function(_1ff){res.total=_1ff;var _200=_1fb.pageSize;if(isNaN(_200)||_200>res.total){_200=res.total;}res.nextPage=function(_201){_1fc.direction=_201=_201!==false;_1fc.count=_200;if(_201){_1fc.start+=res.length;if(_1fc.start>=res.total){_1fc.count=0;}}else{_1fc.start-=_200;if(_1fc.start<0){_1fc.count=Math.max(_200+_1fc.start,0);_1fc.start=0;}}if(_1fc.count<=0){res.length=0;_1fb.onSearch(res,_1f5,_1fc);}else{_1fd();}};_1fb.onSearch(res,_1f5,_1fc);});}},function(err){_1fb._fetchHandle=null;if(!_1fb._cancelingQuery){console.error(_1fb.declaredClass+" "+err.toString());}});};lang.mixin(_1fc,this.fetchProperties);if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_1f5[this.searchAttr]=q;this._queryDeferHandle=this.defer(_1fd,this.searchDelay);},constructor:function(){this.query={};this.fetchProperties={};},postMixInProperties:function(){if(!this.store){var list=this.list;if(list){this.store=_1f7.byId(list);}}this.inherited(arguments);}});});},"dojo/parser":function(){define(["require","./_base/kernel","./_base/lang","./_base/array","./_base/config","./dom","./_base/window","./_base/url","./aspect","./promise/all","./date/stamp","./Deferred","./has","./query","./on","./ready"],function(_202,dojo,_203,_204,_205,dom,_206,_207,_208,all,_209,_20a,has,_20b,don,_20c){new Date("X");function _20d(text){return eval("("+text+")");};var _20e=0;_208.after(_203,"extend",function(){_20e++;},true);function _20f(ctor){var map=ctor._nameCaseMap,_210=ctor.prototype;if(!map||map._extendCnt<_20e){map=ctor._nameCaseMap={};for(var name in _210){if(name.charAt(0)==="_"){continue;}map[name.toLowerCase()]=name;}map._extendCnt=_20e;}return map;};function _211(_212,_213){if(!_213){_213=_202;}var _214=_213._dojoParserCtorMap||(_213._dojoParserCtorMap={});var ts=_212.join();if(!_214[ts]){var _215=[];for(var i=0,l=_212.length;i<l;i++){var t=_212[i];_215[_215.length]=(_214[t]=_214[t]||(_203.getObject(t)||(~t.indexOf("/")&&_213(t))));}var ctor=_215.shift();_214[ts]=_215.length?(ctor.createSubclass?ctor.createSubclass(_215):ctor.extend.apply(ctor,_215)):ctor;}return _214[ts];};var _216={_clearCache:function(){_20e++;_ctorMap={};},_functionFromScript:function(_217,_218){var _219="",_21a="",_21b=(_217.getAttribute(_218+"args")||_217.getAttribute("args")),_21c=_217.getAttribute("with");var _21d=(_21b||"").split(/\s*,\s*/);if(_21c&&_21c.length){_204.forEach(_21c.split(/\s*,\s*/),function(part){_219+="with("+part+"){";_21a+="}";});}return new Function(_21d,_219+_217.innerHTML+_21a);},instantiate:function(_21e,_21f,_220){_21f=_21f||{};_220=_220||{};var _221=(_220.scope||dojo._scopeName)+"Type",_222="data-"+(_220.scope||dojo._scopeName)+"-",_223=_222+"type",_224=_222+"mixins";var list=[];_204.forEach(_21e,function(node){var type=_221 in _21f?_21f[_221]:node.getAttribute(_223)||node.getAttribute(_221);if(type){var _225=node.getAttribute(_224),_226=_225?[type].concat(_225.split(/\s*,\s*/)):[type];list.push({node:node,types:_226});}});return this._instantiate(list,_21f,_220);},_instantiate:function(_227,_228,_229,_22a){var _22b=_204.map(_227,function(obj){var ctor=obj.ctor||_211(obj.types,_229.contextRequire);if(!ctor){throw new Error("Unable to resolve constructor for: '"+obj.types.join()+"'");}return this.construct(ctor,obj.node,_228,_229,obj.scripts,obj.inherited);},this);function _22c(_22d){if(!_228._started&&!_229.noStart){_204.forEach(_22d,function(_22e){if(typeof _22e.startup==="function"&&!_22e._started){_22e.startup();}});}return _22d;};if(_22a){return all(_22b).then(_22c);}else{return _22c(_22b);}},construct:function(ctor,node,_22f,_230,_231,_232){var _233=ctor&&ctor.prototype;_230=_230||{};var _234={};if(_230.defaults){_203.mixin(_234,_230.defaults);}if(_232){_203.mixin(_234,_232);}var _235;if(has("dom-attributes-explicit")){_235=node.attributes;}else{if(has("dom-attributes-specified-flag")){_235=_204.filter(node.attributes,function(a){return a.specified;});}else{var _236=/^input$|^img$/i.test(node.nodeName)?node:node.cloneNode(false),_237=_236.outerHTML.replace(/=[^\s"']+|="[^"]*"|='[^']*'/g,"").replace(/^\s*<[a-zA-Z0-9]*\s*/,"").replace(/\s*>.*$/,"");_235=_204.map(_237.split(/\s+/),function(name){var _238=name.toLowerCase();return {name:name,value:(node.nodeName=="LI"&&name=="value")||_238=="enctype"?node.getAttribute(_238):node.getAttributeNode(_238).value};});}}var _239=_230.scope||dojo._scopeName,_23a="data-"+_239+"-",hash={};if(_239!=="dojo"){hash[_23a+"props"]="data-dojo-props";hash[_23a+"type"]="data-dojo-type";hash[_23a+"mixins"]="data-dojo-mixins";hash[_239+"type"]="dojotype";hash[_23a+"id"]="data-dojo-id";}var i=0,item,_23b=[],_23c,_23d;while(item=_235[i++]){var name=item.name,_23e=name.toLowerCase(),_23f=item.value;switch(hash[_23e]||_23e){case "data-dojo-type":case "dojotype":case "data-dojo-mixins":break;case "data-dojo-props":_23d=_23f;break;case "data-dojo-id":case "jsid":_23c=_23f;break;case "data-dojo-attach-point":case "dojoattachpoint":_234.dojoAttachPoint=_23f;break;case "data-dojo-attach-event":case "dojoattachevent":_234.dojoAttachEvent=_23f;break;case "class":_234["class"]=node.className;break;case "style":_234["style"]=node.style&&node.style.cssText;break;default:if(!(name in _233)){var map=_20f(ctor);name=map[_23e]||name;}if(name in _233){switch(typeof _233[name]){case "string":_234[name]=_23f;break;case "number":_234[name]=_23f.length?Number(_23f):NaN;break;case "boolean":_234[name]=_23f.toLowerCase()!="false";break;case "function":if(_23f===""||_23f.search(/[^\w\.]+/i)!=-1){_234[name]=new Function(_23f);}else{_234[name]=_203.getObject(_23f,false)||new Function(_23f);}_23b.push(name);break;default:var pVal=_233[name];_234[name]=(pVal&&"length" in pVal)?(_23f?_23f.split(/\s*,\s*/):[]):(pVal instanceof Date)?(_23f==""?new Date(""):_23f=="now"?new Date():_209.fromISOString(_23f)):(pVal instanceof _207)?(dojo.baseUrl+_23f):_20d(_23f);}}else{_234[name]=_23f;}}}for(var j=0;j<_23b.length;j++){var _240=_23b[j].toLowerCase();node.removeAttribute(_240);node[_240]=null;}if(_23d){try{_23d=_20d.call(_230.propsThis,"{"+_23d+"}");_203.mixin(_234,_23d);}catch(e){throw new Error(e.toString()+" in data-dojo-props='"+_23d+"'");}}_203.mixin(_234,_22f);if(!_231){_231=(ctor&&(ctor._noScript||_233._noScript)?[]:_20b("> script[type^='dojo/']",node));}var _241=[],_242=[],_243=[],ons=[];if(_231){for(i=0;i<_231.length;i++){var _244=_231[i];node.removeChild(_244);var _245=(_244.getAttribute(_23a+"event")||_244.getAttribute("event")),prop=_244.getAttribute(_23a+"prop"),_246=_244.getAttribute(_23a+"method"),_247=_244.getAttribute(_23a+"advice"),_248=_244.getAttribute("type"),nf=this._functionFromScript(_244,_23a);if(_245){if(_248=="dojo/connect"){_241.push({method:_245,func:nf});}else{if(_248=="dojo/on"){ons.push({event:_245,func:nf});}else{_234[_245]=nf;}}}else{if(_248=="dojo/aspect"){_241.push({method:_246,advice:_247,func:nf});}else{if(_248=="dojo/watch"){_243.push({prop:prop,func:nf});}else{_242.push(nf);}}}}}var _249=ctor.markupFactory||_233.markupFactory;var _24a=_249?_249(_234,node,ctor):new ctor(_234,node);function _24b(_24c){if(_23c){_203.setObject(_23c,_24c);}for(i=0;i<_241.length;i++){_208[_241[i].advice||"after"](_24c,_241[i].method,_203.hitch(_24c,_241[i].func),true);}for(i=0;i<_242.length;i++){_242[i].call(_24c);}for(i=0;i<_243.length;i++){_24c.watch(_243[i].prop,_243[i].func);}for(i=0;i<ons.length;i++){don(_24c,ons[i].event,ons[i].func);}return _24c;};if(_24a.then){return _24a.then(_24b);}else{return _24b(_24a);}},scan:function(root,_24d){var list=[],mids=[],_24e={};var _24f=(_24d.scope||dojo._scopeName)+"Type",_250="data-"+(_24d.scope||dojo._scopeName)+"-",_251=_250+"type",_252=_250+"textdir",_253=_250+"mixins";var node=root.firstChild;var _254=_24d.inherited;if(!_254){function _255(node,attr){return (node.getAttribute&&node.getAttribute(attr))||(node.parentNode&&_255(node.parentNode,attr));};_254={dir:_255(root,"dir"),lang:_255(root,"lang"),textDir:_255(root,_252)};for(var key in _254){if(!_254[key]){delete _254[key];}}}var _256={inherited:_254};var _257;var _258;function _259(_25a){if(!_25a.inherited){_25a.inherited={};var node=_25a.node,_25b=_259(_25a.parent);var _25c={dir:node.getAttribute("dir")||_25b.dir,lang:node.getAttribute("lang")||_25b.lang,textDir:node.getAttribute(_252)||_25b.textDir};for(var key in _25c){if(_25c[key]){_25a.inherited[key]=_25c[key];}}}return _25a.inherited;};while(true){if(!node){if(!_256||!_256.node){break;}node=_256.node.nextSibling;_258=false;_256=_256.parent;_257=_256.scripts;continue;}if(node.nodeType!=1){node=node.nextSibling;continue;}if(_257&&node.nodeName.toLowerCase()=="script"){type=node.getAttribute("type");if(type&&/^dojo\/\w/i.test(type)){_257.push(node);}node=node.nextSibling;continue;}if(_258){node=node.nextSibling;continue;}var type=node.getAttribute(_251)||node.getAttribute(_24f);var _25d=node.firstChild;if(!type&&(!_25d||(_25d.nodeType==3&&!_25d.nextSibling))){node=node.nextSibling;continue;}var _25e;var ctor=null;if(type){var _25f=node.getAttribute(_253),_260=_25f?[type].concat(_25f.split(/\s*,\s*/)):[type];try{ctor=_211(_260,_24d.contextRequire);}catch(e){}if(!ctor){_204.forEach(_260,function(t){if(~t.indexOf("/")&&!_24e[t]){_24e[t]=true;mids[mids.length]=t;}});}var _261=ctor&&!ctor.prototype._noScript?[]:null;_25e={types:_260,ctor:ctor,parent:_256,node:node,scripts:_261};_25e.inherited=_259(_25e);list.push(_25e);}else{_25e={node:node,scripts:_257,parent:_256};}_257=_261;_258=node.stopParser||(ctor&&ctor.prototype.stopParser&&!(_24d.template));_256=_25e;node=_25d;}var d=new _20a();if(mids.length){if(has("dojo-debug-messages")){console.warn("WARNING: Modules being Auto-Required: "+mids.join(", "));}var r=_24d.contextRequire||_202;r(mids,function(){d.resolve(_204.filter(list,function(_262){if(!_262.ctor){try{_262.ctor=_211(_262.types,_24d.contextRequire);}catch(e){}}var _263=_262.parent;while(_263&&!_263.types){_263=_263.parent;}var _264=_262.ctor&&_262.ctor.prototype;_262.instantiateChildren=!(_264&&_264.stopParser&&!(_24d.template));_262.instantiate=!_263||(_263.instantiate&&_263.instantiateChildren);return _262.instantiate;}));});}else{d.resolve(list);}return d.promise;},_require:function(_265,_266){var hash=_20d("{"+_265.innerHTML+"}"),vars=[],mids=[],d=new _20a();var _267=(_266&&_266.contextRequire)||_202;for(var name in hash){vars.push(name);mids.push(hash[name]);}_267(mids,function(){for(var i=0;i<vars.length;i++){_203.setObject(vars[i],arguments[i]);}d.resolve(arguments);});return d.promise;},_scanAmd:function(root,_268){var _269=new _20a(),_26a=_269.promise;_269.resolve(true);var self=this;_20b("script[type='dojo/require']",root).forEach(function(node){_26a=_26a.then(function(){return self._require(node,_268);});node.parentNode.removeChild(node);});return _26a;},parse:function(_26b,_26c){if(_26b&&typeof _26b!="string"&&!("nodeType" in _26b)){_26c=_26b;_26b=_26c.rootNode;}var root=_26b?dom.byId(_26b):_206.body();_26c=_26c||{};var _26d=_26c.template?{template:true}:{},_26e=[],self=this;var p=this._scanAmd(root,_26c).then(function(){return self.scan(root,_26c);}).then(function(_26f){return self._instantiate(_26f,_26d,_26c,true);}).then(function(_270){return _26e=_26e.concat(_270);}).otherwise(function(e){console.error("dojo/parser::parse() error",e);throw e;});_203.mixin(_26e,p);return _26e;}};if(1){dojo.parser=_216;}if(_205.parseOnLoad){_20c(100,_216,"parse");}return _216;});},"dojo/dnd/Manager":function(){define(["../_base/array","../_base/declare","../_base/lang","../_base/window","../dom-class","../Evented","../has","../keys","../on","../topic","../touch","./common","./autoscroll","./Avatar"],function(_271,_272,lang,win,_273,_274,has,keys,on,_275,_276,dnd,_277,_278){var _279=_272("dojo.dnd.Manager",[_274],{constructor:function(){this.avatar=null;this.source=null;this.nodes=[];this.copy=true;this.target=null;this.canDropFlag=false;this.events=[];},OFFSET_X:has("touch")?4:16,OFFSET_Y:has("touch")?4:16,overSource:function(_27a){if(this.avatar){this.target=(_27a&&_27a.targetState!="Disabled")?_27a:null;this.canDropFlag=Boolean(this.target);this.avatar.update();}_275.publish("/dnd/source/over",_27a);},outSource:function(_27b){if(this.avatar){if(this.target==_27b){this.target=null;this.canDropFlag=false;this.avatar.update();_275.publish("/dnd/source/over",null);}}else{_275.publish("/dnd/source/over",null);}},startDrag:function(_27c,_27d,copy){_277.autoScrollStart(win.doc);this.source=_27c;this.nodes=_27d;this.copy=Boolean(copy);this.avatar=this.makeAvatar();win.body().appendChild(this.avatar.node);_275.publish("/dnd/start",_27c,_27d,this.copy);function _27e(e){e.preventDefault();e.stopPropagation();};this.events=[on(win.doc,_276.move,lang.hitch(this,"onMouseMove")),on(win.doc,_276.release,lang.hitch(this,"onMouseUp")),on(win.doc,"keydown",lang.hitch(this,"onKeyDown")),on(win.doc,"keyup",lang.hitch(this,"onKeyUp")),on(win.doc,"dragstart",_27e),on(win.body(),"selectstart",_27e)];var c="dojoDnd"+(copy?"Copy":"Move");_273.add(win.body(),c);},canDrop:function(flag){var _27f=Boolean(this.target&&flag);if(this.canDropFlag!=_27f){this.canDropFlag=_27f;this.avatar.update();}},stopDrag:function(){_273.remove(win.body(),["dojoDndCopy","dojoDndMove"]);_271.forEach(this.events,function(_280){_280.remove();});this.events=[];this.avatar.destroy();this.avatar=null;this.source=this.target=null;this.nodes=[];},makeAvatar:function(){return new _278(this);},updateAvatar:function(){this.avatar.update();},onMouseMove:function(e){var a=this.avatar;if(a){_277.autoScrollNodes(e);var s=a.node.style;s.left=(e.pageX+this.OFFSET_X)+"px";s.top=(e.pageY+this.OFFSET_Y)+"px";var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));if(this.copy!=copy){this._setCopyStatus(copy);}}if(has("touch")){e.preventDefault();}},onMouseUp:function(e){if(this.avatar){if(this.target&&this.canDropFlag){var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));_275.publish("/dnd/drop/before",this.source,this.nodes,copy,this.target,e);_275.publish("/dnd/drop",this.source,this.nodes,copy,this.target,e);}else{_275.publish("/dnd/cancel");}this.stopDrag();}},onKeyDown:function(e){if(this.avatar){switch(e.keyCode){case keys.CTRL:var copy=Boolean(this.source.copyState(true));if(this.copy!=copy){this._setCopyStatus(copy);}break;case keys.ESCAPE:_275.publish("/dnd/cancel");this.stopDrag();break;}}},onKeyUp:function(e){if(this.avatar&&e.keyCode==keys.CTRL){var copy=Boolean(this.source.copyState(false));if(this.copy!=copy){this._setCopyStatus(copy);}}},_setCopyStatus:function(copy){this.copy=copy;this.source._markDndStatus(this.copy);this.updateAvatar();_273.replace(win.body(),"dojoDnd"+(this.copy?"Copy":"Move"),"dojoDnd"+(this.copy?"Move":"Copy"));}});dnd._manager=null;_279.manager=dnd.manager=function(){if(!dnd._manager){dnd._manager=new _279();}return dnd._manager;};return _279;});},"dijit/form/ToggleButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_281,_282,_283,_284){return _281("dijit.form.ToggleButton",[_283,_284],{baseClass:"dijitToggleButton",setChecked:function(_285){_282.deprecated("setChecked("+_285+") is deprecated. Use set('checked',"+_285+") instead.","","2.0");this.set("checked",_285);}});});},"dojo/date/stamp":function(){define(["../_base/lang","../_base/array"],function(lang,_286){var _287={};lang.setObject("dojo.date.stamp",_287);_287.fromISOString=function(_288,_289){if(!_287._isoRegExp){_287._isoRegExp=/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;}var _28a=_287._isoRegExp.exec(_288),_28b=null;if(_28a){_28a.shift();if(_28a[1]){_28a[1]--;}if(_28a[6]){_28a[6]*=1000;}if(_289){_289=new Date(_289);_286.forEach(_286.map(["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],function(prop){return _289["get"+prop]();}),function(_28c,_28d){_28a[_28d]=_28a[_28d]||_28c;});}_28b=new Date(_28a[0]||1970,_28a[1]||0,_28a[2]||1,_28a[3]||0,_28a[4]||0,_28a[5]||0,_28a[6]||0);if(_28a[0]<100){_28b.setFullYear(_28a[0]||1970);}var _28e=0,_28f=_28a[7]&&_28a[7].charAt(0);if(_28f!="Z"){_28e=((_28a[8]||0)*60)+(Number(_28a[9])||0);if(_28f!="-"){_28e*=-1;}}if(_28f){_28e-=_28b.getTimezoneOffset();}if(_28e){_28b.setTime(_28b.getTime()+_28e*60000);}}return _28b;};_287.toISOString=function(_290,_291){var _292=function(n){return (n<10)?"0"+n:n;};_291=_291||{};var _293=[],_294=_291.zulu?"getUTC":"get",date="";if(_291.selector!="time"){var year=_290[_294+"FullYear"]();date=["0000".substr((year+"").length)+year,_292(_290[_294+"Month"]()+1),_292(_290[_294+"Date"]())].join("-");}_293.push(date);if(_291.selector!="date"){var time=[_292(_290[_294+"Hours"]()),_292(_290[_294+"Minutes"]()),_292(_290[_294+"Seconds"]())].join(":");var _295=_290[_294+"Milliseconds"]();if(_291.milliseconds){time+="."+(_295<100?"0":"")+_292(_295);}if(_291.zulu){time+="Z";}else{if(_291.selector!="time"){var _296=_290.getTimezoneOffset();var _297=Math.abs(_296);time+=(_296>0?"-":"+")+_292(Math.floor(_297/60))+":"+_292(_297%60);}}_293.push(time);}return _293.join("T");};return _287;});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_298,lang,_299,when){return _298("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_29a){if(_29a){this.set(_29a);}},_get:function(name,_29b){return typeof this[_29b.g]==="function"?this[_29b.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_29c){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _29d=this._getAttrNames(name),_29e=this._get(name,_29d),_29f=this[_29d.s],_2a0;if(typeof _29f==="function"){_2a0=_29f.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_29c;}if(this._watchCallbacks){var self=this;when(_2a0,function(){self._watchCallbacks(name,_29e,_29c);});}return this;},_changeAttrValue:function(name,_2a1){var _2a2=this.get(name);this[name]=_2a1;if(this._watchCallbacks){this._watchCallbacks(name,_2a2,_2a1);}return this;},watch:function(name,_2a3){var _2a4=this._watchCallbacks;if(!_2a4){var self=this;_2a4=this._watchCallbacks=function(name,_2a5,_2a6,_2a7){var _2a8=function(_2a9){if(_2a9){_2a9=_2a9.slice();for(var i=0,l=_2a9.length;i<l;i++){_2a9[i].call(self,name,_2a5,_2a6);}}};_2a8(_2a4["_"+name]);if(!_2a7){_2a8(_2a4["*"]);}};}if(!_2a3&&typeof name==="function"){_2a3=name;name="*";}else{name="_"+name;}var _2aa=_2a4[name];if(typeof _2aa!=="object"){_2aa=_2a4[name]=[];}_2aa.push(_2a3);var _2ab={};_2ab.unwatch=_2ab.remove=function(){var _2ac=_299.indexOf(_2aa,_2a3);if(_2ac>-1){_2aa.splice(_2ac,1);}};return _2ab;}});});},"dijit/layout/AccordionContainer":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/topic","../focus","../_base/manager","dojo/ready","../_Widget","../_Container","../_TemplatedMixin","../_CssStateMixin","./StackContainer","./ContentPane","dojo/text!./templates/AccordionButton.html","../a11yclick"],function(_2ad,_2ae,_2af,fx,dom,_2b0,_2b1,_2b2,_2b3,keys,lang,has,_2b4,_2b5,_2b6,_2b7,_2b8,_2b9,_2ba,_2bb,_2bc,_2bd,_2be){function size(_2bf,dim){_2bf.resize?_2bf.resize(dim):_2b3.setMarginBox(_2bf.domNode,dim);};var _2c0=_2af("dijit.layout._AccordionButton",[_2b8,_2ba,_2bb],{templateString:_2be,label:"",_setLabelAttr:{node:"titleTextNode",type:"innerHTML"},title:"",_setTitleAttr:{node:"titleTextNode",type:"attribute",attribute:"title"},iconClassAttr:"",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitAccordionTitle",getParent:function(){return this.parent;},buildRendering:function(){this.inherited(arguments);var _2c1=this.id.replace(" ","_");_2b0.set(this.titleTextNode,"id",_2c1+"_title");this.focusNode.setAttribute("aria-labelledby",_2b0.get(this.titleTextNode,"id"));dom.setSelectable(this.domNode,false);},getTitleHeight:function(){return _2b3.getMarginSize(this.domNode).h;},_onTitleClick:function(){var _2c2=this.getParent();_2c2.selectChild(this.contentWidget,true);_2b5.focus(this.focusNode);},_onTitleKeyDown:function(evt){return this.getParent()._onKeyDown(evt,this.contentWidget);},_setSelectedAttr:function(_2c3){this._set("selected",_2c3);this.focusNode.setAttribute("aria-expanded",_2c3?"true":"false");this.focusNode.setAttribute("aria-selected",_2c3?"true":"false");this.focusNode.setAttribute("tabIndex",_2c3?"0":"-1");}});if(has("dojo-bidi")){_2c0.extend({_setLabelAttr:function(_2c4){this._set("label",_2c4);_2b0.set(this.titleTextNode,"innerHTML",_2c4);this.applyTextDir(this.titleTextNode);},_setTitleAttr:function(_2c5){this._set("title",_2c5);_2b0.set(this.titleTextNode,"title",_2c5);this.applyTextDir(this.titleTextNode);}});}var _2c6=_2af("dijit.layout._AccordionInnerContainer"+(has("dojo-bidi")?"_NoBidi":""),[_2b8,_2bb],{baseClass:"dijitAccordionInnerContainer",isLayoutContainer:true,buildRendering:function(){this.domNode=_2b2.place("<div class='"+this.baseClass+"' role='presentation'>",this.contentWidget.domNode,"after");var _2c7=this.contentWidget,cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;this.button=_2c7._buttonWidget=(new cls({contentWidget:_2c7,label:_2c7.title,title:_2c7.tooltip,dir:_2c7.dir,lang:_2c7.lang,textDir:_2c7.textDir||this.textDir,iconClass:_2c7.iconClass,id:_2c7.id+"_button",parent:this.parent})).placeAt(this.domNode);this.containerNode=_2b2.place("<div class='dijitAccordionChildWrapper' role='tabpanel' style='display:none'>",this.domNode);this.containerNode.setAttribute("aria-labelledby",this.button.id);_2b2.place(this.contentWidget.domNode,this.containerNode);},postCreate:function(){this.inherited(arguments);var _2c8=this.button,cw=this.contentWidget;this._contentWidgetWatches=[cw.watch("title",lang.hitch(this,function(name,_2c9,_2ca){_2c8.set("label",_2ca);})),cw.watch("tooltip",lang.hitch(this,function(name,_2cb,_2cc){_2c8.set("title",_2cc);})),cw.watch("iconClass",lang.hitch(this,function(name,_2cd,_2ce){_2c8.set("iconClass",_2ce);}))];},_setSelectedAttr:function(_2cf){this._set("selected",_2cf);this.button.set("selected",_2cf);if(_2cf){var cw=this.contentWidget;if(cw.onSelected){cw.onSelected();}}},startup:function(){this.contentWidget.startup();},destroy:function(){this.button.destroyRecursive();_2ae.forEach(this._contentWidgetWatches||[],function(w){w.unwatch();});delete this.contentWidget._buttonWidget;delete this.contentWidget._wrapperWidget;this.inherited(arguments);},destroyDescendants:function(_2d0){this.contentWidget.destroyRecursive(_2d0);}});if(has("dojo-bidi")){_2c6=_2af("dijit.layout._AccordionInnerContainer",_2c6,{postCreate:function(){this.inherited(arguments);var _2d1=this.button;this._contentWidgetWatches.push(this.contentWidget.watch("textDir",function(name,_2d2,_2d3){_2d1.set("textDir",_2d3);}));}});}var _2d4=_2af("dijit.layout.AccordionContainer",_2bc,{duration:_2b6.defaultDuration,buttonWidget:_2c0,baseClass:"dijitAccordionContainer",buildRendering:function(){this.inherited(arguments);this.domNode.style.overflow="hidden";this.domNode.setAttribute("role","tablist");},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.selectedChildWidget){this.selectedChildWidget._wrapperWidget.set("selected",true);}},layout:function(){var _2d5=this.selectedChildWidget;if(!_2d5){return;}var _2d6=_2d5._wrapperWidget.domNode,_2d7=_2b3.getMarginExtents(_2d6),_2d8=_2b3.getPadBorderExtents(_2d6),_2d9=_2d5._wrapperWidget.containerNode,_2da=_2b3.getMarginExtents(_2d9),_2db=_2b3.getPadBorderExtents(_2d9),_2dc=this._contentBox;var _2dd=0;_2ae.forEach(this.getChildren(),function(_2de){if(_2de!=_2d5){_2dd+=_2b3.getMarginSize(_2de._wrapperWidget.domNode).h;}});this._verticalSpace=_2dc.h-_2dd-_2d7.h-_2d8.h-_2da.h-_2db.h-_2d5._buttonWidget.getTitleHeight();this._containerContentBox={h:this._verticalSpace,w:this._contentBox.w-_2d7.w-_2d8.w-_2da.w-_2db.w};if(_2d5){size(_2d5,this._containerContentBox);}},_setupChild:function(_2df){_2df._wrapperWidget=_2c6({contentWidget:_2df,buttonWidget:this.buttonWidget,id:_2df.id+"_wrapper",dir:_2df.dir,lang:_2df.lang,textDir:_2df.textDir||this.textDir,parent:this});this.inherited(arguments);_2b2.place(_2df.domNode,_2df._wrapper,"replace");},removeChild:function(_2e0){if(_2e0._wrapperWidget){_2b2.place(_2e0.domNode,_2e0._wrapperWidget.domNode,"after");_2e0._wrapperWidget.destroy();delete _2e0._wrapperWidget;}_2b1.remove(_2e0.domNode,"dijitHidden");this.inherited(arguments);},getChildren:function(){return _2ae.map(this.inherited(arguments),function(_2e1){return _2e1.declaredClass=="dijit.layout._AccordionInnerContainer"?_2e1.contentWidget:_2e1;},this);},destroy:function(){if(this._animation){this._animation.stop();}_2ae.forEach(this.getChildren(),function(_2e2){if(_2e2._wrapperWidget){_2e2._wrapperWidget.destroy();}else{_2e2.destroyRecursive();}});this.inherited(arguments);},_showChild:function(_2e3){_2e3._wrapperWidget.containerNode.style.display="block";return this.inherited(arguments);},_hideChild:function(_2e4){_2e4._wrapperWidget.containerNode.style.display="none";this.inherited(arguments);},_transition:function(_2e5,_2e6,_2e7){if(has("ie")<8){_2e7=false;}if(this._animation){this._animation.stop(true);delete this._animation;}var self=this;if(_2e5){_2e5._wrapperWidget.set("selected",true);var d=this._showChild(_2e5);if(this.doLayout){size(_2e5,this._containerContentBox);}}if(_2e6){_2e6._wrapperWidget.set("selected",false);if(!_2e7){this._hideChild(_2e6);}}if(_2e7){var _2e8=_2e5._wrapperWidget.containerNode,_2e9=_2e6._wrapperWidget.containerNode;var _2ea=_2e5._wrapperWidget.containerNode,_2eb=_2b3.getMarginExtents(_2ea),_2ec=_2b3.getPadBorderExtents(_2ea),_2ed=_2eb.h+_2ec.h;_2e9.style.height=(self._verticalSpace-_2ed)+"px";this._animation=new fx.Animation({node:_2e8,duration:this.duration,curve:[1,this._verticalSpace-_2ed-1],onAnimate:function(_2ee){_2ee=Math.floor(_2ee);_2e8.style.height=_2ee+"px";_2e9.style.height=(self._verticalSpace-_2ed-_2ee)+"px";},onEnd:function(){delete self._animation;_2e8.style.height="auto";_2e6._wrapperWidget.containerNode.style.display="none";_2e9.style.height="auto";self._hideChild(_2e6);}});this._animation.onStop=this._animation.onEnd;this._animation.play();}return d;},_onKeyDown:function(e,_2ef){if(this.disabled||e.altKey||!(_2ef||e.ctrlKey)){return;}var c=e.keyCode;if((_2ef&&(c==keys.LEFT_ARROW||c==keys.UP_ARROW))||(e.ctrlKey&&c==keys.PAGE_UP)){this._adjacent(false)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}else{if((_2ef&&(c==keys.RIGHT_ARROW||c==keys.DOWN_ARROW))||(e.ctrlKey&&(c==keys.PAGE_DOWN||c==keys.TAB))){this._adjacent(true)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}}}});if(has("dijit-legacy-requires")){_2b7(0,function(){var _2f0=["dijit/layout/AccordionPane"];_2ad(_2f0);});}_2d4._InnerContainer=_2c6;_2d4._Button=_2c0;return _2d4;});},"dijit/form/ComboButton":function(){define(["dojo/_base/declare","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html","../a11yclick"],function(_2f1,keys,_2f2,_2f3,_2f4){return _2f1("dijit.form.ComboButton",_2f3,{templateString:_2f4,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){_2f2.focus(this._popupStateNode);evt.stopPropagation();evt.preventDefault();}},_onArrowKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){_2f2.focus(this.titleNode);evt.stopPropagation();evt.preventDefault();}},focus:function(_2f5){if(!this.disabled){_2f2.focus(_2f5=="start"?this.titleNode:this._popupStateNode);}}});});},"dijit/form/_AutoCompleterMixin":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/sniff","./DataList","./_TextBoxMixin","./_SearchMixin"],function(_2f6,_2f7,_2f8,keys,lang,_2f9,_2fa,has,_2fb,_2fc,_2fd){var _2fe=_2f7("dijit.form._AutoCompleterMixin",_2fd,{item:null,autoComplete:true,highlightMatch:"first",labelAttr:"",labelType:"text",maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_2ff){var pos=0;if(typeof (_2ff.selectionStart)=="number"){pos=_2ff.selectionStart;}else{if(has("ie")){var tr=_2ff.ownerDocument.selection.createRange().duplicate();var ntr=_2ff.createTextRange();tr.move("character",0);ntr.move("character",0);try{ntr.setEndPoint("EndToEnd",tr);pos=String(ntr.text).replace(/\r/g,"").length;}catch(e){}}}return pos;},_setCaretPos:function(_300,_301){_301=parseInt(_301);_2fc.selectInputText(_300,_301,_301);},_setDisabledAttr:function(_302){this.inherited(arguments);this.domNode.setAttribute("aria-disabled",_302?"true":"false");},_onKey:function(evt){if(evt.charCode>=32){return;}var key=evt.charCode||evt.keyCode;if(key==keys.ALT||key==keys.CTRL||key==keys.META||key==keys.SHIFT){return;}var pw=this.dropDown;var _303=null;this._abortQuery();this.inherited(arguments);if(evt.altKey||evt.ctrlKey||evt.metaKey){return;}if(this._opened){_303=pw.getHighlightedOption();}switch(key){case keys.PAGE_DOWN:case keys.DOWN_ARROW:case keys.PAGE_UP:case keys.UP_ARROW:if(this._opened){this._announceOption(_303);}evt.stopPropagation();evt.preventDefault();break;case keys.ENTER:if(_303){if(_303==pw.nextButton){this._nextSearch(1);evt.stopPropagation();evt.preventDefault();break;}else{if(_303==pw.previousButton){this._nextSearch(-1);evt.stopPropagation();evt.preventDefault();break;}}evt.stopPropagation();evt.preventDefault();}else{this._setBlurValue();this._setCaretPos(this.focusNode,this.focusNode.value.length);}case keys.TAB:var _304=this.get("displayedValue");if(pw&&(_304==pw._messages["previousMessage"]||_304==pw._messages["nextMessage"])){break;}if(_303){this._selectOption(_303);}case keys.ESCAPE:if(this._opened){this._lastQuery=null;this.closeDropDown();}break;}},_autoCompleteText:function(text){var fn=this.focusNode;_2fc.selectInputText(fn,fn.value.length);var _305=this.ignoreCase?"toLowerCase":"substr";if(text[_305](0).indexOf(this.focusNode.value[_305](0))==0){var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;if((cpos+1)>fn.value.length){fn.value=text;_2fc.selectInputText(fn,cpos);}}else{fn.value=text;_2fc.selectInputText(fn);}},_openResultList:function(_306,_307,_308){var _309=this.dropDown.getHighlightedOption();this.dropDown.clearResultList();if(!_306.length&&_308.start==0){this.closeDropDown();return;}this._nextSearch=this.dropDown.onPage=lang.hitch(this,function(_30a){_306.nextPage(_30a!==-1);this.focus();});this.dropDown.createOptions(_306,_308,lang.hitch(this,"_getMenuLabelFromItem"));this._showResultList();if("direction" in _308){if(_308.direction){this.dropDown.highlightFirstOption();}else{if(!_308.direction){this.dropDown.highlightLastOption();}}if(_309){this._announceOption(this.dropDown.getHighlightedOption());}}else{if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_307[this.searchAttr].toString())){this._announceOption(this.dropDown.containerNode.firstChild.nextSibling);}}},_showResultList:function(){this.closeDropDown(true);this.openDropDown();this.domNode.setAttribute("aria-expanded","true");},loadDropDown:function(){this._startSearchAll();},isLoaded:function(){return false;},closeDropDown:function(){this._abortQuery();if(this._opened){this.inherited(arguments);this.domNode.setAttribute("aria-expanded","false");}},_setBlurValue:function(){var _30b=this.get("displayedValue");var pw=this.dropDown;if(pw&&(_30b==pw._messages["previousMessage"]||_30b==pw._messages["nextMessage"])){this._setValueAttr(this._lastValueReported,true);}else{if(typeof this.item=="undefined"){this.item=null;this.set("displayedValue",_30b);}else{if(this.value!=this._lastValueReported){this._handleOnChange(this.value,true);}this._refreshState();}}this.focusNode.removeAttribute("aria-activedescendant");},_setItemAttr:function(item,_30c,_30d){var _30e="";if(item){if(!_30d){_30d=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];}_30e=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_30d;}this.set("value",_30e,_30c,_30d,item);},_announceOption:function(node){if(!node){return;}var _30f;if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){_30f=node.innerHTML;this.item=undefined;this.value="";}else{var item=this.dropDown.items[node.getAttribute("item")];_30f=(this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr]).toString();this.set("item",item,false,_30f);}this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);this.focusNode.setAttribute("aria-activedescendant",_2f8.get(node,"id"));this._autoCompleteText(_30f);},_selectOption:function(_310){this.closeDropDown();if(_310){this._announceOption(_310);}this._setCaretPos(this.focusNode,this.focusNode.value.length);this._handleOnChange(this.value,true);this.focusNode.removeAttribute("aria-activedescendant");},_startSearchAll:function(){this._startSearch("");},_startSearchFromInput:function(){this.item=undefined;this.inherited(arguments);},_startSearch:function(key){if(!this.dropDown){var _311=this.id+"_popup",_312=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;this.dropDown=new _312({onChange:lang.hitch(this,this._selectOption),id:_311,dir:this.dir,textDir:this.textDir});}this._lastInput=key;this.inherited(arguments);},_getValueField:function(){return this.searchAttr;},postMixInProperties:function(){this.inherited(arguments);if(!this.store&&this.srcNodeRef){var _313=this.srcNodeRef;this.store=new _2fb({},_313);if(!("value" in this.params)){var item=(this.item=this.store.fetchSelectedItem());if(item){var _314=this._getValueField();this.value=this.store._oldAPI?this.store.getValue(item,_314):item[_314];}}}},postCreate:function(){var _315=_2f9("label[for=\""+this.id+"\"]");if(_315.length){if(!_315[0].id){_315[0].id=this.id+"_label";}this.domNode.setAttribute("aria-labelledby",_315[0].id);}this.inherited(arguments);_2f6.after(this,"onSearch",lang.hitch(this,"_openResultList"),true);},_getMenuLabelFromItem:function(item){var _316=this.labelFunc(item,this.store),_317=this.labelType;if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){_316=this.doHighlight(_316,this._lastInput);_317="html";}return {html:_317=="html",label:_316};},doHighlight:function(_318,find){var _319=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");find=_2fa.escapeString(find);return this._escapeHtml(_318.replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_319),"\uffff$1\uffff")).replace(/\uFFFF([^\uFFFF]+)\uFFFF/g,"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");},_escapeHtml:function(str){str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");return str;},reset:function(){this.item=null;this.inherited(arguments);},labelFunc:function(item,_31a){return (_31a._oldAPI?_31a.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();},_setValueAttr:function(_31b,_31c,_31d,item){this._set("item",item||null);if(_31b==null){_31b="";}this.inherited(arguments);}});if(has("dojo-bidi")){_2fe.extend({_setTextDirAttr:function(_31e){this.inherited(arguments);if(this.dropDown){this.dropDown._set("textDir",_31e);}}});}return _2fe;});},"dijit/form/MappedTextBox":function(){define(["dojo/_base/declare","dojo/sniff","dojo/dom-construct","./ValidationTextBox"],function(_31f,has,_320,_321){return _31f("dijit.form.MappedTextBox",_321,{postMixInProperties:function(){this.inherited(arguments);this.nameAttrSetting="";},_setNameAttr:"valueNode",serialize:function(val){return val.toString?val.toString():"";},toString:function(){var val=this.filter(this.get("value"));return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";},validate:function(){this.valueNode.value=this.toString();return this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.valueNode=_320.place("<input type='hidden'"+((this.name&&!has("msapp"))?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");},reset:function(){this.valueNode.value="";this.inherited(arguments);}});});},"dijit/form/ComboBoxMixin":function(){define(["dojo/_base/declare","dojo/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_322,_323,_324,lang,_325,_326,_327,_328,_329){return _322("dijit.form.ComboBoxMixin",[_328,_326],{dropDownClass:_327,hasDownArrow:true,templateString:_329,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){this._set("hasDownArrow",val);this._buttonNode.style.display=val?"":"none";},_showResultList:function(){this.displayMessage("");this.inherited(arguments);},_setStoreAttr:function(_32a){if(!_32a.get){lang.mixin(_32a,{_oldAPI:true,get:function(id){var _32b=new _323();this.fetchItemByIdentity({identity:id,onItem:function(_32c){_32b.resolve(_32c);},onError:function(_32d){_32b.reject(_32d);}});return _32b.promise;},query:function(_32e,_32f){var _330=new _323(function(){_331.abort&&_331.abort();});_330.total=new _323();var _331=this.fetch(lang.mixin({query:_32e,onBegin:function(_332){_330.total.resolve(_332);},onComplete:function(_333){_330.resolve(_333);},onError:function(_334){_330.reject(_334);}},_32f));return _325(_330);}});}this._set("store",_32a);},postMixInProperties:function(){var _335=this.params.store||this.store;if(_335){this._setStoreAttr(_335);}this.inherited(arguments);if(!this.params.store&&this.store&&!this.store._oldAPI){var _336=this.declaredClass;lang.mixin(this.store,{getValue:function(item,attr){_324.deprecated(_336+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");return item[attr];},getLabel:function(item){_324.deprecated(_336+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");return item.name;},fetch:function(args){_324.deprecated(_336+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");var shim=["dojo/data/ObjectStore"];require(shim,lang.hitch(this,function(_337){new _337({objectStore:this}).fetch(args);}));}});}},buildRendering:function(){this.inherited(arguments);this.focusNode.setAttribute("aria-autocomplete",this.autoComplete?"both":"list");}});});},"dijit/form/_TextBoxMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/sniff","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_338,_339,dom,has,keys,lang,on,_33a){var _33b=_339("dijit.form._TextBoxMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){return this.parse(this.get("displayedValue"),this.constraints);},_setValueAttr:function(_33c,_33d,_33e){var _33f;if(_33c!==undefined){_33f=this.filter(_33c);if(typeof _33e!="string"){if(_33f!==null&&((typeof _33f!="number")||!isNaN(_33f))){_33e=this.filter(this.format(_33f,this.constraints));}else{_33e="";}if(this.compare(_33f,this.filter(this.parse(_33e,this.constraints)))!=0){_33e=null;}}}if(_33e!=null&&((typeof _33e)!="number"||!isNaN(_33e))&&this.textbox.value!=_33e){this.textbox.value=_33e;this._set("displayedValue",this.get("displayedValue"));}this.inherited(arguments,[_33f,_33d]);},displayedValue:"",_getDisplayedValueAttr:function(){return this.filter(this.textbox.value);},_setDisplayedValueAttr:function(_340){if(_340==null){_340="";}else{if(typeof _340!="string"){_340=String(_340);}}this.textbox.value=_340;this._setValueAttr(this.get("value"),undefined);this._set("displayedValue",this.get("displayedValue"));},format:function(_341){return _341==null?"":(_341.toString?_341.toString():_341);},parse:function(_342){return _342;},_refreshState:function(){},onInput:function(){},_onInput:function(evt){this._lastInputEventValue=this.textbox.value;this._processInput(this._lastInputProducingEvent||evt);delete this._lastInputProducingEvent;if(this.intermediateChanges){this._handleOnChange(this.get("value"),false);}},_processInput:function(){this._refreshState();this._set("displayedValue",this.get("displayedValue"));},postCreate:function(){this.textbox.setAttribute("value",this.textbox.value);this.inherited(arguments);function _343(e){var _344;if(e.type=="keydown"&&e.keyCode!=229){_344=e.keyCode;switch(_344){case keys.SHIFT:case keys.ALT:case keys.CTRL:case keys.META:case keys.CAPS_LOCK:case keys.NUM_LOCK:case keys.SCROLL_LOCK:return;}if(!e.ctrlKey&&!e.metaKey&&!e.altKey){switch(_344){case keys.NUMPAD_0:case keys.NUMPAD_1:case keys.NUMPAD_2:case keys.NUMPAD_3:case keys.NUMPAD_4:case keys.NUMPAD_5:case keys.NUMPAD_6:case keys.NUMPAD_7:case keys.NUMPAD_8:case keys.NUMPAD_9:case keys.NUMPAD_MULTIPLY:case keys.NUMPAD_PLUS:case keys.NUMPAD_ENTER:case keys.NUMPAD_MINUS:case keys.NUMPAD_PERIOD:case keys.NUMPAD_DIVIDE:return;}if((_344>=65&&_344<=90)||(_344>=48&&_344<=57)||_344==keys.SPACE){return;}var _345=false;for(var i in keys){if(keys[i]===e.keyCode){_345=true;break;}}if(!_345){return;}}}_344=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;if(!_344){_344=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;}if(!_344){_344=229;}if(e.type=="keypress"){if(typeof _344!="string"){return;}if((_344>="a"&&_344<="z")||(_344>="A"&&_344<="Z")||(_344>="0"&&_344<="9")||(_344===" ")){if(e.ctrlKey||e.metaKey||e.altKey){return;}}}var faux={faux:true},attr;for(attr in e){if(!/^(layer[XY]|returnValue|keyLocation)$/.test(attr)){var v=e[attr];if(typeof v!="function"&&typeof v!="undefined"){faux[attr]=v;}}}lang.mixin(faux,{charOrCode:_344,_wasConsumed:false,preventDefault:function(){faux._wasConsumed=true;e.preventDefault();},stopPropagation:function(){e.stopPropagation();}});this._lastInputProducingEvent=faux;if(this.onInput(faux)===false){faux.preventDefault();faux.stopPropagation();}if(faux._wasConsumed){return;}if(has("ie")<=9){switch(e.keyCode){case keys.TAB:case keys.ESCAPE:case keys.DOWN_ARROW:case keys.UP_ARROW:case keys.LEFT_ARROW:case keys.RIGHT_ARROW:break;default:if(e.keyCode==keys.ENTER&&this.textbox.tagName.toLowerCase()!="textarea"){break;}this.defer(function(){if(this.textbox.value!==this._lastInputEventValue){on.emit(this.textbox,"input",{bubbles:true});}});}}};this.own(on(this.textbox,"keydown, keypress, paste, cut, compositionend",lang.hitch(this,_343)),on(this.textbox,"input",lang.hitch(this,"_onInput")),on(this.domNode,"keypress",function(e){e.stopPropagation();}));},_blankValue:"",filter:function(val){if(val===null){return this._blankValue;}if(typeof val!="string"){return val;}if(this.trim){val=lang.trim(val);}if(this.uppercase){val=val.toUpperCase();}if(this.lowercase){val=val.toLowerCase();}if(this.propercase){val=val.replace(/[^\s]+/g,function(word){return word.substring(0,1).toUpperCase()+word.substring(1);});}return val;},_setBlurValue:function(){this._setValueAttr(this.get("value"),true);},_onBlur:function(e){if(this.disabled){return;}this._setBlurValue();this.inherited(arguments);},_isTextSelected:function(){return this.textbox.selectionStart!=this.textbox.selectionEnd;},_onFocus:function(by){if(this.disabled||this.readOnly){return;}if(this.selectOnClick&&by=="mouse"){this._selectOnClickHandle=on.once(this.domNode,"mouseup, touchend",lang.hitch(this,function(evt){if(!this._isTextSelected()){_33b.selectInputText(this.textbox);}}));this.own(this._selectOnClickHandle);this.defer(function(){if(this._selectOnClickHandle){this._selectOnClickHandle.remove();this._selectOnClickHandle=null;}},500);}this.inherited(arguments);this._refreshState();},reset:function(){this.textbox.value="";this.inherited(arguments);}});if(has("dojo-bidi")){_33b=_339("dijit.form._TextBoxMixin",_33b,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_setDisplayedValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_onInput:function(){this.applyTextDir(this.focusNode);this.inherited(arguments);}});}_33b._setSelectionRange=_33a._setSelectionRange=function(_346,_347,stop){if(_346.setSelectionRange){_346.setSelectionRange(_347,stop);}};_33b.selectInputText=_33a.selectInputText=function(_348,_349,stop){_348=dom.byId(_348);if(isNaN(_349)){_349=0;}if(isNaN(stop)){stop=_348.value?_348.value.length:0;}try{_348.focus();_33b._setSelectionRange(_348,_349,stop);}catch(e){}};return _33b;});},"dijit/form/SimpleTextarea":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/sniff","./TextBox"],function(_34a,_34b,has,_34c){return _34a("dijit.form.SimpleTextarea",_34c,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){if(!this.value&&this.srcNodeRef){this.value=this.srcNodeRef.value;}this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);if(has("ie")&&this.cols){_34b.add(this.textbox,"dijitTextAreaCols");}},filter:function(_34d){if(_34d){_34d=_34d.replace(/\r/g,"");}return this.inherited(arguments);},_onInput:function(e){if(this.maxLength){var _34e=parseInt(this.maxLength);var _34f=this.textbox.value.replace(/\r/g,"");var _350=_34f.length-_34e;if(_350>0){var _351=this.textbox;if(_351.selectionStart){var pos=_351.selectionStart;var cr=0;if(has("opera")){cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;}this.textbox.value=_34f.substring(0,pos-_350-cr)+_34f.substring(pos-cr);_351.setSelectionRange(pos-_350,pos-_350);}else{if(this.ownerDocument.selection){_351.focus();var _352=this.ownerDocument.selection.createRange();_352.moveStart("character",-_350);_352.text="";_352.select();}}}}this.inherited(arguments);}});});},"dijit/_base/window":function(){define(["dojo/window","../main"],function(_353,_354){_354.getDocumentWindow=function(doc){return _353.get(doc);};});},"dijit/PopupMenuItem":function(){define(["dojo/_base/declare","dojo/dom-style","dojo/_base/lang","dojo/query","./popup","./registry","./MenuItem","./hccss"],function(_355,_356,lang,_357,pm,_358,_359){return _355("dijit.PopupMenuItem",_359,{baseClass:"dijitMenuItem dijitPopupMenuItem",_fillContent:function(){if(this.srcNodeRef){var _35a=_357("*",this.srcNodeRef);this.inherited(arguments,[_35a[0]]);this.dropDownContainer=this.srcNodeRef;}},_openPopup:function(_35b,_35c){var _35d=this.popup;pm.open(lang.delegate(_35b,{popup:this.popup,around:this.domNode}));if(_35c&&_35d.focus){_35d.focus();}},_closePopup:function(){pm.close(this.popup);this.popup.parentMenu=null;},startup:function(){if(this._started){return;}this.inherited(arguments);if(!this.popup){var node=_357("[widgetId]",this.dropDownContainer)[0];this.popup=_358.byNode(node);}this.ownerDocumentBody.appendChild(this.popup.domNode);this.popup.domNode.setAttribute("aria-labelledby",this.containerNode.id);this.popup.startup();this.popup.domNode.style.display="none";if(this.arrowWrapper){_356.set(this.arrowWrapper,"visibility","");}this.focusNode.setAttribute("aria-haspopup","true");},destroyDescendants:function(_35e){if(this.popup){if(!this.popup._destroyed){this.popup.destroyRecursive(_35e);}delete this.popup;}this.inherited(arguments);}});});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_35f,_360,_361,_362,has,_363,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");try{div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url(\""+(_360.blankGif||_35f.toUrl("./resources/blank.gif"))+"\");";win.body().appendChild(div);var cs=_362.getComputedStyle(div),_364=cs.backgroundImage;return cs.borderTopColor==cs.borderRightColor||(_364&&(_364=="none"||_364=="url(invalid-url:)"));}catch(e){console.warn("hccss: exception detecting high-contrast mode, document is likely hidden: "+e.toString());return false;}finally{if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}}});_363(function(){if(has("highcontrast")){_361.add(win.body(),"dj_a11y");}});return has;});},"dijit/form/RadioButton":function(){define(["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_365,_366,_367){return _365("dijit.form.RadioButton",[_366,_367],{baseClass:"dijitRadio"});});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_368,keys,_369,has,_36a){var ret=_369("dijit._OnDijitClickMixin",null,{connect:function(obj,_36b,_36c){return this.inherited(arguments,[obj,_36b=="ondijitclick"?_36a:_36b,_36c]);}});ret.a11yclick=_36a;return ret;});},"dijit/InlineEditBox":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/i18n","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/when","./a11yclick","./focus","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","./_Container","./form/Button","./form/_TextBoxMixin","./form/TextBox","dojo/text!./templates/InlineEditBox.html","dojo/i18n!./nls/common"],function(_36d,_36e,_36f,_370,_371,_372,_373,_374,i18n,_375,keys,lang,on,has,when,_376,fm,_377,_378,_379,_37a,_37b,_37c,_37d,_37e){var _37f=_370("dijit._InlineEditor",[_377,_378,_379],{templateString:_37e,contextRequire:_36d,postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit","common",this.lang);_36e.forEach(["buttonSave","buttonCancel"],function(prop){if(!this[prop]){this[prop]=this.messages[prop];}},this);},buildRendering:function(){this.inherited(arguments);var Cls=typeof this.editor=="string"?(lang.getObject(this.editor)||_36d(this.editor)):this.editor;var _380=this.sourceStyle,_381="line-height:"+_380.lineHeight+";",_382=_374.getComputedStyle(this.domNode);_36e.forEach(["Weight","Family","Size","Style"],function(prop){var _383=_380["font"+prop],_384=_382["font"+prop];if(_384!=_383){_381+="font-"+prop+":"+_380["font"+prop]+";";}},this);_36e.forEach(["marginTop","marginBottom","marginLeft","marginRight","position","left","top","right","bottom","float","clear","display"],function(prop){this.domNode.style[prop]=_380[prop];},this);var _385=this.inlineEditBox.width;if(_385=="100%"){_381+="width:100%;";this.domNode.style.display="block";}else{_381+="width:"+(_385+(Number(_385)==_385?"px":""))+";";}var _386=lang.delegate(this.inlineEditBox.editorParams,{style:_381,dir:this.dir,lang:this.lang,textDir:this.textDir});this.editWidget=new Cls(_386,this.editorPlaceholder);if(this.inlineEditBox.autoSave){this.saveButton.destroy();this.cancelButton.destroy();this.saveButton=this.cancelButton=null;_373.destroy(this.buttonContainer);}},postCreate:function(){this.inherited(arguments);var ew=this.editWidget;if(this.inlineEditBox.autoSave){this.own(_36f.after(ew,"onChange",lang.hitch(this,"_onChange"),true),on(ew,"keydown",lang.hitch(this,"_onKeyDown")));}else{if("intermediateChanges" in ew){ew.set("intermediateChanges",true);this.own(_36f.after(ew,"onChange",lang.hitch(this,"_onIntermediateChange"),true));this.saveButton.set("disabled",true);}}},startup:function(){this.editWidget.startup();this.inherited(arguments);},_onIntermediateChange:function(){this.saveButton.set("disabled",(this.getValue()==this._resetValue)||!this.enableSave());},destroy:function(){this.editWidget.destroy(true);this.inherited(arguments);},getValue:function(){var ew=this.editWidget;return String(ew.get(("displayedValue" in ew||"_getDisplayedValueAttr" in ew)?"displayedValue":"value"));},_onKeyDown:function(e){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(e.altKey||e.ctrlKey){return;}if(e.keyCode==keys.ESCAPE){e.stopPropagation();e.preventDefault();this.cancel(true);}else{if(e.keyCode==keys.ENTER&&e.target.tagName=="INPUT"){e.stopPropagation();e.preventDefault();this._onChange();}}}},_onBlur:function(){this.inherited(arguments);if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(this.getValue()==this._resetValue){this.cancel(false);}else{if(this.enableSave()){this.save(false);}}}},_onChange:function(){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing&&this.enableSave()){fm.focus(this.inlineEditBox.displayNode);}},enableSave:function(){return this.editWidget.isValid?this.editWidget.isValid():true;},focus:function(){this.editWidget.focus();if(this.editWidget.focusNode){fm._onFocusNode(this.editWidget.focusNode);if(this.editWidget.focusNode.tagName=="INPUT"){this.defer(function(){_37c.selectInputText(this.editWidget.focusNode);});}}}});var _387=_370("dijit.InlineEditBox"+(has("dojo-bidi")?"_NoBidi":""),_377,{editing:false,autoSave:true,buttonSave:"",buttonCancel:"",renderAsHtml:false,editor:_37d,editorWrapper:_37f,editorParams:{},disabled:false,onChange:function(){},onCancel:function(){},width:"100%",value:"",noValueIndicator:has("ie")<=6?"<span style='font-family: wingdings; text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>":"<span style='text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>",constructor:function(){this.editorParams={};},postMixInProperties:function(){this.inherited(arguments);this.displayNode=this.srcNodeRef;this.own(on(this.displayNode,_376,lang.hitch(this,"_onClick")),on(this.displayNode,"mouseover, focus",lang.hitch(this,"_onMouseOver")),on(this.displayNode,"mouseout, blur",lang.hitch(this,"_onMouseOut")));this.displayNode.setAttribute("role","button");if(!this.displayNode.getAttribute("tabIndex")){this.displayNode.setAttribute("tabIndex",0);}if(!this.value&&!("value" in this.params)){this.value=lang.trim(this.renderAsHtml?this.displayNode.innerHTML:(this.displayNode.innerText||this.displayNode.textContent||""));}if(!this.value){this.displayNode.innerHTML=this.noValueIndicator;}_372.add(this.displayNode,"dijitInlineEditBoxDisplayMode");},setDisabled:function(_388){_375.deprecated("dijit.InlineEditBox.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_388);},_setDisabledAttr:function(_389){this.domNode.setAttribute("aria-disabled",_389?"true":"false");if(_389){this.displayNode.removeAttribute("tabIndex");}else{this.displayNode.setAttribute("tabIndex",0);}_372.toggle(this.displayNode,"dijitInlineEditBoxDisplayModeDisabled",_389);this._set("disabled",_389);},_onMouseOver:function(){if(!this.disabled){_372.add(this.displayNode,"dijitInlineEditBoxDisplayModeHover");}},_onMouseOut:function(){_372.remove(this.displayNode,"dijitInlineEditBoxDisplayModeHover");},_onClick:function(e){if(this.disabled){return;}if(e){e.stopPropagation();e.preventDefault();}this._onMouseOut();this.defer("edit");},edit:function(){if(this.disabled||this.editing){return;}this._set("editing",true);this._savedTabIndex=_371.get(this.displayNode,"tabIndex")||"0";if(!this.wrapperWidget){var _38a=_373.create("span",null,this.domNode,"before");var Ewc=typeof this.editorWrapper=="string"?lang.getObject(this.editorWrapper):this.editorWrapper;this.wrapperWidget=new Ewc({value:this.value,buttonSave:this.buttonSave,buttonCancel:this.buttonCancel,dir:this.dir,lang:this.lang,tabIndex:this._savedTabIndex,editor:this.editor,inlineEditBox:this,sourceStyle:_374.getComputedStyle(this.displayNode),save:lang.hitch(this,"save"),cancel:lang.hitch(this,"cancel"),textDir:this.textDir},_38a);if(!this.wrapperWidget._started){this.wrapperWidget.startup();}if(!this._started){this.startup();}}var ww=this.wrapperWidget;_372.add(this.displayNode,"dijitOffScreen");_372.remove(ww.domNode,"dijitOffScreen");_374.set(ww.domNode,{visibility:"visible"});_371.set(this.displayNode,"tabIndex","-1");var ew=ww.editWidget;var self=this;when(ew.onLoadDeferred,lang.hitch(ww,function(){ew.set(("displayedValue" in ew||"_setDisplayedValueAttr" in ew)?"displayedValue":"value",self.value);this.defer(function(){if(ww.saveButton){ww.saveButton.set("disabled","intermediateChanges" in ew);}this.focus();this._resetValue=this.getValue();});}));},_onBlur:function(){this.inherited(arguments);if(!this.editing){}},destroy:function(){if(this.wrapperWidget&&!this.wrapperWidget._destroyed){this.wrapperWidget.destroy();delete this.wrapperWidget;}this.inherited(arguments);},_showText:function(_38b){var ww=this.wrapperWidget;_374.set(ww.domNode,{visibility:"hidden"});_372.add(ww.domNode,"dijitOffScreen");_372.remove(this.displayNode,"dijitOffScreen");_371.set(this.displayNode,"tabIndex",this._savedTabIndex);if(_38b){fm.focus(this.displayNode);}},save:function(_38c){if(this.disabled||!this.editing){return;}this._set("editing",false);var ww=this.wrapperWidget;var _38d=ww.getValue();this.set("value",_38d);this._showText(_38c);},setValue:function(val){_375.deprecated("dijit.InlineEditBox.setValue() is deprecated.  Use set('value', ...) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(val){val=lang.trim(val);var _38e=this.renderAsHtml?val:val.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;").replace(/\n/g,"<br>");if(this.editorParams&&this.editorParams.type==="password"){this.displayNode.innerHTML="********";}else{this.displayNode.innerHTML=_38e||this.noValueIndicator;}this._set("value",val);if(this._started){this.defer(function(){this.onChange(val);});}},getValue:function(){_375.deprecated("dijit.InlineEditBox.getValue() is deprecated.  Use get('value') instead.","","2.0");return this.get("value");},cancel:function(_38f){if(this.disabled||!this.editing){return;}this._set("editing",false);this.defer("onCancel");this._showText(_38f);}});if(has("dojo-bidi")){_387=_370("dijit.InlineEditBox",_387,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.displayNode);}});}_387._InlineEditor=_37f;return _387;});},"dojo/selector/acme":function(){define(["../dom","../sniff","../_base/array","../_base/lang","../_base/window"],function(dom,has,_390,lang,win){var trim=lang.trim;var each=_390.forEach;var _391=function(){return win.doc;};var _392=(_391().compatMode)=="BackCompat";var _393=">~+";var _394=false;var _395=function(){return true;};var _396=function(_397){if(_393.indexOf(_397.slice(-1))>=0){_397+=" * ";}else{_397+=" ";}var ts=function(s,e){return trim(_397.slice(s,e));};var _398=[];var _399=-1,_39a=-1,_39b=-1,_39c=-1,_39d=-1,inId=-1,_39e=-1,_39f,lc="",cc="",_3a0;var x=0,ql=_397.length,_3a1=null,_3a2=null;var _3a3=function(){if(_39e>=0){var tv=(_39e==x)?null:ts(_39e,x);_3a1[(_393.indexOf(tv)<0)?"tag":"oper"]=tv;_39e=-1;}};var _3a4=function(){if(inId>=0){_3a1.id=ts(inId,x).replace(/\\/g,"");inId=-1;}};var _3a5=function(){if(_39d>=0){_3a1.classes.push(ts(_39d+1,x).replace(/\\/g,""));_39d=-1;}};var _3a6=function(){_3a4();_3a3();_3a5();};var _3a7=function(){_3a6();if(_39c>=0){_3a1.pseudos.push({name:ts(_39c+1,x)});}_3a1.loops=(_3a1.pseudos.length||_3a1.attrs.length||_3a1.classes.length);_3a1.oquery=_3a1.query=ts(_3a0,x);_3a1.otag=_3a1.tag=(_3a1["oper"])?null:(_3a1.tag||"*");if(_3a1.tag){_3a1.tag=_3a1.tag.toUpperCase();}if(_398.length&&(_398[_398.length-1].oper)){_3a1.infixOper=_398.pop();_3a1.query=_3a1.infixOper.query+" "+_3a1.query;}_398.push(_3a1);_3a1=null;};for(;lc=cc,cc=_397.charAt(x),x<ql;x++){if(lc=="\\"){continue;}if(!_3a1){_3a0=x;_3a1={query:null,pseudos:[],attrs:[],classes:[],tag:null,oper:null,id:null,getTag:function(){return _394?this.otag:this.tag;}};_39e=x;}if(_39f){if(cc==_39f){_39f=null;}continue;}else{if(cc=="'"||cc=="\""){_39f=cc;continue;}}if(_399>=0){if(cc=="]"){if(!_3a2.attr){_3a2.attr=ts(_399+1,x);}else{_3a2.matchFor=ts((_39b||_399+1),x);}var cmf=_3a2.matchFor;if(cmf){if((cmf.charAt(0)=="\"")||(cmf.charAt(0)=="'")){_3a2.matchFor=cmf.slice(1,-1);}}if(_3a2.matchFor){_3a2.matchFor=_3a2.matchFor.replace(/\\/g,"");}_3a1.attrs.push(_3a2);_3a2=null;_399=_39b=-1;}else{if(cc=="="){var _3a8=("|~^$*".indexOf(lc)>=0)?lc:"";_3a2.type=_3a8+cc;_3a2.attr=ts(_399+1,x-_3a8.length);_39b=x+1;}}}else{if(_39a>=0){if(cc==")"){if(_39c>=0){_3a2.value=ts(_39a+1,x);}_39c=_39a=-1;}}else{if(cc=="#"){_3a6();inId=x+1;}else{if(cc=="."){_3a6();_39d=x;}else{if(cc==":"){_3a6();_39c=x;}else{if(cc=="["){_3a6();_399=x;_3a2={};}else{if(cc=="("){if(_39c>=0){_3a2={name:ts(_39c+1,x),value:null};_3a1.pseudos.push(_3a2);}_39a=x;}else{if((cc==" ")&&(lc!=cc)){_3a7();}}}}}}}}}return _398;};var _3a9=function(_3aa,_3ab){if(!_3aa){return _3ab;}if(!_3ab){return _3aa;}return function(){return _3aa.apply(window,arguments)&&_3ab.apply(window,arguments);};};var _3ac=function(i,arr){var r=arr||[];if(i){r.push(i);}return r;};var _3ad=function(n){return (1==n.nodeType);};var _3ae="";var _3af=function(elem,attr){if(!elem){return _3ae;}if(attr=="class"){return elem.className||_3ae;}if(attr=="for"){return elem.htmlFor||_3ae;}if(attr=="style"){return elem.style.cssText||_3ae;}return (_394?elem.getAttribute(attr):elem.getAttribute(attr,2))||_3ae;};var _3b0={"*=":function(attr,_3b1){return function(elem){return (_3af(elem,attr).indexOf(_3b1)>=0);};},"^=":function(attr,_3b2){return function(elem){return (_3af(elem,attr).indexOf(_3b2)==0);};},"$=":function(attr,_3b3){return function(elem){var ea=" "+_3af(elem,attr);var _3b4=ea.lastIndexOf(_3b3);return _3b4>-1&&(_3b4==(ea.length-_3b3.length));};},"~=":function(attr,_3b5){var tval=" "+_3b5+" ";return function(elem){var ea=" "+_3af(elem,attr)+" ";return (ea.indexOf(tval)>=0);};},"|=":function(attr,_3b6){var _3b7=_3b6+"-";return function(elem){var ea=_3af(elem,attr);return ((ea==_3b6)||(ea.indexOf(_3b7)==0));};},"=":function(attr,_3b8){return function(elem){return (_3af(elem,attr)==_3b8);};}};var _3b9=_391().documentElement;var _3ba=!(_3b9.nextElementSibling||"nextElementSibling" in _3b9);var _3bb=!_3ba?"nextElementSibling":"nextSibling";var _3bc=!_3ba?"previousElementSibling":"previousSibling";var _3bd=(_3ba?_3ad:_395);var _3be=function(node){while(node=node[_3bc]){if(_3bd(node)){return false;}}return true;};var _3bf=function(node){while(node=node[_3bb]){if(_3bd(node)){return false;}}return true;};var _3c0=function(node){var root=node.parentNode;root=root.nodeType!=7?root:root.nextSibling;var i=0,tret=root.children||root.childNodes,ci=(node["_i"]||node.getAttribute("_i")||-1),cl=(root["_l"]||(typeof root.getAttribute!=="undefined"?root.getAttribute("_l"):-1));if(!tret){return -1;}var l=tret.length;if(cl==l&&ci>=0&&cl>=0){return ci;}if(has("ie")&&typeof root.setAttribute!=="undefined"){root.setAttribute("_l",l);}else{root["_l"]=l;}ci=-1;for(var te=root["firstElementChild"]||root["firstChild"];te;te=te[_3bb]){if(_3bd(te)){if(has("ie")){te.setAttribute("_i",++i);}else{te["_i"]=++i;}if(node===te){ci=i;}}}return ci;};var _3c1=function(elem){return !((_3c0(elem))%2);};var _3c2=function(elem){return ((_3c0(elem))%2);};var _3c3={"checked":function(name,_3c4){return function(elem){return !!("checked" in elem?elem.checked:elem.selected);};},"disabled":function(name,_3c5){return function(elem){return elem.disabled;};},"enabled":function(name,_3c6){return function(elem){return !elem.disabled;};},"first-child":function(){return _3be;},"last-child":function(){return _3bf;},"only-child":function(name,_3c7){return function(node){return _3be(node)&&_3bf(node);};},"empty":function(name,_3c8){return function(elem){var cn=elem.childNodes;var cnl=elem.childNodes.length;for(var x=cnl-1;x>=0;x--){var nt=cn[x].nodeType;if((nt===1)||(nt==3)){return false;}}return true;};},"contains":function(name,_3c9){var cz=_3c9.charAt(0);if(cz=="\""||cz=="'"){_3c9=_3c9.slice(1,-1);}return function(elem){return (elem.innerHTML.indexOf(_3c9)>=0);};},"not":function(name,_3ca){var p=_396(_3ca)[0];var _3cb={el:1};if(p.tag!="*"){_3cb.tag=1;}if(!p.classes.length){_3cb.classes=1;}var ntf=_3cc(p,_3cb);return function(elem){return (!ntf(elem));};},"nth-child":function(name,_3cd){var pi=parseInt;if(_3cd=="odd"){return _3c2;}else{if(_3cd=="even"){return _3c1;}}if(_3cd.indexOf("n")!=-1){var _3ce=_3cd.split("n",2);var pred=_3ce[0]?((_3ce[0]=="-")?-1:pi(_3ce[0])):1;var idx=_3ce[1]?pi(_3ce[1]):0;var lb=0,ub=-1;if(pred>0){if(idx<0){idx=(idx%pred)&&(pred+(idx%pred));}else{if(idx>0){if(idx>=pred){lb=idx-idx%pred;}idx=idx%pred;}}}else{if(pred<0){pred*=-1;if(idx>0){ub=idx;idx=idx%pred;}}}if(pred>0){return function(elem){var i=_3c0(elem);return (i>=lb)&&(ub<0||i<=ub)&&((i%pred)==idx);};}else{_3cd=idx;}}var _3cf=pi(_3cd);return function(elem){return (_3c0(elem)==_3cf);};}};var _3d0=(has("ie")<9||has("ie")==9&&has("quirks"))?function(cond){var clc=cond.toLowerCase();if(clc=="class"){cond="className";}return function(elem){return (_394?elem.getAttribute(cond):elem[cond]||elem[clc]);};}:function(cond){return function(elem){return (elem&&elem.getAttribute&&elem.hasAttribute(cond));};};var _3cc=function(_3d1,_3d2){if(!_3d1){return _395;}_3d2=_3d2||{};var ff=null;if(!("el" in _3d2)){ff=_3a9(ff,_3ad);}if(!("tag" in _3d2)){if(_3d1.tag!="*"){ff=_3a9(ff,function(elem){return (elem&&((_394?elem.tagName:elem.tagName.toUpperCase())==_3d1.getTag()));});}}if(!("classes" in _3d2)){each(_3d1.classes,function(_3d3,idx,arr){var re=new RegExp("(?:^|\\s)"+_3d3+"(?:\\s|$)");ff=_3a9(ff,function(elem){return re.test(elem.className);});ff.count=idx;});}if(!("pseudos" in _3d2)){each(_3d1.pseudos,function(_3d4){var pn=_3d4.name;if(_3c3[pn]){ff=_3a9(ff,_3c3[pn](pn,_3d4.value));}});}if(!("attrs" in _3d2)){each(_3d1.attrs,function(attr){var _3d5;var a=attr.attr;if(attr.type&&_3b0[attr.type]){_3d5=_3b0[attr.type](a,attr.matchFor);}else{if(a.length){_3d5=_3d0(a);}}if(_3d5){ff=_3a9(ff,_3d5);}});}if(!("id" in _3d2)){if(_3d1.id){ff=_3a9(ff,function(elem){return (!!elem&&(elem.id==_3d1.id));});}}if(!ff){if(!("default" in _3d2)){ff=_395;}}return ff;};var _3d6=function(_3d7){return function(node,ret,bag){while(node=node[_3bb]){if(_3ba&&(!_3ad(node))){continue;}if((!bag||_3d8(node,bag))&&_3d7(node)){ret.push(node);}break;}return ret;};};var _3d9=function(_3da){return function(root,ret,bag){var te=root[_3bb];while(te){if(_3bd(te)){if(bag&&!_3d8(te,bag)){break;}if(_3da(te)){ret.push(te);}}te=te[_3bb];}return ret;};};var _3db=function(_3dc,_3dd){var _3de=function(_3df){var _3e0=[];try{_3e0=Array.prototype.slice.call(_3df);}catch(e){for(var i=0,len=_3df.length;i<len;i++){_3e0.push(_3df[i]);}}return _3e0;};_3dc=_3dc||_395;return function(root,ret,bag){var te,x=0,tret=[];tret=_3de(root.children||root.childNodes);if(_3dd){_390.forEach(tret,function(node){if(node.nodeType===1){tret=tret.concat(_3de(node.getElementsByTagName("*")));}});}while(te=tret[x++]){if(_3bd(te)&&(!bag||_3d8(te,bag))&&(_3dc(te,x))){ret.push(te);}}return ret;};};var _3e1=function(node,root){var pn=node.parentNode;while(pn){if(pn==root){break;}pn=pn.parentNode;}return !!pn;};var _3e2={};var _3e3=function(_3e4){var _3e5=_3e2[_3e4.query];if(_3e5){return _3e5;}var io=_3e4.infixOper;var oper=(io?io.oper:"");var _3e6=_3cc(_3e4,{el:1});var qt=_3e4.tag;var _3e7=("*"==qt);var ecs=_391()["getElementsByClassName"];if(!oper){if(_3e4.id){_3e6=(!_3e4.loops&&_3e7)?_395:_3cc(_3e4,{el:1,id:1});_3e5=function(root,arr){var te=dom.byId(_3e4.id,(root.ownerDocument||root));if(root.ownerDocument&&!_3e1(root,root.ownerDocument)){var _3e8=root.nodeType===11?root.childNodes:[root];_390.some(_3e8,function(_3e9){var _3ea=_3db(function(node){return node.id===_3e4.id;},true)(_3e9,[]);if(_3ea.length){te=_3ea[0];return false;}});}if(!te||!_3e6(te)){return;}if(9==root.nodeType){return _3ac(te,arr);}else{if(_3e1(te,root)){return _3ac(te,arr);}}};}else{if(ecs&&/\{\s*\[native code\]\s*\}/.test(String(ecs))&&_3e4.classes.length&&!_392){_3e6=_3cc(_3e4,{el:1,classes:1,id:1});var _3eb=_3e4.classes.join(" ");_3e5=function(root,arr,bag){var ret=_3ac(0,arr),te,x=0;var tret=root.getElementsByClassName(_3eb);while((te=tret[x++])){if(_3e6(te,root)&&_3d8(te,bag)){ret.push(te);}}return ret;};}else{if(!_3e7&&!_3e4.loops){_3e5=function(root,arr,bag){var ret=_3ac(0,arr),te,x=0;var tag=_3e4.getTag(),tret=tag?root.getElementsByTagName(tag):[];while((te=tret[x++])){if(_3d8(te,bag)){ret.push(te);}}return ret;};}else{_3e6=_3cc(_3e4,{el:1,tag:1,id:1});_3e5=function(root,arr,bag){var ret=_3ac(0,arr),te,x=0;var tag=_3e4.getTag(),tret=tag?root.getElementsByTagName(tag):[];while((te=tret[x++])){if(_3e6(te,root)&&_3d8(te,bag)){ret.push(te);}}return ret;};}}}}else{var _3ec={el:1};if(_3e7){_3ec.tag=1;}_3e6=_3cc(_3e4,_3ec);if("+"==oper){_3e5=_3d6(_3e6);}else{if("~"==oper){_3e5=_3d9(_3e6);}else{if(">"==oper){_3e5=_3db(_3e6);}}}}return _3e2[_3e4.query]=_3e5;};var _3ed=function(root,_3ee){var _3ef=_3ac(root),qp,x,te,qpl=_3ee.length,bag,ret;for(var i=0;i<qpl;i++){ret=[];qp=_3ee[i];x=_3ef.length-1;if(x>0){bag={};ret.nozip=true;}var gef=_3e3(qp);for(var j=0;(te=_3ef[j]);j++){gef(te,ret,bag);}if(!ret.length){break;}_3ef=ret;}return ret;};var _3f0={},_3f1={};var _3f2=function(_3f3){var _3f4=_396(trim(_3f3));if(_3f4.length==1){var tef=_3e3(_3f4[0]);return function(root){var r=tef(root,[]);if(r){r.nozip=true;}return r;};}return function(root){return _3ed(root,_3f4);};};var _3f5=has("ie")?"commentStrip":"nozip";var qsa="querySelectorAll";var _3f6=!!_391()[qsa];var _3f7=/\\[>~+]|n\+\d|([^ \\])?([>~+])([^ =])?/g;var _3f8=function(_3f9,pre,ch,post){return ch?(pre?pre+" ":"")+ch+(post?" "+post:""):_3f9;};var _3fa=/([^[]*)([^\]]*])?/g;var _3fb=function(_3fc,_3fd,att){return _3fd.replace(_3f7,_3f8)+(att||"");};var _3fe=function(_3ff,_400){_3ff=_3ff.replace(_3fa,_3fb);if(_3f6){var _401=_3f1[_3ff];if(_401&&!_400){return _401;}}var _402=_3f0[_3ff];if(_402){return _402;}var qcz=_3ff.charAt(0);var _403=(-1==_3ff.indexOf(" "));if((_3ff.indexOf("#")>=0)&&(_403)){_400=true;}var _404=(_3f6&&(!_400)&&(_393.indexOf(qcz)==-1)&&(!has("ie")||(_3ff.indexOf(":")==-1))&&(!(_392&&(_3ff.indexOf(".")>=0)))&&(_3ff.indexOf(":contains")==-1)&&(_3ff.indexOf(":checked")==-1)&&(_3ff.indexOf("|=")==-1));if(_404){var tq=(_393.indexOf(_3ff.charAt(_3ff.length-1))>=0)?(_3ff+" *"):_3ff;return _3f1[_3ff]=function(root){if(9==root.nodeType||_403){try{var r=root[qsa](tq);r[_3f5]=true;return r;}catch(e){}}return _3fe(_3ff,true)(root);};}else{var _405=_3ff.match(/([^\s,](?:"(?:\\.|[^"])+"|'(?:\\.|[^'])+'|[^,])*)/g);return _3f0[_3ff]=((_405.length<2)?_3f2(_3ff):function(root){var _406=0,ret=[],tp;while((tp=_405[_406++])){ret=ret.concat(_3f2(tp)(root));}return ret;});}};var _407=0;var _408=has("ie")?function(node){if(_394){return (node.getAttribute("_uid")||node.setAttribute("_uid",++_407)||_407);}else{return node.uniqueID;}}:function(node){return (node._uid||(node._uid=++_407));};var _3d8=function(node,bag){if(!bag){return 1;}var id=_408(node);if(!bag[id]){return bag[id]=1;}return 0;};var _409="_zipIdx";var _40a=function(arr){if(arr&&arr.nozip){return arr;}if(!arr||!arr.length){return [];}if(arr.length<2){return [arr[0]];}var ret=[];_407++;var x,te;if(has("ie")&&_394){var _40b=_407+"";for(x=0;x<arr.length;x++){if((te=arr[x])&&te.getAttribute(_409)!=_40b){ret.push(te);te.setAttribute(_409,_40b);}}}else{if(has("ie")&&arr.commentStrip){try{for(x=0;x<arr.length;x++){if((te=arr[x])&&_3ad(te)){ret.push(te);}}}catch(e){}}else{for(x=0;x<arr.length;x++){if((te=arr[x])&&te[_409]!=_407){ret.push(te);te[_409]=_407;}}}}return ret;};var _40c=function(_40d,root){root=root||_391();var od=root.ownerDocument||root;_394=(od.createElement("div").tagName==="div");var r=_3fe(_40d)(root);if(r&&r.nozip){return r;}return _40a(r);};_40c.filter=function(_40e,_40f,root){var _410=[],_411=_396(_40f),_412=(_411.length==1&&!/[^\w#\.]/.test(_40f))?_3cc(_411[0]):function(node){return _390.indexOf(_40c(_40f,dom.byId(root)),node)!=-1;};for(var x=0,te;te=_40e[x];x++){if(_412(te)){_410.push(te);}}return _410;};return _40c;});},"dojo/dnd/autoscroll":function(){define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_413,_414,_415){var _416={};lang.setObject("dojo.dnd.autoscroll",_416);_416.getViewport=_415.getBox;_416.V_TRIGGER_AUTOSCROLL=32;_416.H_TRIGGER_AUTOSCROLL=32;_416.V_AUTOSCROLL_VALUE=16;_416.H_AUTOSCROLL_VALUE=16;var _417,doc=win.doc,_418=Infinity,_419=Infinity;_416.autoScrollStart=function(d){doc=d;_417=_415.getBox(doc);var html=win.body(doc).parentNode;_418=Math.max(html.scrollHeight-_417.h,0);_419=Math.max(html.scrollWidth-_417.w,0);};_416.autoScroll=function(e){var v=_417||_415.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;if(e.clientX<_416.H_TRIGGER_AUTOSCROLL){dx=-_416.H_AUTOSCROLL_VALUE;}else{if(e.clientX>v.w-_416.H_TRIGGER_AUTOSCROLL){dx=Math.min(_416.H_AUTOSCROLL_VALUE,_419-html.scrollLeft);}}if(e.clientY<_416.V_TRIGGER_AUTOSCROLL){dy=-_416.V_AUTOSCROLL_VALUE;}else{if(e.clientY>v.h-_416.V_TRIGGER_AUTOSCROLL){dy=Math.min(_416.V_AUTOSCROLL_VALUE,_418-html.scrollTop);}}window.scrollBy(dx,dy);};_416._validNodes={"div":1,"p":1,"td":1};_416._validOverflow={"auto":1,"scroll":1};_416.autoScrollNodes=function(e){var b,t,w,h,rx,ry,dx=0,dy=0,_41a,_41b;for(var n=e.target;n;){if(n.nodeType==1&&(n.tagName.toLowerCase() in _416._validNodes)){var s=_414.getComputedStyle(n),_41c=(s.overflowX.toLowerCase() in _416._validOverflow),_41d=(s.overflowY.toLowerCase() in _416._validOverflow);if(_41c||_41d){b=_413.getContentBox(n,s);t=_413.position(n,true);}if(_41c){w=Math.min(_416.H_TRIGGER_AUTOSCROLL,b.w/2);rx=e.pageX-t.x;if(has("webkit")||has("opera")){rx+=win.body().scrollLeft;}dx=0;if(rx>0&&rx<b.w){if(rx<w){dx=-w;}else{if(rx>b.w-w){dx=w;}}_41a=n.scrollLeft;n.scrollLeft=n.scrollLeft+dx;}}if(_41d){h=Math.min(_416.V_TRIGGER_AUTOSCROLL,b.h/2);ry=e.pageY-t.y;if(has("webkit")||has("opera")){ry+=win.body().scrollTop;}dy=0;if(ry>0&&ry<b.h){if(ry<h){dy=-h;}else{if(ry>b.h-h){dy=h;}}_41b=n.scrollTop;n.scrollTop=n.scrollTop+dy;}}if(dx||dy){return;}}try{n=n.parentNode;}catch(x){n=null;}}_416.autoScroll(e);};return _416;});},"dijit/form/_RadioButtonMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/lang","dojo/query!css2","../registry"],function(_41e,_41f,_420,lang,_421,_422){return _41f("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){var ary=[];_421("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_423){if(_423.name==this.name&&_423.form==this.focusNode.form){var _424=_422.getEnclosingWidget(_423);if(_424){ary.push(_424);}}}));return ary;},_setCheckedAttr:function(_425){this.inherited(arguments);if(!this._created){return;}if(_425){_41e.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_426){if(_426!=this&&_426.checked){_426.set("checked",false);}}));}},_getSubmitValue:function(_427){return _427==null?"on":_427;},_onClick:function(e){if(this.checked||this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.readOnly){e.stopPropagation();e.preventDefault();_41e.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_428){_420.set(this.focusNode||this.domNode,"checked",_428.checked);}));return false;}var _429=false;var _42a;_41e.some(this._getRelatedWidgets(),function(_42b){if(_42b.checked){_42a=_42b;return true;}return false;});this.checked=true;_42a&&(_42a.checked=false);if(this.onClick(e)===false||e.defaultPrevented){_429=true;}this.checked=false;_42a&&(_42a.checked=true);if(_429){e.preventDefault();}else{this.set("checked",true);}return !_429;}});});},"dojo/data/ItemFileWriteStore":function(){define(["../_base/lang","../_base/declare","../_base/array","../_base/json","../_base/kernel","./ItemFileReadStore","../date/stamp"],function(lang,_42c,_42d,_42e,_42f,_430,_431){return _42c("dojo.data.ItemFileWriteStore",_430,{constructor:function(_432){this._features["dojo.data.api.Write"]=true;this._features["dojo.data.api.Notification"]=true;this._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};if(!this._datatypeMap["Date"].serialize){this._datatypeMap["Date"].serialize=function(obj){return _431.toISOString(obj,{zulu:true});};}if(_432&&(_432.referenceIntegrity===false)){this.referenceIntegrity=false;}this._saveInProgress=false;},referenceIntegrity:true,_assert:function(_433){if(!_433){throw new Error("assertion failed in ItemFileWriteStore");}},_getIdentifierAttribute:function(){return this.getFeatures()["dojo.data.api.Identity"];},newItem:function(_434,_435){this._assert(!this._saveInProgress);if(!this._loadFinished){this._forceLoad();}if(typeof _434!="object"&&typeof _434!="undefined"){throw new Error("newItem() was passed something other than an object");}var _436=null;var _437=this._getIdentifierAttribute();if(_437===Number){_436=this._arrayOfAllItems.length;}else{_436=_434[_437];if(typeof _436==="undefined"){throw new Error("newItem() was not passed an identity for the new item");}if(lang.isArray(_436)){throw new Error("newItem() was not passed an single-valued identity");}}if(this._itemsByIdentity){this._assert(typeof this._itemsByIdentity[_436]==="undefined");}this._assert(typeof this._pending._newItems[_436]==="undefined");this._assert(typeof this._pending._deletedItems[_436]==="undefined");var _438={};_438[this._storeRefPropName]=this;_438[this._itemNumPropName]=this._arrayOfAllItems.length;if(this._itemsByIdentity){this._itemsByIdentity[_436]=_438;_438[_437]=[_436];}this._arrayOfAllItems.push(_438);var _439=null;if(_435&&_435.parent&&_435.attribute){_439={item:_435.parent,attribute:_435.attribute,oldValue:undefined};var _43a=this.getValues(_435.parent,_435.attribute);if(_43a&&_43a.length>0){var _43b=_43a.slice(0,_43a.length);if(_43a.length===1){_439.oldValue=_43a[0];}else{_439.oldValue=_43a.slice(0,_43a.length);}_43b.push(_438);this._setValueOrValues(_435.parent,_435.attribute,_43b,false);_439.newValue=this.getValues(_435.parent,_435.attribute);}else{this._setValueOrValues(_435.parent,_435.attribute,_438,false);_439.newValue=_438;}}else{_438[this._rootItemPropName]=true;this._arrayOfTopLevelItems.push(_438);}this._pending._newItems[_436]=_438;for(var key in _434){if(key===this._storeRefPropName||key===this._itemNumPropName){throw new Error("encountered bug in ItemFileWriteStore.newItem");}var _43c=_434[key];if(!lang.isArray(_43c)){_43c=[_43c];}_438[key]=_43c;if(this.referenceIntegrity){for(var i=0;i<_43c.length;i++){var val=_43c[i];if(this.isItem(val)){this._addReferenceToMap(val,_438,key);}}}}this.onNew(_438,_439);return _438;},_removeArrayElement:function(_43d,_43e){var _43f=_42d.indexOf(_43d,_43e);if(_43f!=-1){_43d.splice(_43f,1);return true;}return false;},deleteItem:function(item){this._assert(!this._saveInProgress);this._assertIsItem(item);var _440=item[this._itemNumPropName];var _441=this.getIdentity(item);if(this.referenceIntegrity){var _442=this.getAttributes(item);if(item[this._reverseRefMap]){item["backup_"+this._reverseRefMap]=lang.clone(item[this._reverseRefMap]);}_42d.forEach(_442,function(_443){_42d.forEach(this.getValues(item,_443),function(_444){if(this.isItem(_444)){if(!item["backupRefs_"+this._reverseRefMap]){item["backupRefs_"+this._reverseRefMap]=[];}item["backupRefs_"+this._reverseRefMap].push({id:this.getIdentity(_444),attr:_443});this._removeReferenceFromMap(_444,item,_443);}},this);},this);var _445=item[this._reverseRefMap];if(_445){for(var _446 in _445){var _447=null;if(this._itemsByIdentity){_447=this._itemsByIdentity[_446];}else{_447=this._arrayOfAllItems[_446];}if(_447){for(var _448 in _445[_446]){var _449=this.getValues(_447,_448)||[];var _44a=_42d.filter(_449,function(_44b){return !(this.isItem(_44b)&&this.getIdentity(_44b)==_441);},this);this._removeReferenceFromMap(item,_447,_448);if(_44a.length<_449.length){this._setValueOrValues(_447,_448,_44a,true);}}}}}}this._arrayOfAllItems[_440]=null;item[this._storeRefPropName]=null;if(this._itemsByIdentity){delete this._itemsByIdentity[_441];}this._pending._deletedItems[_441]=item;if(item[this._rootItemPropName]){this._removeArrayElement(this._arrayOfTopLevelItems,item);}this.onDelete(item);return true;},setValue:function(item,_44c,_44d){return this._setValueOrValues(item,_44c,_44d,true);},setValues:function(item,_44e,_44f){return this._setValueOrValues(item,_44e,_44f,true);},unsetAttribute:function(item,_450){return this._setValueOrValues(item,_450,[],true);},_setValueOrValues:function(item,_451,_452,_453){this._assert(!this._saveInProgress);this._assertIsItem(item);this._assert(lang.isString(_451));this._assert(typeof _452!=="undefined");var _454=this._getIdentifierAttribute();if(_451==_454){throw new Error("ItemFileWriteStore does not have support for changing the value of an item's identifier.");}var _455=this._getValueOrValues(item,_451);var _456=this.getIdentity(item);if(!this._pending._modifiedItems[_456]){var _457={};for(var key in item){if((key===this._storeRefPropName)||(key===this._itemNumPropName)||(key===this._rootItemPropName)){_457[key]=item[key];}else{if(key===this._reverseRefMap){_457[key]=lang.clone(item[key]);}else{_457[key]=item[key].slice(0,item[key].length);}}}this._pending._modifiedItems[_456]=_457;}var _458=false;if(lang.isArray(_452)&&_452.length===0){_458=delete item[_451];_452=undefined;if(this.referenceIntegrity&&_455){var _459=_455;if(!lang.isArray(_459)){_459=[_459];}for(var i=0;i<_459.length;i++){var _45a=_459[i];if(this.isItem(_45a)){this._removeReferenceFromMap(_45a,item,_451);}}}}else{var _45b;if(lang.isArray(_452)){_45b=_452.slice(0,_452.length);}else{_45b=[_452];}if(this.referenceIntegrity){if(_455){var _459=_455;if(!lang.isArray(_459)){_459=[_459];}var map={};_42d.forEach(_459,function(_45c){if(this.isItem(_45c)){var id=this.getIdentity(_45c);map[id.toString()]=true;}},this);_42d.forEach(_45b,function(_45d){if(this.isItem(_45d)){var id=this.getIdentity(_45d);if(map[id.toString()]){delete map[id.toString()];}else{this._addReferenceToMap(_45d,item,_451);}}},this);for(var rId in map){var _45e;if(this._itemsByIdentity){_45e=this._itemsByIdentity[rId];}else{_45e=this._arrayOfAllItems[rId];}this._removeReferenceFromMap(_45e,item,_451);}}else{for(var i=0;i<_45b.length;i++){var _45a=_45b[i];if(this.isItem(_45a)){this._addReferenceToMap(_45a,item,_451);}}}}item[_451]=_45b;_458=true;}if(_453){this.onSet(item,_451,_455,_452);}return _458;},_addReferenceToMap:function(_45f,_460,_461){var _462=this.getIdentity(_460);var _463=_45f[this._reverseRefMap];if(!_463){_463=_45f[this._reverseRefMap]={};}var _464=_463[_462];if(!_464){_464=_463[_462]={};}_464[_461]=true;},_removeReferenceFromMap:function(_465,_466,_467){var _468=this.getIdentity(_466);var _469=_465[this._reverseRefMap];var _46a;if(_469){for(_46a in _469){if(_46a==_468){delete _469[_46a][_467];if(this._isEmpty(_469[_46a])){delete _469[_46a];}}}if(this._isEmpty(_469)){delete _465[this._reverseRefMap];}}},_dumpReferenceMap:function(){var i;for(i=0;i<this._arrayOfAllItems.length;i++){var item=this._arrayOfAllItems[i];if(item&&item[this._reverseRefMap]){}}},_getValueOrValues:function(item,_46b){var _46c=undefined;if(this.hasAttribute(item,_46b)){var _46d=this.getValues(item,_46b);if(_46d.length==1){_46c=_46d[0];}else{_46c=_46d;}}return _46c;},_flatten:function(_46e){if(this.isItem(_46e)){return {_reference:this.getIdentity(_46e)};}else{if(typeof _46e==="object"){for(var type in this._datatypeMap){var _46f=this._datatypeMap[type];if(lang.isObject(_46f)&&!lang.isFunction(_46f)){if(_46e instanceof _46f.type){if(!_46f.serialize){throw new Error("ItemFileWriteStore:  No serializer defined for type mapping: ["+type+"]");}return {_type:type,_value:_46f.serialize(_46e)};}}else{if(_46e instanceof _46f){return {_type:type,_value:_46e.toString()};}}}}return _46e;}},_getNewFileContentString:function(){var _470={};var _471=this._getIdentifierAttribute();if(_471!==Number){_470.identifier=_471;}if(this._labelAttr){_470.label=this._labelAttr;}_470.items=[];for(var i=0;i<this._arrayOfAllItems.length;++i){var item=this._arrayOfAllItems[i];if(item!==null){var _472={};for(var key in item){if(key!==this._storeRefPropName&&key!==this._itemNumPropName&&key!==this._reverseRefMap&&key!==this._rootItemPropName){var _473=this.getValues(item,key);if(_473.length==1){_472[key]=this._flatten(_473[0]);}else{var _474=[];for(var j=0;j<_473.length;++j){_474.push(this._flatten(_473[j]));_472[key]=_474;}}}}_470.items.push(_472);}}var _475=true;return _42e.toJson(_470,_475);},_isEmpty:function(_476){var _477=true;if(lang.isObject(_476)){var i;for(i in _476){_477=false;break;}}else{if(lang.isArray(_476)){if(_476.length>0){_477=false;}}}return _477;},save:function(_478){this._assert(!this._saveInProgress);this._saveInProgress=true;var self=this;var _479=function(){self._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};self._saveInProgress=false;if(_478&&_478.onComplete){var _47a=_478.scope||_42f.global;_478.onComplete.call(_47a);}};var _47b=function(err){self._saveInProgress=false;if(_478&&_478.onError){var _47c=_478.scope||_42f.global;_478.onError.call(_47c,err);}};if(this._saveEverything){var _47d=this._getNewFileContentString();this._saveEverything(_479,_47b,_47d);}if(this._saveCustom){this._saveCustom(_479,_47b);}if(!this._saveEverything&&!this._saveCustom){_479();}},revert:function(){this._assert(!this._saveInProgress);var _47e;for(_47e in this._pending._modifiedItems){var _47f=this._pending._modifiedItems[_47e];var _480=null;if(this._itemsByIdentity){_480=this._itemsByIdentity[_47e];}else{_480=this._arrayOfAllItems[_47e];}_47f[this._storeRefPropName]=this;for(var key in _480){delete _480[key];}lang.mixin(_480,_47f);}var _481;for(_47e in this._pending._deletedItems){_481=this._pending._deletedItems[_47e];_481[this._storeRefPropName]=this;var _482=_481[this._itemNumPropName];if(_481["backup_"+this._reverseRefMap]){_481[this._reverseRefMap]=_481["backup_"+this._reverseRefMap];delete _481["backup_"+this._reverseRefMap];}this._arrayOfAllItems[_482]=_481;if(this._itemsByIdentity){this._itemsByIdentity[_47e]=_481;}if(_481[this._rootItemPropName]){this._arrayOfTopLevelItems.push(_481);}}for(_47e in this._pending._deletedItems){_481=this._pending._deletedItems[_47e];if(_481["backupRefs_"+this._reverseRefMap]){_42d.forEach(_481["backupRefs_"+this._reverseRefMap],function(_483){var _484;if(this._itemsByIdentity){_484=this._itemsByIdentity[_483.id];}else{_484=this._arrayOfAllItems[_483.id];}this._addReferenceToMap(_484,_481,_483.attr);},this);delete _481["backupRefs_"+this._reverseRefMap];}}for(_47e in this._pending._newItems){var _485=this._pending._newItems[_47e];_485[this._storeRefPropName]=null;this._arrayOfAllItems[_485[this._itemNumPropName]]=null;if(_485[this._rootItemPropName]){this._removeArrayElement(this._arrayOfTopLevelItems,_485);}if(this._itemsByIdentity){delete this._itemsByIdentity[_47e];}}this._pending={_newItems:{},_modifiedItems:{},_deletedItems:{}};return true;},isDirty:function(item){if(item){var _486=this.getIdentity(item);return new Boolean(this._pending._newItems[_486]||this._pending._modifiedItems[_486]||this._pending._deletedItems[_486]).valueOf();}else{return !this._isEmpty(this._pending._newItems)||!this._isEmpty(this._pending._modifiedItems)||!this._isEmpty(this._pending._deletedItems);}},onSet:function(item,_487,_488,_489){},onNew:function(_48a,_48b){},onDelete:function(_48c){},close:function(_48d){if(this.clearOnClose){if(!this.isDirty()){this.inherited(arguments);}else{throw new Error("dojo.data.ItemFileWriteStore: There are unsaved changes present in the store.  Please save or revert the changes before invoking close.");}}}});});},"dojo/dnd/TimedMoveable":function(){define(["../_base/declare","./Moveable"],function(_48e,_48f){var _490=_48f.prototype.onMove;return _48e("dojo.dnd.TimedMoveable",_48f,{timeout:40,constructor:function(node,_491){if(!_491){_491={};}if(_491.timeout&&typeof _491.timeout=="number"&&_491.timeout>=0){this.timeout=_491.timeout;}},onMoveStop:function(_492){if(_492._timer){clearTimeout(_492._timer);_490.call(this,_492,_492._leftTop);}_48f.prototype.onMoveStop.apply(this,arguments);},onMove:function(_493,_494){_493._leftTop=_494;if(!_493._timer){var _495=this;_493._timer=setTimeout(function(){_493._timer=null;_490.call(_495,_493,_493._leftTop);},this.timeout);}}});});},"dojo/NodeList-fx":function(){define(["./query","./_base/lang","./aspect","./_base/fx","./fx"],function(_496,lang,_497,_498,_499){var _49a=_496.NodeList;lang.extend(_49a,{_anim:function(obj,_49b,args){args=args||{};var a=_499.combine(this.map(function(item){var _49c={node:item};lang.mixin(_49c,args);return obj[_49b](_49c);}));return args.auto?a.play()&&this:a;},wipeIn:function(args){return this._anim(_499,"wipeIn",args);},wipeOut:function(args){return this._anim(_499,"wipeOut",args);},slideTo:function(args){return this._anim(_499,"slideTo",args);},fadeIn:function(args){return this._anim(_498,"fadeIn",args);},fadeOut:function(args){return this._anim(_498,"fadeOut",args);},animateProperty:function(args){return this._anim(_498,"animateProperty",args);},anim:function(_49d,_49e,_49f,_4a0,_4a1){var _4a2=_499.combine(this.map(function(item){return _498.animateProperty({node:item,properties:_49d,duration:_49e||350,easing:_49f});}));if(_4a0){_497.after(_4a2,"onEnd",_4a0,true);}return _4a2.play(_4a1||0);}});return _49a;});},"dijit/form/_ListMouseMixin":function(){define(["dojo/_base/declare","dojo/on","dojo/touch","./_ListBase"],function(_4a3,on,_4a4,_4a5){return _4a3("dijit.form._ListMouseMixin",_4a5,{postCreate:function(){this.inherited(arguments);this.domNode.dojoClick=true;this._listConnect("click","_onClick");this._listConnect("mousedown","_onMouseDown");this._listConnect("mouseup","_onMouseUp");this._listConnect("mouseover","_onMouseOver");this._listConnect("mouseout","_onMouseOut");},_onClick:function(evt,_4a6){this._setSelectedAttr(_4a6,false);if(this._deferredClick){this._deferredClick.remove();}this._deferredClick=this.defer(function(){this._deferredClick=null;this.onClick(_4a6);});},_onMouseDown:function(evt,_4a7){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}this._isDragging=true;this._setSelectedAttr(_4a7,false);},_onMouseUp:function(evt,_4a8){this._isDragging=false;var _4a9=this.selected;var _4aa=this._hoveredNode;if(_4a9&&_4a8==_4a9){this.defer(function(){this._onClick(evt,_4a9);});}else{if(_4aa){this.defer(function(){this._onClick(evt,_4aa);});}}},_onMouseOut:function(evt,_4ab){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}if(this._isDragging){this._cancelDrag=(new Date()).getTime()+1000;}},_onMouseOver:function(evt,_4ac){if(this._cancelDrag){var time=(new Date()).getTime();if(time>this._cancelDrag){this._isDragging=false;}this._cancelDrag=null;}this._hoveredNode=_4ac;this.onHover(_4ac);if(this._isDragging){this._setSelectedAttr(_4ac,false);}}});});},"dojo/cookie":function(){define(["./_base/kernel","./regexp"],function(dojo,_4ad){dojo.cookie=function(name,_4ae,_4af){var c=document.cookie,ret;if(arguments.length==1){var _4b0=c.match(new RegExp("(?:^|; )"+_4ad.escapeString(name)+"=([^;]*)"));ret=_4b0?decodeURIComponent(_4b0[1]):undefined;}else{_4af=_4af||{};var exp=_4af.expires;if(typeof exp=="number"){var d=new Date();d.setTime(d.getTime()+exp*24*60*60*1000);exp=_4af.expires=d;}if(exp&&exp.toUTCString){_4af.expires=exp.toUTCString();}_4ae=encodeURIComponent(_4ae);var _4b1=name+"="+_4ae,_4b2;for(_4b2 in _4af){_4b1+="; "+_4b2;var _4b3=_4af[_4b2];if(_4b3!==true){_4b1+="="+_4b3;}}document.cookie=_4b1;}return ret;};dojo.cookie.isSupported=function(){if(!("cookieEnabled" in navigator)){this("__djCookieTest__","CookiesAllowed");navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";if(navigator.cookieEnabled){this("__djCookieTest__","",{expires:-1});}}return navigator.cookieEnabled;};return dojo.cookie;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dijit/ProgressBar":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/number","./_Widget","./_TemplatedMixin","dojo/text!./templates/ProgressBar.html"],function(_4b4,_4b5,_4b6,lang,_4b7,_4b8,_4b9,_4ba){return _4b5("dijit.ProgressBar",[_4b8,_4b9],{progress:"0",value:"",maximum:100,places:0,indeterminate:false,label:"",name:"",templateString:_4ba,_indeterminateHighContrastImagePath:_4b4.toUrl("./themes/a11y/indeterminate_progress.gif"),postMixInProperties:function(){this.inherited(arguments);if(!(this.params&&"value" in this.params)){this.value=this.indeterminate?Infinity:this.progress;}},buildRendering:function(){this.inherited(arguments);this.indeterminateHighContrastImage.setAttribute("src",this._indeterminateHighContrastImagePath.toString());this.update();},_setDirAttr:function(val){var rtl=val.toLowerCase()=="rtl";_4b6.toggle(this.domNode,"dijitProgressBarRtl",rtl);_4b6.toggle(this.domNode,"dijitProgressBarIndeterminateRtl",this.indeterminate&&rtl);this.inherited(arguments);},update:function(_4bb){lang.mixin(this,_4bb||{});var tip=this.internalProgress,ap=this.domNode;var _4bc=1;if(this.indeterminate){ap.removeAttribute("aria-valuenow");}else{if(String(this.progress).indexOf("%")!=-1){_4bc=Math.min(parseFloat(this.progress)/100,1);this.progress=_4bc*this.maximum;}else{this.progress=Math.min(this.progress,this.maximum);_4bc=this.maximum?this.progress/this.maximum:0;}ap.setAttribute("aria-valuenow",this.progress);}ap.setAttribute("aria-labelledby",this.labelNode.id);ap.setAttribute("aria-valuemin",0);ap.setAttribute("aria-valuemax",this.maximum);this.labelNode.innerHTML=this.report(_4bc);_4b6.toggle(this.domNode,"dijitProgressBarIndeterminate",this.indeterminate);_4b6.toggle(this.domNode,"dijitProgressBarIndeterminateRtl",this.indeterminate&&!this.isLeftToRight());tip.style.width=(_4bc*100)+"%";this.onChange();},_setValueAttr:function(v){this._set("value",v);if(v==Infinity){this.update({indeterminate:true});}else{this.update({indeterminate:false,progress:v});}},_setLabelAttr:function(_4bd){this._set("label",_4bd);this.update();},_setIndeterminateAttr:function(_4be){this._set("indeterminate",_4be);this.update();},report:function(_4bf){return this.label?this.label:(this.indeterminate?"&#160;":_4b7.format(_4bf,{type:"percent",places:this.places,locale:this.lang}));},onChange:function(){}});});},"dijit/_base/popup":function(){define(["dojo/dom-class","dojo/_base/window","../popup","../BackgroundIframe"],function(_4c0,win,_4c1){var _4c2=_4c1._createWrapper;_4c1._createWrapper=function(_4c3){if(!_4c3.declaredClass){_4c3={_popupWrapper:(_4c3.parentNode&&_4c0.contains(_4c3.parentNode,"dijitPopup"))?_4c3.parentNode:null,domNode:_4c3,destroy:function(){},ownerDocument:_4c3.ownerDocument,ownerDocumentBody:win.body(_4c3.ownerDocument)};}return _4c2.call(this,_4c3);};var _4c4=_4c1.open;_4c1.open=function(args){if(args.orient&&typeof args.orient!="string"&&!("length" in args.orient)){var ary=[];for(var key in args.orient){ary.push({aroundCorner:key,corner:args.orient[key]});}args.orient=ary;}return _4c4.call(this,args);};return _4c1;});},"dojo/promise/all":function(){define(["../_base/array","../_base/lang","../Deferred","../when"],function(_4c5,lang,_4c6,when){"use strict";var some=_4c5.some;return function all(_4c7){var _4c8,_4c5;if(lang.isArray(_4c7)){_4c5=_4c7;}else{if(_4c7&&typeof _4c7==="object"){_4c8=_4c7;}}var _4c9;var _4ca=[];if(_4c8){_4c5=[];for(var key in _4c8){if(Object.hasOwnProperty.call(_4c8,key)){_4ca.push(key);_4c5.push(_4c8[key]);}}_4c9={};}else{if(_4c5){_4c9=[];}}if(!_4c5||!_4c5.length){return new _4c6().resolve(_4c9);}var _4cb=new _4c6();_4cb.promise.always(function(){_4c9=_4ca=null;});var _4cc=_4c5.length;some(_4c5,function(_4cd,_4ce){if(!_4c8){_4ca.push(_4ce);}when(_4cd,function(_4cf){if(!_4cb.isFulfilled()){_4c9[_4ca[_4ce]]=_4cf;if(--_4cc===0){_4cb.resolve(_4c9);}}},_4cb.reject);return _4cb.isFulfilled();});return _4cb.promise;};});},"dijit/ColorPalette":function(){define(["require","dojo/text!./templates/ColorPalette.html","./_Widget","./_TemplatedMixin","./_PaletteMixin","./hccss","dojo/i18n","dojo/_base/Color","dojo/_base/declare","dojo/dom-construct","dojo/string","dojo/i18n!dojo/nls/colors","dojo/colors"],function(_4d0,_4d1,_4d2,_4d3,_4d4,has,i18n,_4d5,_4d6,_4d7,_4d8){var _4d9=_4d6("dijit.ColorPalette",[_4d2,_4d3,_4d4],{palette:"7x10",_palettes:{"7x10":[["white","seashell","cornsilk","lemonchiffon","lightyellow","palegreen","paleturquoise","lightcyan","lavender","plum"],["lightgray","pink","bisque","moccasin","khaki","lightgreen","lightseagreen","lightskyblue","cornflowerblue","violet"],["silver","lightcoral","sandybrown","orange","palegoldenrod","chartreuse","mediumturquoise","skyblue","mediumslateblue","orchid"],["gray","red","orangered","darkorange","yellow","limegreen","darkseagreen","royalblue","slateblue","mediumorchid"],["dimgray","crimson","chocolate","coral","gold","forestgreen","seagreen","blue","blueviolet","darkorchid"],["darkslategray","firebrick","saddlebrown","sienna","olive","green","darkcyan","mediumblue","darkslateblue","darkmagenta"],["black","darkred","maroon","brown","darkolivegreen","darkgreen","midnightblue","navy","indigo","purple"]],"3x4":[["white","lime","green","blue"],["silver","yellow","fuchsia","navy"],["gray","red","purple","black"]]},templateString:_4d1,baseClass:"dijitColorPalette",_dyeFactory:function(_4da,row,col,_4db){return new this._dyeClass(_4da,row,col,_4db);},buildRendering:function(){this.inherited(arguments);this._dyeClass=_4d6(_4d9._Color,{palette:this.palette});this._preparePalette(this._palettes[this.palette],i18n.getLocalization("dojo","colors",this.lang));}});_4d9._Color=_4d6("dijit._Color",_4d5,{template:"<span class='dijitInline dijitPaletteImg'>"+"<img src='${blankGif}' alt='${alt}' title='${title}' class='dijitColorPaletteSwatch' style='background-color: ${color}'/>"+"</span>",hcTemplate:"<span class='dijitInline dijitPaletteImg' style='position: relative; overflow: hidden; height: 12px; width: 14px;'>"+"<img src='${image}' alt='${alt}' title='${title}' style='position: absolute; left: ${left}px; top: ${top}px; ${size}'/>"+"</span>",_imagePaths:{"7x10":_4d0.toUrl("./themes/a11y/colors7x10.png"),"3x4":_4d0.toUrl("./themes/a11y/colors3x4.png")},constructor:function(_4dc,row,col,_4dd){this._title=_4dd;this._row=row;this._col=col;this.setColor(_4d5.named[_4dc]);},getValue:function(){return this.toHex();},fillCell:function(cell,_4de){var html=_4d8.substitute(has("highcontrast")?this.hcTemplate:this.template,{color:this.toHex(),blankGif:_4de,alt:this._title,title:this._title,image:this._imagePaths[this.palette].toString(),left:this._col*-20-5,top:this._row*-20-5,size:this.palette=="7x10"?"height: 145px; width: 206px":"height: 64px; width: 86px"});_4d7.place(html,cell);}});return _4d9;});},"dojo/_base/url":function(){define(["./kernel"],function(dojo){var ore=new RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),ire=new RegExp("^((([^\\[:]+):)?([^@]+)@)?(\\[([^\\]]+)\\]|([^\\[:]*))(:([0-9]+))?$"),_4df=function(){var n=null,_4e0=arguments,uri=[_4e0[0]];for(var i=1;i<_4e0.length;i++){if(!_4e0[i]){continue;}var _4e1=new _4df(_4e0[i]+""),_4e2=new _4df(uri[0]+"");if(_4e1.path==""&&!_4e1.scheme&&!_4e1.authority&&!_4e1.query){if(_4e1.fragment!=n){_4e2.fragment=_4e1.fragment;}_4e1=_4e2;}else{if(!_4e1.scheme){_4e1.scheme=_4e2.scheme;if(!_4e1.authority){_4e1.authority=_4e2.authority;if(_4e1.path.charAt(0)!="/"){var path=_4e2.path.substring(0,_4e2.path.lastIndexOf("/")+1)+_4e1.path;var segs=path.split("/");for(var j=0;j<segs.length;j++){if(segs[j]=="."){if(j==segs.length-1){segs[j]="";}else{segs.splice(j,1);j--;}}else{if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){if(j==(segs.length-1)){segs.splice(j,1);segs[j-1]="";}else{segs.splice(j-1,2);j-=2;}}}}_4e1.path=segs.join("/");}}}}uri=[];if(_4e1.scheme){uri.push(_4e1.scheme,":");}if(_4e1.authority){uri.push("//",_4e1.authority);}uri.push(_4e1.path);if(_4e1.query){uri.push("?",_4e1.query);}if(_4e1.fragment){uri.push("#",_4e1.fragment);}}this.uri=uri.join("");var r=this.uri.match(ore);this.scheme=r[2]||(r[1]?"":n);this.authority=r[4]||(r[3]?"":n);this.path=r[5];this.query=r[7]||(r[6]?"":n);this.fragment=r[9]||(r[8]?"":n);if(this.authority!=n){r=this.authority.match(ire);this.user=r[3]||n;this.password=r[4]||n;this.host=r[6]||r[7];this.port=r[9]||n;}};_4df.prototype.toString=function(){return this.uri;};return dojo._Url=_4df;});},"dojo/text":function(){define(["./_base/kernel","require","./has","./request"],function(dojo,_4e3,has,_4e4){var _4e5;if(1){_4e5=function(url,sync,load){_4e4(url,{sync:!!sync,headers:{"X-Requested-With":null}}).then(load);};}else{if(_4e3.getText){_4e5=_4e3.getText;}else{console.error("dojo/text plugin failed to load because loader does not support getText");}}var _4e6={},_4e7=function(text){if(text){text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var _4e8=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_4e8){text=_4e8[1];}}else{text="";}return text;},_4e9={},_4ea={};dojo.cache=function(_4eb,url,_4ec){var key;if(typeof _4eb=="string"){if(/\//.test(_4eb)){key=_4eb;_4ec=url;}else{key=_4e3.toUrl(_4eb.replace(/\./g,"/")+(url?("/"+url):""));}}else{key=_4eb+"";_4ec=url;}var val=(_4ec!=undefined&&typeof _4ec!="string")?_4ec.value:_4ec,_4ed=_4ec&&_4ec.sanitize;if(typeof val=="string"){_4e6[key]=val;return _4ed?_4e7(val):val;}else{if(val===null){delete _4e6[key];return null;}else{if(!(key in _4e6)){_4e5(key,true,function(text){_4e6[key]=text;});}return _4ed?_4e7(_4e6[key]):_4e6[key];}}};return {dynamic:true,normalize:function(id,_4ee){var _4ef=id.split("!"),url=_4ef[0];return (/^\./.test(url)?_4ee(url):url)+(_4ef[1]?"!"+_4ef[1]:"");},load:function(id,_4f0,load){var _4f1=id.split("!"),_4f2=_4f1.length>1,_4f3=_4f1[0],url=_4f0.toUrl(_4f1[0]),_4f4="url:"+url,text=_4e9,_4f5=function(text){load(_4f2?_4e7(text):text);};if(_4f3 in _4e6){text=_4e6[_4f3];}else{if(_4f0.cache&&_4f4 in _4f0.cache){text=_4f0.cache[_4f4];}else{if(url in _4e6){text=_4e6[url];}}}if(text===_4e9){if(_4ea[url]){_4ea[url].push(_4f5);}else{var _4f6=_4ea[url]=[_4f5];_4e5(url,!_4f0.async,function(text){_4e6[_4f3]=_4e6[url]=text;for(var i=0;i<_4f6.length;){_4f6[i++](text);}delete _4ea[url];});}}else{_4f5(text);}}};});},"dijit/layout/LayoutContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/_base/lang","../_WidgetBase","./_LayoutWidget","./utils"],function(_4f7,_4f8,_4f9,_4fa,lang,_4fb,_4fc,_4fd){var _4fe=_4f8("dijit.layout.LayoutContainer",_4fc,{design:"headline",baseClass:"dijitLayoutContainer",startup:function(){if(this._started){return;}_4f7.forEach(this.getChildren(),this._setupChild,this);this.inherited(arguments);},_setupChild:function(_4ff){this.inherited(arguments);var _500=_4ff.region;if(_500){_4f9.add(_4ff.domNode,this.baseClass+"Pane");}},_getOrderedChildren:function(){var _501=_4f7.map(this.getChildren(),function(_502,idx){return {pane:_502,weight:[_502.region=="center"?Infinity:0,_502.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(_502.region)?1:-1),idx]};},this);_501.sort(function(a,b){var aw=a.weight,bw=b.weight;for(var i=0;i<aw.length;i++){if(aw[i]!=bw[i]){return aw[i]-bw[i];}}return 0;});return _4f7.map(_501,function(w){return w.pane;});},layout:function(){_4fd.layoutChildren(this.domNode,this._contentBox,this._getOrderedChildren());},addChild:function(_503,_504){this.inherited(arguments);if(this._started){this.layout();}},removeChild:function(_505){this.inherited(arguments);if(this._started){this.layout();}_4f9.remove(_505.domNode,this.baseClass+"Pane");_4fa.set(_505.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});_4fa.set(_505.domNode,/top|bottom/.test(_505.region)?"width":"height","auto");}});_4fe.ChildWidgetProperties={region:"",layoutAlign:"",layoutPriority:0};lang.extend(_4fb,_4fe.ChildWidgetProperties);return _4fe;});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_506,lang,_507,has,_508){var html=_508.doc.documentElement,ie=has("ie"),_509=has("trident"),_50a=has("opera"),maj=Math.floor,ff=has("ff"),_50b=_506.boxModel.replace(/-/,""),_50c={"dj_quirks":has("quirks"),"dj_opera":_50a,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_edge":has("edge"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_50c["dj_ie"]=true;_50c["dj_ie"+maj(ie)]=true;_50c["dj_iequirks"]=has("quirks");}if(_509){_50c["dj_trident"]=true;_50c["dj_trident"+maj(_509)]=true;}if(ff){_50c["dj_ff"+maj(ff)]=true;}_50c["dj_"+_50b]=true;var _50d="";for(var clz in _50c){if(_50c[clz]){_50d+=clz+" ";}}html.className=lang.trim(html.className+" "+_50d);_507(function(){if(!_506.isBodyLtr()){var _50e="dj_rtl dijitRtl "+_50d.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_50e+"dj_rtl dijitRtl "+_50d.replace(/ /g,"-rtl "));}});return has;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_50f,_510,fx,dom,_511,_512,_513,lang,_514,on,has,_515,_516,_517,_518,_519,_51a,_51b){var _51c=_510("dijit._MasterTooltip",[_517,_518],{duration:_515.defaultDuration,templateString:_51a,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _519(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_51d,_51e,_51f,rtl,_520,_521,_522){if(this.aroundNode&&this.aroundNode===_51e&&this.containerNode.innerHTML==_51d){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_51d;if(_520){this.set("textDir",_520);}this.containerNode.align=rtl?"right":"left";var pos=_516.around(this.domNode,_51e,_51f&&_51f.length?_51f:_523.defaultPosition,!rtl,lang.hitch(this,"orient"));var _524=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_524.y+((_524.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_524.x+((_524.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_513.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_51e;this.onMouseEnter=_521||noop;this.onMouseLeave=_522||noop;},orient:function(node,_525,_526,_527,_528){this.connectorNode.style.top="";var _529=_527.h,_52a=_527.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_525+"-"+_526];this.domNode.style.width="auto";var size=_512.position(this.domNode);if(has("ie")||has("trident")){size.w+=2;}var _52b=Math.min((Math.max(_52a,1)),size.w);_512.setMarginBox(this.domNode,{w:_52b});if(_526.charAt(0)=="B"&&_525.charAt(0)=="B"){var bb=_512.position(node);var _52c=this.connectorNode.offsetHeight;if(bb.h>_529){var _52d=_529-((_528.h+_52c)>>1);this.connectorNode.style.top=_52d+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_528.h/2-_52c/2,0),bb.h-_52c)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_52a);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_52e){if(this._onDeck&&this._onDeck[1]==_52e){this._onDeck=null;}else{if(this.aroundNode===_52e){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}this.onMouseEnter=this.onMouseLeave=noop;},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_51c.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_50f.forEach(node.children,function(_52f){this._setAutoTextDir(_52f);},this);},_setTextDirAttr:function(_530){this._set("textDir",_530);if(_530=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_51b.showTooltip=function(_531,_532,_533,rtl,_534,_535,_536){if(_533){_533=_50f.map(_533,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_523._masterTT){_51b._masterTT=_523._masterTT=new _51c();}return _523._masterTT.show(_531,_532,_533,rtl,_534,_535,_536);};_51b.hideTooltip=function(_537){return _523._masterTT&&_523._masterTT.hide(_537);};var _538="DORMANT",_539="SHOW TIMER",_53a="SHOWING",_53b="HIDE TIMER";function noop(){};var _523=_510("dijit.Tooltip",_517,{label:"",showDelay:400,hideDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_53c){_50f.forEach(this._connections||[],function(_53d){_50f.forEach(_53d,function(_53e){_53e.remove();});},this);this._connectIds=_50f.filter(lang.isArrayLike(_53c)?_53c:(_53c?[_53c]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_50f.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_53f=this.selector,_540=_53f?function(_541){return on.selector(_53f,_541);}:function(_542){return _542;},self=this;return [on(node,_540(_514.enter),function(){self._onHover(this);}),on(node,_540("focusin"),function(){self._onHover(this);}),on(node,_540(_514.leave),lang.hitch(self,"_onUnHover")),on(node,_540("focusout"),lang.hitch(self,"set","state",_538))];},this);this._set("connectId",_53c);},addTarget:function(node){var id=node.id||node;if(_50f.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_50f.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_511.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_50f.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},state:_538,_setStateAttr:function(val){if(this.state==val||(val==_539&&this.state==_53a)||(val==_53b&&this.state==_538)){return;}if(this._hideTimer){this._hideTimer.remove();delete this._hideTimer;}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}switch(val){case _538:if(this._connectNode){_523.hide(this._connectNode);delete this._connectNode;this.onHide();}break;case _539:if(this.state!=_53a){this._showTimer=this.defer(function(){this.set("state",_53a);},this.showDelay);}break;case _53a:var _543=this.getContent(this._connectNode);if(!_543){this.set("state",_538);return;}_523.show(_543,this._connectNode,this.position,!this.isLeftToRight(),this.textDir,lang.hitch(this,"set","state",_53a),lang.hitch(this,"set","state",_53b));this.onShow(this._connectNode,this.position);break;case _53b:this._hideTimer=this.defer(function(){this.set("state",_538);},this.hideDelay);break;}this._set("state",val);},_onHover:function(_544){if(this._connectNode&&_544!=this._connectNode){this.set("state",_538);}this._connectNode=_544;this.set("state",_539);},_onUnHover:function(_545){this.set("state",_53b);},open:function(_546){this.set("state",_538);this._connectNode=_546;this.set("state",_53a);},close:function(){this.set("state",_538);},onShow:function(){},onHide:function(){},destroy:function(){this.set("state",_538);_50f.forEach(this._connections||[],function(_547){_50f.forEach(_547,function(_548){_548.remove();});},this);this.inherited(arguments);}});_523._MasterTooltip=_51c;_523.show=_51b.showTooltip;_523.hide=_51b.hideTooltip;_523.defaultPosition=["after-centered","before-centered"];return _523;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_549,lang){var _54a=/[&<>'"\/]/g;var _54b={"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;","/":"&#x2F;"};var _54c={};lang.setObject("dojo.string",_54c);_54c.escape=function(str){if(!str){return "";}return str.replace(_54a,function(c){return _54b[c];});};_54c.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_54c.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_54c.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_54c.substitute=function(_54d,map,_54e,_54f){_54f=_54f||_549.global;_54e=_54e?lang.hitch(_54f,_54e):function(v){return v;};return _54d.replace(/\$\{([^\s\:\}]*)(?:\:([^\s\:\}]+))?\}/g,function(_550,key,_551){if(key==""){return "$";}var _552=lang.getObject(key,false,map);if(_551){_552=lang.getObject(_551,false,_54f).call(_54f,_552,key);}var _553=_54e(_552,key);if(typeof _553==="undefined"){throw new Error("string.substitute could not find key \""+key+"\" in template");}return _553.toString();});};_54c.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _54c;});},"dijit/layout/AccordionPane":function(){define(["dojo/_base/declare","dojo/_base/kernel","./ContentPane"],function(_554,_555,_556){return _554("dijit.layout.AccordionPane",_556,{constructor:function(){_555.deprecated("dijit.layout.AccordionPane deprecated, use ContentPane instead","","2.0");},onSelected:function(){}});});},"dijit/dijit":function(){define(["./main","./_base","dojo/parser","./_Widget","./_TemplatedMixin","./_Container","./layout/_LayoutWidget","./form/_FormWidget","./form/_FormValueWidget"],function(_557){return _557;});},"dijit/form/DropDownButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html","../a11yclick"],function(_558,_559,lang,_55a,_55b,_55c,_55d,_55e,_55f,_560){return _558("dijit.form.DropDownButton",[_55d,_55e,_55f],{baseClass:"dijitDropDownButton",templateString:_560,_fillContent:function(){var _561=this.srcNodeRef;var dest=this.containerNode;if(_561&&dest){while(_561.hasChildNodes()){var _562=_561.firstChild;if(_562.hasAttribute&&(_562.hasAttribute("data-dojo-type")||_562.hasAttribute("dojoType")||_562.hasAttribute("data-"+_559._scopeName+"-type")||_562.hasAttribute(_559._scopeName+"Type"))){this.dropDownContainer=this.ownerDocument.createElement("div");this.dropDownContainer.appendChild(_562);}else{dest.appendChild(_562);}}}},startup:function(){if(this._started){return;}if(!this.dropDown&&this.dropDownContainer){this.dropDown=_55b.byNode(this.dropDownContainer.firstChild);delete this.dropDownContainer;}if(this.dropDown){_55c.hide(this.dropDown);}this.inherited(arguments);},isLoaded:function(){var _563=this.dropDown;return (!!_563&&(!_563.href||_563.isLoaded));},loadDropDown:function(_564){var _565=this.dropDown;var _566=_565.on("load",lang.hitch(this,function(){_566.remove();_564();}));_565.refresh();},isFocusable:function(){return this.inherited(arguments)&&!this._mouseDown;}});});},"dijit/form/_FormValueMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./_FormWidgetMixin"],function(_567,_568,keys,lang,on,has,_569){return _567("dijit.form._FormValueMixin",_569,{readOnly:false,_setReadOnlyAttr:function(_56a){if(has("trident")&&"disabled" in this){_568.set(this.focusNode,"readOnly",_56a||this.disabled);}else{_568.set(this.focusNode,"readOnly",_56a);}this._set("readOnly",_56a);},postCreate:function(){this.inherited(arguments);if(this._resetValue===undefined){this._lastValueReported=this._resetValue=this.value;}},_setValueAttr:function(_56b,_56c){this._handleOnChange(_56b,_56c);},_handleOnChange:function(_56d,_56e){this._set("value",_56d);this.inherited(arguments);},undo:function(){this._setValueAttr(this._lastValueReported,false);},reset:function(){this._hasBeenBlurred=false;this._setValueAttr(this._resetValue,true);}});});},"dijit/form/_FormWidgetMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","dojo/window","../a11y"],function(_56f,_570,_571,_572,lang,_573,on,has,_574,a11y){return _570("dijit.form._FormWidgetMixin",null,{name:"",alt:"",value:"",type:"text","aria-label":"focusNode",tabIndex:"0",_setTabIndexAttr:"focusNode",disabled:false,intermediateChanges:false,scrollOnFocus:true,_setIdAttr:"focusNode",_setDisabledAttr:function(_575){this._set("disabled",_575);if(/^(button|input|select|textarea|optgroup|option|fieldset)$/i.test(this.focusNode.tagName)){_571.set(this.focusNode,"disabled",_575);if(has("trident")&&"readOnly" in this){_571.set(this.focusNode,"readonly",_575||this.readOnly);}}else{this.focusNode.setAttribute("aria-disabled",_575?"true":"false");}if(this.valueNode){_571.set(this.valueNode,"disabled",_575);}if(_575){this._set("hovering",false);this._set("active",false);var _576="tabIndex" in this.attributeMap?this.attributeMap.tabIndex:("_setTabIndexAttr" in this)?this._setTabIndexAttr:"focusNode";_56f.forEach(lang.isArray(_576)?_576:[_576],function(_577){var node=this[_577];if(has("webkit")||a11y.hasDefaultTabStop(node)){node.setAttribute("tabIndex","-1");}else{node.removeAttribute("tabIndex");}},this);}else{if(this.tabIndex!=""){this.set("tabIndex",this.tabIndex);}}},_onFocus:function(by){if(by=="mouse"&&this.isFocusable()){var _578=this.own(on(this.focusNode,"focus",function(){_579.remove();_578.remove();}))[0];var _57a=has("pointer-events")?"pointerup":has("MSPointer")?"MSPointerUp":has("touch-events")?"touchend, mouseup":"mouseup";var _579=this.own(on(this.ownerDocumentBody,_57a,lang.hitch(this,function(evt){_579.remove();_578.remove();if(this.focused){if(evt.type=="touchend"){this.defer("focus");}else{this.focus();}}})))[0];}if(this.scrollOnFocus){this.defer(function(){_574.scrollIntoView(this.domNode);});}this.inherited(arguments);},isFocusable:function(){return !this.disabled&&this.focusNode&&(_572.get(this.domNode,"display")!="none");},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},compare:function(val1,val2){if(typeof val1=="number"&&typeof val2=="number"){return (isNaN(val1)&&isNaN(val2))?0:val1-val2;}else{if(val1>val2){return 1;}else{if(val1<val2){return -1;}else{return 0;}}}},onChange:function(){},_onChangeActive:false,_handleOnChange:function(_57b,_57c){if(this._lastValueReported==undefined&&(_57c===null||!this._onChangeActive)){this._resetValue=this._lastValueReported=_57b;}this._pendingOnChange=this._pendingOnChange||(typeof _57b!=typeof this._lastValueReported)||(this.compare(_57b,this._lastValueReported)!=0);if((this.intermediateChanges||_57c||_57c===undefined)&&this._pendingOnChange){this._lastValueReported=_57b;this._pendingOnChange=false;if(this._onChangeActive){if(this._onChangeHandle){this._onChangeHandle.remove();}this._onChangeHandle=this.defer(function(){this._onChangeHandle=null;this.onChange(_57b);});}}},create:function(){this.inherited(arguments);this._onChangeActive=true;},destroy:function(){if(this._onChangeHandle){this._onChangeHandle.remove();this.onChange(this._lastValueReported);}this.inherited(arguments);}});});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_57d,on,_57e){function _57f(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _580;on(document,"keydown",function(e){if(_57f(e)){_580=e.target;e.preventDefault();}else{_580=null;}});on(document,"keyup",function(e){if(_57f(e)&&e.target==_580){_580=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _581=function(node,_582){node.dojoClick=true;return on(node,"click",_582);};_581.click=_581;_581.press=function(node,_583){var _584=on(node,_57e.press,function(evt){if(evt.type=="mousedown"&&!_57d.isLeft(evt)){return;}_583(evt);}),_585=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_583(evt);}});return {remove:function(){_584.remove();_585.remove();}};};_581.release=function(node,_586){var _587=on(node,_57e.release,function(evt){if(evt.type=="mouseup"&&!_57d.isLeft(evt)){return;}_586(evt);}),_588=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_586(evt);}});return {remove:function(){_587.remove();_588.remove();}};};_581.move=_57e.move;return _581;});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_589,_58a,_58b){return _58b("dijit.Destroyable",null,{destroy:function(_58c){this._destroyed=true;},own:function(){var _58d=["destroyRecursive","destroy","remove"];_589.forEach(arguments,function(_58e){var _58f;var odh=_58a.before(this,"destroy",function(_590){_58e[_58f](_590);});var hdhs=[];function _591(){odh.remove();_589.forEach(hdhs,function(hdh){hdh.remove();});};if(_58e.then){_58f="cancel";_58e.then(_591,_591);}else{_589.forEach(_58d,function(_592){if(typeof _58e[_592]==="function"){if(!_58f){_58f=_592;}hdhs.push(_58a.after(_58e,_592,_591,true));}});}},this);return arguments;}});});},"dijit/layout/_ContentPaneResizeMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","../registry","../Viewport","./utils"],function(_593,_594,_595,_596,_597,lang,_598,_599,_59a,_59b){return _594("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){if(this._started){return;}var _59c=this.getParent();this._childOfLayoutWidget=_59c&&_59c.isLayoutContainer;this._needLayout=!this._childOfLayoutWidget;this.inherited(arguments);if(this._isShown()){this._onShow();}if(!this._childOfLayoutWidget){this.own(_59a.on("resize",lang.hitch(this,"resize")));}},_checkIfSingleChild:function(){if(!this.doLayout){return;}var _59d=[],_59e=false;_598("> *",this.containerNode).some(function(node){var _59f=_599.byNode(node);if(_59f&&_59f.resize){_59d.push(_59f);}else{if(!/script|link|style/i.test(node.nodeName)&&node.offsetHeight){_59e=true;}}});this._singleChild=_59d.length==1&&!_59e?_59d[0]:null;_595.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);},resize:function(_5a0,_5a1){this._resizeCalled=true;this._scheduleLayout(_5a0,_5a1);},_scheduleLayout:function(_5a2,_5a3){if(this._isShown()){this._layout(_5a2,_5a3);}else{this._needLayout=true;this._changeSize=_5a2;this._resultSize=_5a3;}},_layout:function(_5a4,_5a5){delete this._needLayout;if(!this._wasShown&&this.open!==false){this._onShow();}if(_5a4){_596.setMarginBox(this.domNode,_5a4);}var cn=this.containerNode;if(cn===this.domNode){var mb=_5a5||{};lang.mixin(mb,_5a4||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_596.getMarginBox(cn),mb);}this._contentBox=_59b.marginBox2contentBox(cn,mb);}else{this._contentBox=_596.getContentBox(cn);}this._layoutChildren();},_layoutChildren:function(){this._checkIfSingleChild();if(this._singleChild&&this._singleChild.resize){var cb=this._contentBox||_596.getContentBox(this.containerNode);this._singleChild.resize({w:cb.w,h:cb.h});}else{var _5a6=this.getChildren(),_5a7,i=0;while(_5a7=_5a6[i++]){if(_5a7.resize){_5a7.resize();}}}},_isShown:function(){if(this._childOfLayoutWidget){if(this._resizeCalled&&"open" in this){return this.open;}return this._resizeCalled;}else{if("open" in this){return this.open;}else{var node=this.domNode,_5a8=this.domNode.parentNode;return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_595.contains(node,"dijitHidden")&&_5a8&&_5a8.style&&(_5a8.style.display!="none");}}},_onShow:function(){this._wasShown=true;if(this._needLayout){this._layout(this._changeSize,this._resultSize);}this.inherited(arguments);}});});},"dijit/WidgetSet":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","./registry"],function(_5a9,_5aa,_5ab,_5ac){var _5ad=_5aa("dijit.WidgetSet",null,{constructor:function(){this._hash={};this.length=0;},add:function(_5ae){if(this._hash[_5ae.id]){throw new Error("Tried to register widget with id=="+_5ae.id+" but that id is already registered");}this._hash[_5ae.id]=_5ae;this.length++;},remove:function(id){if(this._hash[id]){delete this._hash[id];this.length--;}},forEach:function(func,_5af){_5af=_5af||_5ab.global;var i=0,id;for(id in this._hash){func.call(_5af,this._hash[id],i++,this._hash);}return this;},filter:function(_5b0,_5b1){_5b1=_5b1||_5ab.global;var res=new _5ad(),i=0,id;for(id in this._hash){var w=this._hash[id];if(_5b0.call(_5b1,w,i++,this._hash)){res.add(w);}}return res;},byId:function(id){return this._hash[id];},byClass:function(cls){var res=new _5ad(),id,_5b2;for(id in this._hash){_5b2=this._hash[id];if(_5b2.declaredClass==cls){res.add(_5b2);}}return res;},toArray:function(){var ar=[];for(var id in this._hash){ar.push(this._hash[id]);}return ar;},map:function(func,_5b3){return _5a9.map(this.toArray(),func,_5b3);},every:function(func,_5b4){_5b4=_5b4||_5ab.global;var x=0,i;for(i in this._hash){if(!func.call(_5b4,this._hash[i],x++,this._hash)){return false;}}return true;},some:function(func,_5b5){_5b5=_5b5||_5ab.global;var x=0,i;for(i in this._hash){if(func.call(_5b5,this._hash[i],x++,this._hash)){return true;}}return false;}});_5a9.forEach(["forEach","filter","byClass","map","every","some"],function(func){_5ac[func]=_5ad.prototype[func];});return _5ad;});},"dojo/dnd/Moveable":function(){define(["../_base/array","../_base/declare","../_base/lang","../dom","../dom-class","../Evented","../has","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_5b6,_5b7,lang,dom,_5b8,_5b9,has,on,_5ba,_5bb,dnd,_5bc,win){var _5bd;var _5be=function(){};function _5bf(){if("touchAction" in document.body.style){_5bd="touchAction";}else{if("msTouchAction" in document.body.style){_5bd="msTouchAction";}}_5be=function _5be(node,_5c0){node.style[_5bd]=_5c0;};_5be(arguments[0],arguments[1]);};if(has("touch-action")){_5be=_5bf;}var _5c1=_5b7("dojo.dnd.Moveable",[_5b9],{handle:"",delay:0,skip:false,constructor:function(node,_5c2){this.node=dom.byId(node);_5be(this.node,"none");if(!_5c2){_5c2={};}this.handle=_5c2.handle?dom.byId(_5c2.handle):null;if(!this.handle){this.handle=this.node;}this.delay=_5c2.delay>0?_5c2.delay:0;this.skip=_5c2.skip;this.mover=_5c2.mover?_5c2.mover:_5bc;this.events=[on(this.handle,_5bb.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];},markupFactory:function(_5c3,node,Ctor){return new Ctor(node,_5c3);},destroy:function(){_5b6.forEach(this.events,function(_5c4){_5c4.remove();});_5be(this.node,"");this.events=this.node=this.handle=null;},onMouseDown:function(e){if(this.skip&&dnd.isFormElement(e)){return;}if(this.delay){this.events.push(on(this.handle,_5bb.move,lang.hitch(this,"onMouseMove")),on(this.handle.ownerDocument,_5bb.release,lang.hitch(this,"onMouseUp")));this._lastX=e.pageX;this._lastY=e.pageY;}else{this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseMove:function(e){if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){this.onMouseUp(e);this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseUp:function(e){for(var i=0;i<2;++i){this.events.pop().remove();}e.stopPropagation();e.preventDefault();},onSelectStart:function(e){if(!this.skip||!dnd.isFormElement(e)){e.stopPropagation();e.preventDefault();}},onDragDetected:function(e){new this.mover(this.node,e,this);},onMoveStart:function(_5c5){_5ba.publish("/dnd/move/start",_5c5);_5b8.add(win.body(),"dojoMove");_5b8.add(this.node,"dojoMoveItem");},onMoveStop:function(_5c6){_5ba.publish("/dnd/move/stop",_5c6);_5b8.remove(win.body(),"dojoMove");_5b8.remove(this.node,"dojoMoveItem");},onFirstMove:function(){},onMove:function(_5c7,_5c8){this.onMoving(_5c7,_5c8);var s=_5c7.node.style;s.left=_5c8.l+"px";s.top=_5c8.t+"px";this.onMoved(_5c7,_5c8);},onMoving:function(){},onMoved:function(){}});return _5c1;});},"dijit/TooltipDialog":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./focus","./layout/ContentPane","./_DialogMixin","./form/_FormMixin","./_TemplatedMixin","dojo/text!./templates/TooltipDialog.html","./main"],function(_5c9,_5ca,has,keys,lang,on,_5cb,_5cc,_5cd,_5ce,_5cf,_5d0,_5d1){var _5d2=_5c9("dijit.TooltipDialog",[_5cc,_5cf,_5ce,_5cd],{title:"",doLayout:false,autofocus:true,baseClass:"dijitTooltipDialog",_firstFocusItem:null,_lastFocusItem:null,templateString:_5d0,_setTitleAttr:"containerNode",postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));},orient:function(node,_5d3,_5d4){var newC={"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft","BR-TL":"dijitTooltipBelow dijitTooltipABLeft","BL-TR":"dijitTooltipBelow dijitTooltipABRight","TL-BR":"dijitTooltipAbove dijitTooltipABRight","TR-BL":"dijitTooltipAbove dijitTooltipABLeft"}[_5d3+"-"+_5d4];_5ca.replace(this.domNode,newC,this._currentOrientClass||"");this._currentOrientClass=newC;},focus:function(){this._getFocusItems();_5cb.focus(this._firstFocusItem);},onOpen:function(pos){this.orient(this.domNode,pos.aroundCorner,pos.corner);var _5d5=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_5d5.y+((_5d5.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_5d5.x+((_5d5.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}this._onShow();},onClose:function(){this.onHide();},_onKey:function(evt){if(evt.keyCode==keys.ESCAPE){this.defer("onCancel");evt.stopPropagation();evt.preventDefault();}else{if(evt.keyCode==keys.TAB){var node=evt.target;this._getFocusItems();if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_5cb.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_5cb.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}else{evt.stopPropagation();}}}}}}});if(has("dojo-bidi")){_5d2.extend({_setTitleAttr:function(_5d6){this.containerNode.title=(this.textDir&&this.enforceTextDirWithUcc)?this.enforceTextDirWithUcc(null,_5d6):_5d6;this._set("title",_5d6);},_setTextDirAttr:function(_5d7){if(!this._created||this.textDir!=_5d7){this._set("textDir",_5d7);if(this.textDir&&this.title){this.containerNode.title=this.enforceTextDirWithUcc(null,this.title);}}}});}return _5d2;});},"dojo/store/util/SimpleQueryEngine":function(){define(["../../_base/array"],function(_5d8){return function(_5d9,_5da){switch(typeof _5d9){default:throw new Error("Can not query with a "+typeof _5d9);case "object":case "undefined":var _5db=_5d9;_5d9=function(_5dc){for(var key in _5db){var _5dd=_5db[key];if(_5dd&&_5dd.test){if(!_5dd.test(_5dc[key],_5dc)){return false;}}else{if(_5dd!=_5dc[key]){return false;}}}return true;};break;case "string":if(!this[_5d9]){throw new Error("No filter function "+_5d9+" was found in store");}_5d9=this[_5d9];case "function":}function _5de(_5df){var _5e0=_5d8.filter(_5df,_5d9);var _5e1=_5da&&_5da.sort;if(_5e1){_5e0.sort(typeof _5e1=="function"?_5e1:function(a,b){for(var sort,i=0;sort=_5e1[i];i++){var _5e2=a[sort.attribute];var _5e3=b[sort.attribute];_5e2=_5e2!=null?_5e2.valueOf():_5e2;_5e3=_5e3!=null?_5e3.valueOf():_5e3;if(_5e2!=_5e3){return !!sort.descending==(_5e2==null||_5e2>_5e3)?-1:1;}}return 0;});}if(_5da&&(_5da.start||_5da.count)){var _5e4=_5e0.length;_5e0=_5e0.slice(_5da.start||0,(_5da.start||0)+(_5da.count||Infinity));_5e0.total=_5e4;}return _5e0;};_5de.matches=_5d9;return _5de;};});},"dijit/typematic":function(){define(["dojo/_base/array","dojo/_base/connect","dojo/_base/lang","dojo/on","dojo/sniff","./main"],function(_5e5,_5e6,lang,on,has,_5e7){var _5e8=(_5e7.typematic={_fireEventAndReload:function(){this._timer=null;this._callback(++this._count,this._node,this._evt);this._currentTimeout=Math.max(this._currentTimeout<0?this._initialDelay:(this._subsequentDelay>1?this._subsequentDelay:Math.round(this._currentTimeout*this._subsequentDelay)),this._minDelay);this._timer=setTimeout(lang.hitch(this,"_fireEventAndReload"),this._currentTimeout);},trigger:function(evt,_5e9,node,_5ea,obj,_5eb,_5ec,_5ed){if(obj!=this._obj){this.stop();this._initialDelay=_5ec||500;this._subsequentDelay=_5eb||0.9;this._minDelay=_5ed||10;this._obj=obj;this._node=node;this._currentTimeout=-1;this._count=-1;this._callback=lang.hitch(_5e9,_5ea);this._evt={faux:true};for(var attr in evt){if(attr!="layerX"&&attr!="layerY"){var v=evt[attr];if(typeof v!="function"&&typeof v!="undefined"){this._evt[attr]=v;}}}this._fireEventAndReload();}},stop:function(){if(this._timer){clearTimeout(this._timer);this._timer=null;}if(this._obj){this._callback(-1,this._node,this._evt);this._obj=null;}},addKeyListener:function(node,_5ee,_5ef,_5f0,_5f1,_5f2,_5f3){var type="keyCode" in _5ee?"keydown":"charCode" in _5ee?"keypress":_5e6._keypress,attr="keyCode" in _5ee?"keyCode":"charCode" in _5ee?"charCode":"charOrCode";var _5f4=[on(node,type,lang.hitch(this,function(evt){if(evt[attr]==_5ee[attr]&&(_5ee.ctrlKey===undefined||_5ee.ctrlKey==evt.ctrlKey)&&(_5ee.altKey===undefined||_5ee.altKey==evt.altKey)&&(_5ee.metaKey===undefined||_5ee.metaKey==(evt.metaKey||false))&&(_5ee.shiftKey===undefined||_5ee.shiftKey==evt.shiftKey)){evt.stopPropagation();evt.preventDefault();_5e8.trigger(evt,_5ef,node,_5f0,_5ee,_5f1,_5f2,_5f3);}else{if(_5e8._obj==_5ee){_5e8.stop();}}})),on(node,"keyup",lang.hitch(this,function(){if(_5e8._obj==_5ee){_5e8.stop();}}))];return {remove:function(){_5e5.forEach(_5f4,function(h){h.remove();});}};},addMouseListener:function(node,_5f5,_5f6,_5f7,_5f8,_5f9){var _5fa=[on(node,"mousedown",lang.hitch(this,function(evt){evt.preventDefault();_5e8.trigger(evt,_5f5,node,_5f6,node,_5f7,_5f8,_5f9);})),on(node,"mouseup",lang.hitch(this,function(evt){if(this._obj){evt.preventDefault();}_5e8.stop();})),on(node,"mouseout",lang.hitch(this,function(evt){if(this._obj){evt.preventDefault();}_5e8.stop();})),on(node,"dblclick",lang.hitch(this,function(evt){evt.preventDefault();if(has("ie")<9){_5e8.trigger(evt,_5f5,node,_5f6,node,_5f7,_5f8,_5f9);setTimeout(lang.hitch(this,_5e8.stop),50);}}))];return {remove:function(){_5e5.forEach(_5fa,function(h){h.remove();});}};},addListener:function(_5fb,_5fc,_5fd,_5fe,_5ff,_600,_601,_602){var _603=[this.addKeyListener(_5fc,_5fd,_5fe,_5ff,_600,_601,_602),this.addMouseListener(_5fb,_5fe,_5ff,_600,_601,_602)];return {remove:function(){_5e5.forEach(_603,function(h){h.remove();});}};}});return _5e8;});},"dijit/MenuItem":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","dojo/_base/lang","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_604,dom,_605,_606,_607,has,lang,_608,_609,_60a,_60b,_60c){var _60d=_604("dijit.MenuItem"+(has("dojo-bidi")?"_NoBidi":""),[_608,_609,_60a,_60b],{templateString:_60c,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){this._set("label",val);var _60e="";var text;var ndx=val.search(/{\S}/);if(ndx>=0){_60e=val.charAt(ndx+1);var _60f=val.substr(0,ndx);var _610=val.substr(ndx+3);text=_60f+_60e+_610;val=_60f+"<span class=\"dijitMenuItemShortcutKey\">"+_60e+"</span>"+_610;}else{text=val;}this.domNode.setAttribute("aria-label",text+" "+this.accelKey);this.containerNode.innerHTML=val;this._set("shortcutKey",_60e);},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_611){if(_611&&!("label" in this.params)){this._set("label",_611.innerHTML);}},buildRendering:function(){this.inherited(arguments);var _612=this.id+"_text";_605.set(this.containerNode,"id",_612);if(this.accelKeyNode){_605.set(this.accelKeyNode,"id",this.id+"_accel");}dom.setSelectable(this.domNode,false);},onClick:function(){},focus:function(){try{if(has("ie")==8){this.containerNode.focus();}this.focusNode.focus();}catch(e){}},_setSelected:function(_613){_606.toggle(this.domNode,"dijitMenuItemSelected",_613);},setLabel:function(_614){_607.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_614);},setDisabled:function(_615){_607.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_615);},_setDisabledAttr:function(_616){this.focusNode.setAttribute("aria-disabled",_616?"true":"false");this._set("disabled",_616);},_setAccelKeyAttr:function(_617){if(this.accelKeyNode){this.accelKeyNode.style.display=_617?"":"none";this.accelKeyNode.innerHTML=_617;_605.set(this.containerNode,"colSpan",_617?"1":"2");}this._set("accelKey",_617);}});if(has("dojo-bidi")){_60d=_604("dijit.MenuItem",_60d,{_setLabelAttr:function(val){this.inherited(arguments);if(this.textDir==="auto"){this.applyTextDir(this.textDirNode);}}});}return _60d;});},"dijit/layout/TabController":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/has","dojo/i18n","dojo/_base/lang","./StackController","../registry","../Menu","../MenuItem","dojo/text!./templates/_TabButton.html","dojo/i18n!../nls/common"],function(_618,dom,_619,_61a,has,i18n,lang,_61b,_61c,Menu,_61d,_61e){var _61f=_618("dijit.layout._TabButton"+(has("dojo-bidi")?"_NoBidi":""),_61b.StackButton,{baseClass:"dijitTab",cssStateNodes:{closeNode:"dijitTabCloseButton"},templateString:_61e,_setNameAttr:"focusNode",scrollOnFocus:false,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.containerNode,false);},startup:function(){this.inherited(arguments);var n=this.domNode;this.defer(function(){n.className=n.className;},1);},_setCloseButtonAttr:function(disp){this._set("closeButton",disp);_61a.toggle(this.domNode,"dijitClosable",disp);this.closeNode.style.display=disp?"":"none";if(disp){var _620=i18n.getLocalization("dijit","common");if(this.closeNode){_619.set(this.closeNode,"title",_620.itemClose);}}},_setDisabledAttr:function(_621){this.inherited(arguments);if(this.closeNode){if(_621){_619.remove(this.closeNode,"title");}else{var _622=i18n.getLocalization("dijit","common");_619.set(this.closeNode,"title",_622.itemClose);}}},_setLabelAttr:function(_623){this.inherited(arguments);if(!this.showLabel&&!this.params.title){this.iconNode.alt=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_61f=_618("dijit.layout._TabButton",_61f,{_setLabelAttr:function(_624){this.inherited(arguments);this.applyTextDir(this.iconNode,this.iconNode.alt);}});}var _625=_618("dijit.layout.TabController",_61b,{baseClass:"dijitTabController",templateString:"<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'></div>",tabPosition:"top",buttonWidget:_61f,buttonWidgetCloseClass:"dijitTabCloseButton",postCreate:function(){this.inherited(arguments);var _626=new Menu({id:this.id+"_Menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,targetNodeIds:[this.domNode],selector:function(node){return _61a.contains(node,"dijitClosable")&&!_61a.contains(node,"dijitTabDisabled");}});this.own(_626);var _627=i18n.getLocalization("dijit","common"),_628=this;_626.addChild(new _61d({label:_627.itemClose,ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,onClick:function(evt){var _629=_61c.byNode(this.getParent().currentTarget);_628.onCloseButtonClick(_629.page);}}));}});_625.TabButton=_61f;return _625;});},"dijit/ToolbarSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_62a,dom,_62b,_62c){return _62a("dijit.ToolbarSeparator",[_62b,_62c],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/layout/_LayoutWidget":function(){define(["dojo/_base/lang","../_Widget","../_Container","../_Contained","../Viewport","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(lang,_62d,_62e,_62f,_630,_631,_632,_633,_634){return _631("dijit.layout._LayoutWidget",[_62d,_62e,_62f],{baseClass:"dijitLayoutContainer",isLayoutContainer:true,_setTitleAttr:null,buildRendering:function(){this.inherited(arguments);_632.add(this.domNode,"dijitContainer");},startup:function(){if(this._started){return;}this.inherited(arguments);var _635=this.getParent&&this.getParent();if(!(_635&&_635.isLayoutContainer)){this.resize();this.own(_630.on("resize",lang.hitch(this,"resize")));}},resize:function(_636,_637){var node=this.domNode;if(_636){_633.setMarginBox(node,_636);}var mb=_637||{};lang.mixin(mb,_636||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_633.getMarginBox(node),mb);}var cs=_634.getComputedStyle(node);var me=_633.getMarginExtents(node,cs);var be=_633.getBorderExtents(node,cs);var bb=(this._borderBox={w:mb.w-(me.w+be.w),h:mb.h-(me.h+be.h)});var pe=_633.getPadExtents(node,cs);this._contentBox={l:_634.toPixelValue(node,cs.paddingLeft),t:_634.toPixelValue(node,cs.paddingTop),w:bb.w-pe.w,h:bb.h-pe.h};this.layout();},layout:function(){},_setupChild:function(_638){var cls=this.baseClass+"-child "+(_638.baseClass?this.baseClass+"-"+_638.baseClass:"");_632.add(_638.domNode,cls);},addChild:function(_639,_63a){this.inherited(arguments);if(this._started){this._setupChild(_639);}},removeChild:function(_63b){var cls=this.baseClass+"-child"+(_63b.baseClass?" "+this.baseClass+"-"+_63b.baseClass:"");_632.remove(_63b.domNode,cls);this.inherited(arguments);}});});},"dojo/selector/lite":function(){define(["../has","../_base/kernel"],function(has,dojo){"use strict";var _63c=document.createElement("div");var _63d=_63c.matches||_63c.webkitMatchesSelector||_63c.mozMatchesSelector||_63c.msMatchesSelector||_63c.oMatchesSelector;var _63e=_63c.querySelectorAll;var _63f=/([^\s,](?:"(?:\\.|[^"])+"|'(?:\\.|[^'])+'|[^,])*)/g;has.add("dom-matches-selector",!!_63d);has.add("dom-qsa",!!_63e);var _640=function(_641,root){if(_642&&_641.indexOf(",")>-1){return _642(_641,root);}var doc=root?root.ownerDocument||root:dojo.doc||document,_643=(_63e?/^([\w]*)#([\w\-]+$)|^(\.)([\w\-\*]+$)|^(\w+$)/:/^([\w]*)#([\w\-]+)(?:\s+(.*))?$|(?:^|(>|.+\s+))([\w\-\*]+)(\S*$)/).exec(_641);root=root||doc;if(_643){var _644=has("ie")===8&&has("quirks")?root.nodeType===doc.nodeType:root.parentNode!==null&&root.nodeType!==9&&root.parentNode===doc;if(_643[2]&&_644){var _645=dojo.byId?dojo.byId(_643[2],doc):doc.getElementById(_643[2]);if(!_645||(_643[1]&&_643[1]!=_645.tagName.toLowerCase())){return [];}if(root!=doc){var _646=_645;while(_646!=root){_646=_646.parentNode;if(!_646){return [];}}}return _643[3]?_640(_643[3],_645):[_645];}if(_643[3]&&root.getElementsByClassName){return root.getElementsByClassName(_643[4]);}var _645;if(_643[5]){_645=root.getElementsByTagName(_643[5]);if(_643[4]||_643[6]){_641=(_643[4]||"")+_643[6];}else{return _645;}}}if(_63e){if(root.nodeType===1&&root.nodeName.toLowerCase()!=="object"){return _647(root,_641,root.querySelectorAll);}else{return root.querySelectorAll(_641);}}else{if(!_645){_645=root.getElementsByTagName("*");}}var _648=[];for(var i=0,l=_645.length;i<l;i++){var node=_645[i];if(node.nodeType==1&&_649(node,_641,root)){_648.push(node);}}return _648;};var _647=function(_64a,_64b,_64c){var _64d=_64a,old=_64a.getAttribute("id"),nid=old||"__dojo__",_64e=_64a.parentNode,_64f=/^\s*[+~]/.test(_64b);if(_64f&&!_64e){return [];}if(!old){_64a.setAttribute("id",nid);}else{nid=nid.replace(/'/g,"\\$&");}if(_64f&&_64e){_64a=_64a.parentNode;}var _650=_64b.match(_63f);for(var i=0;i<_650.length;i++){_650[i]="[id='"+nid+"'] "+_650[i];}_64b=_650.join(",");try{return _64c.call(_64a,_64b);}finally{if(!old){_64d.removeAttribute("id");}}};if(!has("dom-matches-selector")){var _649=(function(){var _651=_63c.tagName=="div"?"toLowerCase":"toUpperCase";var _652={"":function(_653){_653=_653[_651]();return function(node){return node.tagName==_653;};},".":function(_654){var _655=" "+_654+" ";return function(node){return node.className.indexOf(_654)>-1&&(" "+node.className+" ").indexOf(_655)>-1;};},"#":function(id){return function(node){return node.id==id;};}};var _656={"^=":function(_657,_658){return _657.indexOf(_658)==0;},"*=":function(_659,_65a){return _659.indexOf(_65a)>-1;},"$=":function(_65b,_65c){return _65b.substring(_65b.length-_65c.length,_65b.length)==_65c;},"~=":function(_65d,_65e){return (" "+_65d+" ").indexOf(" "+_65e+" ")>-1;},"|=":function(_65f,_660){return (_65f+"-").indexOf(_660+"-")==0;},"=":function(_661,_662){return _661==_662;},"":function(_663,_664){return true;}};function attr(name,_665,type){var _666=_665.charAt(0);if(_666=="\""||_666=="'"){_665=_665.slice(1,-1);}_665=_665.replace(/\\/g,"");var _667=_656[type||""];return function(node){var _668=node.getAttribute(name);return _668&&_667(_668,_665);};};function _669(_66a){return function(node,root){while((node=node.parentNode)!=root){if(_66a(node,root)){return true;}}};};function _66b(_66c){return function(node,root){node=node.parentNode;return _66c?node!=root&&_66c(node,root):node==root;};};var _66d={};function and(_66e,next){return _66e?function(node,root){return next(node)&&_66e(node,root);}:next;};return function(node,_66f,root){var _670=_66d[_66f];if(!_670){if(_66f.replace(/(?:\s*([> ])\s*)|(#|\.)?((?:\\.|[\w-])+)|\[\s*([\w-]+)\s*(.?=)?\s*("(?:\\.|[^"])+"|'(?:\\.|[^'])+'|(?:\\.|[^\]])*)\s*\]/g,function(t,_671,type,_672,_673,_674,_675){if(_672){_670=and(_670,_652[type||""](_672.replace(/\\/g,"")));}else{if(_671){_670=(_671==" "?_669:_66b)(_670);}else{if(_673){_670=and(_670,attr(_673,_675,_674));}}}return "";})){throw new Error("Syntax error in query");}if(!_670){return true;}_66d[_66f]=_670;}return _670(node,root);};})();}if(!has("dom-qsa")){var _642=function(_676,root){var _677=_676.match(_63f);var _678=[];for(var i=0;i<_677.length;i++){_676=new String(_677[i].replace(/\s*$/,""));_676.indexOf=escape;var _679=_640(_676,root);for(var j=0,l=_679.length;j<l;j++){var node=_679[j];_678[node.sourceIndex]=node;}}var _67a=[];for(i in _678){_67a.push(_678[i]);}return _67a;};}_640.match=_63d?function(node,_67b,root){if(root&&root.nodeType!=9){return _647(root,_67b,function(_67c){return _63d.call(node,_67c);});}return _63d.call(node,_67b);}:_649;return _640;});},"dijit/popup":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./place","./BackgroundIframe","./Viewport","./main","dojo/touch"],function(_67d,_67e,_67f,dom,_680,_681,_682,_683,has,keys,lang,on,_684,_685,_686,_687){function _688(){if(this._popupWrapper){_681.destroy(this._popupWrapper);delete this._popupWrapper;}};var _689=_67f(null,{_stack:[],_beginZIndex:1000,_idGen:1,_repositionAll:function(){if(this._firstAroundNode){var _68a=this._firstAroundPosition,_68b=_682.position(this._firstAroundNode,true),dx=_68b.x-_68a.x,dy=_68b.y-_68a.y;if(dx||dy){this._firstAroundPosition=_68b;for(var i=0;i<this._stack.length;i++){var _68c=this._stack[i].wrapper.style;_68c.top=(parseFloat(_68c.top)+dy)+"px";if(_68c.right=="auto"){_68c.left=(parseFloat(_68c.left)+dx)+"px";}else{_68c.right=(parseFloat(_68c.right)-dx)+"px";}}}this._aroundMoveListener=setTimeout(lang.hitch(this,"_repositionAll"),dx||dy?10:50);}},_createWrapper:function(_68d){var _68e=_68d._popupWrapper,node=_68d.domNode;if(!_68e){_68e=_681.create("div",{"class":"dijitPopup",style:{display:"none"},role:"region","aria-label":_68d["aria-label"]||_68d.label||_68d.name||_68d.id},_68d.ownerDocumentBody);_68e.appendChild(node);var s=node.style;s.display="";s.visibility="";s.position="";s.top="0px";_68d._popupWrapper=_68e;_67e.after(_68d,"destroy",_688,true);if("ontouchend" in document){on(_68e,"touchend",function(evt){if(!/^(input|button|textarea)$/i.test(evt.target.tagName)){evt.preventDefault();}});}_68e.dojoClick=true;}return _68e;},moveOffScreen:function(_68f){var _690=this._createWrapper(_68f);var ltr=_682.isBodyLtr(_68f.ownerDocument),_691={visibility:"hidden",top:"-9999px",display:""};_691[ltr?"left":"right"]="-9999px";_691[ltr?"right":"left"]="auto";_683.set(_690,_691);return _690;},hide:function(_692){var _693=this._createWrapper(_692);_683.set(_693,{display:"none",height:"auto",overflowY:"visible",border:""});var node=_692.domNode;if("_originalStyle" in node){node.style.cssText=node._originalStyle;}},getTopPopup:function(){var _694=this._stack;for(var pi=_694.length-1;pi>0&&_694[pi].parent===_694[pi-1].widget;pi--){}return _694[pi];},open:function(args){var _695=this._stack,_696=args.popup,node=_696.domNode,_697=args.orient||["below","below-alt","above","above-alt"],ltr=args.parent?args.parent.isLeftToRight():_682.isBodyLtr(_696.ownerDocument),_698=args.around,id=(args.around&&args.around.id)?(args.around.id+"_dropdown"):("popup_"+this._idGen++);while(_695.length&&(!args.parent||!dom.isDescendant(args.parent.domNode,_695[_695.length-1].widget.domNode))){this.close(_695[_695.length-1].widget);}var _699=this.moveOffScreen(_696);if(_696.startup&&!_696._started){_696.startup();}var _69a,_69b=_682.position(node);if("maxHeight" in args&&args.maxHeight!=-1){_69a=args.maxHeight||Infinity;}else{var _69c=_686.getEffectiveBox(this.ownerDocument),_69d=_698?_682.position(_698,false):{y:args.y-(args.padding||0),h:(args.padding||0)*2};_69a=Math.floor(Math.max(_69d.y,_69c.h-(_69d.y+_69d.h)));}if(_69b.h>_69a){var cs=_683.getComputedStyle(node),_69e=cs.borderLeftWidth+" "+cs.borderLeftStyle+" "+cs.borderLeftColor;_683.set(_699,{overflowY:"scroll",height:_69a+"px",border:_69e});node._originalStyle=node.style.cssText;node.style.border="none";}_680.set(_699,{id:id,style:{zIndex:this._beginZIndex+_695.length},"class":"dijitPopup "+(_696.baseClass||_696["class"]||"").split(" ")[0]+"Popup",dijitPopupParent:args.parent?args.parent.id:""});if(_695.length==0&&_698){this._firstAroundNode=_698;this._firstAroundPosition=_682.position(_698,true);this._aroundMoveListener=setTimeout(lang.hitch(this,"_repositionAll"),50);}if(has("config-bgIframe")&&!_696.bgIframe){_696.bgIframe=new _685(_699);}var _69f=_696.orient?lang.hitch(_696,"orient"):null,best=_698?_684.around(_699,_698,_697,ltr,_69f):_684.at(_699,args,_697=="R"?["TR","BR","TL","BL"]:["TL","BL","TR","BR"],args.padding,_69f);_699.style.visibility="visible";node.style.visibility="visible";var _6a0=[];_6a0.push(on(_699,"keydown",lang.hitch(this,function(evt){if(evt.keyCode==keys.ESCAPE&&args.onCancel){evt.stopPropagation();evt.preventDefault();args.onCancel();}else{if(evt.keyCode==keys.TAB){evt.stopPropagation();evt.preventDefault();var _6a1=this.getTopPopup();if(_6a1&&_6a1.onCancel){_6a1.onCancel();}}}})));if(_696.onCancel&&args.onCancel){_6a0.push(_696.on("cancel",args.onCancel));}_6a0.push(_696.on(_696.onExecute?"execute":"change",lang.hitch(this,function(){var _6a2=this.getTopPopup();if(_6a2&&_6a2.onExecute){_6a2.onExecute();}})));_695.push({widget:_696,wrapper:_699,parent:args.parent,onExecute:args.onExecute,onCancel:args.onCancel,onClose:args.onClose,handlers:_6a0});if(_696.onOpen){_696.onOpen(best);}return best;},close:function(_6a3){var _6a4=this._stack;while((_6a3&&_67d.some(_6a4,function(elem){return elem.widget==_6a3;}))||(!_6a3&&_6a4.length)){var top=_6a4.pop(),_6a5=top.widget,_6a6=top.onClose;if(_6a5.bgIframe){_6a5.bgIframe.destroy();delete _6a5.bgIframe;}if(_6a5.onClose){_6a5.onClose();}var h;while(h=top.handlers.pop()){h.remove();}if(_6a5&&_6a5.domNode){this.hide(_6a5);}if(_6a6){_6a6();}}if(_6a4.length==0&&this._aroundMoveListener){clearTimeout(this._aroundMoveListener);this._firstAroundNode=this._firstAroundPosition=this._aroundMoveListener=null;}}});return (_687.popup=new _689());});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_6a7,_6a8,lang,_6a9,_6aa){var _6ab={};_6a7.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_6ab[name]=_6a9[name];});lang.mixin(_6ab,{defaultDuration:_6a8["defaultDuration"]||200});lang.mixin(_6aa,_6ab);return _6aa;});},"dijit/layout/StackController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","../focus","../registry","../_Widget","../_TemplatedMixin","../_Container","../form/ToggleButton","dojo/touch"],function(_6ac,_6ad,_6ae,_6af,keys,lang,on,_6b0,_6b1,_6b2,_6b3,_6b4,_6b5,_6b6){var _6b7=_6ad("dijit.layout._StackButton",_6b6,{tabIndex:"-1",closeButton:false,_aria_attr:"aria-selected",buildRendering:function(evt){this.inherited(arguments);(this.focusNode||this.domNode).setAttribute("role","tab");}});var _6b8=_6ad("dijit.layout.StackController",[_6b3,_6b4,_6b5],{baseClass:"dijitStackController",templateString:"<span role='tablist' data-dojo-attach-event='onkeydown'></span>",containerId:"",buttonWidget:_6b7,buttonWidgetCloseClass:"dijitStackCloseButton",pane2button:function(id){return _6b2.byId(this.id+"_"+id);},postCreate:function(){this.inherited(arguments);this.own(_6b0.subscribe(this.containerId+"-startup",lang.hitch(this,"onStartup")),_6b0.subscribe(this.containerId+"-addChild",lang.hitch(this,"onAddChild")),_6b0.subscribe(this.containerId+"-removeChild",lang.hitch(this,"onRemoveChild")),_6b0.subscribe(this.containerId+"-selectChild",lang.hitch(this,"onSelectChild")),_6b0.subscribe(this.containerId+"-containerKeyDown",lang.hitch(this,"onContainerKeyDown")));this.containerNode.dojoClick=true;this.own(on(this.containerNode,"click",lang.hitch(this,function(evt){var _6b9=_6b2.getEnclosingWidget(evt.target);if(_6b9!=this.containerNode&&!_6b9.disabled&&_6b9.page){for(var _6ba=evt.target;_6ba!==this.containerNode;_6ba=_6ba.parentNode){if(_6ae.contains(_6ba,this.buttonWidgetCloseClass)){this.onCloseButtonClick(_6b9.page);break;}else{if(_6ba==_6b9.domNode){this.onButtonClick(_6b9.page);break;}}}}})));},onStartup:function(info){this.textDir=info.textDir;_6ac.forEach(info.children,this.onAddChild,this);if(info.selected){this.onSelectChild(info.selected);}var _6bb=_6b2.byId(this.containerId).containerNode,_6bc=lang.hitch(this,"pane2button"),_6bd={"title":"label","showtitle":"showLabel","iconclass":"iconClass","closable":"closeButton","tooltip":"title","disabled":"disabled","textdir":"textdir"},_6be=function(attr,_6bf){return on(_6bb,"attrmodified-"+attr,function(evt){var _6c0=_6bc(evt.detail&&evt.detail.widget&&evt.detail.widget.id);if(_6c0){_6c0.set(_6bf,evt.detail.newValue);}});};for(var attr in _6bd){this.own(_6be(attr,_6bd[attr]));}},destroy:function(_6c1){this.destroyDescendants(_6c1);this.inherited(arguments);},onAddChild:function(page,_6c2){var Cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;var _6c3=new Cls({id:this.id+"_"+page.id,name:this.id+"_"+page.id,label:page.title,disabled:page.disabled,ownerDocument:this.ownerDocument,dir:page.dir,lang:page.lang,textDir:page.textDir||this.textDir,showLabel:page.showTitle,iconClass:page.iconClass,closeButton:page.closable,title:page.tooltip,page:page});this.addChild(_6c3,_6c2);page.controlButton=_6c3;if(!this._currentChild){this.onSelectChild(page);}var _6c4=page._wrapper.getAttribute("aria-labelledby")?page._wrapper.getAttribute("aria-labelledby")+" "+_6c3.id:_6c3.id;page._wrapper.removeAttribute("aria-label");page._wrapper.setAttribute("aria-labelledby",_6c4);},onRemoveChild:function(page){if(this._currentChild===page){this._currentChild=null;}var _6c5=this.pane2button(page.id);if(_6c5){this.removeChild(_6c5);_6c5.destroy();}delete page.controlButton;},onSelectChild:function(page){if(!page){return;}if(this._currentChild){var _6c6=this.pane2button(this._currentChild.id);_6c6.set("checked",false);_6c6.focusNode.setAttribute("tabIndex","-1");}var _6c7=this.pane2button(page.id);_6c7.set("checked",true);this._currentChild=page;_6c7.focusNode.setAttribute("tabIndex","0");var _6c8=_6b2.byId(this.containerId);},onButtonClick:function(page){var _6c9=this.pane2button(page.id);_6b1.focus(_6c9.focusNode);if(this._currentChild&&this._currentChild.id===page.id){_6c9.set("checked",true);}var _6ca=_6b2.byId(this.containerId);_6ca.selectChild(page);},onCloseButtonClick:function(page){var _6cb=_6b2.byId(this.containerId);_6cb.closeChild(page);if(this._currentChild){var b=this.pane2button(this._currentChild.id);if(b){_6b1.focus(b.focusNode||b.domNode);}}},adjacent:function(_6cc){if(!this.isLeftToRight()&&(!this.tabPosition||/top|bottom/.test(this.tabPosition))){_6cc=!_6cc;}var _6cd=this.getChildren();var idx=_6ac.indexOf(_6cd,this.pane2button(this._currentChild.id)),_6ce=_6cd[idx];var _6cf;do{idx=(idx+(_6cc?1:_6cd.length-1))%_6cd.length;_6cf=_6cd[idx];}while(_6cf.disabled&&_6cf!=_6ce);return _6cf;},onkeydown:function(e,_6d0){if(this.disabled||e.altKey){return;}var _6d1=null;if(e.ctrlKey||!e._djpage){switch(e.keyCode){case keys.LEFT_ARROW:case keys.UP_ARROW:if(!e._djpage){_6d1=false;}break;case keys.PAGE_UP:if(e.ctrlKey){_6d1=false;}break;case keys.RIGHT_ARROW:case keys.DOWN_ARROW:if(!e._djpage){_6d1=true;}break;case keys.PAGE_DOWN:if(e.ctrlKey){_6d1=true;}break;case keys.HOME:var _6d2=this.getChildren();for(var idx=0;idx<_6d2.length;idx++){var _6d3=_6d2[idx];if(!_6d3.disabled){this.onButtonClick(_6d3.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.END:var _6d2=this.getChildren();for(var idx=_6d2.length-1;idx>=0;idx--){var _6d3=_6d2[idx];if(!_6d3.disabled){this.onButtonClick(_6d3.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.DELETE:case "W".charCodeAt(0):if(this._currentChild.closable&&(e.keyCode==keys.DELETE||e.ctrlKey)){this.onCloseButtonClick(this._currentChild);e.stopPropagation();e.preventDefault();}break;case keys.TAB:if(e.ctrlKey){this.onButtonClick(this.adjacent(!e.shiftKey).page);e.stopPropagation();e.preventDefault();}break;}if(_6d1!==null){this.onButtonClick(this.adjacent(_6d1).page);e.stopPropagation();e.preventDefault();}}},onContainerKeyDown:function(info){info.e._djpage=info.page;this.onkeydown(info.e);}});_6b8.StackButton=_6b7;return _6b8;});},"dojo/dnd/Mover":function(){define(["../_base/array","../_base/declare","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_6d4,_6d5,lang,has,win,dom,_6d6,_6d7,_6d8,on,_6d9,dnd,_6da){return _6d5("dojo.dnd.Mover",[_6d8],{constructor:function(node,e,host){this.node=dom.byId(node);this.marginBox={l:e.pageX,t:e.pageY};this.mouseButton=e.button;var h=(this.host=host),d=node.ownerDocument;function _6db(e){e.preventDefault();e.stopPropagation();};this.events=[on(d,_6d9.move,lang.hitch(this,"onFirstMove")),on(d,_6d9.move,lang.hitch(this,"onMouseMove")),on(d,_6d9.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_6db),on(d.body,"selectstart",_6db)];_6da.autoScrollStart(d);if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){_6da.autoScroll(e);var m=this.marginBox;this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);e.preventDefault();e.stopPropagation();},onMouseUp:function(e){if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){this.destroy();}e.preventDefault();e.stopPropagation();},onFirstMove:function(e){var s=this.node.style,l,t,h=this.host;switch(s.position){case "relative":case "absolute":l=Math.round(parseFloat(s.left))||0;t=Math.round(parseFloat(s.top))||0;break;default:s.position="absolute";var m=_6d6.getMarginBox(this.node);var b=win.doc.body;var bs=_6d7.getComputedStyle(b);var bm=_6d6.getMarginBox(b,bs);var bc=_6d6.getContentBox(b,bs);l=m.l-(bc.l-bm.l);t=m.t-(bc.t-bm.t);break;}this.marginBox.l=l-this.marginBox.l;this.marginBox.t=t-this.marginBox.t;if(h&&h.onFirstMove){h.onFirstMove(this,e);}this.events.shift().remove();},destroy:function(){_6d4.forEach(this.events,function(_6dc){_6dc.remove();});var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.node=this.host=null;}});});},"dojo/request/default":function(){define(["exports","require","../has"],function(_6dd,_6de,has){var _6df=has("config-requestProvider"),_6e0;if(1||has("host-webworker")){_6e0="./xhr";}else{if(0){_6e0="./node";}}if(!_6df){_6df=_6e0;}_6dd.getPlatformDefaultId=function(){return _6e0;};_6dd.load=function(id,_6e1,_6e2,_6e3){_6de([id=="platform"?_6e0:_6df],function(_6e4){_6e2(_6e4);});};});},"dijit/layout/TabContainer":function(){define(["dojo/_base/lang","dojo/_base/declare","./_TabContainerBase","./TabController","./ScrollingTabController"],function(lang,_6e5,_6e6,_6e7,_6e8){return _6e5("dijit.layout.TabContainer",_6e6,{useMenu:true,useSlider:true,controllerWidget:"",_makeController:function(_6e9){var cls=this.baseClass+"-tabs"+(this.doLayout?"":" dijitTabNoLayout"),_6e7=typeof this.controllerWidget=="string"?lang.getObject(this.controllerWidget):this.controllerWidget;return new _6e7({id:this.id+"_tablist",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,tabPosition:this.tabPosition,doLayout:this.doLayout,containerId:this.id,"class":cls,nested:this.nested,useMenu:this.useMenu,useSlider:this.useSlider,tabStripClass:this.tabStrip?this.baseClass+(this.tabStrip?"":"No")+"Strip":null},_6e9);},postMixInProperties:function(){this.inherited(arguments);if(!this.controllerWidget){this.controllerWidget=(this.tabPosition=="top"||this.tabPosition=="bottom")&&!this.nested?_6e8:_6e7;}}});});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_6ea,_6eb,_6ec,_6ed,_6ee,lang,on,has){has.add("config-bgIframe",(has("ie")||has("trident"))&&!/IEMobile\/10\.0/.test(navigator.userAgent));var _6ef=new function(){var _6f0=[];this.pop=function(){var _6f1;if(_6f0.length){_6f1=_6f0.pop();_6f1.style.display="";}else{if(has("ie")<9){var burl=_6ec["dojoBlankHtmlUrl"]||_6ea.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_6f1=document.createElement(html);}else{_6f1=_6ed.create("iframe");_6f1.src="javascript:\"\"";_6f1.className="dijitBackgroundIframe";_6f1.setAttribute("role","presentation");_6ee.set(_6f1,"opacity",0.1);}_6f1.tabIndex=-1;}return _6f1;};this.push=function(_6f2){_6f2.style.display="none";_6f0.push(_6f2);};}();_6eb.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _6f3=(this.iframe=_6ef.pop());node.appendChild(_6f3);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_6ee.set(_6f3,{width:"100%",height:"100%"});}}};lang.extend(_6eb.BackgroundIframe,{resize:function(node){if(this.iframe){_6ee.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){this.iframe.parentNode.removeChild(this.iframe);_6ef.push(this.iframe);delete this.iframe;}}});return _6eb.BackgroundIframe;});},"dojo/dnd/Avatar":function(){define(["../_base/declare","../_base/window","../dom","../dom-attr","../dom-class","../dom-construct","../hccss","../query"],function(_6f4,win,dom,_6f5,_6f6,_6f7,has,_6f8){return _6f4("dojo.dnd.Avatar",null,{constructor:function(_6f9){this.manager=_6f9;this.construct();},construct:function(){var a=_6f7.create("table",{"class":"dojoDndAvatar",style:{position:"absolute",zIndex:"1999",margin:"0px"}}),_6fa=this.manager.source,node,b=_6f7.create("tbody",null,a),tr=_6f7.create("tr",null,b),td=_6f7.create("td",null,tr),k=Math.min(5,this.manager.nodes.length),i=0;if(has("highcontrast")){_6f7.create("span",{id:"a11yIcon",innerHTML:this.manager.copy?"+":"<"},td);}_6f7.create("span",{innerHTML:_6fa.generateText?this._generateText():""},td);_6f5.set(tr,{"class":"dojoDndAvatarHeader",style:{opacity:0.9}});for(;i<k;++i){if(_6fa.creator){node=_6fa._normalizedCreator(_6fa.getItem(this.manager.nodes[i].id).data,"avatar").node;}else{node=this.manager.nodes[i].cloneNode(true);if(node.tagName.toLowerCase()=="tr"){var _6fb=_6f7.create("table"),_6fc=_6f7.create("tbody",null,_6fb);_6fc.appendChild(node);node=_6fb;}}node.id="";tr=_6f7.create("tr",null,b);td=_6f7.create("td",null,tr);td.appendChild(node);_6f5.set(tr,{"class":"dojoDndAvatarItem",style:{opacity:(9-i)/10}});}this.node=a;},destroy:function(){_6f7.destroy(this.node);this.node=false;},update:function(){_6f6.toggle(this.node,"dojoDndAvatarCanDrop",this.manager.canDropFlag);if(has("highcontrast")){var icon=dom.byId("a11yIcon");var text="+";if(this.manager.canDropFlag&&!this.manager.copy){text="< ";}else{if(!this.manager.canDropFlag&&!this.manager.copy){text="o";}else{if(!this.manager.canDropFlag){text="x";}}}icon.innerHTML=text;}_6f8(("tr.dojoDndAvatarHeader td span"+(has("highcontrast")?" span":"")),this.node).forEach(function(node){node.innerHTML=this.manager.source.generateText?this._generateText():"";},this);},_generateText:function(){return this.manager.nodes.length.toString();}});});},"dijit/form/Button":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html","../a11yclick"],function(_6fd,_6fe,_6ff,has,_700,lang,_701,_702,_703,_704){if(has("dijit-legacy-requires")){_701(0,function(){var _705=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];_6fd(_705);});}var _706=_6fe("dijit.form.Button"+(has("dojo-bidi")?"_NoBidi":""),[_702,_703],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_704,_setValueAttr:"valueNode",_setNameAttr:function(name){if(this.valueNode){this.valueNode.setAttribute("name",name);}},postCreate:function(){this.inherited(arguments);this._setLabelFromContainer();},_setLabelFromContainer:function(){if(this.containerNode&&!this.label){this.label=lang.trim(this.containerNode.innerHTML);this.onLabelSet();}},_setShowLabelAttr:function(val){if(this.containerNode){_6ff.toggle(this.containerNode,"dijitDisplayNone",!val);}this._set("showLabel",val);},setLabel:function(_707){_700.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_707);},onLabelSet:function(){this.inherited(arguments);if(!this.showLabel&&!("title" in this.params)){this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_706=_6fe("dijit.form.Button",_706,{onLabelSet:function(){this.inherited(arguments);if(this.titleNode.title){this.applyTextDir(this.titleNode,this.titleNode.title);}},_setTextDirAttr:function(_708){if(this._created&&this.textDir!=_708){this._set("textDir",_708);this._setLabelAttr(this.label);}}});}return _706;});},"dojo/dnd/move":function(){define(["../_base/declare","../dom-geometry","../dom-style","./common","./Mover","./Moveable"],function(_709,_70a,_70b,dnd,_70c,_70d){var _70e=_709("dojo.dnd.move.constrainedMoveable",_70d,{constraints:function(){},within:false,constructor:function(node,_70f){if(!_70f){_70f={};}this.constraints=_70f.constraints;this.within=_70f.within;},onFirstMove:function(_710){var c=this.constraintBox=this.constraints.call(this,_710);c.r=c.l+c.w;c.b=c.t+c.h;if(this.within){var mb=_70a.getMarginSize(_710.node);c.r-=mb.w;c.b-=mb.h;}},onMove:function(_711,_712){var c=this.constraintBox,s=_711.node.style;this.onMoving(_711,_712);_712.l=_712.l<c.l?c.l:c.r<_712.l?c.r:_712.l;_712.t=_712.t<c.t?c.t:c.b<_712.t?c.b:_712.t;s.left=_712.l+"px";s.top=_712.t+"px";this.onMoved(_711,_712);}});var _713=_709("dojo.dnd.move.boxConstrainedMoveable",_70e,{box:{},constructor:function(node,_714){var box=_714&&_714.box;this.constraints=function(){return box;};}});var _715=_709("dojo.dnd.move.parentConstrainedMoveable",_70e,{area:"content",constructor:function(node,_716){var area=_716&&_716.area;this.constraints=function(){var n=this.node.parentNode,s=_70b.getComputedStyle(n),mb=_70a.getMarginBox(n,s);if(area=="margin"){return mb;}var t=_70a.getMarginExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="border"){return mb;}t=_70a.getBorderExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="padding"){return mb;}t=_70a.getPadExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;return mb;};}});return {constrainedMoveable:_70e,boxConstrainedMoveable:_713,parentConstrainedMoveable:_715};});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_717,_718,_719,_71a,_71b,_71c,dom,_71d,_71e,_71f,_720,_721,has,_722,lang,on,_723,_724,_725,win,_726,_727,_728){has.add("dijit-legacy-requires",!_722.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_723(0,function(){var _729=["dijit/_base/manager"];_717(_729);});}var _72a={};function _72b(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _72c(attr){return function(val){_71d[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _72d(a,b){return a===b||(a!==a&&b!==b);};var _72e=_71c("dijit._WidgetBase",[_724,_726],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_72c("lang"),dir:"",_setDirAttr:_72c("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},_setTypeAttr:null,style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_71a.blankGif||_717.toUrl("dojo/resources/blank.gif"),textDir:"",_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _72f=ctor.prototype,_730=ctor._setterAttrs=[],_731=(ctor._onMap={});for(var name in _72f.attributeMap){_730.push(name);}for(name in _72f){if(/^on/.test(name)){_731[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_72f.attributeMap||!(name in _72f.attributeMap)){_730.push(name);}}}}},postscript:function(_732,_733){this.create(_732,_733);},create:function(_734,_735){this._introspect();this.srcNodeRef=dom.byId(_735);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&this.srcNodeRef.id&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_734){this.params=_734;lang.mixin(this,_734);}this.postMixInProperties();if(!this.id){this.id=_728.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_728.add(this);this.buildRendering();var _736;if(this.domNode){this._applyAttributes();var _737=this.srcNodeRef;if(_737&&_737.parentNode&&this.domNode!==_737){_737.parentNode.replaceChild(this.domNode,_737);_736=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_736){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _738={};for(var key in this.params||{}){_738[key]=this._get(key);}_718.forEach(this.constructor._setterAttrs,function(key){if(!(key in _738)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _738){this.set(key,_738[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _739=this.baseClass.split(" ");if(!this.isLeftToRight()){_739=_739.concat(_718.map(_739,function(name){return name+"Rtl";}));}_71e.add(this.domNode,_739);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_718.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_73a){this._beingDestroyed=true;this.destroyDescendants(_73a);this.destroy(_73a);},destroy:function(_73b){this._beingDestroyed=true;this.uninitialize();function _73c(w){if(w.destroyRecursive){w.destroyRecursive(_73b);}else{if(w.destroy){w.destroy(_73b);}}};_718.forEach(this._connects,lang.hitch(this,"disconnect"));_718.forEach(this._supportingWidgets,_73c);if(this.domNode){_718.forEach(_728.findWidgets(this.domNode,this.containerNode),_73c);}this.destroyRendering(_73b);_728.remove(this.id);this._destroyed=true;},destroyRendering:function(_73d){if(this.bgIframe){this.bgIframe.destroy(_73d);delete this.bgIframe;}if(this.domNode){if(_73d){_71d.remove(this.domNode,"widgetId");}else{_71f.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_73d){_71f.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_73e){_718.forEach(this.getChildren(),function(_73f){if(_73f.destroyRecursive){_73f.destroyRecursive(_73e);}});},uninitialize:function(){return false;},_setStyleAttr:function(_740){var _741=this.domNode;if(lang.isObject(_740)){_721.set(_741,_740);}else{if(_741.style.cssText){_741.style.cssText+="; "+_740;}else{_741.style.cssText=_740;}}this._set("style",_740);},_attrToDom:function(attr,_742,_743){_743=arguments.length>=3?_743:this.attributeMap[attr];_718.forEach(lang.isArray(_743)?_743:[_743],function(_744){var _745=this[_744.node||_744||"domNode"];var type=_744.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_742)){_742=lang.hitch(this,_742);}var _746=_744.attribute?_744.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_745.tagName){_71d.set(_745,_746,_742);}else{_745.set(_746,_742);}break;case "innerText":_745.innerHTML="";_745.appendChild(this.ownerDocument.createTextNode(_742));break;case "textContent":_745.textContent=_742;break;case "innerHTML":_745.innerHTML=_742;break;case "class":_71e.replace(_745,_742,this[attr]);break;case "toggleClass":_71e.toggle(_745,_744.className||attr,_742);break;}},this);},get:function(name){var _747=this._getAttrNames(name);return this[_747.g]?this[_747.g]():this._get(name);},set:function(name,_748){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _749=this._getAttrNames(name),_74a=this[_749.s];if(lang.isFunction(_74a)){var _74b=_74a.apply(this,Array.prototype.slice.call(arguments,1));}else{var _74c=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_74c]&&this[_74c].tagName,_74d=tag&&(_72a[tag]||(_72a[tag]=_72b(this[_74c]))),map=name in this.attributeMap?this.attributeMap[name]:_749.s in this?this[_749.s]:((_74d&&_749.l in _74d&&typeof _748!="function")||/^aria-|^data-|^role$/.test(name))?_74c:null;if(map!=null){this._attrToDom(name,_748,map);}this._set(name,_748);}return _74b||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_74e){var _74f=this[name];this[name]=_74e;if(this._created&&!_72d(_74f,_74e)){if(this._watchCallbacks){this._watchCallbacks(name,_74f,_74e);}this.emit("attrmodified-"+name,{detail:{prevValue:_74f,newValue:_74e}});}},_get:function(name){return this[name];},emit:function(type,_750,_751){_750=_750||{};if(_750.bubbles===undefined){_750.bubbles=true;}if(_750.cancelable===undefined){_750.cancelable=true;}if(!_750.detail){_750.detail={};}_750.detail.widget=this;var ret,_752=this["on"+type];if(_752){ret=_752.apply(this,_751?_751:[_750]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_750);}return ret;},on:function(type,func){var _753=this._onMap(type);if(_753){return _719.after(this,_753,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_728.findWidgets(this.containerNode):[];},getParent:function(){return _728.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_754,_755){return this.own(_71b.connect(obj,_754,this,_755))[0];},disconnect:function(_756){_756.remove();},subscribe:function(t,_757){return this.own(_725.subscribe(t,lang.hitch(this,_757)))[0];},unsubscribe:function(_758){_758.remove();},isLeftToRight:function(){return this.dir?(this.dir.toLowerCase()=="ltr"):_720.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_721.get(this.domNode,"display")!="none");},placeAt:function(_759,_75a){var _75b=!_759.tagName&&_728.byId(_759);if(_75b&&_75b.addChild&&(!_75a||typeof _75a==="number")){_75b.addChild(this,_75a);}else{var ref=_75b&&("domNode" in _75b)?(_75b.containerNode&&!/after|before|replace/.test(_75a||"")?_75b.containerNode:_75b.domNode):dom.byId(_759,this.ownerDocument);_71f.place(this.domNode,ref,_75a);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_75c){var _75d=setTimeout(lang.hitch(this,function(){if(!_75d){return;}_75d=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_75c||0);return {remove:function(){if(_75d){clearTimeout(_75d);_75d=null;}return null;}};}});if(has("dojo-bidi")){_72e.extend(_727);}return _72e;});},"dijit/layout/_TabContainerBase":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","./StackContainer","./utils","../_TemplatedMixin","dojo/text!./templates/TabContainer.html"],function(_75e,_75f,_760,_761,_762,_763,_764,_765){return _75e("dijit.layout._TabContainerBase",[_762,_764],{tabPosition:"top",baseClass:"dijitTabContainer",tabStrip:false,nested:false,templateString:_765,postMixInProperties:function(){this.baseClass+=this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"");this.srcNodeRef&&_761.set(this.srcNodeRef,"visibility","hidden");this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.tablist=this._makeController(this.tablistNode);if(!this.doLayout){_75f.add(this.domNode,"dijitTabContainerNoLayout");}if(this.nested){_75f.add(this.domNode,"dijitTabContainerNested");_75f.add(this.tablist.containerNode,"dijitTabContainerTabListNested");_75f.add(this.tablistSpacer,"dijitTabContainerSpacerNested");_75f.add(this.containerNode,"dijitTabPaneWrapperNested");}else{_75f.add(this.domNode,"tabStrip-"+(this.tabStrip?"enabled":"disabled"));}},_setupChild:function(tab){_75f.add(tab.domNode,"dijitTabPane");this.inherited(arguments);},removeChild:function(_766){_75f.remove(_766.domNode,"dijitTabPane");this.inherited(arguments);},startup:function(){if(this._started){return;}this.tablist.startup();this.inherited(arguments);},layout:function(){if(!this._contentBox||typeof (this._contentBox.l)=="undefined"){return;}var sc=this.selectedChildWidget;if(this.doLayout){var _767=this.tabPosition.replace(/-h/,"");this.tablist.region=_767;var _768=[this.tablist,{domNode:this.tablistSpacer,region:_767},{domNode:this.containerNode,region:"center"}];_763.layoutChildren(this.domNode,this._contentBox,_768);this._containerContentBox=_763.marginBox2contentBox(this.containerNode,_768[2]);if(sc&&sc.resize){sc.resize(this._containerContentBox);}}else{if(this.tablist.resize){var s=this.tablist.domNode.style;s.width="0";var _769=_760.getContentBox(this.domNode).w;s.width="";this.tablist.resize({w:_769});}if(sc&&sc.resize){sc.resize();}}},destroy:function(_76a){if(this.tablist){this.tablist.destroy(_76a);}this.inherited(arguments);}});});},"dijit/form/Form":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/sniff","../_Widget","../_TemplatedMixin","./_FormMixin","../layout/_ContentPaneResizeMixin"],function(_76b,_76c,_76d,has,_76e,_76f,_770,_771){return _76b("dijit.form.Form",[_76e,_76f,_770,_771],{name:"",action:"",method:"",encType:"","accept-charset":"",accept:"",target:"",templateString:"<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",postMixInProperties:function(){this.nameAttrSetting=this.name?("name='"+this.name+"'"):"";this.inherited(arguments);},execute:function(){},onExecute:function(){},_setEncTypeAttr:function(_772){_76c.set(this.domNode,"encType",_772);if(has("ie")){this.domNode.encoding=_772;}this._set("encType",_772);},reset:function(e){var faux={returnValue:true,preventDefault:function(){this.returnValue=false;},stopPropagation:function(){},currentTarget:e?e.target:this.domNode,target:e?e.target:this.domNode};if(!(this.onReset(faux)===false)&&faux.returnValue){this.inherited(arguments,[]);}},onReset:function(){return true;},_onReset:function(e){this.reset(e);e.stopPropagation();e.preventDefault();return false;},_onSubmit:function(e){var fp=this.constructor.prototype;if(this.execute!=fp.execute||this.onExecute!=fp.onExecute){_76d.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.","","2.0");this.onExecute();this.execute(this.getValues());}if(this.onSubmit(e)===false){e.stopPropagation();e.preventDefault();}},onSubmit:function(){return this.isValid();},submit:function(){if(!(this.onSubmit()===false)){this.containerNode.submit();}}});});},"dojo/store/Memory":function(){define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_773,_774,_775){var base=null;return _773("dojo.store.Memory",base,{constructor:function(_776){for(var i in _776){this[i]=_776[i];}this.setData(this.data||[]);},data:null,idProperty:"id",index:null,queryEngine:_775,get:function(id){return this.data[this.index[id]];},getIdentity:function(_777){return _777[this.idProperty];},put:function(_778,_779){var data=this.data,_77a=this.index,_77b=this.idProperty;var id=_778[_77b]=(_779&&"id" in _779)?_779.id:_77b in _778?_778[_77b]:Math.random();if(id in _77a){if(_779&&_779.overwrite===false){throw new Error("Object already exists");}data[_77a[id]]=_778;}else{_77a[id]=data.push(_778)-1;}return id;},add:function(_77c,_77d){(_77d=_77d||{}).overwrite=false;return this.put(_77c,_77d);},remove:function(id){var _77e=this.index;var data=this.data;if(id in _77e){data.splice(_77e[id],1);this.setData(data);return true;}},query:function(_77f,_780){return _774(this.queryEngine(_77f,_780)(this.data));},setData:function(data){if(data.items){this.idProperty=data.identifier||this.idProperty;data=this.data=data.items;}else{this.data=data;}this.index={};for(var i=0,l=data.length;i<l;i++){this.index[data[i][this.idProperty]]=i;}}});});},"dijit/_base/sniff":function(){define(["dojo/uacss"],function(){});},"dijit/Toolbar":function(){define(["require","dojo/_base/declare","dojo/has","dojo/keys","dojo/ready","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_781,_782,has,keys,_783,_784,_785,_786){if(has("dijit-legacy-requires")){_783(0,function(){var _787=["dijit/ToolbarSeparator"];_781(_787);});}return _782("dijit.Toolbar",[_784,_786,_785],{templateString:"<div class=\"dijit\" role=\"toolbar\" tabIndex=\"${tabIndex}\" data-dojo-attach-point=\"containerNode\">"+"</div>",baseClass:"dijitToolbar",_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();}});});},"dijit/layout/StackContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/topic","dojo/when","../registry","../_WidgetBase","./_LayoutWidget"],function(_788,_789,_78a,_78b,_78c,has,lang,on,_78d,_78e,when,_78f,_790,_791){if(has("dijit-legacy-requires")){_78d(0,function(){var _792=["dijit/layout/StackController"];require(_792);});}var _793=_78a("dijit.layout.StackContainer",_791,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){this.inherited(arguments);_78b.add(this.domNode,"dijitLayoutContainer");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")));},startup:function(){if(this._started){return;}var _794=this.getChildren();_788.forEach(_794,this._setupChild,this);if(this.persist){this.selectedChildWidget=_78f.byId(_789(this.id+"_selectedChild"));}else{_788.some(_794,function(_795){if(_795.selected){this.selectedChildWidget=_795;}return _795.selected;},this);}var _796=this.selectedChildWidget;if(!_796&&_794[0]){_796=this.selectedChildWidget=_794[0];_796.selected=true;}_78e.publish(this.id+"-startup",{children:_794,selected:_796,textDir:this.textDir});this.inherited(arguments);},resize:function(){if(!this._hasBeenShown){this._hasBeenShown=true;var _797=this.selectedChildWidget;if(_797){this._showChild(_797);}}this.inherited(arguments);},_setupChild:function(_798){var _799=_798.domNode,_79a=_78c.place("<div role='tabpanel' class='"+this.baseClass+"ChildWrapper dijitHidden'>",_798.domNode,"replace"),_79b=_798["aria-label"]||_798.title||_798.label;if(_79b){_79a.setAttribute("aria-label",_79b);}_78c.place(_799,_79a);_798._wrapper=_79a;this.inherited(arguments);if(_799.style.display=="none"){_799.style.display="block";}_798.domNode.removeAttribute("title");},addChild:function(_79c,_79d){this.inherited(arguments);if(this._started){_78e.publish(this.id+"-addChild",_79c,_79d);this.layout();if(!this.selectedChildWidget){this.selectChild(_79c);}}},removeChild:function(page){var idx=_788.indexOf(this.getChildren(),page);this.inherited(arguments);_78c.destroy(page._wrapper);delete page._wrapper;if(this._started){_78e.publish(this.id+"-removeChild",page);}if(this._descendantsBeingDestroyed){return;}if(this.selectedChildWidget===page){this.selectedChildWidget=undefined;if(this._started){var _79e=this.getChildren();if(_79e.length){this.selectChild(_79e[Math.max(idx-1,0)]);}}}if(this._started){this.layout();}},selectChild:function(page,_79f){var d;page=_78f.byId(page);if(this.selectedChildWidget!=page){d=this._transition(page,this.selectedChildWidget,_79f);this._set("selectedChildWidget",page);_78e.publish(this.id+"-selectChild",page,this._focused);if(this.persist){_789(this.id+"_selectedChild",this.selectedChildWidget.id);}}return when(d||true);},_transition:function(_7a0,_7a1){if(_7a1){this._hideChild(_7a1);}var d=this._showChild(_7a0);if(_7a0.resize){if(this.doLayout){_7a0.resize(this._containerContentBox||this._contentBox);}else{_7a0.resize();}}return d;},_adjacent:function(_7a2){var _7a3=this.getChildren();var _7a4=_788.indexOf(_7a3,this.selectedChildWidget);_7a4+=_7a2?1:_7a3.length-1;return _7a3[_7a4%_7a3.length];},forward:function(){return this.selectChild(this._adjacent(true),true);},back:function(){return this.selectChild(this._adjacent(false),true);},_onKeyDown:function(e){_78e.publish(this.id+"-containerKeyDown",{e:e,page:this});},layout:function(){var _7a5=this.selectedChildWidget;if(_7a5&&_7a5.resize){if(this.doLayout){_7a5.resize(this._containerContentBox||this._contentBox);}else{_7a5.resize();}}},_showChild:function(page){var _7a6=this.getChildren();page.isFirstChild=(page==_7a6[0]);page.isLastChild=(page==_7a6[_7a6.length-1]);page._set("selected",true);if(page._wrapper){_78b.replace(page._wrapper,"dijitVisible","dijitHidden");}return (page._onShow&&page._onShow())||true;},_hideChild:function(page){page._set("selected",false);if(page._wrapper){_78b.replace(page._wrapper,"dijitHidden","dijitVisible");}page.onHide&&page.onHide();},closeChild:function(page){var _7a7=!page.onClose||page.onClose(this,page);if(_7a7){this.removeChild(page);page.destroyRecursive();}},destroyDescendants:function(_7a8){this._descendantsBeingDestroyed=true;this.selectedChildWidget=undefined;_788.forEach(this.getChildren(),function(_7a9){if(!_7a8){this.removeChild(_7a9);}_7a9.destroyRecursive(_7a8);},this);this._descendantsBeingDestroyed=false;}});_793.ChildWidgetProperties={selected:false,disabled:false,closable:false,iconClass:"dijitNoIcon",showTitle:true};lang.extend(_790,_793.ChildWidgetProperties);return _793;});},"dojo/regexp":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){var _7aa={};lang.setObject("dojo.regexp",_7aa);_7aa.escapeString=function(str,_7ab){return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+\-^])/g,function(ch){if(_7ab&&_7ab.indexOf(ch)!=-1){return ch;}return "\\"+ch;});};_7aa.buildGroupRE=function(arr,re,_7ac){if(!(arr instanceof Array)){return re(arr);}var b=[];for(var i=0;i<arr.length;i++){b.push(re(arr[i]));}return _7aa.group(b.join("|"),_7ac);};_7aa.group=function(_7ad,_7ae){return "("+(_7ae?"?:":"")+_7ad+")";};return _7aa;});},"dijit/form/ComboBox":function(){define(["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_7af,_7b0,_7b1){return _7af("dijit.form.ComboBox",[_7b0,_7b1],{});});},"dijit/DropDownMenu":function(){define(["dojo/_base/declare","dojo/keys","dojo/text!./templates/Menu.html","./_MenuBase"],function(_7b2,keys,_7b3,_7b4){return _7b2("dijit.DropDownMenu",_7b4,{templateString:_7b3,baseClass:"dijitMenu",_onUpArrow:function(){this.focusPrev();},_onDownArrow:function(){this.focusNext();},_onRightArrow:function(evt){this._moveToPopup(evt);evt.stopPropagation();evt.preventDefault();},_onLeftArrow:function(evt){if(this.parentMenu){if(this.parentMenu._isMenuBar){this.parentMenu.focusPrev();}else{this.onCancel(false);}}else{evt.stopPropagation();evt.preventDefault();}}});});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_7b5,_7b6,_7b7,_7b8,lang,_7b9,on,_7ba,_7bb){var _7bc=lang.delegate(_7ba,{"mouseenter":_7b9.enter,"mouseleave":_7b9.leave,"keypress":_7b7._keypress});var _7bd;var _7be=_7b8("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_7bf){var node=_7bf;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_7bf){return;}while(!node.nextSibling){node=node.parentNode;if(node==_7bf){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_7c0,_7c1,_7c2){var ret=true;var _7c3=this.attachScope||this,_7c4=_7c1(_7c0,"dojoAttachPoint")||_7c1(_7c0,"data-dojo-attach-point");if(_7c4){var _7c5,_7c6=_7c4.split(/\s*,\s*/);while((_7c5=_7c6.shift())){if(lang.isArray(_7c3[_7c5])){_7c3[_7c5].push(_7c0);}else{_7c3[_7c5]=_7c0;}ret=(_7c5!="containerNode");this._attachPoints.push(_7c5);}}var _7c7=_7c1(_7c0,"dojoAttachEvent")||_7c1(_7c0,"data-dojo-attach-event");if(_7c7){var _7c8,_7c9=_7c7.split(/\s*,\s*/);var trim=lang.trim;while((_7c8=_7c9.shift())){if(_7c8){var _7ca=null;if(_7c8.indexOf(":")!=-1){var _7cb=_7c8.split(":");_7c8=trim(_7cb[0]);_7ca=trim(_7cb[1]);}else{_7c8=trim(_7c8);}if(!_7ca){_7ca=_7c8;}this._attachEvents.push(_7c2(_7c0,_7c8,lang.hitch(_7c3,_7ca)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_7bd||(_7bd=_7b5("./a11yclick"));}else{type=_7bc[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _7cc=this.attachScope||this;_7b6.forEach(this._attachPoints,function(_7cd){delete _7cc[_7cd];});this._attachPoints=[];_7b6.forEach(this._attachEvents,function(_7ce){_7ce.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_7bb,{dojoAttachEvent:"",dojoAttachPoint:""});return _7be;});},"dijit/form/_FormMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_7cf,_7d0,_7d1,lang,on,_7d2){return _7d0("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_7d3){var res=[];_7cf.forEach(_7d3||this.getChildren(),function(_7d4){if("value" in _7d4){res.push(_7d4);}else{res=res.concat(this._getDescendantFormWidgets(_7d4.getChildren()));}},this);return res;},reset:function(){_7cf.forEach(this._getDescendantFormWidgets(),function(_7d5){if(_7d5.reset){_7d5.reset();}});},validate:function(){var _7d6=false;return _7cf.every(_7cf.map(this._getDescendantFormWidgets(),function(_7d7){_7d7._hasBeenBlurred=true;var _7d8=_7d7.disabled||!_7d7.validate||_7d7.validate();if(!_7d8&&!_7d6){_7d2.scrollIntoView(_7d7.containerNode||_7d7.domNode);_7d7.focus();_7d6=true;}return _7d8;}),function(item){return item;});},setValues:function(val){_7d1.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(obj){var map={};_7cf.forEach(this._getDescendantFormWidgets(),function(_7d9){if(!_7d9.name){return;}var _7da=map[_7d9.name]||(map[_7d9.name]=[]);_7da.push(_7d9);});for(var name in map){if(!map.hasOwnProperty(name)){continue;}var _7db=map[name],_7dc=lang.getObject(name,false,obj);if(_7dc===undefined){continue;}_7dc=[].concat(_7dc);if(typeof _7db[0].checked=="boolean"){_7cf.forEach(_7db,function(w){w.set("value",_7cf.indexOf(_7dc,w._get("value"))!=-1);});}else{if(_7db[0].multiple){_7db[0].set("value",_7dc);}else{_7cf.forEach(_7db,function(w,i){w.set("value",_7dc[i]);});}}}},getValues:function(){_7d1.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},_getValueAttr:function(){var obj={};_7cf.forEach(this._getDescendantFormWidgets(),function(_7dd){var name=_7dd.name;if(!name||_7dd.disabled){return;}var _7de=_7dd.get("value");if(typeof _7dd.checked=="boolean"){if(/Radio/.test(_7dd.declaredClass)){if(_7de!==false){lang.setObject(name,_7de,obj);}else{_7de=lang.getObject(name,false,obj);if(_7de===undefined){lang.setObject(name,null,obj);}}}else{var ary=lang.getObject(name,false,obj);if(!ary){ary=[];lang.setObject(name,ary,obj);}if(_7de!==false){ary.push(_7de);}}}else{var prev=lang.getObject(name,false,obj);if(typeof prev!="undefined"){if(lang.isArray(prev)){prev.push(_7de);}else{lang.setObject(name,[prev,_7de],obj);}}else{lang.setObject(name,_7de,obj);}}});return obj;},isValid:function(){return this.state=="";},onValidStateChange:function(){},_getState:function(){var _7df=_7cf.map(this._descendants,function(w){return w.get("state")||"";});return _7cf.indexOf(_7df,"Error")>=0?"Error":_7cf.indexOf(_7df,"Incomplete")>=0?"Incomplete":"";},disconnectChildren:function(){},connectChildren:function(_7e0){this._descendants=this._getDescendantFormWidgets();_7cf.forEach(this._descendants,function(_7e1){if(!_7e1._started){_7e1.startup();}});if(!_7e0){this._onChildChange();}},_onChildChange:function(attr){if(!attr||attr=="state"||attr=="disabled"){this._set("state",this._getState());}if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){if(this._onChangeDelayTimer){this._onChangeDelayTimer.remove();}this._onChangeDelayTimer=this.defer(function(){delete this._onChangeDelayTimer;this._set("value",this.get("value"));},10);}},startup:function(){this.inherited(arguments);this._descendants=this._getDescendantFormWidgets();this.value=this.get("value");this.state=this._getState();var self=this;this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){if(evt.target==self.domNode){return;}self._onChildChange(evt.type.replace("attrmodified-",""));}));this.watch("state",function(attr,_7e2,_7e3){this.onValidStateChange(_7e3=="");});},destroy:function(){this.inherited(arguments);}});});},"dojo/data/util/simpleFetch":function(){define(["../../_base/lang","../../_base/kernel","./sorter"],function(lang,_7e4,_7e5){var _7e6={};lang.setObject("dojo.data.util.simpleFetch",_7e6);_7e6.errorHandler=function(_7e7,_7e8){if(_7e8.onError){var _7e9=_7e8.scope||_7e4.global;_7e8.onError.call(_7e9,_7e7,_7e8);}};_7e6.fetchHandler=function(_7ea,_7eb){var _7ec=_7eb.abort||null,_7ed=false,_7ee=_7eb.start?_7eb.start:0,_7ef=(_7eb.count&&(_7eb.count!==Infinity))?(_7ee+_7eb.count):_7ea.length;_7eb.abort=function(){_7ed=true;if(_7ec){_7ec.call(_7eb);}};var _7f0=_7eb.scope||_7e4.global;if(!_7eb.store){_7eb.store=this;}if(_7eb.onBegin){_7eb.onBegin.call(_7f0,_7ea.length,_7eb);}if(_7eb.sort){_7ea.sort(_7e5.createSortFunction(_7eb.sort,this));}if(_7eb.onItem){for(var i=_7ee;(i<_7ea.length)&&(i<_7ef);++i){var item=_7ea[i];if(!_7ed){_7eb.onItem.call(_7f0,item,_7eb);}}}if(_7eb.onComplete&&!_7ed){var _7f1=null;if(!_7eb.onItem){_7f1=_7ea.slice(_7ee,_7ef);}_7eb.onComplete.call(_7f0,_7f1,_7eb);}};_7e6.fetch=function(_7f2){_7f2=_7f2||{};if(!_7f2.store){_7f2.store=this;}this._fetchItems(_7f2,lang.hitch(this,"fetchHandler"),lang.hitch(this,"errorHandler"));return _7f2;};return _7e6;});},"dijit/Menu":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_7f3,_7f4,_7f5,dom,_7f6,_7f7,_7f8,keys,lang,on,has,win,_7f9,pm,_7fa,_7fb){if(has("dijit-legacy-requires")){_7fb(0,function(){var _7fc=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];_7f3(_7fc);});}return _7f5("dijit.Menu",_7fa,{constructor:function(){this._bindings=[];},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){if(this.contextMenuForWindow){this.bindDomNode(this.ownerDocumentBody);}else{_7f4.forEach(this.targetNodeIds,this.bindDomNode,this);}this.inherited(arguments);},_iframeContentWindow:function(_7fd){return _7f9.get(this._iframeContentDocument(_7fd))||this._iframeContentDocument(_7fd)["__parent__"]||(_7fd.name&&document.frames[_7fd.name])||null;},_iframeContentDocument:function(_7fe){return _7fe.contentDocument||(_7fe.contentWindow&&_7fe.contentWindow.document)||(_7fe.name&&document.frames[_7fe.name]&&document.frames[_7fe.name].document)||null;},bindDomNode:function(node){node=dom.byId(node,this.ownerDocument);var cn;if(node.tagName.toLowerCase()=="iframe"){var _7ff=node,_800=this._iframeContentWindow(_7ff);cn=win.body(_800.document);}else{cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);}var _801={node:node,iframe:_7ff};_7f6.set(node,"_dijitMenu"+this.id,this._bindings.push(_801));var _802=lang.hitch(this,function(cn){var _803=this.selector,_804=_803?function(_805){return on.selector(_803,_805);}:function(_806){return _806;},self=this;return [on(cn,_804(this.leftClickToOpen?"click":"contextmenu"),function(evt){evt.stopPropagation();evt.preventDefault();if((new Date()).getTime()<self._lastKeyDown+500){return;}self._scheduleOpen(this,_7ff,{x:evt.pageX,y:evt.pageY},evt.target);}),on(cn,_804("keydown"),function(evt){if(evt.keyCode==93||(evt.shiftKey&&evt.keyCode==keys.F10)||(self.leftClickToOpen&&evt.keyCode==keys.SPACE)){evt.stopPropagation();evt.preventDefault();self._scheduleOpen(this,_7ff,null,evt.target);self._lastKeyDown=(new Date()).getTime();}})];});_801.connects=cn?_802(cn):[];if(_7ff){_801.onloadHandler=lang.hitch(this,function(){var _807=this._iframeContentWindow(_7ff),cn=win.body(_807.document);_801.connects=_802(cn);});if(_7ff.addEventListener){_7ff.addEventListener("load",_801.onloadHandler,false);}else{_7ff.attachEvent("onload",_801.onloadHandler);}}},unBindDomNode:function(_808){var node;try{node=dom.byId(_808,this.ownerDocument);}catch(e){return;}var _809="_dijitMenu"+this.id;if(node&&_7f6.has(node,_809)){var bid=_7f6.get(node,_809)-1,b=this._bindings[bid],h;while((h=b.connects.pop())){h.remove();}var _80a=b.iframe;if(_80a){if(_80a.removeEventListener){_80a.removeEventListener("load",b.onloadHandler,false);}else{_80a.detachEvent("onload",b.onloadHandler);}}_7f6.remove(node,_809);delete this._bindings[bid];}},_scheduleOpen:function(_80b,_80c,_80d,_80e){if(!this._openTimer){this._openTimer=this.defer(function(){delete this._openTimer;this._openMyself({target:_80e,delegatedTarget:_80b,iframe:_80c,coords:_80d});},1);}},_openMyself:function(args){var _80f=args.target,_810=args.iframe,_811=args.coords,_812=!_811;this.currentTarget=args.delegatedTarget;if(_811){if(_810){var ifc=_7f7.position(_810,true),_813=this._iframeContentWindow(_810),_814=_7f7.docScroll(_813.document);var cs=_7f8.getComputedStyle(_810),tp=_7f8.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_810,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_810,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_810,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_810,cs.borderTopWidth):0);_811.x+=ifc.x+left-_814.x;_811.y+=ifc.y+top-_814.y;}}else{_811=_7f7.position(_80f,true);_811.x+=10;_811.y+=10;}var self=this;var _815=this._focusManager.get("prevNode");var _816=this._focusManager.get("curNode");var _817=!_816||(dom.isDescendant(_816,this.domNode))?_815:_816;function _818(){if(self.refocus&&_817){_817.focus();}pm.close(self);};pm.open({popup:this,x:_811.x,y:_811.y,onExecute:_818,onCancel:_818,orient:this.isLeftToRight()?"L":"R"});this.focus();if(!_812){this.defer(function(){this._cleanUp(true);});}this._onBlur=function(){this.inherited("_onBlur",arguments);pm.close(this);};},destroy:function(){_7f4.forEach(this._bindings,function(b){if(b){this.unBindDomNode(b.node);}},this);this.inherited(arguments);}});});},"dijit/form/_CheckBoxMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_819,_81a){return _819("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(_81b){this._set("readOnly",_81b);_81a.set(this.focusNode,"readOnly",_81b);},_setLabelAttr:undefined,_getSubmitValue:function(_81c){return (_81c==null||_81c==="")?"on":_81c;},_setValueAttr:function(_81d){_81d=this._getSubmitValue(_81d);this._set("value",_81d);_81a.set(this.focusNode,"value",_81d);},reset:function(){this.inherited(arguments);this._set("value",this._getSubmitValue(this.params.value));_81a.set(this.focusNode,"value",this.value);},_onClick:function(e){if(this.readOnly){e.stopPropagation();e.preventDefault();return false;}return this.inherited(arguments);}});});},"dijit/layout/ContentPane":function(){define(["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when","dojo/i18n!../nls/loading"],function(_81e,lang,_81f,_820,_821,_822,html,_823,_824,_825,dom,_826,_827,xhr,i18n,when){return _824("dijit.layout.ContentPane",[_81f,_820,_821],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_81e._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,markupFactory:function(_828,node,ctor){var self=new ctor(_828,node);return !self.href&&self._contentSetter&&self._contentSetter.parseDeferred&&!self._contentSetter.parseDeferred.isFulfilled()?self._contentSetter.parseDeferred.then(function(){return self;}):self;},create:function(_829,_82a){if((!_829||!_829.template)&&_82a&&!("href" in _829)&&!("content" in _829)){_82a=dom.byId(_82a);var df=_82a.ownerDocument.createDocumentFragment();while(_82a.firstChild){df.appendChild(_82a.firstChild);}_829=lang.delegate(_829,{content:df});}this.inherited(arguments,[_829,_82a]);},postMixInProperties:function(){this.inherited(arguments);var _82b=i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_822.substitute(this.loadingMessage,_82b);this.errorMessage=_822.substitute(this.errorMessage,_82b);},buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}this.domNode.removeAttribute("title");},startup:function(){this.inherited(arguments);if(this._contentSetter){_823.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},_startChildren:function(){_823.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});if(this._contentSetter){_823.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},setHref:function(href){_81e.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");return this.set("href",href);},_setHrefAttr:function(href){this.cancel();this.onLoadDeferred=new _825(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._set("href",href);if(this.preload||(this._created&&this._isShown())){this._load();}else{this._hrefChanged=true;}return this.onLoadDeferred;},setContent:function(data){_81e.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");this.set("content",data);},_setContentAttr:function(data){this._set("href","");this.cancel();this.onLoadDeferred=new _825(lang.hitch(this,"cancel"));if(this._created){this.onLoadDeferred.then(lang.hitch(this,"onLoad"));}this._setContent(data||"");this._isDownloaded=false;return this.onLoadDeferred;},_getContentAttr:function(){return this.containerNode.innerHTML;},cancel:function(){if(this._xhrDfd&&(this._xhrDfd.fired==-1)){this._xhrDfd.cancel();}delete this._xhrDfd;this.onLoadDeferred=null;},destroy:function(){this.cancel();this.inherited(arguments);},destroyRecursive:function(_82c){if(this._beingDestroyed){return;}this.inherited(arguments);},_onShow:function(){this.inherited(arguments);if(this.href){if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){return this.refresh();}}},refresh:function(){this.cancel();this.onLoadDeferred=new _825(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._load();return this.onLoadDeferred;},_load:function(){this._setContent(this.onDownloadStart(),true);var self=this;var _82d={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};if(lang.isObject(this.ioArgs)){lang.mixin(_82d,this.ioArgs);}var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_82d)),_82e;hand.then(function(html){_82e=html;try{self._isDownloaded=true;return self._setContent(html,false);}catch(err){self._onError("Content",err);}},function(err){if(!hand.canceled){self._onError("Download",err);}delete self._xhrDfd;return err;}).then(function(){self.onDownloadEnd();delete self._xhrDfd;return _82e;});delete this._hrefChanged;},_onLoadHandler:function(data){this._set("isLoaded",true);try{this.onLoadDeferred.resolve(data);}catch(e){console.error("Error "+(this.widgetId||this.id)+" running custom onLoad code: "+e.message);}},_onUnloadHandler:function(){this._set("isLoaded",false);try{this.onUnload();}catch(e){console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);}},destroyDescendants:function(_82f){if(this.isLoaded){this._onUnloadHandler();}var _830=this._contentSetter;_823.forEach(this.getChildren(),function(_831){if(_831.destroyRecursive){_831.destroyRecursive(_82f);}else{if(_831.destroy){_831.destroy(_82f);}}_831._destroyed=true;});if(_830){_823.forEach(_830.parseResults,function(_832){if(!_832._destroyed){if(_832.destroyRecursive){_832.destroyRecursive(_82f);}else{if(_832.destroy){_832.destroy(_82f);}}_832._destroyed=true;}});delete _830.parseResults;}if(!_82f){_827.empty(this.containerNode);}delete this._singleChild;},_setContent:function(cont,_833){cont=this.preprocessContent(cont);this.destroyDescendants();var _834=this._contentSetter;if(!(_834&&_834 instanceof html._ContentSetter)){_834=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){var _835=this.onContentError(e);try{this.containerNode.innerHTML=_835;}catch(e){console.error("Fatal "+this.id+" could not change content due to "+e.message,e);}})});}var _836=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});var p=_834.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_836);var self=this;return when(p&&p.then?p:_834.parseDeferred,function(){delete self._contentSetterParams;if(!_833){if(self._started){self._startChildren();self._scheduleLayout();}self._onLoadHandler(cont);}});},preprocessContent:function(_837){return _837;},_onError:function(type,err,_838){this.onLoadDeferred.reject(err);var _839=this["on"+type+"Error"].call(this,err);if(_838){console.error(_838,err);}else{if(_839){this._setContent(_839,true);}}},onLoad:function(){},onUnload:function(){},onDownloadStart:function(){return this.loadingMessage;},onContentError:function(){},onDownloadError:function(){return this.errorMessage;},onDownloadEnd:function(){}});});},"dijit/_KeyNavContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/keys","dojo/_base/lang","./registry","./_Container","./_FocusMixin","./_KeyNavMixin"],function(_83a,_83b,_83c,_83d,keys,lang,_83e,_83f,_840,_841){return _83b("dijit._KeyNavContainer",[_840,_841,_83f],{connectKeyNavHandlers:function(_842,_843){var _844=(this._keyNavCodes={});var prev=lang.hitch(this,"focusPrev");var next=lang.hitch(this,"focusNext");_83a.forEach(_842,function(code){_844[code]=prev;});_83a.forEach(_843,function(code){_844[code]=next;});_844[keys.HOME]=lang.hitch(this,"focusFirstChild");_844[keys.END]=lang.hitch(this,"focusLastChild");},startupKeyNavChildren:function(){_83d.deprecated("startupKeyNavChildren() call no longer needed","","2.0");},startup:function(){this.inherited(arguments);_83a.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));},addChild:function(_845,_846){this.inherited(arguments);this._startupChild(_845);},_startupChild:function(_847){_847.set("tabIndex","-1");},_getFirst:function(){var _848=this.getChildren();return _848.length?_848[0]:null;},_getLast:function(){var _849=this.getChildren();return _849.length?_849[_849.length-1]:null;},focusNext:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,1));},focusPrev:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);},childSelector:function(node){var node=_83e.byNode(node);return node&&node.getParent()==this;}});});},"dijit/layout/utils":function(){define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang"],function(_84a,_84b,_84c,_84d,lang){function _84e(word){return word.substring(0,1).toUpperCase()+word.substring(1);};function size(_84f,dim){var _850=_84f.resize?_84f.resize(dim):_84c.setMarginBox(_84f.domNode,dim);if(_850){lang.mixin(_84f,_850);}else{lang.mixin(_84f,_84c.getMarginBox(_84f.domNode));lang.mixin(_84f,dim);}};var _851={marginBox2contentBox:function(node,mb){var cs=_84d.getComputedStyle(node);var me=_84c.getMarginExtents(node,cs);var pb=_84c.getPadBorderExtents(node,cs);return {l:_84d.toPixelValue(node,cs.paddingLeft),t:_84d.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};},layoutChildren:function(_852,dim,_853,_854,_855){dim=lang.mixin({},dim);_84b.add(_852,"dijitLayoutContainer");_853=_84a.filter(_853,function(item){return item.region!="center"&&item.layoutAlign!="client";}).concat(_84a.filter(_853,function(item){return item.region=="center"||item.layoutAlign=="client";}));_84a.forEach(_853,function(_856){var elm=_856.domNode,pos=(_856.region||_856.layoutAlign);if(!pos){throw new Error("No region setting for "+_856.id);}var _857=elm.style;_857.left=dim.l+"px";_857.top=dim.t+"px";_857.position="absolute";_84b.add(elm,"dijitAlign"+_84e(pos));var _858={};if(_854&&_854==_856.id){_858[_856.region=="top"||_856.region=="bottom"?"h":"w"]=_855;}if(pos=="leading"){pos=_856.isLeftToRight()?"left":"right";}if(pos=="trailing"){pos=_856.isLeftToRight()?"right":"left";}if(pos=="top"||pos=="bottom"){_858.w=dim.w;size(_856,_858);dim.h-=_856.h;if(pos=="top"){dim.t+=_856.h;}else{_857.top=dim.t+dim.h+"px";}}else{if(pos=="left"||pos=="right"){_858.h=dim.h;size(_856,_858);dim.w-=_856.w;if(pos=="left"){dim.l+=_856.w;}else{_857.left=dim.l+dim.w+"px";}}else{if(pos=="client"||pos=="center"){size(_856,dim);}}}});}};lang.setObject("dijit.layout.utils",_851);return _851;});},"dijit/_Contained":function(){define(["dojo/_base/declare","./registry"],function(_859,_85a){return _859("dijit._Contained",null,{_getSibling:function(_85b){var p=this.getParent();return (p&&p._getSiblingOfChild&&p._getSiblingOfChild(this,_85b=="previous"?-1:1))||null;},getPreviousSibling:function(){return this._getSibling("previous");},getNextSibling:function(){return this._getSibling("next");},getIndexInParent:function(){var p=this.getParent();if(!p||!p.getIndexOfChild){return -1;}return p.getIndexOfChild(this);}});});},"dijit/form/DataList":function(){define(["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_85c,dom,lang,_85d,_85e,_85f){function _860(_861){return {id:_861.value,value:_861.value,name:lang.trim(_861.innerText||_861.textContent||"")};};return _85c("dijit.form.DataList",_85e,{constructor:function(_862,_863){this.domNode=dom.byId(_863);lang.mixin(this,_862);if(this.id){_85f.add(this);}this.domNode.style.display="none";this.inherited(arguments,[{data:_85d("option",this.domNode).map(_860)}]);},destroy:function(){_85f.remove(this.id);},fetchSelectedItem:function(){var _864=_85d("> option[selected]",this.domNode)[0]||_85d("> option",this.domNode)[0];return _864&&_860(_864);}});});},"dijit/form/CheckBox":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom","../a11yclick"],function(_865,_866,_867,has,_868,_869,_86a,_86b,_86c){if(has("dijit-legacy-requires")){_869(0,function(){var _86d=["dijit/form/RadioButton"];_865(_86d);});}return _866("dijit.form.CheckBox",[_86a,_86b],{templateString:_86c,baseClass:"dijitCheckBox",_setValueAttr:function(_86e,_86f){if(typeof _86e=="string"){this.inherited(arguments);_86e=true;}if(this._created){this.set("checked",_86e,_86f);}},_getValueAttr:function(){return this.checked&&this._get("value");},_setIconClassAttr:null,_setNameAttr:"focusNode",postMixInProperties:function(){this.inherited(arguments);this.checkedAttrSetting="";},_fillContent:function(){},_onFocus:function(){if(this.id){_868("label[for='"+this.id+"']").addClass("dijitFocusedLabel");}this.inherited(arguments);},_onBlur:function(){if(this.id){_868("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");}this.inherited(arguments);}});});},"dijit/tree/_dndSelector":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/dnd/common","dojo/dom","dojo/mouse","dojo/on","dojo/touch","../a11yclick","./_dndContainer"],function(_870,_871,_872,lang,_873,dom,_874,on,_875,_876,_877){return _871("dijit.tree._dndSelector",_877,{constructor:function(){this.selection={};this.anchor=null;this.events.push(on(this.tree.domNode,_875.press,lang.hitch(this,"onMouseDown")),on(this.tree.domNode,_875.release,lang.hitch(this,"onMouseUp")),on(this.tree.domNode,_875.move,lang.hitch(this,"onMouseMove")),on(this.tree.domNode,_876.press,lang.hitch(this,"onClickPress")),on(this.tree.domNode,_876.release,lang.hitch(this,"onClickRelease")));},singular:false,getSelectedTreeNodes:function(){var _878=[],sel=this.selection;for(var i in sel){_878.push(sel[i]);}return _878;},selectNone:function(){this.setSelection([]);return this;},destroy:function(){this.inherited(arguments);this.selection=this.anchor=null;},addTreeNode:function(node,_879){this.setSelection(this.getSelectedTreeNodes().concat([node]));if(_879){this.anchor=node;}return node;},removeTreeNode:function(node){var _87a=_870.filter(this.getSelectedTreeNodes(),function(_87b){return !dom.isDescendant(_87b.domNode,node.domNode);});this.setSelection(_87a);return node;},isTreeNodeSelected:function(node){return node.id&&!!this.selection[node.id];},setSelection:function(_87c){var _87d=this.getSelectedTreeNodes();_870.forEach(this._setDifference(_87d,_87c),lang.hitch(this,function(node){node.setSelected(false);if(this.anchor==node){delete this.anchor;}delete this.selection[node.id];}));_870.forEach(this._setDifference(_87c,_87d),lang.hitch(this,function(node){node.setSelected(true);this.selection[node.id]=node;}));this._updateSelectionProperties();},_setDifference:function(xs,ys){_870.forEach(ys,function(y){y.__exclude__=true;});var ret=_870.filter(xs,function(x){return !x.__exclude__;});_870.forEach(ys,function(y){delete y["__exclude__"];});return ret;},_updateSelectionProperties:function(){var _87e=this.getSelectedTreeNodes();var _87f=[],_880=[];_870.forEach(_87e,function(node){var ary=node.getTreePath();_880.push(node);_87f.push(ary);},this);var _881=_870.map(_880,function(node){return node.item;});this.tree._set("paths",_87f);this.tree._set("path",_87f[0]||[]);this.tree._set("selectedNodes",_880);this.tree._set("selectedNode",_880[0]||null);this.tree._set("selectedItems",_881);this.tree._set("selectedItem",_881[0]||null);},onClickPress:function(e){if(this.current&&this.current.isExpandable&&this.tree.isExpandoNode(e.target,this.current)){return;}if(e.type=="mousedown"&&_874.isLeft(e)){e.preventDefault();}var _882=e.type=="keydown"?this.tree.focusedChild:this.current;if(!_882){return;}var copy=_873.getCopyKeyState(e),id=_882.id;if(!this.singular&&!e.shiftKey&&this.selection[id]){this._doDeselect=true;return;}else{this._doDeselect=false;}this.userSelect(_882,copy,e.shiftKey);},onClickRelease:function(e){if(!this._doDeselect){return;}this._doDeselect=false;this.userSelect(e.type=="keyup"?this.tree.focusedChild:this.current,_873.getCopyKeyState(e),e.shiftKey);},onMouseMove:function(){this._doDeselect=false;},onMouseDown:function(){},onMouseUp:function(){},_compareNodes:function(n1,n2){if(n1===n2){return 0;}if("sourceIndex" in document.documentElement){return n1.sourceIndex-n2.sourceIndex;}else{if("compareDocumentPosition" in document.documentElement){return n1.compareDocumentPosition(n2)&2?1:-1;}else{if(document.createRange){var r1=doc.createRange();r1.setStartBefore(n1);var r2=doc.createRange();r2.setStartBefore(n2);return r1.compareBoundaryPoints(r1.END_TO_END,r2);}else{throw Error("dijit.tree._compareNodes don't know how to compare two different nodes in this browser");}}}},userSelect:function(node,_883,_884){if(this.singular){if(this.anchor==node&&_883){this.selectNone();}else{this.setSelection([node]);this.anchor=node;}}else{if(_884&&this.anchor){var cr=this._compareNodes(this.anchor.rowNode,node.rowNode),_885,end,_886=this.anchor;if(cr<0){_885=_886;end=node;}else{_885=node;end=_886;}var _887=[];while(_885!=end){_887.push(_885);_885=this.tree._getNext(_885);}_887.push(end);this.setSelection(_887);}else{if(this.selection[node.id]&&_883){this.removeTreeNode(node);}else{if(_883){this.addTreeNode(node,true);}else{this.setSelection([node]);this.anchor=node;}}}}},getItem:function(key){var _888=this.selection[key];return {data:_888,type:["treeNode"]};},forInSelectedItems:function(f,o){o=o||_872.global;for(var id in this.selection){f.call(o,this.getItem(id),id,this);}}});});},"dijit/_Container":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/_base/kernel"],function(_889,_88a,_88b,_88c){return _88a("dijit._Container",null,{buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}},addChild:function(_88d,_88e){var _88f=this.containerNode;if(_88e>0){_88f=_88f.firstChild;while(_88e>0){if(_88f.nodeType==1){_88e--;}_88f=_88f.nextSibling;}if(_88f){_88e="before";}else{_88f=this.containerNode;_88e="last";}}_88b.place(_88d.domNode,_88f,_88e);if(this._started&&!_88d._started){_88d.startup();}},removeChild:function(_890){if(typeof _890=="number"){_890=this.getChildren()[_890];}if(_890){var node=_890.domNode;if(node&&node.parentNode){node.parentNode.removeChild(node);}}},hasChildren:function(){return this.getChildren().length>0;},_getSiblingOfChild:function(_891,dir){var _892=this.getChildren(),idx=_889.indexOf(_892,_891);return _892[idx+dir];},getIndexOfChild:function(_893){return _889.indexOf(this.getChildren(),_893);}});});},"dojo/data/ItemFileReadStore":function(){define(["../_base/kernel","../_base/lang","../_base/declare","../_base/array","../_base/xhr","../Evented","./util/filter","./util/simpleFetch","../date/stamp"],function(_894,lang,_895,_896,xhr,_897,_898,_899,_89a){var _89b=_895("dojo.data.ItemFileReadStore",[_897],{constructor:function(_89c){this._arrayOfAllItems=[];this._arrayOfTopLevelItems=[];this._loadFinished=false;this._jsonFileUrl=_89c.url;this._ccUrl=_89c.url;this.url=_89c.url;this._jsonData=_89c.data;this.data=null;this._datatypeMap=_89c.typeMap||{};if(!this._datatypeMap["Date"]){this._datatypeMap["Date"]={type:Date,deserialize:function(_89d){return _89a.fromISOString(_89d);}};}this._features={"dojo.data.api.Read":true,"dojo.data.api.Identity":true};this._itemsByIdentity=null;this._storeRefPropName="_S";this._itemNumPropName="_0";this._rootItemPropName="_RI";this._reverseRefMap="_RRM";this._loadInProgress=false;this._queuedFetches=[];if(_89c.urlPreventCache!==undefined){this.urlPreventCache=_89c.urlPreventCache?true:false;}if(_89c.hierarchical!==undefined){this.hierarchical=_89c.hierarchical?true:false;}if(_89c.clearOnClose){this.clearOnClose=true;}if("failOk" in _89c){this.failOk=_89c.failOk?true:false;}},url:"",_ccUrl:"",data:null,typeMap:null,clearOnClose:false,urlPreventCache:false,failOk:false,hierarchical:true,_assertIsItem:function(item){if(!this.isItem(item)){throw new Error(this.declaredClass+": Invalid item argument.");}},_assertIsAttribute:function(_89e){if(typeof _89e!=="string"){throw new Error(this.declaredClass+": Invalid attribute argument.");}},getValue:function(item,_89f,_8a0){var _8a1=this.getValues(item,_89f);return (_8a1.length>0)?_8a1[0]:_8a0;},getValues:function(item,_8a2){this._assertIsItem(item);this._assertIsAttribute(_8a2);return (item[_8a2]||[]).slice(0);},getAttributes:function(item){this._assertIsItem(item);var _8a3=[];for(var key in item){if((key!==this._storeRefPropName)&&(key!==this._itemNumPropName)&&(key!==this._rootItemPropName)&&(key!==this._reverseRefMap)){_8a3.push(key);}}return _8a3;},hasAttribute:function(item,_8a4){this._assertIsItem(item);this._assertIsAttribute(_8a4);return (_8a4 in item);},containsValue:function(item,_8a5,_8a6){var _8a7=undefined;if(typeof _8a6==="string"){_8a7=_898.patternToRegExp(_8a6,false);}return this._containsValue(item,_8a5,_8a6,_8a7);},_containsValue:function(item,_8a8,_8a9,_8aa){return _896.some(this.getValues(item,_8a8),function(_8ab){if(_8ab!==null&&!lang.isObject(_8ab)&&_8aa){if(_8ab.toString().match(_8aa)){return true;}}else{if(_8a9===_8ab){return true;}}});},isItem:function(_8ac){if(_8ac&&_8ac[this._storeRefPropName]===this){if(this._arrayOfAllItems[_8ac[this._itemNumPropName]]===_8ac){return true;}}return false;},isItemLoaded:function(_8ad){return this.isItem(_8ad);},loadItem:function(_8ae){this._assertIsItem(_8ae.item);},getFeatures:function(){return this._features;},getLabel:function(item){if(this._labelAttr&&this.isItem(item)){return this.getValue(item,this._labelAttr);}return undefined;},getLabelAttributes:function(item){if(this._labelAttr){return [this._labelAttr];}return null;},filter:function(_8af,_8b0,_8b1){var _8b2=[],i,key;if(_8af.query){var _8b3,_8b4=_8af.queryOptions?_8af.queryOptions.ignoreCase:false;var _8b5={};for(key in _8af.query){_8b3=_8af.query[key];if(typeof _8b3==="string"){_8b5[key]=_898.patternToRegExp(_8b3,_8b4);}else{if(_8b3 instanceof RegExp){_8b5[key]=_8b3;}}}for(i=0;i<_8b0.length;++i){var _8b6=true;var _8b7=_8b0[i];if(_8b7===null){_8b6=false;}else{for(key in _8af.query){_8b3=_8af.query[key];if(!this._containsValue(_8b7,key,_8b3,_8b5[key])){_8b6=false;}}}if(_8b6){_8b2.push(_8b7);}}_8b1(_8b2,_8af);}else{for(i=0;i<_8b0.length;++i){var item=_8b0[i];if(item!==null){_8b2.push(item);}}_8b1(_8b2,_8af);}},_fetchItems:function(_8b8,_8b9,_8ba){var self=this;if(this._loadFinished){this.filter(_8b8,this._getItemsArray(_8b8.queryOptions),_8b9);}else{if(this._jsonFileUrl!==this._ccUrl){_894.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){if(this._loadInProgress){this._queuedFetches.push({args:_8b8,filter:lang.hitch(self,"filter"),findCallback:lang.hitch(self,_8b9)});}else{this._loadInProgress=true;var _8bb={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};var _8bc=xhr.get(_8bb);_8bc.addCallback(function(data){try{self._getItemsFromLoadedData(data);self._loadFinished=true;self._loadInProgress=false;self.filter(_8b8,self._getItemsArray(_8b8.queryOptions),_8b9);self._handleQueuedFetches();}catch(e){self._loadFinished=true;self._loadInProgress=false;_8ba(e,_8b8);}});_8bc.addErrback(function(_8bd){self._loadInProgress=false;_8ba(_8bd,_8b8);});var _8be=null;if(_8b8.abort){_8be=_8b8.abort;}_8b8.abort=function(){var df=_8bc;if(df&&df.fired===-1){df.cancel();df=null;}if(_8be){_8be.call(_8b8);}};}}else{if(this._jsonData){try{this._loadFinished=true;this._getItemsFromLoadedData(this._jsonData);this._jsonData=null;self.filter(_8b8,this._getItemsArray(_8b8.queryOptions),_8b9);}catch(e){_8ba(e,_8b8);}}else{_8ba(new Error(this.declaredClass+": No JSON source data was provided as either URL or a nested Javascript object."),_8b8);}}}},_handleQueuedFetches:function(){if(this._queuedFetches.length>0){for(var i=0;i<this._queuedFetches.length;i++){var _8bf=this._queuedFetches[i],_8c0=_8bf.args,_8c1=_8bf.filter,_8c2=_8bf.findCallback;if(_8c1){_8c1(_8c0,this._getItemsArray(_8c0.queryOptions),_8c2);}else{this.fetchItemByIdentity(_8c0);}}this._queuedFetches=[];}},_getItemsArray:function(_8c3){if(_8c3&&_8c3.deep){return this._arrayOfAllItems;}return this._arrayOfTopLevelItems;},close:function(_8c4){if(this.clearOnClose&&this._loadFinished&&!this._loadInProgress){if(((this._jsonFileUrl==""||this._jsonFileUrl==null)&&(this.url==""||this.url==null))&&this.data==null){}this._arrayOfAllItems=[];this._arrayOfTopLevelItems=[];this._loadFinished=false;this._itemsByIdentity=null;this._loadInProgress=false;this._queuedFetches=[];}},_getItemsFromLoadedData:function(_8c5){var _8c6=false,self=this;function _8c7(_8c8){return (_8c8!==null)&&(typeof _8c8==="object")&&(!lang.isArray(_8c8)||_8c6)&&(!lang.isFunction(_8c8))&&(_8c8.constructor==Object||lang.isArray(_8c8))&&(typeof _8c8._reference==="undefined")&&(typeof _8c8._type==="undefined")&&(typeof _8c8._value==="undefined")&&self.hierarchical;};function _8c9(_8ca){self._arrayOfAllItems.push(_8ca);for(var _8cb in _8ca){var _8cc=_8ca[_8cb];if(_8cc){if(lang.isArray(_8cc)){var _8cd=_8cc;for(var k=0;k<_8cd.length;++k){var _8ce=_8cd[k];if(_8c7(_8ce)){_8c9(_8ce);}}}else{if(_8c7(_8cc)){_8c9(_8cc);}}}}};this._labelAttr=_8c5.label;var i,item;this._arrayOfAllItems=[];this._arrayOfTopLevelItems=_8c5.items;for(i=0;i<this._arrayOfTopLevelItems.length;++i){item=this._arrayOfTopLevelItems[i];if(lang.isArray(item)){_8c6=true;}_8c9(item);item[this._rootItemPropName]=true;}var _8cf={},key;for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];for(key in item){if(key!==this._rootItemPropName){var _8d0=item[key];if(_8d0!==null){if(!lang.isArray(_8d0)){item[key]=[_8d0];}}else{item[key]=[null];}}_8cf[key]=key;}}while(_8cf[this._storeRefPropName]){this._storeRefPropName+="_";}while(_8cf[this._itemNumPropName]){this._itemNumPropName+="_";}while(_8cf[this._reverseRefMap]){this._reverseRefMap+="_";}var _8d1;var _8d2=_8c5.identifier;if(_8d2){this._itemsByIdentity={};this._features["dojo.data.api.Identity"]=_8d2;for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];_8d1=item[_8d2];var _8d3=_8d1[0];if(!Object.hasOwnProperty.call(this._itemsByIdentity,_8d3)){this._itemsByIdentity[_8d3]=item;}else{if(this._jsonFileUrl){throw new Error(this.declaredClass+":  The json data as specified by: ["+this._jsonFileUrl+"] is malformed.  Items within the list have identifier: ["+_8d2+"].  Value collided: ["+_8d3+"]");}else{if(this._jsonData){throw new Error(this.declaredClass+":  The json data provided by the creation arguments is malformed.  Items within the list have identifier: ["+_8d2+"].  Value collided: ["+_8d3+"]");}}}}}else{this._features["dojo.data.api.Identity"]=Number;}for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];item[this._storeRefPropName]=this;item[this._itemNumPropName]=i;}for(i=0;i<this._arrayOfAllItems.length;++i){item=this._arrayOfAllItems[i];for(key in item){_8d1=item[key];for(var j=0;j<_8d1.length;++j){_8d0=_8d1[j];if(_8d0!==null&&typeof _8d0=="object"){if(("_type" in _8d0)&&("_value" in _8d0)){var type=_8d0._type;var _8d4=this._datatypeMap[type];if(!_8d4){throw new Error("dojo.data.ItemFileReadStore: in the typeMap constructor arg, no object class was specified for the datatype '"+type+"'");}else{if(lang.isFunction(_8d4)){_8d1[j]=new _8d4(_8d0._value);}else{if(lang.isFunction(_8d4.deserialize)){_8d1[j]=_8d4.deserialize(_8d0._value);}else{throw new Error("dojo.data.ItemFileReadStore: Value provided in typeMap was neither a constructor, nor a an object with a deserialize function");}}}}if(_8d0._reference){var _8d5=_8d0._reference;if(!lang.isObject(_8d5)){_8d1[j]=this._getItemByIdentity(_8d5);}else{for(var k=0;k<this._arrayOfAllItems.length;++k){var _8d6=this._arrayOfAllItems[k],_8d7=true;for(var _8d8 in _8d5){if(_8d6[_8d8]!=_8d5[_8d8]){_8d7=false;}}if(_8d7){_8d1[j]=_8d6;}}}if(this.referenceIntegrity){var _8d9=_8d1[j];if(this.isItem(_8d9)){this._addReferenceToMap(_8d9,item,key);}}}else{if(this.isItem(_8d0)){if(this.referenceIntegrity){this._addReferenceToMap(_8d0,item,key);}}}}}}}},_addReferenceToMap:function(_8da,_8db,_8dc){},getIdentity:function(item){var _8dd=this._features["dojo.data.api.Identity"];if(_8dd===Number){return item[this._itemNumPropName];}else{var _8de=item[_8dd];if(_8de){return _8de[0];}}return null;},fetchItemByIdentity:function(_8df){var item,_8e0;if(!this._loadFinished){var self=this;if(this._jsonFileUrl!==this._ccUrl){_894.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null&&this._jsonData==null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){if(this._loadInProgress){this._queuedFetches.push({args:_8df});}else{this._loadInProgress=true;var _8e1={url:self._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk};var _8e2=xhr.get(_8e1);_8e2.addCallback(function(data){var _8e3=_8df.scope?_8df.scope:_894.global;try{self._getItemsFromLoadedData(data);self._loadFinished=true;self._loadInProgress=false;item=self._getItemByIdentity(_8df.identity);if(_8df.onItem){_8df.onItem.call(_8e3,item);}self._handleQueuedFetches();}catch(error){self._loadInProgress=false;if(_8df.onError){_8df.onError.call(_8e3,error);}}});_8e2.addErrback(function(_8e4){self._loadInProgress=false;if(_8df.onError){var _8e5=_8df.scope?_8df.scope:_894.global;_8df.onError.call(_8e5,_8e4);}});}}else{if(this._jsonData){self._getItemsFromLoadedData(self._jsonData);self._jsonData=null;self._loadFinished=true;item=self._getItemByIdentity(_8df.identity);if(_8df.onItem){_8e0=_8df.scope?_8df.scope:_894.global;_8df.onItem.call(_8e0,item);}}}}else{item=this._getItemByIdentity(_8df.identity);if(_8df.onItem){_8e0=_8df.scope?_8df.scope:_894.global;_8df.onItem.call(_8e0,item);}}},_getItemByIdentity:function(_8e6){var item=null;if(this._itemsByIdentity){if(Object.hasOwnProperty.call(this._itemsByIdentity,_8e6)){item=this._itemsByIdentity[_8e6];}}else{if(Object.hasOwnProperty.call(this._arrayOfAllItems,_8e6)){item=this._arrayOfAllItems[_8e6];}}if(item===undefined){item=null;}return item;},getIdentityAttributes:function(item){var _8e7=this._features["dojo.data.api.Identity"];if(_8e7===Number){return null;}else{return [_8e7];}},_forceLoad:function(){var self=this;if(this._jsonFileUrl!==this._ccUrl){_894.deprecated(this.declaredClass+": ","To change the url, set the url property of the store,"+" not _jsonFileUrl.  _jsonFileUrl support will be removed in 2.0");this._ccUrl=this._jsonFileUrl;this.url=this._jsonFileUrl;}else{if(this.url!==this._ccUrl){this._jsonFileUrl=this.url;this._ccUrl=this.url;}}if(this.data!=null){this._jsonData=this.data;this.data=null;}if(this._jsonFileUrl){var _8e8={url:this._jsonFileUrl,handleAs:"json-comment-optional",preventCache:this.urlPreventCache,failOk:this.failOk,sync:true};var _8e9=xhr.get(_8e8);_8e9.addCallback(function(data){try{if(self._loadInProgress!==true&&!self._loadFinished){self._getItemsFromLoadedData(data);self._loadFinished=true;}else{if(self._loadInProgress){throw new Error(this.declaredClass+":  Unable to perform a synchronous load, an async load is in progress.");}}}catch(e){throw e;}});_8e9.addErrback(function(_8ea){throw _8ea;});}else{if(this._jsonData){self._getItemsFromLoadedData(self._jsonData);self._jsonData=null;self._loadFinished=true;}}}});lang.extend(_89b,_899);return _89b;});},"dojo/html":function(){define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_8eb,lang,_8ec,_8ed,dom,_8ee,_8ef){var _8f0=0;var html={_secureForInnerHtml:function(cont){return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");},_emptyNode:_8ee.empty,_setNodeContent:function(node,cont){_8ee.empty(node);if(cont){if(typeof cont=="number"){cont=cont.toString();}if(typeof cont=="string"){cont=_8ee.toDom(cont,node.ownerDocument);}if(!cont.nodeType&&lang.isArrayLike(cont)){for(var _8f1=cont.length,i=0;i<cont.length;i=_8f1==cont.length?i+1:0){_8ee.place(cont[i],node,"last");}}else{_8ee.place(cont,node,"last");}}return node;},_ContentSetter:_8ed("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_8eb._scopeName,startup:true,constructor:function(_8f2,node){lang.mixin(this,_8f2||{});node=this.node=dom.byId(this.node||node);if(!this.id){this.id=["Setter",(node)?node.id||node.tagName:"",_8f0++].join("_");}},set:function(cont,_8f3){if(undefined!==cont){this.content=cont;}if(typeof cont=="number"){cont=cont.toString();}if(_8f3){this._mixin(_8f3);}this.onBegin();this.setContent();var ret=this.onEnd();if(ret&&ret.then){return ret;}else{return this.node;}},setContent:function(){var node=this.node;if(!node){throw new Error(this.declaredClass+": setContent given no node");}try{node=html._setNodeContent(node,this.content);}catch(e){var _8f4=this.onContentError(e);try{node.innerHTML=_8f4;}catch(e){console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);}}this.node=node;},empty:function(){if(this.parseDeferred){if(!this.parseDeferred.isResolved()){this.parseDeferred.cancel();}delete this.parseDeferred;}if(this.parseResults&&this.parseResults.length){_8ec.forEach(this.parseResults,function(w){if(w.destroy){w.destroy();}});delete this.parseResults;}_8ee.empty(this.node);},onBegin:function(){var cont=this.content;if(lang.isString(cont)){if(this.cleanContent){cont=html._secureForInnerHtml(cont);}if(this.extractContent){var _8f5=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_8f5){cont=_8f5[1];}}}this.empty();this.content=cont;return this.node;},onEnd:function(){if(this.parseContent){this._parse();}return this.node;},tearDown:function(){delete this.parseResults;delete this.parseDeferred;delete this.node;delete this.content;},onContentError:function(err){return "Error occurred setting content: "+err;},onExecError:function(err){return "Error occurred executing scripts: "+err;},_mixin:function(_8f6){var _8f7={},key;for(key in _8f6){if(key in _8f7){continue;}this[key]=_8f6[key];}},_parse:function(){var _8f8=this.node;try{var _8f9={};_8ec.forEach(["dir","lang","textDir"],function(name){if(this[name]){_8f9[name]=this[name];}},this);var self=this;this.parseDeferred=_8ef.parse({rootNode:_8f8,noStart:!this.startup,inherited:_8f9,scope:this.parserScope}).then(function(_8fa){return self.parseResults=_8fa;},function(e){self._onError("Content",e,"Error parsing in _ContentSetter#"+self.id);});}catch(e){this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);}},_onError:function(type,err,_8fb){var _8fc=this["on"+type+"Error"].call(this,err);if(_8fb){console.error(_8fb,err);}else{if(_8fc){html._setNodeContent(this.node,_8fc,true);}}}}),set:function(node,cont,_8fd){if(undefined==cont){console.warn("dojo.html.set: no cont argument provided, using empty string");cont="";}if(typeof cont=="number"){cont=cont.toString();}if(!_8fd){return html._setNodeContent(node,cont,true);}else{var op=new html._ContentSetter(lang.mixin(_8fd,{content:cont,node:node}));return op.set();}}};lang.setObject("dojo.html",html);return html;});},"dijit/_PaletteMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","./_CssStateMixin","./a11yclick","./focus","./typematic"],function(_8fe,_8ff,_900,_901,keys,lang,on,_902,_903,_904,_905){var _906=_8fe("dijit._PaletteMixin",_902,{defaultTimeout:500,timeoutChangeRate:0.9,value:"",_selectedCell:-1,tabIndex:"0",cellClass:"dijitPaletteCell",dyeClass:null,_dyeFactory:function(_907){var _908=typeof this.dyeClass=="string"?lang.getObject(this.dyeClass):this.dyeClass;return new _908(_907);},_preparePalette:function(_909,_90a){this._cells=[];var url=this._blankGif;this.own(on(this.gridNode,_903,lang.hitch(this,"_onCellClick")));for(var row=0;row<_909.length;row++){var _90b=_901.create("tr",{tabIndex:"-1",role:"row"},this.gridNode);for(var col=0;col<_909[row].length;col++){var _90c=_909[row][col];if(_90c){var _90d=this._dyeFactory(_90c,row,col,_90a[_90c]);var _90e=_901.create("td",{"class":this.cellClass,tabIndex:"-1",title:_90a[_90c],role:"gridcell"},_90b);_90d.fillCell(_90e,url);_90e.idx=this._cells.length;this._cells.push({node:_90e,dye:_90d});}}}this._xDim=_909[0].length;this._yDim=_909.length;var _90f={UP_ARROW:-this._xDim,DOWN_ARROW:this._xDim,RIGHT_ARROW:this.isLeftToRight()?1:-1,LEFT_ARROW:this.isLeftToRight()?-1:1};for(var key in _90f){this.own(_905.addKeyListener(this.domNode,{keyCode:keys[key],ctrlKey:false,altKey:false,shiftKey:false},this,function(){var _910=_90f[key];return function(_911){this._navigateByKey(_910,_911);};}(),this.timeoutChangeRate,this.defaultTimeout));}},postCreate:function(){this.inherited(arguments);this._setCurrent(this._cells[0].node);},focus:function(){_904.focus(this._currentFocus);},_onCellClick:function(evt){var _912=evt.target;while(_912.tagName!="TD"){if(!_912.parentNode||_912==this.gridNode){return;}_912=_912.parentNode;}var _913=this._getDye(_912).getValue();this._setCurrent(_912);_904.focus(_912);this._setValueAttr(_913,true);evt.stopPropagation();evt.preventDefault();},_setCurrent:function(node){if("_currentFocus" in this){_8ff.set(this._currentFocus,"tabIndex","-1");}this._currentFocus=node;if(node){_8ff.set(node,"tabIndex",this.tabIndex);}},_setValueAttr:function(_914,_915){if(this._selectedCell>=0){_900.remove(this._cells[this._selectedCell].node,this.cellClass+"Selected");}this._selectedCell=-1;if(_914){for(var i=0;i<this._cells.length;i++){if(_914==this._cells[i].dye.getValue()){this._selectedCell=i;_900.add(this._cells[i].node,this.cellClass+"Selected");break;}}}this._set("value",this._selectedCell>=0?_914:null);if(_915||_915===undefined){this.onChange(_914);}},onChange:function(){},_navigateByKey:function(_916,_917){if(_917==-1){return;}var _918=this._currentFocus.idx+_916;if(_918<this._cells.length&&_918>-1){var _919=this._cells[_918].node;this._setCurrent(_919);this.defer(lang.hitch(_904,"focus",_919));}},_getDye:function(cell){return this._cells[cell.idx].dye;}});return _906;});},"dijit/form/ValidationTextBox":function(){define(["dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_91a,_91b,lang,i18n,_91c,_91d,_91e){var _91f=_91a("dijit.form.ValidationTextBox",_91c,{templateString:_91e,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,_920){if(_920!=_91f.prototype[attr]){_91b.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");this.set("pattern",_920);}},_setRegExpGenAttr:function(_921){this._deprecateRegExp("regExpGen",_921);this._set("regExpGen",this._computeRegexp);},_setRegExpAttr:function(_922){this._deprecateRegExp("regExp",_922);},_setValueAttr:function(){this.inherited(arguments);this._refreshState();},validator:function(_923,_924){return (new RegExp("^(?:"+this._computeRegexp(_924)+")"+(this.required?"":"?")+"$")).test(_923)&&(!this.required||!this._isEmpty(_923))&&(this._isEmpty(_923)||this.parse(_923,_924)!==undefined);},_isValidSubset:function(){return this.textbox.value.search(this._partialre)==0;},isValid:function(){return this.validator(this.textbox.value,this.get("constraints"));},_isEmpty:function(_925){return (this.trim?/^\s*$/:/^$/).test(_925);},getErrorMessage:function(){var _926=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;var _927=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_926:this.missingMessage;return (this.required&&this._isEmpty(this.textbox.value))?_927:_926;},getPromptMessage:function(){return this.promptMessage;},_maskValidSubsetError:true,validate:function(_928){var _929="";var _92a=this.disabled||this.isValid(_928);if(_92a){this._maskValidSubsetError=true;}var _92b=this._isEmpty(this.textbox.value);var _92c=!_92a&&_928&&this._isValidSubset();this._set("state",_92a?"":(((((!this._hasBeenBlurred||_928)&&_92b)||_92c)&&(this._maskValidSubsetError||(_92c&&!this._hasBeenBlurred&&_928)))?"Incomplete":"Error"));this.focusNode.setAttribute("aria-invalid",this.state=="Error"?"true":"false");if(this.state=="Error"){this._maskValidSubsetError=_928&&_92c;_929=this.getErrorMessage(_928);}else{if(this.state=="Incomplete"){_929=this.getPromptMessage(_928);this._maskValidSubsetError=!this._hasBeenBlurred||_928;}else{if(_92b){_929=this.getPromptMessage(_928);}}}this.set("message",_929);return _92a;},displayMessage:function(_92d){if(_92d&&this.focused){_91d.show(_92d,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_91d.hide(this.domNode);}},_refreshState:function(){if(this._created){this.validate(this.focused);}this.inherited(arguments);},constructor:function(_92e){this.constraints=lang.clone(this.constraints);this.baseClass+=" dijitValidationTextBox";},startup:function(){this.inherited(arguments);this._refreshState();},_setConstraintsAttr:function(_92f){if(!_92f.locale&&this.lang){_92f.locale=this.lang;}this._set("constraints",_92f);this._refreshState();},_setPatternAttr:function(_930){this._set("pattern",_930);this._refreshState();},_computeRegexp:function(_931){var p=this.pattern;if(typeof p=="function"){p=p.call(this,_931);}if(p!=this._lastRegExp){var _932="";this._lastRegExp=p;if(p!=".*"){p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){switch(re.charAt(0)){case "{":case "+":case "?":case "*":case "^":case "$":case "|":case "(":_932+=re;break;case ")":_932+="|$)";break;default:_932+="(?:"+re+"|$)";break;}});}try{"".search(_932);}catch(e){_932=this.pattern;console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);}this._partialre="^(?:"+_932+")$";}return p;},postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this._setConstraintsAttr(this.constraints);},_setDisabledAttr:function(_933){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_934){this._set("required",_934);this.focusNode.setAttribute("aria-required",_934);this._refreshState();},_setMessageAttr:function(_935){this._set("message",_935);this.displayMessage(_935);},reset:function(){this._maskValidSubsetError=true;this.inherited(arguments);},_onBlur:function(){this.displayMessage("");this.inherited(arguments);},destroy:function(){_91d.hide(this.domNode);this.inherited(arguments);}});return _91f;});},"dijit/selection":function(){define(["dojo/_base/array","dojo/dom","dojo/_base/lang","dojo/sniff","dojo/_base/window","dijit/focus"],function(_936,dom,lang,has,_937,_938){var _939=function(win){var doc=win.document;this.getType=function(){if(doc.getSelection){var _93a="text";var oSel;try{oSel=win.getSelection();}catch(e){}if(oSel&&oSel.rangeCount==1){var _93b=oSel.getRangeAt(0);if((_93b.startContainer==_93b.endContainer)&&((_93b.endOffset-_93b.startOffset)==1)&&(_93b.startContainer.nodeType!=3)){_93a="control";}}return _93a;}else{return doc.selection.type.toLowerCase();}};this.getSelectedText=function(){if(doc.getSelection){var _93c=win.getSelection();return _93c?_93c.toString():"";}else{if(this.getType()=="control"){return null;}return doc.selection.createRange().text;}};this.getSelectedHtml=function(){if(doc.getSelection){var _93d=win.getSelection();if(_93d&&_93d.rangeCount){var i;var html="";for(i=0;i<_93d.rangeCount;i++){var frag=_93d.getRangeAt(i).cloneContents();var div=doc.createElement("div");div.appendChild(frag);html+=div.innerHTML;}return html;}return null;}else{if(this.getType()=="control"){return null;}return doc.selection.createRange().htmlText;}};this.getSelectedElement=function(){if(this.getType()=="control"){if(doc.getSelection){var _93e=win.getSelection();return _93e.anchorNode.childNodes[_93e.anchorOffset];}else{var _93f=doc.selection.createRange();if(_93f&&_93f.item){return doc.selection.createRange().item(0);}}}return null;};this.getParentElement=function(){if(this.getType()=="control"){var p=this.getSelectedElement();if(p){return p.parentNode;}}else{if(doc.getSelection){var _940=doc.getSelection();if(_940){var node=_940.anchorNode;while(node&&(node.nodeType!=1)){node=node.parentNode;}return node;}}else{var r=doc.selection.createRange();r.collapse(true);return r.parentElement();}}return null;};this.hasAncestorElement=function(_941){return this.getAncestorElement.apply(this,arguments)!=null;};this.getAncestorElement=function(_942){var node=this.getSelectedElement()||this.getParentElement();return this.getParentOfType(node,arguments);};this.isTag=function(node,tags){if(node&&node.tagName){var _943=node.tagName.toLowerCase();for(var i=0;i<tags.length;i++){var _944=String(tags[i]).toLowerCase();if(_943==_944){return _944;}}}return "";};this.getParentOfType=function(node,tags){while(node){if(this.isTag(node,tags).length){return node;}node=node.parentNode;}return null;};this.collapse=function(_945){if(doc.getSelection){var _946=win.getSelection();if(_946.removeAllRanges){if(_945){_946.collapseToStart();}else{_946.collapseToEnd();}}else{_946.collapse(_945);}}else{var _947=doc.selection.createRange();_947.collapse(_945);_947.select();}};this.remove=function(){var sel=doc.selection;if(doc.getSelection){sel=win.getSelection();sel.deleteFromDocument();return sel;}else{if(sel.type.toLowerCase()!="none"){sel.clear();}return sel;}};this.selectElementChildren=function(_948,_949){var _94a;_948=dom.byId(_948);if(doc.getSelection){var _94b=win.getSelection();if(has("opera")){if(_94b.rangeCount){_94a=_94b.getRangeAt(0);}else{_94a=doc.createRange();}_94a.setStart(_948,0);_94a.setEnd(_948,(_948.nodeType==3)?_948.length:_948.childNodes.length);_94b.addRange(_94a);}else{_94b.selectAllChildren(_948);}}else{_94a=_948.ownerDocument.body.createTextRange();_94a.moveToElementText(_948);if(!_949){try{_94a.select();}catch(e){}}}};this.selectElement=function(_94c,_94d){var _94e;_94c=dom.byId(_94c);if(doc.getSelection){var _94f=doc.getSelection();_94e=doc.createRange();if(_94f.removeAllRanges){if(has("opera")){if(_94f.getRangeAt(0)){_94e=_94f.getRangeAt(0);}}_94e.selectNode(_94c);_94f.removeAllRanges();_94f.addRange(_94e);}}else{try{var tg=_94c.tagName?_94c.tagName.toLowerCase():"";if(tg==="img"||tg==="table"){_94e=_937.body(doc).createControlRange();}else{_94e=_937.body(doc).createRange();}_94e.addElement(_94c);if(!_94d){_94e.select();}}catch(e){this.selectElementChildren(_94c,_94d);}}};this.inSelection=function(node){if(node){var _950;var _951;if(doc.getSelection){var sel=win.getSelection();if(sel&&sel.rangeCount>0){_951=sel.getRangeAt(0);}if(_951&&_951.compareBoundaryPoints&&doc.createRange){try{_950=doc.createRange();_950.setStart(node,0);if(_951.compareBoundaryPoints(_951.START_TO_END,_950)===1){return true;}}catch(e){}}}else{_951=doc.selection.createRange();try{_950=node.ownerDocument.body.createTextRange();_950.moveToElementText(node);}catch(e2){}if(_951&&_950){if(_951.compareEndPoints("EndToStart",_950)===1){return true;}}}}return false;};this.getBookmark=function(){var bm,rg,tg,sel=doc.selection,cf=_938.curNode;if(doc.getSelection){sel=win.getSelection();if(sel){if(sel.isCollapsed){tg=cf?cf.tagName:"";if(tg){tg=tg.toLowerCase();if(tg=="textarea"||(tg=="input"&&(!cf.type||cf.type.toLowerCase()=="text"))){sel={start:cf.selectionStart,end:cf.selectionEnd,node:cf,pRange:true};return {isCollapsed:(sel.end<=sel.start),mark:sel};}}bm={isCollapsed:true};if(sel.rangeCount){bm.mark=sel.getRangeAt(0).cloneRange();}}else{rg=sel.getRangeAt(0);bm={isCollapsed:false,mark:rg.cloneRange()};}}}else{if(sel){tg=cf?cf.tagName:"";tg=tg.toLowerCase();if(cf&&tg&&(tg=="button"||tg=="textarea"||tg=="input")){if(sel.type&&sel.type.toLowerCase()=="none"){return {isCollapsed:true,mark:null};}else{rg=sel.createRange();return {isCollapsed:rg.text&&rg.text.length?false:true,mark:{range:rg,pRange:true}};}}bm={};try{rg=sel.createRange();bm.isCollapsed=!(sel.type=="Text"?rg.htmlText.length:rg.length);}catch(e){bm.isCollapsed=true;return bm;}if(sel.type.toUpperCase()=="CONTROL"){if(rg.length){bm.mark=[];var i=0,len=rg.length;while(i<len){bm.mark.push(rg.item(i++));}}else{bm.isCollapsed=true;bm.mark=null;}}else{bm.mark=rg.getBookmark();}}else{console.warn("No idea how to store the current selection for this browser!");}}return bm;};this.moveToBookmark=function(_952){var mark=_952.mark;if(mark){if(doc.getSelection){var sel=win.getSelection();if(sel&&sel.removeAllRanges){if(mark.pRange){var n=mark.node;n.selectionStart=mark.start;n.selectionEnd=mark.end;}else{sel.removeAllRanges();sel.addRange(mark);}}else{console.warn("No idea how to restore selection for this browser!");}}else{if(doc.selection&&mark){var rg;if(mark.pRange){rg=mark.range;}else{if(lang.isArray(mark)){rg=doc.body.createControlRange();_936.forEach(mark,function(n){rg.addElement(n);});}else{rg=doc.body.createTextRange();rg.moveToBookmark(mark);}}rg.select();}}}};this.isCollapsed=function(){return this.getBookmark().isCollapsed;};};var _953=new _939(window);_953.SelectionManager=_939;return _953;});},"dijit/_base/typematic":function(){define(["../typematic"],function(){});},"dijit/layout/BorderContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","../_WidgetBase","../_Widget","../_TemplatedMixin","./LayoutContainer","./utils"],function(_954,_955,_956,_957,_958,_959,_95a,keys,lang,on,_95b,_95c,_95d,_95e,_95f,_960){var _961=_956("dijit.layout._Splitter",[_95d,_95e],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeydown:_onKeyDown,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){this._handlers=[];},postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);this._factor=/top|left/.test(this.region)?1:-1;this._cookieName=this.container.id+"_"+this.region;},buildRendering:function(){this.inherited(arguments);_957.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));if(this.container.persist){var _962=_955(this._cookieName);if(_962){this.child.domNode.style[this.horizontal?"height":"width"]=_962;}}},_computeMaxSize:function(){var dim=this.horizontal?"h":"w",_963=_959.getMarginBox(this.child.domNode)[dim],_964=_954.filter(this.container.getChildren(),function(_965){return _965.region=="center";})[0];var _966=_959.getContentBox(_964.domNode)[dim]-10;return Math.min(this.child.maxSize,_963+_966);},_startDrag:function(e){if(!this.cover){this.cover=_958.place("<div class=dijitSplitterCover></div>",this.child.domNode,"after");}_957.add(this.cover,"dijitSplitterCoverActive");if(this.fake){_958.destroy(this.fake);}if(!(this._resize=this.live)){(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");_957.add(this.domNode,"dijitSplitterShadow");_958.place(this.fake,this.domNode,"after");}_957.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");if(this.fake){_957.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");}var _967=this._factor,_968=this.horizontal,axis=_968?"pageY":"pageX",_969=e[axis],_96a=this.domNode.style,dim=_968?"h":"w",_96b=_95a.getComputedStyle(this.child.domNode),_96c=_959.getMarginBox(this.child.domNode,_96b)[dim],max=this._computeMaxSize(),min=Math.max(this.child.minSize,_959.getPadBorderExtents(this.child.domNode,_96b)[dim]+10),_96d=this.region,_96e=_96d=="top"||_96d=="bottom"?"top":"left",_96f=parseInt(_96a[_96e],10),_970=this._resize,_971=lang.hitch(this.container,"_layoutChildren",this.child.id),de=this.ownerDocument;this._handlers=this._handlers.concat([on(de,_95b.move,this._drag=function(e,_972){var _973=e[axis]-_969,_974=_967*_973+_96c,_975=Math.max(Math.min(_974,max),min);if(_970||_972){_971(_975);}_96a[_96e]=_973+_96f+_967*(_975-_974)+"px";}),on(de,"dragstart",function(e){e.stopPropagation();e.preventDefault();}),on(this.ownerDocumentBody,"selectstart",function(e){e.stopPropagation();e.preventDefault();}),on(de,_95b.release,lang.hitch(this,"_stopDrag"))]);e.stopPropagation();e.preventDefault();},_onMouse:function(e){var o=(e.type=="mouseover"||e.type=="mouseenter");_957.toggle(this.domNode,"dijitSplitterHover",o);_957.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);},_stopDrag:function(e){try{if(this.cover){_957.remove(this.cover,"dijitSplitterCoverActive");}if(this.fake){_958.destroy(this.fake);}_957.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");this._drag(e);this._drag(e,true);}finally{this._cleanupHandlers();delete this._drag;}if(this.container.persist){_955(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});}},_cleanupHandlers:function(){var h;while(h=this._handlers.pop()){h.remove();}},_onKeyDown:function(e){this._resize=true;var _976=this.horizontal;var tick=1;switch(e.keyCode){case _976?keys.UP_ARROW:keys.LEFT_ARROW:tick*=-1;case _976?keys.DOWN_ARROW:keys.RIGHT_ARROW:break;default:return;}var _977=_959.getMarginSize(this.child.domNode)[_976?"h":"w"]+this._factor*tick;this.container._layoutChildren(this.child.id,Math.max(Math.min(_977,this._computeMaxSize()),this.child.minSize));e.stopPropagation();e.preventDefault();},destroy:function(){this._cleanupHandlers();delete this.child;delete this.container;delete this.cover;delete this.fake;this.inherited(arguments);}});var _978=_956("dijit.layout._Gutter",[_95d,_95e],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);},buildRendering:function(){this.inherited(arguments);_957.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));}});var _979=_956("dijit.layout.BorderContainer",_95f,{gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_961,postMixInProperties:function(){if(!this.gutters){this.baseClass+="NoGutter";}this.inherited(arguments);},_setupChild:function(_97a){this.inherited(arguments);var _97b=_97a.region,ltr=_97a.isLeftToRight();if(_97b=="leading"){_97b=ltr?"left":"right";}if(_97b=="trailing"){_97b=ltr?"right":"left";}if(_97b){if(_97b!="center"&&(_97a.splitter||this.gutters)&&!_97a._splitterWidget){var _97c=_97a.splitter?this._splitterClass:_978;if(lang.isString(_97c)){_97c=lang.getObject(_97c);}var _97d=new _97c({id:_97a.id+"_splitter",container:this,child:_97a,region:_97b,live:this.liveSplitters});_97d.isSplitter=true;_97a._splitterWidget=_97d;var _97e=_97b=="bottom"||_97b==(this.isLeftToRight()?"right":"left");_958.place(_97d.domNode,_97a.domNode,_97e?"before":"after");_97d.startup();}}},layout:function(){this._layoutChildren();},removeChild:function(_97f){var _980=_97f._splitterWidget;if(_980){_980.destroy();delete _97f._splitterWidget;}this.inherited(arguments);},getChildren:function(){return _954.filter(this.inherited(arguments),function(_981){return !_981.isSplitter;});},getSplitter:function(_982){return _954.filter(this.getChildren(),function(_983){return _983.region==_982;})[0]._splitterWidget;},resize:function(_984,_985){if(!this.cs||!this.pe){var node=this.domNode;this.cs=_95a.getComputedStyle(node);this.pe=_959.getPadExtents(node,this.cs);this.pe.r=_95a.toPixelValue(node,this.cs.paddingRight);this.pe.b=_95a.toPixelValue(node,this.cs.paddingBottom);_95a.set(node,"padding","0px");}this.inherited(arguments);},_layoutChildren:function(_986,_987){if(!this._borderBox||!this._borderBox.h){return;}var _988=[];_954.forEach(this._getOrderedChildren(),function(pane){_988.push(pane);if(pane._splitterWidget){_988.push(pane._splitterWidget);}});var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};_960.layoutChildren(this.domNode,dim,_988,_986,_987);},destroyRecursive:function(){_954.forEach(this.getChildren(),function(_989){var _98a=_989._splitterWidget;if(_98a){_98a.destroy();}delete _989._splitterWidget;});this.inherited(arguments);}});_979.ChildWidgetProperties={splitter:false,minSize:0,maxSize:Infinity};lang.mixin(_979.ChildWidgetProperties,_95f.ChildWidgetProperties);lang.extend(_95c,_979.ChildWidgetProperties);_979._Splitter=_961;_979._Gutter=_978;return _979;});},"dijit/_base":function(){define(["./main","./a11y","./WidgetSet","./_base/focus","./_base/manager","./_base/place","./_base/popup","./_base/scroll","./_base/sniff","./_base/typematic","./_base/wai","./_base/window"],function(_98b){return _98b._base;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_98c,dom,geom,_98d,_98e){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_98c.body(doc),_98f=_98e.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_98e.create("div",{style:{overflow:"hidden",direction:"ltr"}},_98f,"last"),ret=geom.position(div).x!=0;_98f.removeChild(div);body.removeChild(_98f);return ret;});has.add("position-fixed-support",function(win,doc){var body=_98c.body(doc),_990=_98e.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_991=_98e.create("span",{style:{position:"fixed",left:"0",top:"0"}},_990,"last"),ret=geom.position(_991).x!=geom.position(_990).x;_990.removeChild(_991);body.removeChild(_990);return ret;});var _992={getBox:function(doc){doc=doc||_98c.doc;var _993=(doc.compatMode=="BackCompat")?_98c.body(doc):doc.documentElement,_994=geom.docScroll(doc),w,h;if(has("touch")){var _995=_992.get(doc);w=_995.innerWidth||_993.clientWidth;h=_995.innerHeight||_993.clientHeight;}else{w=_993.clientWidth;h=_993.clientHeight;}return {l:_994.x,t:_994.y,w:w,h:h};},get:function(doc){if(has("ie")&&_992!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_98c.doc,body=_98c.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie")||has("trident"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident")||has("edge"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _996=doc.compatMode=="BackCompat",_997=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_998=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_999=(isWK||_996)?body:html,_99a=pos||geom.position(node),el=node.parentNode,_99b=function(el){return (isIE<=6||(isIE==7&&_996))?false:(has("position-fixed-support")&&(_98d.get(el,"position").toLowerCase()=="fixed"));},self=this,_99c=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){self.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_99b(node)){return;}while(el){if(el==body){el=_999;}var _99d=geom.position(el),_99e=_99b(el),rtl=_98d.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_999){_99d.w=_997;_99d.h=_998;if(_999==html&&(isIE||has("trident"))&&rtl){_99d.x+=_999.offsetWidth-_99d.w;}_99d.x=0;_99d.y=0;}else{var pb=geom.getPadBorderExtents(el);_99d.w-=pb.w;_99d.h-=pb.h;_99d.x+=pb.l;_99d.y+=pb.t;var _99f=el.clientWidth,_9a0=_99d.w-_99f;if(_99f>0&&_9a0>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_99d.x+=_9a0;}_99d.w=_99f;}_99f=el.clientHeight;_9a0=_99d.h-_99f;if(_99f>0&&_9a0>0){_99d.h=_99f;}}if(_99e){if(_99d.y<0){_99d.h+=_99d.y;_99d.y=0;}if(_99d.x<0){_99d.w+=_99d.x;_99d.x=0;}if(_99d.y+_99d.h>_998){_99d.h=_998-_99d.y;}if(_99d.x+_99d.w>_997){_99d.w=_997-_99d.x;}}var l=_99a.x-_99d.x,t=_99a.y-_99d.y,r=l+_99a.w-_99d.w,bot=t+_99a.h-_99d.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_999||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_996)||has("trident")>=5)){s=-s;}old=el.scrollLeft;_99c(el,s,0);s=el.scrollLeft-old;_99a.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_999||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_99c(el,0,s);s=el.scrollTop-old;_99a.y-=s;}el=(el!=_999)&&!_99e&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_992);return _992;});},"dojo/number":function(){define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_9a1,_9a2,_9a3){var _9a4={};lang.setObject("dojo.number",_9a4);_9a4.format=function(_9a5,_9a6){_9a6=lang.mixin({},_9a6||{});var _9a7=i18n.normalizeLocale(_9a6.locale),_9a8=i18n.getLocalization("dojo.cldr","number",_9a7);_9a6.customs=_9a8;var _9a9=_9a6.pattern||_9a8[(_9a6.type||"decimal")+"Format"];if(isNaN(_9a5)||Math.abs(_9a5)==Infinity){return null;}return _9a4._applyPattern(_9a5,_9a9,_9a6);};_9a4._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;_9a4._applyPattern=function(_9aa,_9ab,_9ac){_9ac=_9ac||{};var _9ad=_9ac.customs.group,_9ae=_9ac.customs.decimal,_9af=_9ab.split(";"),_9b0=_9af[0];_9ab=_9af[(_9aa<0)?1:0]||("-"+_9b0);if(_9ab.indexOf("%")!=-1){_9aa*=100;}else{if(_9ab.indexOf("‰")!=-1){_9aa*=1000;}else{if(_9ab.indexOf("¤")!=-1){_9ad=_9ac.customs.currencyGroup||_9ad;_9ae=_9ac.customs.currencyDecimal||_9ae;_9ab=_9ab.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/,function(_9b1,_9b2,_9b3,_9b4){var prop=["symbol","currency","displayName"][_9b3.length-1],_9b5=_9ac[prop]||_9ac.currency||"";if(!_9b5){return "";}return _9b2+_9b5+_9b4;});}else{if(_9ab.indexOf("E")!=-1){throw new Error("exponential notation not supported");}}}}var _9b6=_9a4._numberPatternRE;var _9b7=_9b0.match(_9b6);if(!_9b7){throw new Error("unable to find a number expression in pattern: "+_9ab);}if(_9ac.fractional===false){_9ac.places=0;}return _9ab.replace(_9b6,_9a4._formatAbsolute(_9aa,_9b7[0],{decimal:_9ae,group:_9ad,places:_9ac.places,round:_9ac.round}));};_9a4.round=function(_9b8,_9b9,_9ba){var _9bb=10/(_9ba||10);return (_9bb*+_9b8).toFixed(_9b9)/_9bb;};if((0.9).toFixed()==0){var _9bc=_9a4.round;_9a4.round=function(v,p,m){var d=Math.pow(10,-p||0),a=Math.abs(v);if(!v||a>=d){d=0;}else{a/=d;if(a<0.5||a>=0.95){d=0;}}return _9bc(v,p,m)+(v>0?d:-d);};}_9a4._formatAbsolute=function(_9bd,_9be,_9bf){_9bf=_9bf||{};if(_9bf.places===true){_9bf.places=0;}if(_9bf.places===Infinity){_9bf.places=6;}var _9c0=_9be.split("."),_9c1=typeof _9bf.places=="string"&&_9bf.places.indexOf(","),_9c2=_9bf.places;if(_9c1){_9c2=_9bf.places.substring(_9c1+1);}else{if(!(_9c2>=0)){_9c2=(_9c0[1]||[]).length;}}if(!(_9bf.round<0)){_9bd=_9a4.round(_9bd,_9c2,_9bf.round);}var _9c3=String(Math.abs(_9bd)).split("."),_9c4=_9c3[1]||"";if(_9c0[1]||_9bf.places){if(_9c1){_9bf.places=_9bf.places.substring(0,_9c1);}var pad=_9bf.places!==undefined?_9bf.places:(_9c0[1]&&_9c0[1].lastIndexOf("0")+1);if(pad>_9c4.length){_9c3[1]=_9a2.pad(_9c4,pad,"0",true);}if(_9c2<_9c4.length){_9c3[1]=_9c4.substr(0,_9c2);}}else{if(_9c3[1]){_9c3.pop();}}var _9c5=_9c0[0].replace(",","");pad=_9c5.indexOf("0");if(pad!=-1){pad=_9c5.length-pad;if(pad>_9c3[0].length){_9c3[0]=_9a2.pad(_9c3[0],pad);}if(_9c5.indexOf("#")==-1){_9c3[0]=_9c3[0].substr(_9c3[0].length-pad);}}var _9c6=_9c0[0].lastIndexOf(","),_9c7,_9c8;if(_9c6!=-1){_9c7=_9c0[0].length-_9c6-1;var _9c9=_9c0[0].substr(0,_9c6);_9c6=_9c9.lastIndexOf(",");if(_9c6!=-1){_9c8=_9c9.length-_9c6-1;}}var _9ca=[];for(var _9cb=_9c3[0];_9cb;){var off=_9cb.length-_9c7;_9ca.push((off>0)?_9cb.substr(off):_9cb);_9cb=(off>0)?_9cb.slice(0,off):"";if(_9c8){_9c7=_9c8;_9c8=undefined;}}_9c3[0]=_9ca.reverse().join(_9bf.group||",");return _9c3.join(_9bf.decimal||".");};_9a4.regexp=function(_9cc){return _9a4._parseInfo(_9cc).regexp;};_9a4._parseInfo=function(_9cd){_9cd=_9cd||{};var _9ce=i18n.normalizeLocale(_9cd.locale),_9cf=i18n.getLocalization("dojo.cldr","number",_9ce),_9d0=_9cd.pattern||_9cf[(_9cd.type||"decimal")+"Format"],_9d1=_9cf.group,_9d2=_9cf.decimal,_9d3=1;if(_9d0.indexOf("%")!=-1){_9d3/=100;}else{if(_9d0.indexOf("‰")!=-1){_9d3/=1000;}else{var _9d4=_9d0.indexOf("¤")!=-1;if(_9d4){_9d1=_9cf.currencyGroup||_9d1;_9d2=_9cf.currencyDecimal||_9d2;}}}var _9d5=_9d0.split(";");if(_9d5.length==1){_9d5.push("-"+_9d5[0]);}var re=_9a3.buildGroupRE(_9d5,function(_9d6){_9d6="(?:"+_9a3.escapeString(_9d6,".")+")";return _9d6.replace(_9a4._numberPatternRE,function(_9d7){var _9d8={signed:false,separator:_9cd.strict?_9d1:[_9d1,""],fractional:_9cd.fractional,decimal:_9d2,exponent:false},_9d9=_9d7.split("."),_9da=_9cd.places;if(_9d9.length==1&&_9d3!=1){_9d9[1]="###";}if(_9d9.length==1||_9da===0){_9d8.fractional=false;}else{if(_9da===undefined){_9da=_9cd.pattern?_9d9[1].lastIndexOf("0")+1:Infinity;}if(_9da&&_9cd.fractional==undefined){_9d8.fractional=true;}if(!_9cd.places&&(_9da<_9d9[1].length)){_9da+=","+_9d9[1].length;}_9d8.places=_9da;}var _9db=_9d9[0].split(",");if(_9db.length>1){_9d8.groupSize=_9db.pop().length;if(_9db.length>1){_9d8.groupSize2=_9db.pop().length;}}return "("+_9a4._realNumberRegexp(_9d8)+")";});},true);if(_9d4){re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(_9dc,_9dd,_9de,_9df){var prop=["symbol","currency","displayName"][_9de.length-1],_9e0=_9a3.escapeString(_9cd[prop]||_9cd.currency||"");if(!_9e0){return "";}_9dd=_9dd?"[\\s\\xa0]":"";_9df=_9df?"[\\s\\xa0]":"";if(!_9cd.strict){if(_9dd){_9dd+="*";}if(_9df){_9df+="*";}return "(?:"+_9dd+_9e0+_9df+")?";}return _9dd+_9e0+_9df;});}return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:_9d1,decimal:_9d2,factor:_9d3};};_9a4.parse=function(_9e1,_9e2){var info=_9a4._parseInfo(_9e2),_9e3=(new RegExp("^"+info.regexp+"$")).exec(_9e1);if(!_9e3){return NaN;}var _9e4=_9e3[1];if(!_9e3[1]){if(!_9e3[2]){return NaN;}_9e4=_9e3[2];info.factor*=-1;}_9e4=_9e4.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");return _9e4*info.factor;};_9a4._realNumberRegexp=function(_9e5){_9e5=_9e5||{};if(!("places" in _9e5)){_9e5.places=Infinity;}if(typeof _9e5.decimal!="string"){_9e5.decimal=".";}if(!("fractional" in _9e5)||/^0/.test(_9e5.places)){_9e5.fractional=[true,false];}if(!("exponent" in _9e5)){_9e5.exponent=[true,false];}if(!("eSigned" in _9e5)){_9e5.eSigned=[true,false];}var _9e6=_9a4._integerRegexp(_9e5),_9e7=_9a3.buildGroupRE(_9e5.fractional,function(q){var re="";if(q&&(_9e5.places!==0)){re="\\"+_9e5.decimal;if(_9e5.places==Infinity){re="(?:"+re+"\\d+)?";}else{re+="\\d{"+_9e5.places+"}";}}return re;},true);var _9e8=_9a3.buildGroupRE(_9e5.exponent,function(q){if(q){return "([eE]"+_9a4._integerRegexp({signed:_9e5.eSigned})+")";}return "";});var _9e9=_9e6+_9e7;if(_9e7){_9e9="(?:(?:"+_9e9+")|(?:"+_9e7+"))";}return _9e9+_9e8;};_9a4._integerRegexp=function(_9ea){_9ea=_9ea||{};if(!("signed" in _9ea)){_9ea.signed=[true,false];}if(!("separator" in _9ea)){_9ea.separator="";}else{if(!("groupSize" in _9ea)){_9ea.groupSize=3;}}var _9eb=_9a3.buildGroupRE(_9ea.signed,function(q){return q?"[-+]":"";},true);var _9ec=_9a3.buildGroupRE(_9ea.separator,function(sep){if(!sep){return "(?:\\d+)";}sep=_9a3.escapeString(sep);if(sep==" "){sep="\\s";}else{if(sep==" "){sep="\\s\\xa0";}}var grp=_9ea.groupSize,grp2=_9ea.groupSize2;if(grp2){var _9ed="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";return ((grp-grp2)>0)?"(?:"+_9ed+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_9ed;}return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";},true);return _9eb+_9ec;};return _9a4;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_9ee,_9ef,_9f0,lang){lang.extend(_9ef,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _9f0("dijit._FocusMixin",null,{_focusManager:_9ee});});},"dojo/data/util/filter":function(){define(["../../_base/lang"],function(lang){var _9f1={};lang.setObject("dojo.data.util.filter",_9f1);_9f1.patternToRegExp=function(_9f2,_9f3){var rxp="^";var c=null;for(var i=0;i<_9f2.length;i++){c=_9f2.charAt(i);switch(c){case "\\":rxp+=c;i++;rxp+=_9f2.charAt(i);break;case "*":rxp+=".*";break;case "?":rxp+=".";break;case "$":case "^":case "/":case "+":case ".":case "|":case "(":case ")":case "{":case "}":case "[":case "]":rxp+="\\";default:rxp+=c;}}rxp+="$";if(_9f3){return new RegExp(rxp,"mi");}else{return new RegExp(rxp,"m");}};return _9f1;});},"dijit/_WidgetsInTemplateMixin":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser"],function(_9f4,_9f5,_9f6,lang,_9f7){return _9f6("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,contextRequire:null,_beforeFillContent:function(){if(/dojoType|data-dojo-type/i.test(this.domNode.innerHTML)){var node=this.domNode;if(this.containerNode&&!this.searchContainerNode){this.containerNode.stopParser=true;}_9f7.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,contextRequire:this.contextRequire,scope:"dojo"}).then(lang.hitch(this,function(_9f8){this._startupWidgets=_9f8;for(var i=0;i<_9f8.length;i++){this._processTemplateNode(_9f8[i],function(n,p){return n[p];},function(_9f9,type,_9fa){if(type in _9f9){return _9f9.connect(_9f9,type,_9fa);}else{return _9f9.on(type,_9fa,true);}});}if(this.containerNode&&this.containerNode.stopParser){delete this.containerNode.stopParser;}}));if(!this._startupWidgets){throw new Error(this.declaredClass+": parser returned unfilled promise (probably waiting for module auto-load), "+"unsupported by _WidgetsInTemplateMixin.   Must pre-load all supporting widgets before instantiation.");}}},_processTemplateNode:function(_9fb,_9fc,_9fd){if(_9fc(_9fb,"dojoType")||_9fc(_9fb,"data-dojo-type")){return true;}return this.inherited(arguments);},startup:function(){_9f4.forEach(this._startupWidgets,function(w){if(w&&!w._started&&w.startup){w.startup();}});this._startupWidgets=null;this.inherited(arguments);}});});},"dojo/fx/Toggler":function(){define(["../_base/lang","../_base/declare","../_base/fx","../aspect"],function(lang,_9fe,_9ff,_a00){return _9fe("dojo.fx.Toggler",null,{node:null,showFunc:_9ff.fadeIn,hideFunc:_9ff.fadeOut,showDuration:200,hideDuration:200,constructor:function(args){var _a01=this;lang.mixin(_a01,args);_a01.node=args.node;_a01._showArgs=lang.mixin({},args);_a01._showArgs.node=_a01.node;_a01._showArgs.duration=_a01.showDuration;_a01.showAnim=_a01.showFunc(_a01._showArgs);_a01._hideArgs=lang.mixin({},args);_a01._hideArgs.node=_a01.node;_a01._hideArgs.duration=_a01.hideDuration;_a01.hideAnim=_a01.hideFunc(_a01._hideArgs);_a00.after(_a01.showAnim,"beforeBegin",lang.hitch(_a01.hideAnim,"stop",true),true);_a00.after(_a01.hideAnim,"beforeBegin",lang.hitch(_a01.showAnim,"stop",true),true);},show:function(_a02){return this.showAnim.play(_a02||0);},hide:function(_a03){return this.hideAnim.play(_a03||0);}});});},"dijit/form/FilteringSelect":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/when","./MappedTextBox","./ComboBoxMixin"],function(_a04,lang,when,_a05,_a06){return _a04("dijit.form.FilteringSelect",[_a05,_a06],{required:true,_lastDisplayedValue:"",_isValidSubset:function(){return this._opened;},isValid:function(){return !!this.item||(!this.required&&this.get("displayedValue")=="");},_refreshState:function(){if(!this.searchTimer){this.inherited(arguments);}},_callbackSetLabel:function(_a07,_a08,_a09,_a0a){if((_a08&&_a08[this.searchAttr]!==this._lastQuery)||(!_a08&&_a07.length&&this.store.getIdentity(_a07[0])!=this._lastQuery)){return;}if(!_a07.length){this.set("value","",_a0a||(_a0a===undefined&&!this.focused),this.textbox.value,null);}else{this.set("item",_a07[0],_a0a);}},_openResultList:function(_a0b,_a0c,_a0d){if(_a0c[this.searchAttr]!==this._lastQuery){return;}this.inherited(arguments);if(this.item===undefined){this.validate(true);}},_getValueAttr:function(){return this.valueNode.value;},_getValueField:function(){return "value";},_setValueAttr:function(_a0e,_a0f,_a10,item){if(!this._onChangeActive){_a0f=null;}if(item===undefined){if(_a0e===null||_a0e===""){_a0e="";if(!lang.isString(_a10)){this._setDisplayedValueAttr(_a10||"",_a0f);return;}}var self=this;this._lastQuery=_a0e;when(this.store.get(_a0e),function(item){self._callbackSetLabel(item?[item]:[],undefined,undefined,_a0f);});}else{this.valueNode.value=_a0e;this.inherited(arguments,[_a0e,_a0f,_a10,item]);}},_setItemAttr:function(item,_a11,_a12){this.inherited(arguments);this._lastDisplayedValue=this.textbox.value;},_getDisplayQueryString:function(text){return text.replace(/([\\\*\?])/g,"\\$1");},_setDisplayedValueAttr:function(_a13,_a14){if(_a13==null){_a13="";}if(!this._created){if(!("displayedValue" in this.params)){return;}_a14=false;}if(this.store){this.closeDropDown();var _a15=lang.clone(this.query);var qs=this._getDisplayQueryString(_a13),q;if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_a15[this.searchAttr]=q;this.textbox.value=_a13;this._lastDisplayedValue=_a13;this._set("displayedValue",_a13);var _a16=this;var _a17={queryOptions:{ignoreCase:this.ignoreCase,deep:true}};lang.mixin(_a17,this.fetchProperties);this._fetchHandle=this.store.query(_a15,_a17);when(this._fetchHandle,function(_a18){_a16._fetchHandle=null;_a16._callbackSetLabel(_a18||[],_a15,_a17,_a14);},function(err){_a16._fetchHandle=null;if(!_a16._cancelingQuery){console.error("dijit.form.FilteringSelect: "+err.toString());}});}},undo:function(){this.set("displayedValue",this._lastDisplayedValue);}});});},"dojo/data/util/sorter":function(){define(["../../_base/lang"],function(lang){var _a19={};lang.setObject("dojo.data.util.sorter",_a19);_a19.basicComparator=function(a,b){var r=-1;if(a===null){a=undefined;}if(b===null){b=undefined;}if(a==b){r=0;}else{if(a>b||a==null){r=1;}}return r;};_a19.createSortFunction=function(_a1a,_a1b){var _a1c=[];function _a1d(attr,dir,comp,s){return function(_a1e,_a1f){var a=s.getValue(_a1e,attr);var b=s.getValue(_a1f,attr);return dir*comp(a,b);};};var _a20;var map=_a1b.comparatorMap;var bc=_a19.basicComparator;for(var i=0;i<_a1a.length;i++){_a20=_a1a[i];var attr=_a20.attribute;if(attr){var dir=(_a20.descending)?-1:1;var comp=bc;if(map){if(typeof attr!=="string"&&("toString" in attr)){attr=attr.toString();}comp=map[attr]||bc;}_a1c.push(_a1d(attr,dir,comp,_a1b));}}return function(rowA,rowB){var i=0;while(i<_a1c.length){var ret=_a1c[i++](rowA,rowB);if(ret!==0){return ret;}}return 0;};};return _a19;});},"dijit/form/_ButtonMixin":function(){define(["dojo/_base/declare","dojo/dom","dojo/has","../registry"],function(_a21,dom,has,_a22){var _a23=_a21("dijit.form._ButtonMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{label:"",type:"button",__onClick:function(e){e.stopPropagation();e.preventDefault();if(!this.disabled){this.valueNode.click(e);}return false;},_onClick:function(e){if(this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.onClick(e)===false){e.preventDefault();}var _a24=e.defaultPrevented;if(!_a24&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){for(var node=this.domNode;node.parentNode;node=node.parentNode){var _a25=_a22.byNode(node);if(_a25&&typeof _a25._onSubmit=="function"){_a25._onSubmit(e);e.preventDefault();_a24=true;break;}}}return !_a24;},postCreate:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},onClick:function(){return true;},_setLabelAttr:function(_a26){this._set("label",_a26);var _a27=this.containerNode||this.focusNode;_a27.innerHTML=_a26;this.onLabelSet();},onLabelSet:function(){}});if(has("dojo-bidi")){_a23=_a21("dijit.form._ButtonMixin",_a23,{onLabelSet:function(){this.inherited(arguments);var _a28=this.containerNode||this.focusNode;this.applyTextDir(_a28);}});}return _a23;});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_a29,_a2a){var _a2b={};lang.setObject("dojo.colors",_a2b);var _a2c=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_a29.fromRgb=function(_a2d,obj){var m=_a2d.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_a2a.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _a29.fromArray(a,obj);}return _a29.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_a2c(m1,m2,H+1/3)*256,_a2c(m1,m2,H)*256,_a2c(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _a29.fromArray(a,obj);}}return null;};var _a2e=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_a29.prototype.sanitize=function(){var t=this;t.r=Math.round(_a2e(t.r,0,255));t.g=Math.round(_a2e(t.g,0,255));t.b=Math.round(_a2e(t.b,0,255));t.a=_a2e(t.a,0,1);return this;};_a2b.makeGrey=_a29.makeGrey=function(g,a){return _a29.fromArray([g,g,g,a]);};lang.mixin(_a29.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _a29;});},"dijit/registry":function(){define(["dojo/_base/array","dojo/_base/window","./main"],function(_a2f,win,_a30){var _a31={},hash={};var _a32={length:0,add:function(_a33){if(hash[_a33.id]){throw new Error("Tried to register widget with id=="+_a33.id+" but that id is already registered");}hash[_a33.id]=_a33;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_a34){var id;do{id=_a34+"_"+(_a34 in _a31?++_a31[_a34]:_a31[_a34]=0);}while(hash[id]);return _a30._scopeName=="dijit"?id:_a30._scopeName+"_"+id;},findWidgets:function(root,_a35){var _a36=[];function _a37(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _a38=node.getAttribute("widgetId");if(_a38){var _a39=hash[_a38];if(_a39){_a36.push(_a39);}}else{if(node!==_a35){_a37(node);}}}}};_a37(root);return _a36;},_destroyAll:function(){_a30._curFocus=null;_a30._prevFocus=null;_a30._activeStack=[];_a2f.forEach(_a32.findWidgets(win.body()),function(_a3a){if(!_a3a._destroyed){if(_a3a.destroyRecursive){_a3a.destroyRecursive();}else{if(_a3a.destroy){_a3a.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_a30.registry=_a32;return _a32;});},"dijit/tree/_dndContainer":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/touch"],function(_a3b,_a3c,_a3d,lang,on,_a3e){return _a3c("dijit.tree._dndContainer",null,{constructor:function(tree,_a3f){this.tree=tree;this.node=tree.domNode;lang.mixin(this,_a3f);this.containerState="";_a3d.add(this.node,"dojoDndContainer");this.events=[on(this.node,_a3e.enter,lang.hitch(this,"onOverEvent")),on(this.node,_a3e.leave,lang.hitch(this,"onOutEvent")),_a3b.after(this.tree,"_onNodeMouseEnter",lang.hitch(this,"onMouseOver"),true),_a3b.after(this.tree,"_onNodeMouseLeave",lang.hitch(this,"onMouseOut"),true),on(this.node,"dragstart, selectstart",function(evt){evt.preventDefault();})];},destroy:function(){var h;while(h=this.events.pop()){h.remove();}this.node=this.parent=null;},onMouseOver:function(_a40){this.current=_a40;},onMouseOut:function(){this.current=null;},_changeState:function(type,_a41){var _a42="dojoDnd"+type;var _a43=type.toLowerCase()+"State";_a3d.replace(this.node,_a42+_a41,_a42+this[_a43]);this[_a43]=_a41;},_addItemClass:function(node,type){_a3d.add(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){_a3d.remove(node,"dojoDndItem"+type);},onOverEvent:function(){this._changeState("Container","Over");},onOutEvent:function(){this._changeState("Container","");}});});},"dijit/_base/wai":function(){define(["dojo/dom-attr","dojo/_base/lang","../main","../hccss"],function(_a44,lang,_a45){var _a46={hasWaiRole:function(elem,role){var _a47=this.getWaiRole(elem);return role?(_a47.indexOf(role)>-1):(_a47.length>0);},getWaiRole:function(elem){return lang.trim((_a44.get(elem,"role")||"").replace("wairole:",""));},setWaiRole:function(elem,role){_a44.set(elem,"role",role);},removeWaiRole:function(elem,role){var _a48=_a44.get(elem,"role");if(!_a48){return;}if(role){var t=lang.trim((" "+_a48+" ").replace(" "+role+" "," "));_a44.set(elem,"role",t);}else{elem.removeAttribute("role");}},hasWaiState:function(elem,_a49){return elem.hasAttribute?elem.hasAttribute("aria-"+_a49):!!elem.getAttribute("aria-"+_a49);},getWaiState:function(elem,_a4a){return elem.getAttribute("aria-"+_a4a)||"";},setWaiState:function(elem,_a4b,_a4c){elem.setAttribute("aria-"+_a4b,_a4c);},removeWaiState:function(elem,_a4d){elem.removeAttribute("aria-"+_a4d);}};lang.mixin(_a45,_a46);return _a45;});},"dijit/form/_FormSelectWidget":function(){define(["dojo/_base/array","dojo/_base/Deferred","dojo/aspect","dojo/data/util/sorter","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/when","dojo/store/util/QueryResults","./_FormValueWidget"],function(_a4e,_a4f,_a50,_a51,_a52,dom,_a53,_a54,lang,_a55,when,_a56,_a57){var _a58=_a52("dijit.form._FormSelectWidget",_a57,{multiple:false,options:null,store:null,_setStoreAttr:function(val){if(this._created){this._deprecatedSetStore(val);}},query:null,_setQueryAttr:function(_a59){if(this._created){this._deprecatedSetStore(this.store,this.selectedValue,{query:_a59});}},queryOptions:null,_setQueryOptionsAttr:function(_a5a){if(this._created){this._deprecatedSetStore(this.store,this.selectedValue,{queryOptions:_a5a});}},labelAttr:"",onFetch:null,sortByLabel:true,loadChildrenOnOpen:false,onLoadDeferred:null,getOptions:function(_a5b){var opts=this.options||[];if(_a5b==null){return opts;}if(lang.isArrayLike(_a5b)){return _a4e.map(_a5b,"return this.getOptions(item);",this);}if(lang.isString(_a5b)){_a5b={value:_a5b};}if(lang.isObject(_a5b)){if(!_a4e.some(opts,function(_a5c,idx){for(var a in _a5b){if(!(a in _a5c)||_a5c[a]!=_a5b[a]){return false;}}_a5b=idx;return true;})){_a5b=-1;}}if(_a5b>=0&&_a5b<opts.length){return opts[_a5b];}return null;},addOption:function(_a5d){_a4e.forEach(lang.isArrayLike(_a5d)?_a5d:[_a5d],function(i){if(i&&lang.isObject(i)){this.options.push(i);}},this);this._loadChildren();},removeOption:function(_a5e){var _a5f=this.getOptions(lang.isArrayLike(_a5e)?_a5e:[_a5e]);_a4e.forEach(_a5f,function(_a60){if(_a60){this.options=_a4e.filter(this.options,function(node){return (node.value!==_a60.value||node.label!==_a60.label);});this._removeOptionItem(_a60);}},this);this._loadChildren();},updateOption:function(_a61){_a4e.forEach(lang.isArrayLike(_a61)?_a61:[_a61],function(i){var _a62=this.getOptions({value:i.value}),k;if(_a62){for(k in i){_a62[k]=i[k];}}},this);this._loadChildren();},setStore:function(_a63,_a64,_a65){_a54.deprecated(this.declaredClass+"::setStore(store, selectedValue, fetchArgs) is deprecated. Use set('query', fetchArgs.query), set('queryOptions', fetchArgs.queryOptions), set('store', store), or set('value', selectedValue) instead.","","2.0");this._deprecatedSetStore(_a63,_a64,_a65);},_deprecatedSetStore:function(_a66,_a67,_a68){var _a69=this.store;_a68=_a68||{};if(_a69!==_a66){var h;while((h=this._notifyConnections.pop())){h.remove();}if(!_a66.get){lang.mixin(_a66,{_oldAPI:true,get:function(id){var _a6a=new _a4f();this.fetchItemByIdentity({identity:id,onItem:function(_a6b){_a6a.resolve(_a6b);},onError:function(_a6c){_a6a.reject(_a6c);}});return _a6a.promise;},query:function(_a6d,_a6e){var _a6f=new _a4f(function(){if(_a70.abort){_a70.abort();}});_a6f.total=new _a4f();var _a70=this.fetch(lang.mixin({query:_a6d,onBegin:function(_a71){_a6f.total.resolve(_a71);},onComplete:function(_a72){_a6f.resolve(_a72);},onError:function(_a73){_a6f.reject(_a73);}},_a6e));return new _a56(_a6f);}});if(_a66.getFeatures()["dojo.data.api.Notification"]){this._notifyConnections=[_a50.after(_a66,"onNew",lang.hitch(this,"_onNewItem"),true),_a50.after(_a66,"onDelete",lang.hitch(this,"_onDeleteItem"),true),_a50.after(_a66,"onSet",lang.hitch(this,"_onSetItem"),true)];}}this._set("store",_a66);}if(this.options&&this.options.length){this.removeOption(this.options);}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(this._observeHandle&&this._observeHandle.remove){this._observeHandle.remove();this._observeHandle=null;}if(_a68.query){this._set("query",_a68.query);}if(_a68.queryOptions){this._set("queryOptions",_a68.queryOptions);}if(_a66&&_a66.query){this._loadingStore=true;this.onLoadDeferred=new _a4f();this._queryRes=_a66.query(this.query,this.queryOptions);when(this._queryRes,lang.hitch(this,function(_a74){if(this.sortByLabel&&!_a68.sort&&_a74.length){if(_a66.getValue){_a74.sort(_a51.createSortFunction([{attribute:_a66.getLabelAttributes(_a74[0])[0]}],_a66));}else{var _a75=this.labelAttr;_a74.sort(function(a,b){return a[_a75]>b[_a75]?1:b[_a75]>a[_a75]?-1:0;});}}if(_a68.onFetch){_a74=_a68.onFetch.call(this,_a74,_a68);}_a4e.forEach(_a74,function(i){this._addOptionForItem(i);},this);if(this._queryRes.observe){this._observeHandle=this._queryRes.observe(lang.hitch(this,function(_a76,_a77,_a78){if(_a77==_a78){this._onSetItem(_a76);}else{if(_a77!=-1){this._onDeleteItem(_a76);}if(_a78!=-1){this._onNewItem(_a76);}}}),true);}this._loadingStore=false;this.set("value","_pendingValue" in this?this._pendingValue:_a67);delete this._pendingValue;if(!this.loadChildrenOnOpen){this._loadChildren();}else{this._pseudoLoadChildren(_a74);}this.onLoadDeferred.resolve(true);this.onSetStore();}),lang.hitch(this,function(err){console.error("dijit.form.Select: "+err.toString());this.onLoadDeferred.reject(err);}));}return _a69;},_setValueAttr:function(_a79,_a7a){if(!this._onChangeActive){_a7a=null;}if(this._loadingStore){this._pendingValue=_a79;return;}if(_a79==null){return;}if(lang.isArrayLike(_a79)){_a79=_a4e.map(_a79,function(_a7b){return lang.isObject(_a7b)?_a7b:{value:_a7b};});}else{if(lang.isObject(_a79)){_a79=[_a79];}else{_a79=[{value:_a79}];}}_a79=_a4e.filter(this.getOptions(_a79),function(i){return i&&i.value;});var opts=this.getOptions()||[];if(!this.multiple&&(!_a79[0]||!_a79[0].value)&&!!opts.length){_a79[0]=opts[0];}_a4e.forEach(opts,function(opt){opt.selected=_a4e.some(_a79,function(v){return v.value===opt.value;});});var val=_a4e.map(_a79,function(opt){return opt.value;});if(typeof val=="undefined"||typeof val[0]=="undefined"){return;}var disp=_a4e.map(_a79,function(opt){return opt.label;});this._setDisplay(this.multiple?disp:disp[0]);this.inherited(arguments,[this.multiple?val:val[0],_a7a]);this._updateSelection();},_getDisplayedValueAttr:function(){var ret=_a4e.map([].concat(this.get("selectedOptions")),function(v){if(v&&"label" in v){return v.label;}else{if(v){return v.value;}}return null;},this);return this.multiple?ret:ret[0];},_setDisplayedValueAttr:function(_a7c){this.set("value",this.getOptions(typeof _a7c=="string"?{label:_a7c}:_a7c));},_loadChildren:function(){if(this._loadingStore){return;}_a4e.forEach(this._getChildren(),function(_a7d){_a7d.destroyRecursive();});_a4e.forEach(this.options,this._addOptionItem,this);this._updateSelection();},_updateSelection:function(){this.focusedChild=null;this._set("value",this._getValueFromOpts());var val=[].concat(this.value);if(val&&val[0]){var self=this;_a4e.forEach(this._getChildren(),function(_a7e){var _a7f=_a4e.some(val,function(v){return _a7e.option&&(v===_a7e.option.value);});if(_a7f&&!self.multiple){self.focusedChild=_a7e;}_a53.toggle(_a7e.domNode,this.baseClass.replace(/\s+|$/g,"SelectedOption "),_a7f);_a7e.domNode.setAttribute("aria-selected",_a7f?"true":"false");},this);}},_getValueFromOpts:function(){var opts=this.getOptions()||[];if(!this.multiple&&opts.length){var opt=_a4e.filter(opts,function(i){return i.selected;})[0];if(opt&&opt.value){return opt.value;}else{opts[0].selected=true;return opts[0].value;}}else{if(this.multiple){return _a4e.map(_a4e.filter(opts,function(i){return i.selected;}),function(i){return i.value;})||[];}}return "";},_onNewItem:function(item,_a80){if(!_a80||!_a80.parent){this._addOptionForItem(item);}},_onDeleteItem:function(item){var _a81=this.store;this.removeOption({value:_a81.getIdentity(item)});},_onSetItem:function(item){this.updateOption(this._getOptionObjForItem(item));},_getOptionObjForItem:function(item){var _a82=this.store,_a83=(this.labelAttr&&this.labelAttr in item)?item[this.labelAttr]:_a82.getLabel(item),_a84=(_a83?_a82.getIdentity(item):null);return {value:_a84,label:_a83,item:item};},_addOptionForItem:function(item){var _a85=this.store;if(_a85.isItemLoaded&&!_a85.isItemLoaded(item)){_a85.loadItem({item:item,onItem:function(i){this._addOptionForItem(i);},scope:this});return;}var _a86=this._getOptionObjForItem(item);this.addOption(_a86);},constructor:function(_a87){this._oValue=(_a87||{}).value||null;this._notifyConnections=[];},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},_fillContent:function(){if(!this.options){this.options=this.srcNodeRef?_a55("> *",this.srcNodeRef).map(function(node){if(node.getAttribute("type")==="separator"){return {value:"",label:"",selected:false,disabled:false};}return {value:(node.getAttribute("data-"+_a54._scopeName+"-value")||node.getAttribute("value")),label:String(node.innerHTML),selected:node.getAttribute("selected")||false,disabled:node.getAttribute("disabled")||false};},this):[];}if(!this.value){this._set("value",this._getValueFromOpts());}else{if(this.multiple&&typeof this.value=="string"){this._set("value",this.value.split(","));}}},postCreate:function(){this.inherited(arguments);_a50.after(this,"onChange",lang.hitch(this,"_updateSelection"));var _a88=this.store;if(_a88&&(_a88.getIdentity||_a88.getFeatures()["dojo.data.api.Identity"])){this.store=null;this._deprecatedSetStore(_a88,this._oValue,{query:this.query,queryOptions:this.queryOptions});}this._storeInitialized=true;},startup:function(){this._loadChildren();this.inherited(arguments);},destroy:function(){var h;while((h=this._notifyConnections.pop())){h.remove();}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(this._observeHandle&&this._observeHandle.remove){this._observeHandle.remove();this._observeHandle=null;}this.inherited(arguments);},_addOptionItem:function(){},_removeOptionItem:function(){},_setDisplay:function(){},_getChildren:function(){return [];},_getSelectedOptionsAttr:function(){return this.getOptions({selected:true});},_pseudoLoadChildren:function(){},onSetStore:function(){}});return _a58;});},"dijit/form/Select":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../DropDownMenu","../MenuItem","../MenuSeparator","../Tooltip","../_KeyNavMixin","../registry","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(_a89,_a8a,_a8b,_a8c,_a8d,i18n,keys,lang,on,has,_a8e,_a8f,_a90,_a91,_a92,_a93,_a94,_a95,_a96){var _a97=_a8a("dijit.form._SelectMenu",_a90,{autoFocus:true,buildRendering:function(){this.inherited(arguments);this.domNode.setAttribute("role","listbox");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));},focus:function(){var _a98=false,val=this.parentWidget.value;if(lang.isArray(val)){val=val[val.length-1];}if(val){_a89.forEach(this.parentWidget._getChildren(),function(_a99){if(_a99.option&&(val===_a99.option.value)){_a98=true;this.focusChild(_a99,false);}},this);}if(!_a98){this.inherited(arguments);}}});var _a9a=_a8a("dijit.form.Select"+(has("dojo-bidi")?"_NoBidi":""),[_a8e,_a8f,_a94],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_a96,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,labelType:"html",_fillContent:function(){this.inherited(arguments);if(this.options.length&&!this.value&&this.srcNodeRef){var si=this.srcNodeRef.selectedIndex||0;this._set("value",this.options[si>=0?si:0].value);}this.dropDown=new _a97({id:this.id+"_menu",parentWidget:this});_a8c.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));},_getMenuItemForOption:function(_a9b){if(!_a9b.value&&!_a9b.label){return new _a92({ownerDocument:this.ownerDocument});}else{var _a9c=lang.hitch(this,"_setValueAttr",_a9b);var item=new _a91({option:_a9b,label:(this.labelType==="text"?(_a9b.label||"").toString().replace(/&/g,"&amp;").replace(/</g,"&lt;"):_a9b.label)||this.emptyLabel,onClick:_a9c,ownerDocument:this.ownerDocument,dir:this.dir,textDir:this.textDir,disabled:_a9b.disabled||false});item.focusNode.setAttribute("role","option");return item;}},_addOptionItem:function(_a9d){if(this.dropDown){this.dropDown.addChild(this._getMenuItemForOption(_a9d));}},_getChildren:function(){if(!this.dropDown){return [];}return this.dropDown.getChildren();},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},focusChild:function(_a9e){if(_a9e){this.set("value",_a9e.option);}},_getFirst:function(){var _a9f=this._getChildren();return _a9f.length?_a9f[0]:null;},_getLast:function(){var _aa0=this._getChildren();return _aa0.length?_aa0[_aa0.length-1]:null;},childSelector:function(node){var node=_a95.byNode(node);return node&&node.getParent()==this.dropDown;},onKeyboardSearch:function(item,evt,_aa1,_aa2){if(item){this.focusChild(item);}},_loadChildren:function(_aa3){if(_aa3===true){if(this.dropDown){delete this.dropDown.focusedChild;this.focusedChild=null;}if(this.options.length){this.inherited(arguments);}else{_a89.forEach(this._getChildren(),function(_aa4){_aa4.destroyRecursive();});var item=new _a91({ownerDocument:this.ownerDocument,label:this.emptyLabel});this.dropDown.addChild(item);}}else{this._updateSelection();}this._isLoaded=false;this._childrenLoaded=true;if(!this._loadingStore){this._setValueAttr(this.value,false);}},_refreshState:function(){if(this._started){this.validate(this.focused);}},startup:function(){this.inherited(arguments);this._refreshState();},_setValueAttr:function(_aa5){this.inherited(arguments);_a8b.set(this.valueNode,"value",this.get("value"));this._refreshState();},_setNameAttr:"valueNode",_setDisabledAttr:function(_aa6){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_aa7){this._set("required",_aa7);this.focusNode.setAttribute("aria-required",_aa7);this._refreshState();},_setOptionsAttr:function(_aa8){this._isLoaded=false;this._set("options",_aa8);},_setDisplay:function(_aa9){var lbl=(this.labelType==="text"?(_aa9||"").replace(/&/g,"&amp;").replace(/</g,"&lt;"):_aa9)||this.emptyLabel;this.containerNode.innerHTML="<span role=\"option\" aria-selected=\"true\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";},validate:function(_aaa){var _aab=this.disabled||this.isValid(_aaa);this._set("state",_aab?"":(this._hasBeenBlurred?"Error":"Incomplete"));this.focusNode.setAttribute("aria-invalid",_aab?"false":"true");var _aac=_aab?"":this._missingMsg;if(_aac&&this.focused&&this._hasBeenBlurred){_a93.show(_aac,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_a93.hide(this.domNode);}this._set("message",_aac);return _aab;},isValid:function(){return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));},reset:function(){this.inherited(arguments);_a93.hide(this.domNode);this._refreshState();},postMixInProperties:function(){this.inherited(arguments);this._missingMsg=i18n.getLocalization("dijit.form","validate",this.lang).missingMessage;},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));this.domNode.setAttribute("aria-expanded","false");var _aad=this._keyNavCodes;delete _aad[keys.LEFT_ARROW];delete _aad[keys.RIGHT_ARROW];},_setStyleAttr:function(_aae){this.inherited(arguments);_a8c.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);},isLoaded:function(){return this._isLoaded;},loadDropDown:function(_aaf){this._loadChildren(true);this._isLoaded=true;_aaf();},destroy:function(_ab0){if(this.dropDown&&!this.dropDown._destroyed){this.dropDown.destroyRecursive(_ab0);delete this.dropDown;}_a93.hide(this.domNode);this.inherited(arguments);},_onFocus:function(){this.validate(true);},_onBlur:function(){_a93.hide(this.domNode);this.inherited(arguments);this.validate(false);}});if(has("dojo-bidi")){_a9a=_a8a("dijit.form.Select",_a9a,{_setDisplay:function(_ab1){this.inherited(arguments);this.applyTextDir(this.containerNode);}});}_a9a._Menu=_a97;function _ab2(_ab3){return function(evt){if(!this._isLoaded){this.loadDropDown(lang.hitch(this,_ab3,evt));}else{this.inherited(_ab3,arguments);}};};_a9a.prototype._onContainerKeydown=_ab2("_onContainerKeydown");_a9a.prototype._onContainerKeypress=_ab2("_onContainerKeypress");return _a9a;});},"dojo/store/util/QueryResults":function(){define(["../../_base/array","../../_base/lang","../../when"],function(_ab4,lang,when){var _ab5=function(_ab6){if(!_ab6){return _ab6;}var _ab7=!!_ab6.then;if(_ab7){_ab6=lang.delegate(_ab6);}function _ab8(_ab9){_ab6[_ab9]=function(){var args=arguments;var _aba=when(_ab6,function(_abb){Array.prototype.unshift.call(args,_abb);return _ab5(_ab4[_ab9].apply(_ab4,args));});if(_ab9!=="forEach"||_ab7){return _aba;}};};_ab8("forEach");_ab8("filter");_ab8("map");if(_ab6.total==null){_ab6.total=when(_ab6,function(_abc){return _abc.length;});}return _ab6;};lang.setObject("dojo.store.util.QueryResults",_ab5);return _ab5;});},"dijit/_KeyNavMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dijit/registry","dijit/_FocusMixin"],function(_abd,_abe,_abf,keys,lang,on,_ac0,_ac1){return _abe("dijit._KeyNavMixin",_ac1,{tabIndex:"0",childSelector:null,postCreate:function(){this.inherited(arguments);_abf.set(this.domNode,"tabIndex",this.tabIndex);if(!this._keyNavCodes){var _ac2=this._keyNavCodes={};_ac2[keys.HOME]=lang.hitch(this,"focusFirstChild");_ac2[keys.END]=lang.hitch(this,"focusLastChild");_ac2[this.isLeftToRight()?keys.LEFT_ARROW:keys.RIGHT_ARROW]=lang.hitch(this,"_onLeftArrow");_ac2[this.isLeftToRight()?keys.RIGHT_ARROW:keys.LEFT_ARROW]=lang.hitch(this,"_onRightArrow");_ac2[keys.UP_ARROW]=lang.hitch(this,"_onUpArrow");_ac2[keys.DOWN_ARROW]=lang.hitch(this,"_onDownArrow");}var self=this,_ac3=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.domNode,"keypress",lang.hitch(this,"_onContainerKeypress")),on(this.domNode,"keydown",lang.hitch(this,"_onContainerKeydown")),on(this.domNode,"focus",lang.hitch(this,"_onContainerFocus")),on(this.containerNode,on.selector(_ac3,"focusin"),function(evt){self._onChildFocus(_ac0.getEnclosingWidget(this),evt);}));},_onLeftArrow:function(){},_onRightArrow:function(){},_onUpArrow:function(){},_onDownArrow:function(){},focus:function(){this.focusFirstChild();},_getFirstFocusableChild:function(){return this._getNextFocusableChild(null,1);},_getLastFocusableChild:function(){return this._getNextFocusableChild(null,-1);},focusFirstChild:function(){this.focusChild(this._getFirstFocusableChild());},focusLastChild:function(){this.focusChild(this._getLastFocusableChild());},focusChild:function(_ac4,last){if(!_ac4){return;}if(this.focusedChild&&_ac4!==this.focusedChild){this._onChildBlur(this.focusedChild);}_ac4.set("tabIndex",this.tabIndex);_ac4.focus(last?"end":"start");},_onContainerFocus:function(evt){if(evt.target!==this.domNode||this.focusedChild){return;}this.focus();},_onFocus:function(){_abf.set(this.domNode,"tabIndex","-1");this.inherited(arguments);},_onBlur:function(evt){_abf.set(this.domNode,"tabIndex",this.tabIndex);if(this.focusedChild){this.focusedChild.set("tabIndex","-1");this.lastFocusedChild=this.focusedChild;this._set("focusedChild",null);}this.inherited(arguments);},_onChildFocus:function(_ac5){if(_ac5&&_ac5!=this.focusedChild){if(this.focusedChild&&!this.focusedChild._destroyed){this.focusedChild.set("tabIndex","-1");}_ac5.set("tabIndex",this.tabIndex);this.lastFocused=_ac5;this._set("focusedChild",_ac5);}},_searchString:"",multiCharSearchDuration:1000,onKeyboardSearch:function(item,evt,_ac6,_ac7){if(item){this.focusChild(item);}},_keyboardSearchCompare:function(item,_ac8){var _ac9=item.domNode,text=item.label||(_ac9.focusNode?_ac9.focusNode.label:"")||_ac9.innerText||_ac9.textContent||"",_aca=text.replace(/^\s+/,"").substr(0,_ac8.length).toLowerCase();return (!!_ac8.length&&_aca==_ac8)?-1:0;},_onContainerKeydown:function(evt){var func=this._keyNavCodes[evt.keyCode];if(func){func(evt,this.focusedChild);evt.stopPropagation();evt.preventDefault();this._searchString="";}else{if(evt.keyCode==keys.SPACE&&this._searchTimer&&!(evt.ctrlKey||evt.altKey||evt.metaKey)){evt.stopImmediatePropagation();evt.preventDefault();this._keyboardSearch(evt," ");}}},_onContainerKeypress:function(evt){if(evt.charCode<=keys.SPACE||evt.ctrlKey||evt.altKey||evt.metaKey){return;}evt.preventDefault();evt.stopPropagation();this._keyboardSearch(evt,String.fromCharCode(evt.charCode).toLowerCase());},_keyboardSearch:function(evt,_acb){var _acc=null,_acd,_ace=0,_acf=lang.hitch(this,function(){if(this._searchTimer){this._searchTimer.remove();}this._searchString+=_acb;var _ad0=/^(.)\1*$/.test(this._searchString);var _ad1=_ad0?1:this._searchString.length;_acd=this._searchString.substr(0,_ad1);this._searchTimer=this.defer(function(){this._searchTimer=null;this._searchString="";},this.multiCharSearchDuration);var _ad2=this.focusedChild||null;if(_ad1==1||!_ad2){_ad2=this._getNextFocusableChild(_ad2,1);if(!_ad2){return;}}var stop=_ad2;do{var rc=this._keyboardSearchCompare(_ad2,_acd);if(!!rc&&_ace++==0){_acc=_ad2;}if(rc==-1){_ace=-1;break;}_ad2=this._getNextFocusableChild(_ad2,1);}while(_ad2&&_ad2!=stop);});_acf();this.onKeyboardSearch(_acc,evt,_acd,_ace);},_onChildBlur:function(){},_getNextFocusableChild:function(_ad3,dir){var _ad4=_ad3;do{if(!_ad3){_ad3=this[dir>0?"_getFirst":"_getLast"]();if(!_ad3){break;}}else{_ad3=this._getNext(_ad3,dir);}if(_ad3!=null&&_ad3!=_ad4&&_ad3.isFocusable()){return _ad3;}}while(_ad3!=_ad4);return null;},_getFirst:function(){return null;},_getLast:function(){return null;},_getNext:function(_ad5,dir){if(_ad5){_ad5=_ad5.domNode;while(_ad5){_ad5=_ad5[dir<0?"previousSibling":"nextSibling"];if(_ad5&&"getAttribute" in _ad5){var w=_ac0.byNode(_ad5);if(w){return w;}}}}return null;}});});},"dijit/form/_ListBase":function(){define(["dojo/_base/declare","dojo/on","dojo/window"],function(_ad6,on,_ad7){return _ad6("dijit.form._ListBase",null,{selected:null,_listConnect:function(_ad8,_ad9){var self=this;return self.own(on(self.containerNode,on.selector(function(_ada,_adb,_adc){return _ada.parentNode==_adc;},_ad8),function(evt){self[_ad9](evt,this);}));},selectFirstNode:function(){var _add=this.containerNode.firstChild;while(_add&&_add.style.display=="none"){_add=_add.nextSibling;}this._setSelectedAttr(_add,true);},selectLastNode:function(){var last=this.containerNode.lastChild;while(last&&last.style.display=="none"){last=last.previousSibling;}this._setSelectedAttr(last,true);},selectNextNode:function(){var _ade=this.selected;if(!_ade){this.selectFirstNode();}else{var next=_ade.nextSibling;while(next&&next.style.display=="none"){next=next.nextSibling;}if(!next){this.selectFirstNode();}else{this._setSelectedAttr(next,true);}}},selectPreviousNode:function(){var _adf=this.selected;if(!_adf){this.selectLastNode();}else{var prev=_adf.previousSibling;while(prev&&prev.style.display=="none"){prev=prev.previousSibling;}if(!prev){this.selectLastNode();}else{this._setSelectedAttr(prev,true);}}},_setSelectedAttr:function(node,_ae0){if(this.selected!=node){var _ae1=this.selected;if(_ae1){this.onDeselect(_ae1);}if(node){if(_ae0){_ad7.scrollIntoView(node);}this.onSelect(node);}this._set("selected",node);}else{if(node){this.onSelect(node);}}}});});},"dijit/form/_FormWidget":function(){define(["dojo/_base/declare","dojo/sniff","dojo/_base/kernel","dojo/ready","../_Widget","../_CssStateMixin","../_TemplatedMixin","./_FormWidgetMixin"],function(_ae2,has,_ae3,_ae4,_ae5,_ae6,_ae7,_ae8){if(has("dijit-legacy-requires")){_ae4(0,function(){var _ae9=["dijit/form/_FormValueWidget"];require(_ae9);});}return _ae2("dijit.form._FormWidget",[_ae5,_ae7,_ae6,_ae8],{setDisabled:function(_aea){_ae3.deprecated("setDisabled("+_aea+") is deprecated. Use set('disabled',"+_aea+") instead.","","2.0");this.set("disabled",_aea);},setValue:function(_aeb){_ae3.deprecated("dijit.form._FormWidget:setValue("+_aeb+") is deprecated.  Use set('value',"+_aeb+") instead.","","2.0");this.set("value",_aeb);},getValue:function(){_ae3.deprecated(this.declaredClass+"::getValue() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},postMixInProperties:function(){this.nameAttrSetting=(this.name&&!has("msapp"))?("name=\""+this.name.replace(/"/g,"&quot;")+"\""):"";this.inherited(arguments);}});});},"dojo/dnd/common":function(){define(["../sniff","../_base/kernel","../_base/lang","../dom"],function(has,_aec,lang,dom){var _aed=lang.getObject("dojo.dnd",true);_aed.getCopyKeyState=function(evt){return evt[has("mac")?"metaKey":"ctrlKey"];};_aed._uniqueId=0;_aed.getUniqueId=function(){var id;do{id=_aec._scopeName+"Unique"+(++_aed._uniqueId);}while(dom.byId(id));return id;};_aed._empty={};_aed.isFormElement=function(e){var t=e.target;if(t.nodeType==3){t=t.parentNode;}return " a button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;};return _aed;});},"dijit/CheckedMenuItem":function(){define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_aee,_aef,_af0,_af1){return _aee("dijit.CheckedMenuItem",_af0,{baseClass:"dijitMenuItem dijitCheckedMenuItem",templateString:_af1,checked:false,_setCheckedAttr:function(_af2){this.domNode.setAttribute("aria-checked",_af2?"true":"false");this._set("checked",_af2);},iconClass:"",role:"menuitemcheckbox",checkedChar:"&#10003;",onChange:function(){},_onClick:function(evt){if(!this.disabled){this.set("checked",!this.checked);this.onChange(this.checked);}this.onClick(evt);}});});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_af3,on,_af4,has,_af5){var _af6=new _af3();var _af7;_af4(function(){var _af8=_af5.getBox();_af6._rlh=on(window,"resize",function(){var _af9=_af5.getBox();if(_af8.h==_af9.h&&_af8.w==_af9.w){return;}_af8=_af9;_af6.emit("resize");});if(has("ie")==8){var _afa=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_afa){_afa=screen.deviceXDPI;_af6.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_af7=evt.target;});on(document,"focusout",function(evt){_af7=null;});}});_af6.getEffectiveBox=function(doc){var box=_af5.getBox(doc);var tag=_af7&&_af7.tagName&&_af7.tagName.toLowerCase();if(has("ios")&&_af7&&!_af7.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_af7.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_af7.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _af6;});},"dijit/_base/place":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/window","../place","../main"],function(_afb,lang,_afc,_afd,_afe){var _aff={};_aff.getViewport=function(){return _afc.getBox();};_aff.placeOnScreen=_afd.at;_aff.placeOnScreenAroundElement=function(node,_b00,_b01,_b02){var _b03;if(lang.isArray(_b01)){_b03=_b01;}else{_b03=[];for(var key in _b01){_b03.push({aroundCorner:key,corner:_b01[key]});}}return _afd.around(node,_b00,_b03,true,_b02);};_aff.placeOnScreenAroundNode=_aff.placeOnScreenAroundElement;_aff.placeOnScreenAroundRectangle=_aff.placeOnScreenAroundElement;_aff.getPopupAroundAlignment=function(_b04,_b05){var _b06={};_afb.forEach(_b04,function(pos){var ltr=_b05;switch(pos){case "after":_b06[_b05?"BR":"BL"]=_b05?"BL":"BR";break;case "before":_b06[_b05?"BL":"BR"]=_b05?"BR":"BL";break;case "below-alt":ltr=!ltr;case "below":_b06[ltr?"BL":"BR"]=ltr?"TL":"TR";_b06[ltr?"BR":"BL"]=ltr?"TR":"TL";break;case "above-alt":ltr=!ltr;case "above":default:_b06[ltr?"TL":"TR"]=ltr?"BL":"BR";_b06[ltr?"TR":"TL"]=ltr?"BR":"BL";break;}});return _b06;};lang.mixin(_afe,_aff);return _afe;});},"dijit/MenuSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_b07,dom,_b08,_b09,_b0a,_b0b){return _b07("dijit.MenuSeparator",[_b08,_b09,_b0a],{templateString:_b0b,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/form/_ComboBoxMenu":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_b0c,_b0d,_b0e,keys,_b0f,_b10,_b11,_b12){return _b0c("dijit.form._ComboBoxMenu",[_b0f,_b10,_b12,_b11],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;' role='listbox'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",postCreate:function(){this.inherited(arguments);if(!this.isLeftToRight()){_b0d.add(this.previousButton,"dijitMenuItemRtl");_b0d.add(this.nextButton,"dijitMenuItemRtl");}this.containerNode.setAttribute("role","listbox");},_createMenuItem:function(){var item=this.ownerDocument.createElement("div");item.className="dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl");item.setAttribute("role","option");return item;},onHover:function(node){_b0d.add(node,"dijitMenuItemHover");},onUnhover:function(node){_b0d.remove(node,"dijitMenuItemHover");},onSelect:function(node){_b0d.add(node,"dijitMenuItemSelected");},onDeselect:function(node){_b0d.remove(node,"dijitMenuItemSelected");},_page:function(up){var _b13=0;var _b14=this.domNode.scrollTop;var _b15=_b0e.get(this.domNode,"height");if(!this.getHighlightedOption()){this.selectNextNode();}while(_b13<_b15){var _b16=this.getHighlightedOption();if(up){if(!_b16.previousSibling||_b16.previousSibling.style.display=="none"){break;}this.selectPreviousNode();}else{if(!_b16.nextSibling||_b16.nextSibling.style.display=="none"){break;}this.selectNextNode();}var _b17=this.domNode.scrollTop;_b13+=(_b17-_b14)*(up?-1:1);_b14=_b17;}},handleKey:function(evt){switch(evt.keyCode){case keys.DOWN_ARROW:this.selectNextNode();return false;case keys.PAGE_DOWN:this._page(false);return false;case keys.UP_ARROW:this.selectPreviousNode();return false;case keys.PAGE_UP:this._page(true);return false;default:return true;}}});});},"dijit/Dialog":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/touch","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","./layout/utils","dojo/text!./templates/Dialog.html","./a11yclick","dojo/i18n!./nls/common"],function(_b18,_b19,_b1a,_b1b,_b1c,dom,_b1d,_b1e,_b1f,fx,i18n,keys,lang,on,_b20,has,_b21,_b22,_b23,_b24,_b25,_b26,_b27,_b28,_b29,_b2a,_b2b,_b2c,_b2d,_b2e,_b2f){var _b30=new _b1c();_b30.resolve(true);function nop(){};var _b31=_b1b("dijit._DialogBase"+(has("dojo-bidi")?"_NoBidi":""),[_b28,_b2a,_b2b,_b29],{templateString:_b2f,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:false,duration:_b26.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,draggable:true,_setDraggableAttr:function(val){this._set("draggable",val);},maxRatio:0.9,closable:true,_setClosableAttr:function(val){this.closeButtonNode.style.display=val?"":"none";this._set("closable",val);},postMixInProperties:function(){var _b32=i18n.getLocalization("dijit","common");lang.mixin(this,_b32);this.inherited(arguments);},postCreate:function(){_b1f.set(this.domNode,{display:"none",position:"absolute"});this.ownerDocumentBody.appendChild(this.domNode);this.inherited(arguments);_b1a.after(this,"onExecute",lang.hitch(this,"hide"),true);_b1a.after(this,"onCancel",lang.hitch(this,"hide"),true);on(this.closeButtonNode,_b21.press,function(e){e.stopPropagation();});this._modalconnects=[];},onLoad:function(){this.resize();this._position();if(this.autofocus&&_b33.isTop(this)){this._getFocusItems();_b25.focus(this._firstFocusItem);}this.inherited(arguments);},focus:function(){this._getFocusItems();_b25.focus(this._firstFocusItem);},_endDrag:function(){var _b34=_b1e.position(this.domNode),_b35=_b22.getBox(this.ownerDocument);_b34.y=Math.min(Math.max(_b34.y,0),(_b35.h-_b34.h));_b34.x=Math.min(Math.max(_b34.x,0),(_b35.w-_b34.w));this._relativePosition=_b34;this._position();},_setup:function(){var node=this.domNode;if(this.titleBar&&this.draggable){this._moveable=new ((has("ie")==6)?_b24:_b23)(node,{handle:this.titleBar});_b1a.after(this._moveable,"onMoveStop",lang.hitch(this,"_endDrag"),true);}else{_b1d.add(node,"dijitDialogFixed");}this.underlayAttrs={dialogId:this.id,"class":_b19.map(this["class"].split(/\s/),function(s){return s+"_underlay";}).join(" "),_onKeyDown:lang.hitch(this,"_onKey"),ownerDocument:this.ownerDocument};},_size:function(){this.resize();},_position:function(){if(!_b1d.contains(this.ownerDocumentBody,"dojoMove")){var node=this.domNode,_b36=_b22.getBox(this.ownerDocument),p=this._relativePosition,bb=_b1e.position(node),l=Math.floor(_b36.l+(p?Math.min(p.x,_b36.w-bb.w):(_b36.w-bb.w)/2)),t=Math.floor(_b36.t+(p?Math.min(p.y,_b36.h-bb.h):(_b36.h-bb.h)/2));_b1f.set(node,{left:l+"px",top:t+"px"});}},_onKey:function(evt){if(evt.keyCode==keys.TAB){this._getFocusItems();var node=evt.target;if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_b25.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_b25.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}}}}else{if(this.closable&&evt.keyCode==keys.ESCAPE){this.onCancel();evt.stopPropagation();evt.preventDefault();}}},show:function(){if(this.open){return _b30.promise;}if(!this._started){this.startup();}if(!this._alreadyInitialized){this._setup();this._alreadyInitialized=true;}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();_b33.hide(this);}var win=_b22.get(this.ownerDocument);this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize",null)));this._modalconnects.push(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));_b1f.set(this.domNode,{opacity:0,display:""});this._set("open",true);this._onShow();this.resize();this._position();var _b37;this._fadeInDeferred=new _b1c(lang.hitch(this,function(){_b37.stop();delete this._fadeInDeferred;}));this._fadeInDeferred.then(undefined,nop);var _b38=this._fadeInDeferred.promise;_b37=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){_b33.show(this,this.underlayAttrs);}),onEnd:lang.hitch(this,function(){if(this.autofocus&&_b33.isTop(this)){this._getFocusItems();_b25.focus(this._firstFocusItem);}this._fadeInDeferred.resolve(true);delete this._fadeInDeferred;})}).play();return _b38;},hide:function(){if(!this._alreadyInitialized||!this.open){return _b30.promise;}if(this._fadeInDeferred){this._fadeInDeferred.cancel();}var _b39;this._fadeOutDeferred=new _b1c(lang.hitch(this,function(){_b39.stop();delete this._fadeOutDeferred;}));this._fadeOutDeferred.then(undefined,nop);this._fadeOutDeferred.then(lang.hitch(this,"onHide"));var _b3a=this._fadeOutDeferred.promise;_b39=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){this.domNode.style.display="none";_b33.hide(this);this._fadeOutDeferred.resolve(true);delete this._fadeOutDeferred;})}).play();if(this._scrollConnected){this._scrollConnected=false;}var h;while(h=this._modalconnects.pop()){h.remove();}if(this._relativePosition){delete this._relativePosition;}this._set("open",false);return _b3a;},resize:function(dim){if(this.domNode.style.display!="none"){this._checkIfSingleChild();if(!dim){if(this._shrunk){if(this._singleChild){if(typeof this._singleChildOriginalStyle!="undefined"){this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;delete this._singleChildOriginalStyle;}}_b19.forEach([this.domNode,this.containerNode,this.titleBar,this.actionBarNode],function(node){if(node){_b1f.set(node,{position:"static",width:"auto",height:"auto"});}});this.domNode.style.position="absolute";}var _b3b=_b22.getBox(this.ownerDocument);_b3b.w*=this.maxRatio;_b3b.h*=this.maxRatio;var bb=_b1e.position(this.domNode);this._shrunk=false;if(bb.w>=_b3b.w){dim={w:_b3b.w};_b1e.setMarginBox(this.domNode,dim);bb=_b1e.position(this.domNode);this._shrunk=true;}if(bb.h>=_b3b.h){if(!dim){dim={w:bb.w};}dim.h=_b3b.h;this._shrunk=true;}if(dim){if(!dim.w){dim.w=bb.w;}if(!dim.h){dim.h=bb.h;}}}if(dim){_b1e.setMarginBox(this.domNode,dim);var _b3c=[];if(this.titleBar){_b3c.push({domNode:this.titleBar,region:"top"});}if(this.actionBarNode){_b3c.push({domNode:this.actionBarNode,region:"bottom"});}var _b3d={domNode:this.containerNode,region:"center"};_b3c.push(_b3d);var _b3e=_b2e.marginBox2contentBox(this.domNode,dim);_b2e.layoutChildren(this.domNode,_b3e,_b3c);if(this._singleChild){var cb=_b2e.marginBox2contentBox(this.containerNode,_b3d);this._singleChild.resize({w:cb.w,h:cb.h});}else{this.containerNode.style.overflow="auto";this._layoutChildren();}}else{this._layoutChildren();}if(!has("touch")&&!dim){this._position();}}},_layoutChildren:function(){_b19.forEach(this.getChildren(),function(_b3f){if(_b3f.resize){_b3f.resize();}});},destroy:function(){if(this._fadeInDeferred){this._fadeInDeferred.cancel();}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();}if(this._moveable){this._moveable.destroy();}var h;while(h=this._modalconnects.pop()){h.remove();}_b33.hide(this);this.inherited(arguments);}});if(has("dojo-bidi")){_b31=_b1b("dijit._DialogBase",_b31,{_setTitleAttr:function(_b40){this._set("title",_b40);this.titleNode.innerHTML=_b40;this.applyTextDir(this.titleNode);},_setTextDirAttr:function(_b41){if(this._created&&this.textDir!=_b41){this._set("textDir",_b41);this.set("title",this.title);}}});}var _b42=_b1b("dijit.Dialog",[_b2d,_b31],{});_b42._DialogBase=_b31;var _b33=_b42._DialogLevelManager={_beginZIndex:950,show:function(_b43,_b44){ds[ds.length-1].focus=_b25.curNode;var _b45=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_b42._DialogLevelManager._beginZIndex;_b1f.set(_b43.domNode,"zIndex",_b45);_b2c.show(_b44,_b45-1);ds.push({dialog:_b43,underlayAttrs:_b44,zIndex:_b45});},hide:function(_b46){if(ds[ds.length-1].dialog==_b46){ds.pop();var pd=ds[ds.length-1];if(ds.length==1){_b2c.hide();}else{_b2c.show(pd.underlayAttrs,pd.zIndex-1);}if(_b46.refocus){var _b47=pd.focus;if(pd.dialog&&(!_b47||!dom.isDescendant(_b47,pd.dialog.domNode))){pd.dialog._getFocusItems();_b47=pd.dialog._firstFocusItem;}if(_b47){try{_b47.focus();}catch(e){}}}}else{var idx=_b19.indexOf(_b19.map(ds,function(elem){return elem.dialog;}),_b46);if(idx!=-1){ds.splice(idx,1);}}},isTop:function(_b48){return ds[ds.length-1].dialog==_b48;}};var ds=_b42._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];_b25.watch("curNode",function(attr,_b49,node){var _b4a=ds[ds.length-1].dialog;if(node&&_b4a&&!_b4a._fadeOutDeferred&&node.ownerDocument==_b4a.ownerDocument){do{if(node==_b4a.domNode||_b1d.contains(node,"dijitPopup")){return;}}while(node=node.parentNode);_b4a.focus();}});if(has("dijit-legacy-requires")){_b20(0,function(){var _b4b=["dijit/TooltipDialog"];_b18(_b4b);});}return _b42;});},"dijit/form/MultiSelect":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/sniff","dojo/query","./_FormValueWidget","dojo/NodeList-dom"],function(_b4c,_b4d,_b4e,has,_b4f,_b50){var _b51=_b4d("dijit.form.MultiSelect"+(has("dojo-bidi")?"_NoBidi":""),_b50,{size:7,baseClass:"dijitMultiSelect",templateString:"<select multiple='multiple' ${!nameAttrSetting} data-dojo-attach-point='containerNode,focusNode' data-dojo-attach-event='onchange: _onChange'></select>",addSelected:function(_b52){_b52.getSelected().forEach(function(n){this.containerNode.appendChild(n);this.domNode.scrollTop=this.domNode.offsetHeight;var _b53=_b52.domNode.scrollTop;_b52.domNode.scrollTop=0;_b52.domNode.scrollTop=_b53;},this);this._set("value",this.get("value"));},getSelected:function(){return _b4f("option",this.containerNode).filter(function(n){return n.selected;});},_getValueAttr:function(){return _b4c.map(this.getSelected(),function(n){return n.value;});},multiple:true,_setMultipleAttr:function(val){},_setValueAttr:function(_b54){if(has("android")){_b4f("option",this.containerNode).orphan().forEach(function(n){var _b55=n.ownerDocument.createElement("option");_b55.value=n.value;_b55.selected=(_b4c.indexOf(_b54,n.value)!=-1);_b55.text=n.text;_b55.originalText=n.originalText;this.containerNode.appendChild(_b55);},this);}else{_b4f("option",this.containerNode).forEach(function(n){n.selected=(_b4c.indexOf(_b54,n.value)!=-1);});}this.inherited(arguments);},invertSelection:function(_b56){var val=[];_b4f("option",this.containerNode).forEach(function(n){if(!n.selected){val.push(n.value);}});this._setValueAttr(val,!(_b56===false||_b56==null));},_onChange:function(){this._handleOnChange(this.get("value"),true);},resize:function(size){if(size){_b4e.setMarginBox(this.domNode,size);}},postCreate:function(){this._set("value",this.get("value"));this.inherited(arguments);}});if(has("dojo-bidi")){_b51=_b4d("dijit.form.MultiSelect",_b51,{addSelected:function(_b57){_b57.getSelected().forEach(function(n){n.text=this.enforceTextDirWithUcc(this.restoreOriginalText(n),n.text);},this);this.inherited(arguments);},_setTextDirAttr:function(_b58){if((this.textDir!=_b58||!this._created)&&this.enforceTextDirWithUcc){this._set("textDir",_b58);_b4f("option",this.containerNode).forEach(function(_b59){if(!this._created&&_b59.value===_b59.text){_b59.value=_b59.text;}_b59.text=this.enforceTextDirWithUcc(_b59,_b59.originalText||_b59.text);},this);}}});}return _b51;});},"dijit/_base/focus":function(){define(["dojo/_base/array","dojo/dom","dojo/_base/lang","dojo/topic","dojo/_base/window","../focus","../selection","../main"],function(_b5a,dom,lang,_b5b,win,_b5c,_b5d,_b5e){var _b5f={_curFocus:null,_prevFocus:null,isCollapsed:function(){return _b5e.getBookmark().isCollapsed;},getBookmark:function(){var sel=win.global==window?_b5d:new _b5d.SelectionManager(win.global);return sel.getBookmark();},moveToBookmark:function(_b60){var sel=win.global==window?_b5d:new _b5d.SelectionManager(win.global);return sel.moveToBookmark(_b60);},getFocus:function(menu,_b61){var node=!_b5c.curNode||(menu&&dom.isDescendant(_b5c.curNode,menu.domNode))?_b5e._prevFocus:_b5c.curNode;return {node:node,bookmark:node&&(node==_b5c.curNode)&&win.withGlobal(_b61||win.global,_b5e.getBookmark),openedForWindow:_b61};},_activeStack:[],registerIframe:function(_b62){return _b5c.registerIframe(_b62);},unregisterIframe:function(_b63){_b63&&_b63.remove();},registerWin:function(_b64,_b65){return _b5c.registerWin(_b64,_b65);},unregisterWin:function(_b66){_b66&&_b66.remove();}};_b5c.focus=function(_b67){if(!_b67){return;}var node="node" in _b67?_b67.node:_b67,_b68=_b67.bookmark,_b69=_b67.openedForWindow,_b6a=_b68?_b68.isCollapsed:false;if(node){var _b6b=(node.tagName.toLowerCase()=="iframe")?node.contentWindow:node;if(_b6b&&_b6b.focus){try{_b6b.focus();}catch(e){}}_b5c._onFocusNode(node);}if(_b68&&win.withGlobal(_b69||win.global,_b5e.isCollapsed)&&!_b6a){if(_b69){_b69.focus();}try{win.withGlobal(_b69||win.global,_b5e.moveToBookmark,null,[_b68]);}catch(e2){}}};_b5c.watch("curNode",function(name,_b6c,_b6d){_b5e._curFocus=_b6d;_b5e._prevFocus=_b6c;if(_b6d){_b5b.publish("focusNode",_b6d);}});_b5c.watch("activeStack",function(name,_b6e,_b6f){_b5e._activeStack=_b6f;});_b5c.on("widget-blur",function(_b70,by){_b5b.publish("widgetBlur",_b70,by);});_b5c.on("widget-focus",function(_b71,by){_b5b.publish("widgetFocus",_b71,by);});lang.mixin(_b5e,_b5f);return _b5e;});},"dijit/tree/dndSource":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dnd/common","dojo/dom-class","dojo/dom-geometry","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","dojo/topic","dojo/dnd/Manager","./_dndSelector"],function(_b72,_b73,_b74,_b75,_b76,lang,_b77,on,_b78,_b79,_b7a,_b7b){var _b7c=_b73("dijit.tree.dndSource",_b7b,{isSource:true,accept:["text","treeNode"],copyOnly:false,dragThreshold:5,betweenThreshold:0,generateText:true,constructor:function(tree,_b7d){if(!_b7d){_b7d={};}lang.mixin(this,_b7d);var type=_b7d.accept instanceof Array?_b7d.accept:["text","treeNode"];this.accept=null;if(type.length){this.accept={};for(var i=0;i<type.length;++i){this.accept[type[i]]=1;}}this.isDragging=false;this.mouseDown=false;this.targetAnchor=null;this.targetBox=null;this.dropPosition="";this._lastX=0;this._lastY=0;this.sourceState="";if(this.isSource){_b75.add(this.node,"dojoDndSource");}this.targetState="";if(this.accept){_b75.add(this.node,"dojoDndTarget");}this.topics=[_b79.subscribe("/dnd/source/over",lang.hitch(this,"onDndSourceOver")),_b79.subscribe("/dnd/start",lang.hitch(this,"onDndStart")),_b79.subscribe("/dnd/drop",lang.hitch(this,"onDndDrop")),_b79.subscribe("/dnd/cancel",lang.hitch(this,"onDndCancel"))];},checkAcceptance:function(){return true;},copyState:function(_b7e){return this.copyOnly||_b7e;},destroy:function(){this.inherited(arguments);var h;while(h=this.topics.pop()){h.remove();}this.targetAnchor=null;},_onDragMouse:function(e,_b7f){var m=_b7a.manager(),_b80=this.targetAnchor,_b81=this.current,_b82=this.dropPosition;var _b83="Over";if(_b81&&this.betweenThreshold>0){if(!this.targetBox||_b80!=_b81){this.targetBox=_b76.position(_b81.rowNode,true);}if((e.pageY-this.targetBox.y)<=this.betweenThreshold){_b83="Before";}else{if((e.pageY-this.targetBox.y)>=(this.targetBox.h-this.betweenThreshold)){_b83="After";}}}if(_b7f||_b81!=_b80||_b83!=_b82){if(_b80){this._removeItemClass(_b80.rowNode,_b82);}if(_b81){this._addItemClass(_b81.rowNode,_b83);}if(!_b81){m.canDrop(false);}else{if(_b81==this.tree.rootNode&&_b83!="Over"){m.canDrop(false);}else{var _b84=false,_b85=false;if(m.source==this){_b85=(_b83==="Over");for(var _b86 in this.selection){var _b87=this.selection[_b86];if(_b87.item===_b81.item){_b84=true;break;}if(_b87.getParent().id!==_b81.id){_b85=false;}}}m.canDrop(!_b84&&!_b85&&!this._isParentChildDrop(m.source,_b81.rowNode)&&this.checkItemAcceptance(_b81.rowNode,m.source,_b83.toLowerCase()));}}this.targetAnchor=_b81;this.dropPosition=_b83;}},onMouseMove:function(e){if(this.isDragging&&this.targetState=="Disabled"){return;}this.inherited(arguments);var m=_b7a.manager();if(this.isDragging){this._onDragMouse(e);}else{if(this.mouseDown&&this.isSource&&(Math.abs(e.pageX-this._lastX)>=this.dragThreshold||Math.abs(e.pageY-this._lastY)>=this.dragThreshold)){var _b88=this.getSelectedTreeNodes();if(_b88.length){if(_b88.length>1){var seen=this.selection,i=0,r=[],n,p;nextitem:while((n=_b88[i++])){for(p=n.getParent();p&&p!==this.tree;p=p.getParent()){if(seen[p.id]){continue nextitem;}}r.push(n);}_b88=r;}_b88=_b72.map(_b88,function(n){return n.domNode;});m.startDrag(this,_b88,this.copyState(_b74.getCopyKeyState(e)));this._onDragMouse(e,true);}}}},onMouseDown:function(e){if(e.type=="touchstart"||_b77.isLeft(e)){this.mouseDown=true;this.mouseButton=e.button;this._lastX=e.pageX;this._lastY=e.pageY;}this.inherited(arguments);},onMouseUp:function(e){if(this.mouseDown){this.mouseDown=false;this.inherited(arguments);}},onMouseOut:function(){this.inherited(arguments);this._unmarkTargetAnchor();},checkItemAcceptance:function(){return true;},onDndSourceOver:function(_b89){if(this!=_b89){this.mouseDown=false;this._unmarkTargetAnchor();}else{if(this.isDragging){var m=_b7a.manager();m.canDrop(false);}}},onDndStart:function(_b8a,_b8b,copy){if(this.isSource){this._changeState("Source",this==_b8a?(copy?"Copied":"Moved"):"");}var _b8c=this.checkAcceptance(_b8a,_b8b);this._changeState("Target",_b8c?"":"Disabled");if(this==_b8a){_b7a.manager().overSource(this);}this.isDragging=true;},itemCreator:function(_b8d){return _b72.map(_b8d,function(node){return {"id":node.id,"name":node.textContent||node.innerText||""};});},onDndDrop:function(_b8e,_b8f,copy){if(this.containerState=="Over"){var tree=this.tree,_b90=tree.model,_b91=this.targetAnchor,_b92=false;this.isDragging=false;var _b93;var _b94;var _b95;_b93=(_b91&&_b91.item)||tree.item;if(this.dropPosition=="Before"||this.dropPosition=="After"){_b93=(_b91.getParent()&&_b91.getParent().item)||tree.item;_b94=_b91.getIndexInParent();if(this.dropPosition=="After"){_b94=_b91.getIndexInParent()+1;_b95=_b91.getNextSibling()&&_b91.getNextSibling().item;}else{_b95=_b91.item;}}else{_b93=(_b91&&_b91.item)||tree.item;_b92=true;}var _b96;_b72.forEach(_b8f,function(node,idx){var _b97=_b8e.getItem(node.id);if(_b72.indexOf(_b97.type,"treeNode")!=-1){var _b98=_b97.data,_b99=_b98.item,_b9a=_b98.getParent().item;}if(_b8e==this){if(typeof _b94=="number"){if(_b93==_b9a&&_b98.getIndexInParent()<_b94){_b94-=1;}}_b90.pasteItem(_b99,_b9a,_b93,copy,_b94,_b95);}else{if(_b90.isItem(_b99)){_b90.pasteItem(_b99,_b9a,_b93,copy,_b94,_b95);}else{if(!_b96){_b96=this.itemCreator(_b8f,_b91.rowNode,_b8e);}_b90.newItem(_b96[idx],_b93,_b94,_b95);}}},this);if(_b92){this.tree._expandNode(_b91);}}this.onDndCancel();},onDndCancel:function(){this._unmarkTargetAnchor();this.isDragging=false;this.mouseDown=false;delete this.mouseButton;this._changeState("Source","");this._changeState("Target","");},onOverEvent:function(){this.inherited(arguments);_b7a.manager().overSource(this);},onOutEvent:function(){this._unmarkTargetAnchor();var m=_b7a.manager();if(this.isDragging){m.canDrop(false);}m.outSource(this);this.inherited(arguments);},_isParentChildDrop:function(_b9b,_b9c){if(!_b9b.tree||_b9b.tree!=this.tree){return false;}var root=_b9b.tree.domNode;var ids=_b9b.selection;var node=_b9c.parentNode;while(node!=root&&!ids[node.id]){node=node.parentNode;}return node.id&&ids[node.id];},_unmarkTargetAnchor:function(){if(!this.targetAnchor){return;}this._removeItemClass(this.targetAnchor.rowNode,this.dropPosition);this.targetAnchor=null;this.targetBox=null;this.dropPosition=null;},_markDndStatus:function(copy){this._changeState("Source",copy?"Copied":"Moved");}});return _b7c;});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_b9d,dom,_b9e,_b9f,lang,has,_ba0){var _ba1;var a11y={_isElementShown:function(elem){var s=_b9f.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_b9e.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _b9e.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _ba2=elem.contentDocument;if("designMode" in _ba2&&_ba2.designMode=="on"){return true;}body=_ba2.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_b9e.get(elem,"disabled")){return _ba1;}else{if(_b9e.has(elem,"tabIndex")){return +_b9e.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_ba1;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _ba3,last,_ba4,_ba5,_ba6,_ba7,_ba8={};function _ba9(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _baa=a11y._isElementShown,_bab=a11y.effectiveTabIndex;var _bac=function(_bad){for(var _bae=_bad.firstChild;_bae;_bae=_bae.nextSibling){if(_bae.nodeType!=1||(has("ie")<=9&&_bae.scopeName!=="HTML")||!_baa(_bae)){continue;}var _baf=_bab(_bae);if(_baf>=0){if(_baf==0){if(!_ba3){_ba3=_bae;}last=_bae;}else{if(_baf>0){if(!_ba4||_baf<_ba5){_ba5=_baf;_ba4=_bae;}if(!_ba6||_baf>=_ba7){_ba7=_baf;_ba6=_bae;}}}var rn=_ba9(_bae);if(_b9e.get(_bae,"checked")&&rn){_ba8[rn]=_bae;}}if(_bae.nodeName.toUpperCase()!="SELECT"){_bac(_bae);}}};if(_baa(root)){_bac(root);}function rs(node){return _ba8[_ba9(node)]||node;};return {first:rs(_ba3),last:rs(last),lowest:rs(_ba4),highest:rs(_ba6)};},getFirstInTabbingOrder:function(root,doc){var _bb0=a11y._getTabNavigable(dom.byId(root,doc));return _bb0.lowest?_bb0.lowest:_bb0.first;},getLastInTabbingOrder:function(root,doc){var _bb1=a11y._getTabNavigable(dom.byId(root,doc));return _bb1.last?_bb1.last:_bb1.highest;}};1&&lang.mixin(_ba0,a11y);return a11y;});},"dijit/form/_ToggleButtonMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_bb2,_bb3){return _bb2("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){var _bb4=this.checked;this._set("checked",!_bb4);var ret=this.inherited(arguments);this.set("checked",ret?this.checked:_bb4);return ret;},_setCheckedAttr:function(_bb5,_bb6){this._set("checked",_bb5);var node=this.focusNode||this.domNode;if(this._created){if(_bb3.get(node,"checked")!=!!_bb5){_bb3.set(node,"checked",!!_bb5);}}node.setAttribute(this._aria_attr,String(_bb5));this._handleOnChange(_bb5,_bb6);},postCreate:function(){this.inherited(arguments);var node=this.focusNode||this.domNode;if(this.checked){node.setAttribute("checked","checked");}if(this._resetValue===undefined){this._lastValueReported=this._resetValue=this.checked;}},reset:function(){this._hasBeenBlurred=false;this.set("checked",this.params.checked||false);}});});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_bb7,_bb8,_bb9,_bba,has,_bbb,lang,_bbc,_bbd,_bbe,_bbf,_bc0,_bc1){function _bc2(){};function _bc3(_bc4){return function(obj,_bc5,_bc6,_bc7){if(obj&&typeof _bc5=="string"&&obj[_bc5]==_bc2){return obj.on(_bc5.substring(2).toLowerCase(),lang.hitch(_bc6,_bc7));}return _bc4.apply(_bb9,arguments);};};_bb7.around(_bb9,"connect",_bc3);if(_bbb.connect){_bb7.around(_bbb,"connect",_bc3);}var _bc8=_bba("dijit._Widget",[_bbf,_bc0,_bc1],{onClick:_bc2,onDblClick:_bc2,onKeyDown:_bc2,onKeyPress:_bc2,onKeyUp:_bc2,onMouseDown:_bc2,onMouseMove:_bc2,onMouseOut:_bc2,onMouseOver:_bc2,onMouseLeave:_bc2,onMouseEnter:_bc2,onMouseUp:_bc2,constructor:function(_bc9){this._toConnect={};for(var name in _bc9){if(this[name]===_bc2){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_bc9[name];delete _bc9[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_bc2){return _bb9.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_bca){_bbb.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_bca);},attr:function(name,_bcb){var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_bbb.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_bbc("[widgetId]",this.containerNode).map(_bbe.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_bbd(0,function(){var _bcc=["dijit/_base"];require(_bcc);});}return _bc8;});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_bcd,dom,_bce,lang,on,has,_bcf,_bd0,win){var ios4=has("ios")<5;var _bd1=has("pointer-events")||has("MSPointer"),_bd2=(function(){var _bd3={};for(var type in {down:1,move:1,up:1,cancel:1,over:1,out:1}){_bd3[type]=has("MSPointer")?"MSPointer"+type.charAt(0).toUpperCase()+type.slice(1):"pointer"+type;}return _bd3;})();var _bd4=has("touch-events");var _bd5,_bd6,_bd7=false,_bd8,_bd9,_bda,_bdb,_bdc,_bdd;var _bde;function _bdf(_be0,_be1,_be2){if(_bd1&&_be2){return function(node,_be3){return on(node,_be2,_be3);};}else{if(_bd4){return function(node,_be4){var _be5=on(node,_be1,function(evt){_be4.call(this,evt);_bde=(new Date()).getTime();}),_be6=on(node,_be0,function(evt){if(!_bde||(new Date()).getTime()>_bde+1000){_be4.call(this,evt);}});return {remove:function(){_be5.remove();_be6.remove();}};};}else{return function(node,_be7){return on(node,_be0,_be7);};}}};function _be8(node){do{if(node.dojoClick!==undefined){return node;}}while(node=node.parentNode);};function _be9(e,_bea,_beb){if(_bcf.isRight(e)){return;}var _bec=_be8(e.target);_bd6=!e.target.disabled&&_bec&&_bec.dojoClick;if(_bd6){_bd7=(_bd6=="useTarget");_bd8=(_bd7?_bec:e.target);if(_bd7){e.preventDefault();}_bd9=e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX;_bda=e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY;_bdb=(typeof _bd6=="object"?_bd6.x:(typeof _bd6=="number"?_bd6:0))||4;_bdc=(typeof _bd6=="object"?_bd6.y:(typeof _bd6=="number"?_bd6:0))||4;if(!_bd5){_bd5=true;function _bed(e){if(_bd7){_bd6=dom.isDescendant(win.doc.elementFromPoint((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX),(e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)),_bd8);}else{_bd6=_bd6&&(e.changedTouches?e.changedTouches[0].target:e.target)==_bd8&&Math.abs((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX)-_bd9)<=_bdb&&Math.abs((e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)-_bda)<=_bdc;}};win.doc.addEventListener(_bea,function(e){if(_bcf.isRight(e)){return;}_bed(e);if(_bd7){e.preventDefault();}},true);win.doc.addEventListener(_beb,function(e){if(_bcf.isRight(e)){return;}_bed(e);if(_bd6){_bdd=(new Date()).getTime();var _bee=(_bd7?_bd8:e.target);if(_bee.tagName==="LABEL"){_bee=dom.byId(_bee.getAttribute("for"))||_bee;}var src=(e.changedTouches)?e.changedTouches[0]:e;function _bef(type){var evt=document.createEvent("MouseEvents");evt._dojo_click=true;evt.initMouseEvent(type,true,true,e.view,e.detail,src.screenX,src.screenY,src.clientX,src.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,0,null);return evt;};var _bf0=_bef("mousedown");var _bf1=_bef("mouseup");var _bf2=_bef("click");setTimeout(function(){on.emit(_bee,"mousedown",_bf0);on.emit(_bee,"mouseup",_bf1);on.emit(_bee,"click",_bf2);_bdd=(new Date()).getTime();},0);}},true);function _bf3(type){win.doc.addEventListener(type,function(e){var _bf4=e.target;if(_bd6&&!e._dojo_click&&(new Date()).getTime()<=_bdd+1000&&!(_bf4.tagName=="INPUT"&&_bce.contains(_bf4,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(_bf4.tagName!="INPUT"||(_bf4.type=="radio"&&(_bce.contains(_bf4,"dijitCheckBoxInput")||_bce.contains(_bf4,"mblRadioButton")))||(_bf4.type=="checkbox"&&(_bce.contains(_bf4,"dijitCheckBoxInput")||_bce.contains(_bf4,"mblCheckBox"))))&&_bf4.tagName!="TEXTAREA"&&_bf4.tagName!="AUDIO"&&_bf4.tagName!="VIDEO"){e.preventDefault();}}},true);};_bf3("click");_bf3("mousedown");_bf3("mouseup");}}};var _bf5;if(has("touch")){if(_bd1){_bd0(function(){win.doc.addEventListener(_bd2.down,function(evt){_be9(evt,_bd2.move,_bd2.up);},true);});}else{_bd0(function(){_bf5=win.body();win.doc.addEventListener("touchstart",function(evt){_bde=(new Date()).getTime();var _bf6=_bf5;_bf5=evt.target;on.emit(_bf6,"dojotouchout",{relatedTarget:_bf5,bubbles:true});on.emit(_bf5,"dojotouchover",{relatedTarget:_bf6,bubbles:true});_be9(evt,"touchmove","touchend");},true);function _bf7(evt){var _bf8=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_bf8.touches=evt.touches;_bf8.altKey=evt.altKey;_bf8.changedTouches=evt.changedTouches;_bf8.ctrlKey=evt.ctrlKey;_bf8.metaKey=evt.metaKey;_bf8.shiftKey=evt.shiftKey;_bf8.targetTouches=evt.targetTouches;}return _bf8;};on(win.doc,"touchmove",function(evt){_bde=(new Date()).getTime();var _bf9=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_bf9){if(_bf5!==_bf9){on.emit(_bf5,"dojotouchout",{relatedTarget:_bf9,bubbles:true});on.emit(_bf9,"dojotouchover",{relatedTarget:_bf5,bubbles:true});_bf5=_bf9;}if(!on.emit(_bf9,"dojotouchmove",_bf7(evt))){evt.preventDefault();}}});on(win.doc,"touchend",function(evt){_bde=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_bf7(evt));});});}}var _bfa={press:_bdf("mousedown","touchstart",_bd2.down),move:_bdf("mousemove","dojotouchmove",_bd2.move),release:_bdf("mouseup","dojotouchend",_bd2.up),cancel:_bdf(_bcf.leave,"touchcancel",_bd1?_bd2.cancel:null),over:_bdf("mouseover","dojotouchover",_bd2.over),out:_bdf("mouseout","dojotouchout",_bd2.out),enter:_bcf._eventHandler(_bdf("mouseover","dojotouchover",_bd2.over)),leave:_bcf._eventHandler(_bdf("mouseout","dojotouchout",_bd2.out))};1&&(dojo.touch=_bfa);return _bfa;});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_bfb,dojo,_bfc,_bfd,_bfe,dom,_bff,geom,_c00,_c01){if(!dojo.isAsync){_c00(0,function(){var _c02=["./fx/Toggler"];_c01(_c02);});}var _c03=dojo.fx={};var _c04={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _c05=function(_c06){this._index=-1;this._animations=_c06||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_bfc.forEach(this._animations,function(a){if(a){if(typeof a.duration!="undefined"){this.duration+=a.duration;}if(a.delay){this.duration+=a.delay;}}},this);};_c05.prototype=new _bfb();lang.extend(_c05,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_bfd.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_bfd.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_c07,_c08){if(!this._current){this._current=this._animations[this._index=0];}if(!_c08&&this._current.status()=="playing"){return this;}var _c09=_bfd.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_c0a=_bfd.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_c0b=_bfd.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_c09.remove();_c0a.remove();_c0b.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_bfd.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_bfd.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_bfd.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_c0c,_c0d){this.pause();var _c0e=this.duration*_c0c;this._current=null;_bfc.some(this._animations,function(a,_c0f){if(_c0e<=a.duration){this._current=a;this._index=_c0f;return true;}_c0e-=a.duration;return false;},this);if(this._current){this._current.gotoPercent(_c0e/this._current.duration);}if(_c0d){this.play();}return this;},stop:function(_c10){if(this._current){if(_c10){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_bfd.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){this.stop();if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_c05,_c04);_c03.chain=function(_c11){return new _c05(lang.isArray(_c11)?_c11:Array.prototype.slice.call(_c11,0));};var _c12=function(_c13){this._animations=_c13||[];this._connects=[];this._finished=0;this.duration=0;_bfc.forEach(_c13,function(a){var _c14=a.duration;if(a.delay){_c14+=a.delay;}if(this.duration<_c14){this.duration=_c14;}this._connects.push(_bfd.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _bfe.Animation({curve:[0,1],duration:this.duration});var self=this;_bfc.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_bfd.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_c12,{_doAction:function(_c15,args){_bfc.forEach(this._animations,function(a){a[_c15].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_c16,args){var t=this._pseudoAnimation;t[_c16].apply(t,args);},play:function(_c17,_c18){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_c19,_c1a){var ms=this.duration*_c19;_bfc.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_c1a);});this._call("gotoPercent",arguments);return this;},stop:function(_c1b){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){this.stop();_bfc.forEach(this._connects,function(_c1c){_c1c.remove();});}});lang.extend(_c12,_c04);_c03.combine=function(_c1d){return new _c12(lang.isArray(_c1d)?_c1d:Array.prototype.slice.call(_c1d,0));};_c03.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_bfe.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _c1e=_bff.get(node,"height");return Math.max(_c1e,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_bfd.after(anim,"onStop",fini,true);_bfd.after(anim,"onEnd",fini,true);return anim;};_c03.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_bfe.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_bfd.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_bfd.after(anim,"onStop",fini,true);_bfd.after(anim,"onEnd",fini,true);return anim;};_c03.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_bff.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_bfe.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_bfd.after(anim,"beforeBegin",init,true);return anim;};return _c03;});},"dojo/request":function(){define(["./request/default!"],function(_c1f){return _c1f;});},"dijit/_DialogMixin":function(){define(["dojo/_base/declare","./a11y"],function(_c20,a11y){return _c20("dijit._DialogMixin",null,{actionBarTemplate:"",execute:function(){},onCancel:function(){},onExecute:function(){},_onSubmit:function(){this.onExecute();this.execute(this.get("value"));},_getFocusItems:function(){var _c21=a11y._getTabNavigable(this.domNode);this._firstFocusItem=_c21.lowest||_c21.first||this.closeButtonNode||this.domNode;this._lastFocusItem=_c21.last||_c21.highest||this._firstFocusItem;}});});},"dijit/Tree":function(){define(["dojo/_base/array","dojo/aspect","dojo/cookie","dojo/_base/declare","dojo/Deferred","dojo/promise/all","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/errors/create","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","dojo/touch","dojo/when","./a11yclick","./focus","./registry","./_base/manager","./_Widget","./_TemplatedMixin","./_Container","./_Contained","./_CssStateMixin","./_KeyNavMixin","dojo/text!./templates/TreeNode.html","dojo/text!./templates/Tree.html","./tree/TreeStoreModel","./tree/ForestStoreModel","./tree/_dndSelector","dojo/query!css2"],function(_c22,_c23,_c24,_c25,_c26,all,dom,_c27,_c28,_c29,_c2a,_c2b,has,_c2c,keys,lang,on,_c2d,_c2e,when,_c2f,_c30,_c31,_c32,_c33,_c34,_c35,_c36,_c37,_c38,_c39,_c3a,_c3b,_c3c,_c3d){function _c3e(d){return lang.delegate(d.promise||d,{addCallback:function(_c3f){this.then(_c3f);},addErrback:function(_c40){this.otherwise(_c40);}});};var _c41=_c25("dijit._TreeNode",[_c33,_c34,_c35,_c36,_c37],{item:null,isTreeNode:true,label:"",_setLabelAttr:function(val){this.labelNode[this.labelType=="html"?"innerHTML":"innerText" in this.labelNode?"innerText":"textContent"]=val;this._set("label",val);if(has("dojo-bidi")){this.applyTextDir(this.labelNode);}},labelType:"text",isExpandable:null,isExpanded:false,state:"NotLoaded",templateString:_c39,baseClass:"dijitTreeNode",cssStateNodes:{rowNode:"dijitTreeRow"},_setTooltipAttr:{node:"rowNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);this._setExpando();this._updateItemClasses(this.item);if(this.isExpandable){this.labelNode.setAttribute("aria-expanded",this.isExpanded);}this.setSelected(false);},_setIndentAttr:function(_c42){var _c43=(Math.max(_c42,0)*this.tree._nodePixelIndent)+"px";_c29.set(this.domNode,"backgroundPosition",_c43+" 0px");_c29.set(this.rowNode,this.isLeftToRight()?"paddingLeft":"paddingRight",_c43);_c22.forEach(this.getChildren(),function(_c44){_c44.set("indent",_c42+1);});this._set("indent",_c42);},markProcessing:function(){this.state="Loading";this._setExpando(true);},unmarkProcessing:function(){this._setExpando(false);},_updateItemClasses:function(item){var tree=this.tree,_c45=tree.model;if(tree._v10Compat&&item===_c45.root){item=null;}this._applyClassAndStyle(item,"icon","Icon");this._applyClassAndStyle(item,"label","Label");this._applyClassAndStyle(item,"row","Row");this.tree._startPaint(true);},_applyClassAndStyle:function(item,_c46,_c47){var _c48="_"+_c46+"Class";var _c49=_c46+"Node";var _c4a=this[_c48];this[_c48]=this.tree["get"+_c47+"Class"](item,this.isExpanded);_c27.replace(this[_c49],this[_c48]||"",_c4a||"");_c29.set(this[_c49],this.tree["get"+_c47+"Style"](item,this.isExpanded)||{});},_updateLayout:function(){var _c4b=this.getParent(),_c4c=!_c4b||!_c4b.rowNode||_c4b.rowNode.style.display=="none";_c27.toggle(this.domNode,"dijitTreeIsRoot",_c4c);_c27.toggle(this.domNode,"dijitTreeIsLast",!_c4c&&!this.getNextSibling());},_setExpando:function(_c4d){var _c4e=["dijitTreeExpandoLoading","dijitTreeExpandoOpened","dijitTreeExpandoClosed","dijitTreeExpandoLeaf"],_c4f=["*","-","+","*"],idx=_c4d?0:(this.isExpandable?(this.isExpanded?1:2):3);_c27.replace(this.expandoNode,_c4e[idx],_c4e);this.expandoNodeText.innerHTML=_c4f[idx];},expand:function(){if(this._expandDeferred){return _c3e(this._expandDeferred);}if(this._collapseDeferred){this._collapseDeferred.cancel();delete this._collapseDeferred;}this.isExpanded=true;this.labelNode.setAttribute("aria-expanded","true");if(this.tree.showRoot||this!==this.tree.rootNode){this.containerNode.setAttribute("role","group");}_c27.add(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","true");}var _c50=_c2b.wipeIn({node:this.containerNode,duration:_c32.defaultDuration});var def=(this._expandDeferred=new _c26(function(){_c50.stop();}));_c23.after(_c50,"onEnd",function(){def.resolve(true);},true);_c50.play();return _c3e(def);},collapse:function(){if(this._collapseDeferred){return _c3e(this._collapseDeferred);}if(this._expandDeferred){this._expandDeferred.cancel();delete this._expandDeferred;}this.isExpanded=false;this.labelNode.setAttribute("aria-expanded","false");if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","false");}_c27.remove(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);var _c51=_c2b.wipeOut({node:this.containerNode,duration:_c32.defaultDuration});var def=(this._collapseDeferred=new _c26(function(){_c51.stop();}));_c23.after(_c51,"onEnd",function(){def.resolve(true);},true);_c51.play();return _c3e(def);},indent:0,setChildItems:function(_c52){var tree=this.tree,_c53=tree.model,defs=[];var _c54=tree.focusedChild;var _c55=this.getChildren();_c22.forEach(_c55,function(_c56){_c35.prototype.removeChild.call(this,_c56);},this);this.defer(function(){_c22.forEach(_c55,function(node){if(!node._destroyed&&!node.getParent()){tree.dndController.removeTreeNode(node);function _c57(node){var id=_c53.getIdentity(node.item),ary=tree._itemNodesMap[id];if(ary.length==1){delete tree._itemNodesMap[id];}else{var _c58=_c22.indexOf(ary,node);if(_c58!=-1){ary.splice(_c58,1);}}_c22.forEach(node.getChildren(),_c57);};_c57(node);if(tree.persist){var _c59=_c22.map(node.getTreePath(),function(item){return tree.model.getIdentity(item);}).join("/");for(var path in tree._openedNodes){if(path.substr(0,_c59.length)==_c59){delete tree._openedNodes[path];}}tree._saveExpandedNodes();}if(tree.lastFocusedChild&&!dom.isDescendant(tree.lastFocusedChild.domNode,tree.domNode)){delete tree.lastFocusedChild;}if(_c54&&!dom.isDescendant(_c54.domNode,tree.domNode)){tree.focus();}node.destroyRecursive();}});});this.state="Loaded";if(_c52&&_c52.length>0){this.isExpandable=true;_c22.forEach(_c52,function(item){var id=_c53.getIdentity(item),_c5a=tree._itemNodesMap[id],node;if(_c5a){for(var i=0;i<_c5a.length;i++){if(_c5a[i]&&!_c5a[i].getParent()){node=_c5a[i];node.set("indent",this.indent+1);break;}}}if(!node){node=this.tree._createTreeNode({item:item,tree:tree,isExpandable:_c53.mayHaveChildren(item),label:tree.getLabel(item),labelType:(tree.model&&tree.model.labelType)||"text",tooltip:tree.getTooltip(item),ownerDocument:tree.ownerDocument,dir:tree.dir,lang:tree.lang,textDir:tree.textDir,indent:this.indent+1});if(_c5a){_c5a.push(node);}else{tree._itemNodesMap[id]=[node];}}this.addChild(node);if(this.tree.autoExpand||this.tree._state(node)){defs.push(tree._expandNode(node));}},this);_c22.forEach(this.getChildren(),function(_c5b){_c5b._updateLayout();});}else{this.isExpandable=false;}if(this._setExpando){this._setExpando(false);}this._updateItemClasses(this.item);var def=all(defs);this.tree._startPaint(def);return _c3e(def);},getTreePath:function(){var node=this;var path=[];while(node&&node!==this.tree.rootNode){path.unshift(node.item);node=node.getParent();}path.unshift(this.tree.rootNode.item);return path;},getIdentity:function(){return this.tree.model.getIdentity(this.item);},removeChild:function(node){this.inherited(arguments);var _c5c=this.getChildren();if(_c5c.length==0){this.isExpandable=false;this.collapse();}_c22.forEach(_c5c,function(_c5d){_c5d._updateLayout();});},makeExpandable:function(){this.isExpandable=true;this._setExpando(false);},setSelected:function(_c5e){this.labelNode.setAttribute("aria-selected",_c5e?"true":"false");_c27.toggle(this.rowNode,"dijitTreeRowSelected",_c5e);},focus:function(){_c30.focus(this.focusNode);}});if(has("dojo-bidi")){_c41.extend({_setTextDirAttr:function(_c5f){if(_c5f&&((this.textDir!=_c5f)||!this._created)){this._set("textDir",_c5f);this.applyTextDir(this.labelNode);_c22.forEach(this.getChildren(),function(_c60){_c60.set("textDir",_c5f);},this);}}});}var Tree=_c25("dijit.Tree",[_c33,_c38,_c34,_c37],{baseClass:"dijitTree",store:null,model:null,query:null,label:"",showRoot:true,childrenAttr:["children"],paths:[],path:[],selectedItems:null,selectedItem:null,openOnClick:false,openOnDblClick:false,templateString:_c3a,persist:false,autoExpand:false,dndController:_c3d,dndParams:["onDndDrop","itemCreator","onDndCancel","checkAcceptance","checkItemAcceptance","dragThreshold","betweenThreshold"],onDndDrop:null,itemCreator:null,onDndCancel:null,checkAcceptance:null,checkItemAcceptance:null,dragThreshold:5,betweenThreshold:0,_nodePixelIndent:19,_publish:function(_c61,_c62){_c2d.publish(this.id,lang.mixin({tree:this,event:_c61},_c62||{}));},postMixInProperties:function(){this.tree=this;if(this.autoExpand){this.persist=false;}this._itemNodesMap={};if(!this.cookieName&&this.id){this.cookieName=this.id+"SaveStateCookie";}this.expandChildrenDeferred=new _c26();this.pendingCommandsPromise=this.expandChildrenDeferred.promise;this.inherited(arguments);},postCreate:function(){this._initState();var self=this;this.own(on(this.containerNode,on.selector(".dijitTreeNode",_c2e.enter),function(evt){self._onNodeMouseEnter(_c31.byNode(this),evt);}),on(this.containerNode,on.selector(".dijitTreeNode",_c2e.leave),function(evt){self._onNodeMouseLeave(_c31.byNode(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow",_c2f.press),function(evt){self._onNodePress(_c31.getEnclosingWidget(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow",_c2f),function(evt){self._onClick(_c31.getEnclosingWidget(this),evt);}),on(this.containerNode,on.selector(".dijitTreeRow","dblclick"),function(evt){self._onDblClick(_c31.getEnclosingWidget(this),evt);}));if(!this.model){this._store2model();}this.own(_c23.after(this.model,"onChange",lang.hitch(this,"_onItemChange"),true),_c23.after(this.model,"onChildrenChange",lang.hitch(this,"_onItemChildrenChange"),true),_c23.after(this.model,"onDelete",lang.hitch(this,"_onItemDelete"),true));this.inherited(arguments);if(this.dndController){if(lang.isString(this.dndController)){this.dndController=lang.getObject(this.dndController);}var _c63={};for(var i=0;i<this.dndParams.length;i++){if(this[this.dndParams[i]]){_c63[this.dndParams[i]]=this[this.dndParams[i]];}}this.dndController=new this.dndController(this,_c63);}this._load();this.onLoadDeferred=_c3e(this.pendingCommandsPromise);this.onLoadDeferred.then(lang.hitch(this,"onLoad"));},_store2model:function(){this._v10Compat=true;_c2c.deprecated("Tree: from version 2.0, should specify a model object rather than a store/query");var _c64={id:this.id+"_ForestStoreModel",store:this.store,query:this.query,childrenAttrs:this.childrenAttr};if(this.params.mayHaveChildren){_c64.mayHaveChildren=lang.hitch(this,"mayHaveChildren");}if(this.params.getItemChildren){_c64.getChildren=lang.hitch(this,function(item,_c65,_c66){this.getItemChildren((this._v10Compat&&item===this.model.root)?null:item,_c65,_c66);});}this.model=new _c3c(_c64);this.showRoot=Boolean(this.label);},onLoad:function(){},_load:function(){this.model.getRoot(lang.hitch(this,function(item){var rn=(this.rootNode=this.tree._createTreeNode({item:item,tree:this,isExpandable:true,label:this.label||this.getLabel(item),labelType:this.model.labelType||"text",textDir:this.textDir,indent:this.showRoot?0:-1}));if(!this.showRoot){rn.rowNode.style.display="none";this.domNode.setAttribute("role","presentation");this.domNode.removeAttribute("aria-expanded");this.domNode.removeAttribute("aria-multiselectable");if(this["aria-label"]){rn.containerNode.setAttribute("aria-label",this["aria-label"]);this.domNode.removeAttribute("aria-label");}else{if(this["aria-labelledby"]){rn.containerNode.setAttribute("aria-labelledby",this["aria-labelledby"]);this.domNode.removeAttribute("aria-labelledby");}}rn.labelNode.setAttribute("role","presentation");rn.labelNode.removeAttribute("aria-selected");rn.containerNode.setAttribute("role","tree");rn.containerNode.setAttribute("aria-expanded","true");rn.containerNode.setAttribute("aria-multiselectable",!this.dndController.singular);}else{this.domNode.setAttribute("aria-multiselectable",!this.dndController.singular);this.rootLoadingIndicator.style.display="none";}this.containerNode.appendChild(rn.domNode);var _c67=this.model.getIdentity(item);if(this._itemNodesMap[_c67]){this._itemNodesMap[_c67].push(rn);}else{this._itemNodesMap[_c67]=[rn];}rn._updateLayout();this._expandNode(rn).then(lang.hitch(this,function(){if(!this._destroyed){this.rootLoadingIndicator.style.display="none";this.expandChildrenDeferred.resolve(true);}}));}),lang.hitch(this,function(err){console.error(this,": error loading root: ",err);}));},getNodesByItem:function(item){if(!item){return [];}var _c68=lang.isString(item)?item:this.model.getIdentity(item);return [].concat(this._itemNodesMap[_c68]);},_setSelectedItemAttr:function(item){this.set("selectedItems",[item]);},_setSelectedItemsAttr:function(_c69){var tree=this;return this.pendingCommandsPromise=this.pendingCommandsPromise.always(lang.hitch(this,function(){var _c6a=_c22.map(_c69,function(item){return (!item||lang.isString(item))?item:tree.model.getIdentity(item);});var _c6b=[];_c22.forEach(_c6a,function(id){_c6b=_c6b.concat(tree._itemNodesMap[id]||[]);});this.set("selectedNodes",_c6b);}));},_setPathAttr:function(path){if(path.length){return _c3e(this.set("paths",[path]).then(function(_c6c){return _c6c[0];}));}else{return _c3e(this.set("paths",[]).then(function(_c6d){return _c6d[0];}));}},_setPathsAttr:function(_c6e){var tree=this;function _c6f(path,_c70){var _c71=path.shift();var _c72=_c22.filter(_c70,function(node){return node.getIdentity()==_c71;})[0];if(!!_c72){if(path.length){return tree._expandNode(_c72).then(function(){return _c6f(path,_c72.getChildren());});}else{return _c72;}}else{throw new Tree.PathError("Could not expand path at "+_c71);}};return _c3e(this.pendingCommandsPromise=this.pendingCommandsPromise.always(function(){return all(_c22.map(_c6e,function(path){path=_c22.map(path,function(item){return item&&lang.isObject(item)?tree.model.getIdentity(item):item;});if(path.length){return _c6f(path,[tree.rootNode]);}else{throw new Tree.PathError("Empty path");}}));}).then(function setNodes(_c73){tree.set("selectedNodes",_c73);return tree.paths;}));},_setSelectedNodeAttr:function(node){this.set("selectedNodes",[node]);},_setSelectedNodesAttr:function(_c74){this.dndController.setSelection(_c74);},expandAll:function(){var _c75=this;function _c76(node){return _c75._expandNode(node).then(function(){var _c77=_c22.filter(node.getChildren()||[],function(node){return node.isExpandable;});return all(_c22.map(_c77,_c76));});};return _c3e(_c76(this.rootNode));},collapseAll:function(){var _c78=this;function _c79(node){var _c7a=_c22.filter(node.getChildren()||[],function(node){return node.isExpandable;}),defs=all(_c22.map(_c7a,_c79));if(!node.isExpanded||(node==_c78.rootNode&&!_c78.showRoot)){return defs;}else{return defs.then(function(){return _c78._collapseNode(node);});}};return _c3e(_c79(this.rootNode));},mayHaveChildren:function(){},getItemChildren:function(){},getLabel:function(item){return this.model.getLabel(item);},getIconClass:function(item,_c7b){return (!item||this.model.mayHaveChildren(item))?(_c7b?"dijitFolderOpened":"dijitFolderClosed"):"dijitLeaf";},getLabelClass:function(){},getRowClass:function(){},getIconStyle:function(){},getLabelStyle:function(){},getRowStyle:function(){},getTooltip:function(){return "";},_onDownArrow:function(evt,node){var _c7c=this._getNext(node);if(_c7c&&_c7c.isTreeNode){this.focusNode(_c7c);}},_onUpArrow:function(evt,node){var _c7d=node.getPreviousSibling();if(_c7d){node=_c7d;while(node.isExpandable&&node.isExpanded&&node.hasChildren()){var _c7e=node.getChildren();node=_c7e[_c7e.length-1];}}else{var _c7f=node.getParent();if(!(!this.showRoot&&_c7f===this.rootNode)){node=_c7f;}}if(node&&node.isTreeNode){this.focusNode(node);}},_onRightArrow:function(evt,node){if(node.isExpandable&&!node.isExpanded){this._expandNode(node);}else{if(node.hasChildren()){node=node.getChildren()[0];if(node&&node.isTreeNode){this.focusNode(node);}}}},_onLeftArrow:function(evt,node){if(node.isExpandable&&node.isExpanded){this._collapseNode(node);}else{var _c80=node.getParent();if(_c80&&_c80.isTreeNode&&!(!this.showRoot&&_c80===this.rootNode)){this.focusNode(_c80);}}},focusLastChild:function(){var node=this._getLast();if(node&&node.isTreeNode){this.focusNode(node);}},_getFirst:function(){return this.showRoot?this.rootNode:this.rootNode.getChildren()[0];},_getLast:function(){var node=this.rootNode;while(node.isExpanded){var c=node.getChildren();if(!c.length){break;}node=c[c.length-1];}return node;},_getNext:function(node){if(node.isExpandable&&node.isExpanded&&node.hasChildren()){return node.getChildren()[0];}else{while(node&&node.isTreeNode){var _c81=node.getNextSibling();if(_c81){return _c81;}node=node.getParent();}return null;}},childSelector:".dijitTreeRow",isExpandoNode:function(node,_c82){return dom.isDescendant(node,_c82.expandoNode)||dom.isDescendant(node,_c82.expandoNodeText);},_onNodePress:function(_c83,e){this.focusNode(_c83);},__click:function(_c84,e,_c85,func){var _c86=e.target,_c87=this.isExpandoNode(_c86,_c84);if(_c84.isExpandable&&(_c85||_c87)){this._onExpandoClick({node:_c84});}else{this._publish("execute",{item:_c84.item,node:_c84,evt:e});this[func](_c84.item,_c84,e);this.focusNode(_c84);}e.stopPropagation();e.preventDefault();},_onClick:function(_c88,e){this.__click(_c88,e,this.openOnClick,"onClick");},_onDblClick:function(_c89,e){this.__click(_c89,e,this.openOnDblClick,"onDblClick");},_onExpandoClick:function(_c8a){var node=_c8a.node;this.focusNode(node);if(node.isExpanded){this._collapseNode(node);}else{this._expandNode(node);}},onClick:function(){},onDblClick:function(){},onOpen:function(){},onClose:function(){},_getNextNode:function(node){_c2c.deprecated(this.declaredClass+"::_getNextNode(node) is deprecated. Use _getNext(node) instead.","","2.0");return this._getNext(node);},_getRootOrFirstNode:function(){_c2c.deprecated(this.declaredClass+"::_getRootOrFirstNode() is deprecated. Use _getFirst() instead.","","2.0");return this._getFirst();},_collapseNode:function(node){if(node._expandNodeDeferred){delete node._expandNodeDeferred;}if(node.state=="Loading"){return;}if(node.isExpanded){var ret=node.collapse();this.onClose(node.item,node);this._state(node,false);this._startPaint(ret);return ret;}},_expandNode:function(node){if(node._expandNodeDeferred){return node._expandNodeDeferred;}var _c8b=this.model,item=node.item,_c8c=this;if(!node._loadDeferred){node.markProcessing();node._loadDeferred=new _c26();_c8b.getChildren(item,function(_c8d){node.unmarkProcessing();node.setChildItems(_c8d).then(function(){node._loadDeferred.resolve(_c8d);});},function(err){console.error(_c8c,": error loading "+node.label+" children: ",err);node._loadDeferred.reject(err);});}var def=node._loadDeferred.then(lang.hitch(this,function(){var def2=node.expand();this.onOpen(node.item,node);this._state(node,true);return def2;}));this._startPaint(def);return def;},focusNode:function(node){var tmp=[];for(var _c8e=this.domNode;_c8e&&_c8e.tagName&&_c8e.tagName.toUpperCase()!=="IFRAME";_c8e=_c8e.parentNode){tmp.push({domNode:_c8e.contentWindow||_c8e,scrollLeft:_c8e.scrollLeft||0,scrollTop:_c8e.scrollTop||0});}this.focusChild(node);this.defer(function(){for(var i=0,max=tmp.length;i<max;i++){tmp[i].domNode.scrollLeft=tmp[i].scrollLeft;tmp[i].domNode.scrollTop=tmp[i].scrollTop;}},0);},_onNodeMouseEnter:function(){},_onNodeMouseLeave:function(){},_onItemChange:function(item){var _c8f=this.model,_c90=_c8f.getIdentity(item),_c91=this._itemNodesMap[_c90];if(_c91){var _c92=this.getLabel(item),_c93=this.getTooltip(item);_c22.forEach(_c91,function(node){node.set({item:item,label:_c92,tooltip:_c93});node._updateItemClasses(item);});}},_onItemChildrenChange:function(_c94,_c95){var _c96=this.model,_c97=_c96.getIdentity(_c94),_c98=this._itemNodesMap[_c97];if(_c98){_c22.forEach(_c98,function(_c99){_c99.setChildItems(_c95);});}},_onItemDelete:function(item){var _c9a=this.model,_c9b=_c9a.getIdentity(item),_c9c=this._itemNodesMap[_c9b];if(_c9c){_c22.forEach(_c9c,function(node){this.dndController.removeTreeNode(node);var _c9d=node.getParent();if(_c9d){_c9d.removeChild(node);}if(this.lastFocusedChild&&!dom.isDescendant(this.lastFocusedChild.domNode,this.domNode)){delete this.lastFocusedChild;}if(this.focusedChild&&!dom.isDescendant(this.focusedChild.domNode,this.domNode)){this.focus();}node.destroyRecursive();},this);delete this._itemNodesMap[_c9b];}},_initState:function(){this._openedNodes={};if(this.persist&&this.cookieName){var oreo=_c24(this.cookieName);if(oreo){_c22.forEach(oreo.split(","),function(item){this._openedNodes[item]=true;},this);}}},_state:function(node,_c9e){if(!this.persist){return false;}var path=_c22.map(node.getTreePath(),function(item){return this.model.getIdentity(item);},this).join("/");if(arguments.length===1){return this._openedNodes[path];}else{if(_c9e){this._openedNodes[path]=true;}else{delete this._openedNodes[path];}this._saveExpandedNodes();}},_saveExpandedNodes:function(){if(this.persist&&this.cookieName){var ary=[];for(var id in this._openedNodes){ary.push(id);}_c24(this.cookieName,ary.join(","),{expires:365});}},destroy:function(){if(this._curSearch){this._curSearch.timer.remove();delete this._curSearch;}if(this.rootNode){this.rootNode.destroyRecursive();}if(this.dndController&&!lang.isString(this.dndController)){this.dndController.destroy();}this.rootNode=null;this.inherited(arguments);},destroyRecursive:function(){this.destroy();},resize:function(_c9f){if(_c9f){_c28.setMarginBox(this.domNode,_c9f);}this._nodePixelIndent=_c28.position(this.tree.indentDetector).w||this._nodePixelIndent;this.expandChildrenDeferred.then(lang.hitch(this,function(){this.rootNode.set("indent",this.showRoot?0:-1);this._adjustWidths();}));},_outstandingPaintOperations:0,_startPaint:function(p){this._outstandingPaintOperations++;if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}var oc=lang.hitch(this,function(){this._outstandingPaintOperations--;if(this._outstandingPaintOperations<=0&&!this._adjustWidthsTimer&&this._started){this._adjustWidthsTimer=this.defer("_adjustWidths");}});when(p,oc,oc);},_adjustWidths:function(){if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}this.containerNode.style.width="auto";this.containerNode.style.width=this.domNode.scrollWidth>this.domNode.offsetWidth?"auto":"100%";},_createTreeNode:function(args){return new _c41(args);},focus:function(){if(this.lastFocusedChild){this.focusNode(this.lastFocusedChild);}else{this.focusFirstChild();}}});if(has("dojo-bidi")){Tree.extend({_setTextDirAttr:function(_ca0){if(_ca0&&this.textDir!=_ca0){this._set("textDir",_ca0);this.rootNode.set("textDir",_ca0);}}});}Tree.PathError=_c2a("TreePathError");Tree._TreeNode=_c41;return Tree;});},"dijit/form/_FormValueWidget":function(){define(["dojo/_base/declare","dojo/sniff","./_FormWidget","./_FormValueMixin"],function(_ca1,has,_ca2,_ca3){return _ca1("dijit.form._FormValueWidget",[_ca2,_ca3],{_layoutHackIE7:function(){if(has("ie")==7){var _ca4=this.domNode;var _ca5=_ca4.parentNode;var _ca6=_ca4.firstChild||_ca4;var _ca7=_ca6.style.filter;var _ca8=this;while(_ca5&&_ca5.clientHeight==0){(function ping(){var _ca9=_ca8.connect(_ca5,"onscroll",function(){_ca8.disconnect(_ca9);_ca6.style.filter=(new Date()).getMilliseconds();_ca8.defer(function(){_ca6.style.filter=_ca7;});});})();_ca5=_ca5.parentNode;}}}});});},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow\" role=\"presentation\"\n\t\t><span data-dojo-attach-point=\"expandoNode\" class=\"dijitInline dijitTreeExpando\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTreeIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span data-dojo-attach-point=\"labelNode,focusNode\" class=\"dijitTreeLabel\" role=\"treeitem\"\n\t\t\t\t   tabindex=\"-1\" aria-selected=\"false\" id=\"${id}_label\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeNodeContainer\" role=\"presentation\"\n\t\t style=\"display: none;\" aria-labelledby=\"${id}_label\"></div>\n</div>\n","url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='ondijitclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeydown:_onTitleKeyDown'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><span role=\"presentation\" class=\"dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode, textDirNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n","url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\" role=\"separator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>\n","url:dijit/templates/ProgressBar.html":"<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\n\t\t><span style=\"visibility:hidden\">&#160;</span\n\t></div\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\n\t><span data-dojo-attach-point=\"indeterminateHighContrastImage\"\n\t\t   class=\"dijitInline dijitProgressBarIndeterminateHighContrastImage\"></span\n></div>\n","url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode,_popupStateNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\" data-dojo-attach-point=\"valueNode\" aria-hidden=\"true\"\n/></span>\n","url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\taria-haspopup=\"true\"\n\tdata-dojo-attach-point=\"_popupStateNode\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"${type}\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\"\n\t/></div\n></div>\n","url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset\" data-dojo-attach-point=\"focusNode\" role=\"${role}\" tabIndex=\"-1\" aria-checked=\"${checked}\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span class=\"dijitInline dijitIcon dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span class=\"dijitMenuItemIconChar dijitCheckedMenuItemIconChar\">${!checkedChar}</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode,textDirNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\" data-dojo-attach-event=\"mouseenter:onMouseEnter,mouseleave:onMouseLeave\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n","url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/templates/InlineEditBox.html":"<span data-dojo-attach-point=\"editNode\" role=\"presentation\" class=\"dijitReset dijitInline dijitOffScreen\"\n\t><span data-dojo-attach-point=\"editorPlaceholder\"></span\n\t><span data-dojo-attach-point=\"buttonContainer\"\n\t\t><button data-dojo-type=\"./form/Button\" data-dojo-props=\"label: '${buttonSave}', 'class': 'saveButton'\"\n\t\t\tdata-dojo-attach-point=\"saveButton\" data-dojo-attach-event=\"onClick:save\"></button\n\t\t><button data-dojo-type=\"./form/Button\"  data-dojo-props=\"label: '${buttonCancel}', 'class': 'cancelButton'\"\n\t\t\tdata-dojo-attach-point=\"cancelButton\" data-dojo-attach-event=\"onClick:cancel\"></button\n\t></span\n></span>\n","url:dijit/templates/ColorPalette.html":"<div class=\"dijitInline dijitColorPalette\" role=\"grid\">\n\t<table data-dojo-attach-point=\"paletteTableNode\" class=\"dijitPaletteTable\" cellSpacing=\"0\" cellPadding=\"0\" role=\"presentation\">\n\t\t<tbody data-dojo-attach-point=\"gridNode\"></tbody>\n\t</table>\n</div>\n","url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"ondijitclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\" role=\"button\">\n\t<span role=\"presentation\" class=\"dijitInline dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>","url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n","url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:__onClick,onkeydown:_onButtonKeyDown\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeydown:_onArrowKeyDown\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\"\n\t\t\t\tclass=\"dijitOffScreen\" aria-hidden=\"true\" data-dojo-attach-event=\"onclick:_onClick\"\n\t\t/></td></tr></tbody\n></table>\n","url:dijit/templates/Tree.html":"<div role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n\t<div class=\"dijitTreeExpando dijitTreeExpandoLoading\" data-dojo-attach-point=\"rootLoadingIndicator\"></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\">\n\t</div>\n</div>\n","url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabindex=\"-1\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n\t${!actionBarTemplate}\n</div>\n\n","url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode,_popupStateNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,textDirNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,textDirNode\"\n\t\trole=\"presentation\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<span data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<span class=\"dijitInline dijitIcon dijitMenuExpand\"></span>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</span>\n\t</td>\n</tr>\n","url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode,innerDiv,tabContent\" class=\"dijitTabInner dijitTabContent\">\n\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTabButtonIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point='containerNode,focusNode' class='tabLabel'></span>\n\t<span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t  role=\"presentation\">\n\t\t<span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t\t\t></span>\n</div>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"ondijitclick:_onClick\"\n/></div>\n","url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_menuBtn\"\n\t\t data-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t data-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_leftBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_rightBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'\n\t\t\t data-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\ttabIndex=\"-1\" aria-hidden=\"true\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","url:dijit/templates/TooltipDialog.html":"<div role=\"alertdialog\" tabIndex=\"-1\">\n\t<div class=\"dijitTooltipContainer\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"contentsNode\" class=\"dijitTooltipContents dijitTooltipFocusNode\">\n\t\t\t<div data-dojo-attach-point=\"containerNode\"></div>\n\t\t\t${!actionBarTemplate}\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTooltipConnector\" role=\"presentation\" data-dojo-attach-point=\"connectorNode\"></div>\n</div>\n","*now":function(r){r(["dojo/i18n!*preload*dojo/nls/tt-rss-layer*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);}}});define("dojo/tt-rss-layer",[],1);