/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import javax.annotation.Nonnull;
import org.coode.owlapi.obo12.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;

class XRefTagHandler
extends AbstractTagValueHandler {
    public XRefTagHandler(@Nonnull OBOConsumer consumer) {
        super(OBOVocabulary.XREF.getName(), consumer);
    }

    @Override
    public void handle(String currentId, String value, String qualifierBlock, String comment) {
        if (currentId == null) {
            return;
        }
        OWLAnnotation xrefAnnotation = this.getConsumer().parseXRef(value);
        IRI subject = this.getIRIFromOBOId(currentId);
        OWLAnnotationAssertionAxiom ax = this.getDataFactory().getOWLAnnotationAssertionAxiom(xrefAnnotation.getProperty(), subject, xrefAnnotation.getValue());
        this.applyChange(new AddAxiom(this.getOntology(), ax));
        if (this.getConsumer().isTypedef() && xrefAnnotation.getValue() instanceof IRI) {
            IRI xrefIRI = (IRI)xrefAnnotation.getValue();
            String typedefId = this.getConsumer().getCurrentId();
            this.getConsumer().addSymbolicIdMapping(typedefId, xrefIRI);
        }
    }
}

