/*
 * Decompiled with CFR 0.152.
 */
package processing.app.exec;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ProcessRegistry {
    private static final Set<Process> REGISTRY = Collections.synchronizedSet(new HashSet());

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = REGISTRY;
                synchronized (set) {
                    for (Process p : REGISTRY) {
                        try {
                            p.destroy();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
    }

    public static void watch(Process p) {
        REGISTRY.add(p);
    }

    public static void unwatch(Process p) {
        REGISTRY.remove(p);
    }
}

