/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;

public class VectorForce {
    private final double x;
    private final double y;

    public VectorForce(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isInfinite(x) || Double.isInfinite(y)) {
            throw new IllegalArgumentException();
        }
        this.x = x;
        this.y = y;
    }

    public VectorForce(Point2D src, Point2D dest) {
        this(dest.getX() - src.getX(), dest.getY() - src.getY());
    }

    public VectorForce plus(VectorForce other) {
        return new VectorForce(this.x + other.x, this.y + other.y);
    }

    public VectorForce multiply(double v) {
        return new VectorForce(this.x * v, this.y * v);
    }

    public String toString() {
        return String.format("{%8.2f %8.2f}", this.x, this.y);
    }

    public VectorForce negate() {
        return new VectorForce(-this.x, -this.y);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public VectorForce normaliseTo(double newLength) {
        if (Double.isInfinite(newLength) || Double.isNaN(newLength)) {
            throw new IllegalArgumentException();
        }
        double actualLength = this.length();
        if (actualLength == 0.0) {
            return this;
        }
        double f = newLength / actualLength;
        return new VectorForce(this.x * f, this.y * f);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }
}

