/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.prefix;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.ResettableView;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.prefix.PrefixField;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.model.prefix.Prefix;

public class PrefixPane
extends HBox
implements TaskParametersBuildStep<MultipleOutputTaskParametersBuilder<?>>,
RestorableView,
ResettableView {
    private PrefixField field = new PrefixField();

    public PrefixPane() {
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        I18nContext ctx = DefaultI18nContext.getInstance();
        this.getChildren().addAll((Object[])new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Generated PDF documents name prefix:")), this.field, HelpUtils.helpIcon((Region)new TextFlow(new Node[]{new Text(ctx.i18n("Prefix for the output files name.") + System.lineSeparator()), new Text(ctx.i18n("Some special keywords are replaced with runtime values.") + System.lineSeparator()), new Text(ctx.i18n("Right click to add these keywords."))}))});
    }

    public void addMenuItemFor(Prefix ... prefixes) {
        this.field.addMenuItemFor(prefixes);
    }

    public void addMenuItemFor(String ... prefixes) {
        this.field.addMenuItemFor(prefixes);
    }

    public final String getText() {
        return this.field.getText();
    }

    public void resetView() {
        this.field.resetView();
    }

    public void apply(MultipleOutputTaskParametersBuilder<?> builder, Consumer<String> onError) {
        builder.prefix(this.getText());
    }

    public void saveStateTo(Map<String, String> data) {
        data.put(StringUtils.defaultString((String)this.getId()) + "prefix", StringUtils.defaultString((String)this.field.getText()));
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.field.setText(Optional.ofNullable(data.get(StringUtils.defaultString((String)this.getId()) + "prefix")).orElse(""));
    }
}

