/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileOrDirectoryTaskOutput;

public class DirectoryOutputAdapter {
    private final DirectoryTaskOutput pdfDirectoryOutput;

    public DirectoryOutputAdapter(String directoryPath) {
        Path directory = Paths.get(directoryPath, new String[0]).toAbsolutePath().normalize();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new ConversionException("Path '" + directory.toString() + "' is not an existing directory");
        }
        this.pdfDirectoryOutput = new DirectoryTaskOutput(directory.toFile());
    }

    public DirectoryTaskOutput getPdfDirectoryOutput() {
        return this.pdfDirectoryOutput;
    }

    public FileOrDirectoryTaskOutput getPdfFileOrDirectoryOutput() {
        return new FileOrDirectoryTaskOutput(this.pdfDirectoryOutput.getDestination());
    }
}

