/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.parameter.base.MultiplePdfSourceMultipleOutputParameters;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.rotation.Rotation;

public class RotateParameters
extends MultiplePdfSourceMultipleOutputParameters {
    @Valid
    @NotNull
    private Rotation rotation = null;
    @NotNull
    private PredefinedSetOfPages predefinedSetOfPages;
    @Valid
    private final Map<PageRange, Rotation> pageSelection = new HashMap<PageRange, Rotation>();
    private Map<Integer, Map<PageRange, Rotation>> pageSelectionPerSource = new HashMap<Integer, Map<PageRange, Rotation>>();

    public RotateParameters(Rotation rotation, PredefinedSetOfPages predefinedSetOfPages) {
        this.rotation = rotation;
        this.predefinedSetOfPages = predefinedSetOfPages;
    }

    public RotateParameters(Rotation rotation) {
        this(rotation, PredefinedSetOfPages.NONE);
    }

    public RotateParameters() {
        this(Rotation.DEGREES_0);
    }

    @Deprecated
    public Rotation getRotation() {
        return this.rotation;
    }

    public Rotation getRotation(int page) {
        Rotation defaultRotation = Rotation.DEGREES_0;
        if (this.predefinedSetOfPages.includes(page)) {
            defaultRotation = this.rotation;
        }
        return this.pageSelection.keySet().stream().filter(range -> range.contains(page)).findFirst().map(this.pageSelection::get).orElse(defaultRotation);
    }

    public Rotation getRotation(int sourceIndex, int page) {
        Map<PageRange, Rotation> pageSelection = this.pageSelectionPerSource.get(sourceIndex);
        if (pageSelection != null) {
            for (PageRange range : pageSelection.keySet()) {
                if (!range.contains(page)) continue;
                return pageSelection.get(range);
            }
        }
        return this.getRotation(page);
    }

    public void addPageRange(PageRange range) {
        this.pageSelection.put(range, this.rotation);
    }

    public void addPageRange(PageRange range, Rotation rotation) {
        this.pageSelection.put(range, rotation);
    }

    public void addAllPageRanges(Collection<PageRange> ranges) {
        ranges.forEach(this::addPageRange);
    }

    public void addPageRangePerSource(int sourceIndex, PageRange range, Rotation rotation) {
        if (!this.pageSelectionPerSource.containsKey(sourceIndex)) {
            this.pageSelectionPerSource.put(sourceIndex, new HashMap());
        }
        Map<PageRange, Rotation> pageSelection = this.pageSelectionPerSource.get(sourceIndex);
        pageSelection.put(range, rotation);
    }

    public PredefinedSetOfPages getPredefinedSetOfPages() {
        return this.predefinedSetOfPages;
    }

    public Map<PageRange, Rotation> getPageSelection() {
        return this.pageSelection;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.rotation).append((Object)this.predefinedSetOfPages).append(this.pageSelection).append(this.pageSelectionPerSource).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RotateParameters)) {
            return false;
        }
        RotateParameters parameter = (RotateParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.predefinedSetOfPages, (Object)parameter.predefinedSetOfPages).append(this.pageSelection, parameter.pageSelection).append((Object)this.rotation, (Object)parameter.rotation).append(this.pageSelectionPerSource, parameter.pageSelectionPerSource).isEquals();
    }
}

