/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.optionalcontent;

import java.util.Optional;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.sejda.sambox.rendering.RenderDestination;

public class PDOptionalContentGroup
extends PDPropertyList {
    public PDOptionalContentGroup(String name) {
        this.dict.setItem(COSName.TYPE, (COSBase)COSName.OCG);
        this.setName(name);
    }

    public PDOptionalContentGroup(COSDictionary dict) {
        super(dict);
        if (!dict.getItem(COSName.TYPE).equals(COSName.OCG)) {
            throw new IllegalArgumentException("Provided dictionary is not of type '" + COSName.OCG + "'");
        }
    }

    public String getName() {
        return this.dict.getString(COSName.NAME);
    }

    public void setName(String name) {
        this.dict.setString(COSName.NAME, name);
    }

    public RenderState getRenderState(RenderDestination destination) {
        COSName state = null;
        COSDictionary usage = this.dict.getDictionaryObject("Usage", COSDictionary.class);
        if (usage != null) {
            if (RenderDestination.PRINT.equals((Object)destination)) {
                state = Optional.ofNullable(usage.getDictionaryObject("Print", COSDictionary.class)).map(p -> p.getDictionaryObject("PrintState", COSName.class)).orElse(null);
            } else if (RenderDestination.VIEW.equals((Object)destination)) {
                state = Optional.ofNullable(usage.getDictionaryObject("View", COSDictionary.class)).map(v -> v.getDictionaryObject("ViewState", COSName.class)).orElse(null);
            }
            if (state == null) {
                state = Optional.ofNullable(usage.getDictionaryObject("Export", COSDictionary.class)).map(e -> e.getDictionaryObject("ExportState", COSName.class)).orElse(null);
            }
        }
        return Optional.ofNullable(state).map(RenderState::valueOf).orElse(null);
    }

    public String toString() {
        return super.toString() + " (" + this.getName() + ")";
    }

    public static enum RenderState {
        ON(COSName.ON),
        OFF(COSName.OFF);

        private final COSName name;

        private RenderState(COSName value) {
            this.name = value;
        }

        public static RenderState valueOf(COSName state) {
            if (state == null) {
                return null;
            }
            return RenderState.valueOf(state.getName().toUpperCase());
        }

        public COSName getName() {
            return this.name;
        }
    }
}

