/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word;

import java.util.Map;
import java.util.TreeMap;

public class WordInfo {
    Map<Character, int[]> left;
    Map<Character, int[]> right;
    public String text;
    public int frequency;
    float p;
    float leftEntropy;
    float rightEntropy;
    public float aggregation;
    public float entropy;

    WordInfo(String text) {
        this.text = text;
        this.left = new TreeMap<Character, int[]>();
        this.right = new TreeMap<Character, int[]>();
        this.aggregation = Float.MAX_VALUE;
    }

    private static void increaseFrequency(char c, Map<Character, int[]> storage) {
        int[] freq = storage.get(Character.valueOf(c));
        if (freq == null) {
            freq = new int[]{1};
            storage.put(Character.valueOf(c), freq);
        } else {
            freq[0] = freq[0] + 1;
        }
    }

    private float computeEntropy(Map<Character, int[]> storage) {
        float sum = 0.0f;
        for (Map.Entry<Character, int[]> entry : storage.entrySet()) {
            float p = (float)entry.getValue()[0] / (float)this.frequency;
            sum = (float)((double)sum - (double)p * Math.log(p));
        }
        return sum;
    }

    void update(char left, char right) {
        ++this.frequency;
        WordInfo.increaseFrequency(left, this.left);
        WordInfo.increaseFrequency(right, this.right);
    }

    void computeProbabilityEntropy(int length) {
        this.p = (float)this.frequency / (float)length;
        this.leftEntropy = this.computeEntropy(this.left);
        this.rightEntropy = this.computeEntropy(this.right);
        this.entropy = Math.min(this.leftEntropy, this.rightEntropy);
    }

    void computeAggregation(Map<String, WordInfo> word_cands) {
        if (this.text.length() == 1) {
            this.aggregation = (float)Math.sqrt(this.p);
            return;
        }
        for (int i = 1; i < this.text.length(); ++i) {
            this.aggregation = Math.min(this.aggregation, this.p / word_cands.get((Object)this.text.substring((int)0, (int)i)).p / word_cands.get((Object)this.text.substring((int)i)).p);
        }
    }

    public String toString() {
        return this.text;
    }
}

