/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    @Nullable
    private final RegistryKeyDescriptor myKeyDescriptor;
    private final List<RegistryValueListener> myListeners;
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private Double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;
    private static final Logger LOG = Logger.getInstance(RegistryValue.class);

    RegistryValue(@NotNull Registry registry, @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(0);
        }
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRegistry = registry;
        this.myKey = key;
        this.myKeyDescriptor = keyDescriptor;
    }

    @NotNull
    public String asString() {
        String value2 = this.get(this.myKey, null, true);
        assert (value2 != null) : this.myKey;
        String string2 = value2;
        if (string2 == null) {
            RegistryValue.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public boolean asBoolean() {
        if (this.myBooleanCachedValue == null) {
            this.myBooleanCachedValue = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return this.myBooleanCachedValue;
    }

    public int asInteger() {
        if (this.myIntCachedValue == null) {
            try {
                this.myIntCachedValue = Integer.valueOf(this.get(this.myKey, "0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myIntCachedValue = Integer.valueOf(bundleValue);
            }
        }
        return this.myIntCachedValue;
    }

    boolean isRestartRequired() {
        if (this.myKeyDescriptor != null) {
            return this.myKeyDescriptor.isRestartRequired();
        }
        return Boolean.parseBoolean(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return this.isChangedFromDefault(this.asString());
    }

    boolean isChangedFromDefault(@NotNull String newValue2) {
        if (newValue2 == null) {
            RegistryValue.$$$reportNull$$$0(6);
        }
        return !newValue2.equals(Registry.getInstance().getBundleValue(this.myKey, false));
    }

    protected String get(@NotNull String key, String defaultValue2, boolean isValue) throws MissingResourceException {
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(7);
        }
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue2, true);
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue2, false);
    }

    private String _get(@NotNull String key, String defaultValue2, boolean mustExistInBundle) throws MissingResourceException {
        String userValue;
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(8);
        }
        if ((userValue = this.myRegistry.getUserProperties().get(key)) != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        String bundleValue = Registry.getInstance().getBundleValue(key, mustExistInBundle);
        if (bundleValue != null) {
            return bundleValue;
        }
        return defaultValue2;
    }

    public void setValue(boolean value2) {
        this.setValue(Boolean.toString(value2));
    }

    public void setValue(String value2) {
        this.resetCache();
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.myRegistry.getUserProperties().put(this.myKey, value2);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault() && !this.isRestartRequired()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
        LOG.info("Registry value '" + this.myKey + "' has changed to '" + value2 + '\'');
    }

    public void setValue(boolean value2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RegistryValue.$$$reportNull$$$0(9);
        }
        boolean prev = this.asBoolean();
        this.setValue(value2);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myDoubleCachedValue = null;
        this.myBooleanCachedValue = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isChangedFromDefault";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "_get";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

