/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.declaration;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class LSBasedHyperlink
implements IHyperlink {
    private final Either<Location, LocationLink> location;
    private final IRegion highlightRegion;

    public LSBasedHyperlink(Either<Location, LocationLink> location, IRegion highlightRegion) {
        this.location = location;
        this.highlightRegion = highlightRegion;
    }

    public LSBasedHyperlink(Location location, IRegion linkRegion) {
        this((Either<Location, LocationLink>)Either.forLeft((Object)location), linkRegion);
    }

    public LSBasedHyperlink(LocationLink locationLink, IRegion linkRegion) {
        this((Either<Location, LocationLink>)Either.forRight((Object)locationLink), linkRegion);
    }

    public IRegion getHyperlinkRegion() {
        return this.highlightRegion;
    }

    public String getTypeLabel() {
        return Messages.hyperlinkLabel;
    }

    public String getHyperlinkText() {
        return Messages.hyperlinkLabel;
    }

    public Either<Location, LocationLink> getLocation() {
        return this.location;
    }

    public void open() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (this.location.isLeft()) {
            LSPEclipseUtils.openInEditor((Location)this.location.getLeft(), page);
        } else {
            LSPEclipseUtils.openInEditor((LocationLink)this.location.getRight(), page);
        }
    }
}

