/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IRunControl2;
import org.eclipse.cdt.dsf.debug.service.IRunControl3;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.service.control.StepIntoSelectionActiveOperation;
import org.eclipse.cdt.dsf.gdb.internal.service.control.StepIntoSelectionUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIRunControl;
import org.eclipse.cdt.dsf.mi.service.MIStack;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIRunningEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MISignalEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadExitEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackInfoDepthInfo;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class GDBRunControl
extends MIRunControl {
    private IGDBBackend fGdb;
    private IMIProcesses fProcService;
    private CommandFactory fCommandFactory;
    private ICommandControlService fConnection;
    private IRunControl.IExecutionDMContext[] fOldExecutionCtxts;
    private RunToLineActiveOperation fRunToLineActiveOperation = null;
    private StepIntoSelectionActiveOperation fStepInToSelectionActiveOperation = null;

    public GDBRunControl(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            public void handleSuccess() {
                GDBRunControl.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fProcService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fConnection = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.register(new String[]{IRunControl.class.getName(), IRunControl2.class.getName(), IRunControl3.class.getName(), IMIRunControl.class.getName(), MIRunControl.class.getName(), GDBRunControl.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    protected boolean runControlOperationsEnabled() {
        return this.fGdb.getSessionType() != SessionType.CORE;
    }

    @Override
    public IMIExecutionDMContext createMIExecutionContext(IRunControl.IContainerDMContext container, String threadId) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)container, IProcesses.IProcessDMContext.class);
        IProcesses.IThreadDMContext threadDmc = null;
        if (procDmc != null) {
            threadDmc = this.fProcService.createThreadContext(procDmc, threadId);
        }
        return this.fProcService.createExecutionContext(container, threadDmc, threadId);
    }

    @Override
    public void suspend(final IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        this.canSuspend(context, new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Boolean)this.getData()).booleanValue()) {
                    int interruptTimeout = GDBRunControl.this.getInterruptTimeout();
                    if (GDBRunControl.this.fGdb.getIsAttachSession() && GDBRunControl.this.fGdb.getSessionType() != SessionType.REMOTE && Platform.getOS().equals("win32")) {
                        IMIProcessDMContext processDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIProcessDMContext.class);
                        String inferiorPid = processDmc.getProcId();
                        if (inferiorPid != null) {
                            GDBRunControl.this.fGdb.interruptInferiorAndWait(Long.parseLong(inferiorPid), interruptTimeout, rm);
                        } else {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)"why don't we have the inferior's pid?");
                            }
                            GDBRunControl.this.fGdb.interruptAndWait(interruptTimeout, rm);
                        }
                    } else {
                        GDBRunControl.this.fGdb.interruptAndWait(interruptTimeout, rm);
                    }
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Context cannot be suspended.", null));
                    rm.done();
                }
            }
        });
    }

    @Override
    public void getExecutionContexts(IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        this.fProcService.getProcessesBeingDebugged((IDMContext)containerDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (this.getData() instanceof IRunControl.IExecutionDMContext[]) {
                    IRunControl.IExecutionDMContext[] execDmcs = (IRunControl.IExecutionDMContext[])this.getData();
                    GDBRunControl.this.raiseExitEvents(execDmcs);
                    GDBRunControl.this.fOldExecutionCtxts = execDmcs;
                    rm.setData((Object)GDBRunControl.this.fOldExecutionCtxts);
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid contexts", null));
                }
                rm.done();
            }
        });
    }

    private void raiseExitEvents(IRunControl.IExecutionDMContext[] ctxts) {
        if (ctxts == null || this.fOldExecutionCtxts == null) {
            return;
        }
        List<IRunControl.IExecutionDMContext> list = Arrays.asList(ctxts);
        List<IRunControl.IExecutionDMContext> oldThreadList = Arrays.asList(this.fOldExecutionCtxts);
        for (IRunControl.IExecutionDMContext ctxt : oldThreadList) {
            if (list.contains(ctxt)) continue;
            IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctxt, IRunControl.IContainerDMContext.class);
            MIThreadExitEvent e = new MIThreadExitEvent(containerDmc, ((IMIExecutionDMContext)ctxt).getThreadId());
            this.getSession().dispatchEvent((Object)e, this.getProperties());
        }
    }

    @Override
    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (!this.runControlOperationsEnabled()) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        super.canResume(context, rm);
    }

    @Override
    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (!this.runControlOperationsEnabled()) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        super.canSuspend(context, rm);
    }

    @Override
    public void canStep(final IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, final DataRequestMonitor<Boolean> rm) {
        MIStack stackService;
        if (!this.runControlOperationsEnabled()) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        if (stepType == IRunControl.StepType.STEP_RETURN && (stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class))) != null) {
            stackService.getStackDepth((IDMContext)context, 2, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

                public void handleCompleted() {
                    if (this.isSuccess() && (Integer)this.getData() == 1) {
                        rm.setData((Object)false);
                        rm.done();
                    } else {
                        GDBRunControl.this.canResume(context, (DataRequestMonitor<Boolean>)rm);
                    }
                }
            });
            return;
        }
        this.canResume(context, rm);
    }

    @Override
    public void runToLocation(IRunControl.IExecutionDMContext context, final String location, final boolean skipBreakpoints, final RequestMonitor rm) {
        assert (context != null);
        final IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Given context: " + context + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (this.doCanResume(dmc)) {
            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)context, IBreakpoints.IBreakpointsTargetDMContext.class);
            this.getConnection().queueCommand(this.fCommandFactory.createMIBreakInsert(bpDmc, true, false, null, 0, location, dmc.getThreadId()), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), rm){

                public void handleSuccess() {
                    String bpId = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getNumber();
                    String addr = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getAddress();
                    GDBRunControl.this.fRunToLineActiveOperation = new RunToLineActiveOperation(dmc, bpId, location, addr, skipBreakpoints);
                    GDBRunControl.this.resume(dmc, new RequestMonitor((Executor)GDBRunControl.this.getExecutor(), rm){

                        public void handleFailure() {
                            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)GDBRunControl.this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                            String bpId = GDBRunControl.this.fRunToLineActiveOperation.getBreakointId();
                            GDBRunControl.this.getConnection().queueCommand(GDBRunControl.this.fCommandFactory.createMIBreakDelete(bpDmc, new String[]{bpId}), new DataRequestMonitor((Executor)GDBRunControl.this.getExecutor(), null));
                            GDBRunControl.this.fRunToLineActiveOperation = null;
                            GDBRunControl.this.fStepInToSelectionActiveOperation = null;
                            super.handleFailure();
                        }
                    });
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Cannot resume given DMC.", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIInferiorExitEvent e) {
        if (this.fRunToLineActiveOperation != null) {
            IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            String bpId = this.fRunToLineActiveOperation.getBreakointId();
            this.getConnection().queueCommand(this.fCommandFactory.createMIBreakDelete(bpDmc, new String[]{bpId}), new DataRequestMonitor((Executor)this.getExecutor(), null));
            this.fRunToLineActiveOperation = null;
            this.fStepInToSelectionActiveOperation = null;
        }
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        if (this.fDisableNextSignalEvent && e instanceof MISignalEvent) {
            this.fDisableNextSignalEvent = false;
            this.fSilencedSignalEvent = e;
            return;
        }
        if (this.processRunToLineStoppedEvent(e)) {
            return;
        }
        if (!this.processStepIntoSelection(e)) {
            super.eventDispatched(e);
        }
    }

    @Override
    @DsfServiceEventHandler
    public void eventDispatched(MIRunningEvent e) {
        if (this.fDisableNextRunningEvent) {
            super.eventDispatched(e);
            return;
        }
        if (this.fRunToLineActiveOperation == null && this.fStepInToSelectionActiveOperation == null) {
            super.eventDispatched(e);
        } else if (this.fLatestEvent instanceof IRunControl.ISuspendedDMEvent) {
            super.eventDispatched(e);
        }
    }

    private boolean processRunToLineStoppedEvent(MIStoppedEvent e) {
        if (this.fRunToLineActiveOperation != null) {
            String bpId = "";
            if (e instanceof MIBreakpointHitEvent) {
                bpId = ((MIBreakpointHitEvent)e).getNumber();
            }
            boolean equalFileLocation = false;
            boolean equalAddrLocation = false;
            boolean equalBpId = bpId.equals(this.fRunToLineActiveOperation.getBreakointId());
            MIFrame frame = e.getFrame();
            if (frame != null) {
                String fileLocation = String.valueOf(frame.getFile()) + ":" + frame.getLine();
                String addrLocation = frame.getAddress();
                equalFileLocation = fileLocation.equals(this.fRunToLineActiveOperation.getFileLocation());
                equalAddrLocation = addrLocation.equals(this.fRunToLineActiveOperation.getAddrLocation());
            }
            if (equalFileLocation || equalAddrLocation || equalBpId) {
                this.fRunToLineActiveOperation = null;
            } else {
                if (this.fRunToLineActiveOperation.shouldSkipBreakpoints() && e instanceof MIBreakpointHitEvent) {
                    this.getConnection().queueCommand(this.fCommandFactory.createMIExecContinue(this.fRunToLineActiveOperation.getThreadContext()), new DataRequestMonitor((Executor)this.getExecutor(), null));
                    return true;
                }
                IBreakpoints.IBreakpointsTargetDMContext bpDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.fRunToLineActiveOperation.getThreadContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
                this.getConnection().queueCommand(this.fCommandFactory.createMIBreakDelete(bpDmc, new String[]{this.fRunToLineActiveOperation.getBreakointId()}), new DataRequestMonitor((Executor)this.getExecutor(), null));
                this.fRunToLineActiveOperation = null;
                this.fStepInToSelectionActiveOperation = null;
            }
        }
        return false;
    }

    private boolean processStepIntoSelection(final MIStoppedEvent e) {
        if (this.fStepInToSelectionActiveOperation == null) {
            return false;
        }
        IMIExecutionDMContext threadDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IMIExecutionDMContext.class);
        if (this.fStepInToSelectionActiveOperation.getThreadContext().equals(threadDmc)) {
            final MIFrame frame = e.getFrame();
            assert (this.fRunToLineActiveOperation == null);
            if (this.fStepInToSelectionActiveOperation.getRunToLineFrame() == null) {
                assert (this.fStepInToSelectionActiveOperation.getLine() == frame.getLine());
                this.fStepInToSelectionActiveOperation.setRunToLineFrame(frame);
            }
            this.getStackDepth(threadDmc, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), null){
                private int originalStackDepth;
                {
                    super($anonymous0, $anonymous1);
                    this.originalStackDepth = GDBRunControl.this.fStepInToSelectionActiveOperation.getOriginalStackDepth();
                }

                protected void handleSuccess() {
                    int frameDepth = this.getStackDepth();
                    if (frameDepth > this.originalStackDepth) {
                        if (!$assertionsDisabled && frameDepth != this.originalStackDepth + 1) {
                            throw new AssertionError();
                        }
                        if (StepIntoSelectionUtils.sameSignature(frame, GDBRunControl.this.fStepInToSelectionActiveOperation)) {
                            GDBRunControl.this.stopStepIntoSelection(e);
                            return;
                        }
                        GDBRunControl.this.continueStepping(e, IRunControl.StepType.STEP_RETURN);
                    } else if (frameDepth == this.originalStackDepth) {
                        String searchLineLocation;
                        String currentLocation = String.valueOf(frame.getFile()) + ":" + frame.getLine();
                        if (currentLocation.equals(searchLineLocation = GDBRunControl.this.fStepInToSelectionActiveOperation.getFileLocation())) {
                            GDBRunControl.this.continueStepping(e, IRunControl.StepType.STEP_INTO);
                        } else {
                            StepIntoSelectionUtils.missedSelectedTarget(GDBRunControl.this.fStepInToSelectionActiveOperation);
                            GDBRunControl.this.stopStepIntoSelection(e);
                        }
                    } else {
                        StepIntoSelectionUtils.missedSelectedTarget(GDBRunControl.this.fStepInToSelectionActiveOperation);
                    }
                }

                protected void handleFailure() {
                    if (this.getStatus() != null) {
                        GdbPlugin.getDefault().getLog().log(this.getStatus());
                    }
                    GDBRunControl.this.stopStepIntoSelection(e);
                }

                private int getStackDepth() {
                    Integer stackDepth = null;
                    if (this.isSuccess() && this.getData() != null) {
                        stackDepth = (Integer)this.getData();
                        if (frame == GDBRunControl.this.fStepInToSelectionActiveOperation.getRunToLineFrame()) {
                            GDBRunControl.this.fStepInToSelectionActiveOperation.setOriginalStackDepth(stackDepth);
                            this.originalStackDepth = stackDepth;
                        }
                    }
                    if (stackDepth == null) {
                        return GDBRunControl.this.fStepInToSelectionActiveOperation.getOriginalStackDepth();
                    }
                    return stackDepth;
                }
            });
            return true;
        }
        this.fStepInToSelectionActiveOperation = null;
        return false;
    }

    private void stopStepIntoSelection(MIStoppedEvent e) {
        this.fStepInToSelectionActiveOperation = null;
        super.eventDispatched(e);
    }

    protected int getInterruptTimeout() {
        return 0;
    }

    private void continueStepping(final MIStoppedEvent event, IRunControl.StepType steptype) {
        this.step(this.fStepInToSelectionActiveOperation.getThreadContext(), steptype, false, new RequestMonitor((Executor)this.getExecutor(), null){

            protected void handleFailure() {
                if (this.getStatus() != null) {
                    GdbPlugin.getDefault().getLog().log(this.getStatus());
                }
                GDBRunControl.this.stopStepIntoSelection(event);
            }
        });
    }

    private void stepIntoSelection(IRunControl.IExecutionDMContext context, final int baseLine, final String baseLineLocation, final boolean skipBreakpoints, final IFunctionDeclaration targetFunction, final RequestMonitor rm) {
        assert (context != null);
        final IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Given context: " + context + " is not an MI execution context.", null));
            rm.done();
            return;
        }
        if (!this.doCanResume(dmc)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        if (this.fLatestEvent == null || !(this.fLatestEvent instanceof MIRunControl.SuspendedEvent)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given context: " + context + " invalid suspended event.", null));
            rm.done();
            return;
        }
        MIRunControl.SuspendedEvent suspendedEvent = (MIRunControl.SuspendedEvent)this.fLatestEvent;
        final MIFrame currentFrame = ((MIStoppedEvent)((Object)suspendedEvent.getMIEvent())).getFrame();
        if (currentFrame == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Given event: " + suspendedEvent + " with invalid frame.", null));
            rm.done();
            return;
        }
        this.getStackDepth(dmc, new DataRequestMonitor<Integer>((Executor)this.getExecutor(), rm){

            public void handleSuccess() {
                if (this.getData() != null) {
                    int framesSize = (Integer)this.getData();
                    RequestMonitor rms = new RequestMonitor((Executor)GDBRunControl.this.getExecutor(), rm){

                        protected void handleFailure() {
                            GDBRunControl.this.fStepInToSelectionActiveOperation = null;
                            super.handleFailure();
                        }
                    };
                    if ((String.valueOf(currentFrame.getFile()) + ":" + currentFrame.getLine()).endsWith(baseLineLocation)) {
                        GDBRunControl.this.fStepInToSelectionActiveOperation = new StepIntoSelectionActiveOperation(dmc, baseLine, targetFunction, framesSize, currentFrame);
                        GDBRunControl.this.step(dmc, IRunControl.StepType.STEP_INTO, rms);
                    } else {
                        GDBRunControl.this.fStepInToSelectionActiveOperation = new StepIntoSelectionActiveOperation(dmc, baseLine, targetFunction, framesSize, null);
                        GDBRunControl.this.runToLocation(dmc, baseLineLocation, skipBreakpoints, rms);
                    }
                } else {
                    rm.done();
                }
            }
        });
    }

    @Override
    public void canStepIntoSelection(IRunControl.IExecutionDMContext context, String sourceFile, int lineNumber, IFunctionDeclaration selectedFunction, DataRequestMonitor<Boolean> rm) {
        this.canStep(context, IRunControl.StepType.STEP_INTO, rm);
    }

    @Override
    public void stepIntoSelection(final IRunControl.IExecutionDMContext context, String sourceFile, final int lineNumber, final boolean skipBreakpoints, final IFunctionDeclaration selectedFunction, final RequestMonitor rm) {
        this.determineDebuggerPath((IDMContext)context, sourceFile, (DataRequestMonitor<String>)new ImmediateDataRequestMonitor<String>(rm){

            protected void handleSuccess() {
                GDBRunControl.this.stepIntoSelection(context, lineNumber, String.valueOf((String)this.getData()) + ":" + Integer.toString(lineNumber), skipBreakpoints, selectedFunction, rm);
            }
        });
    }

    private void getStackDepth(IMIExecutionDMContext dmc, final DataRequestMonitor<Integer> rm) {
        if (dmc != null) {
            this.fConnection.queueCommand(this.fCommandFactory.createMIStackInfoDepth(dmc), (DataRequestMonitor)new DataRequestMonitor<MIStackInfoDepthInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((MIStackInfoDepthInfo)this.getData()).getDepth());
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context", null));
            rm.done();
        }
    }

    private static class RunToLineActiveOperation {
        private IMIExecutionDMContext fThreadContext;
        private String fBpId;
        private String fFileLocation;
        private String fAddrLocation;
        private boolean fSkipBreakpoints;

        public RunToLineActiveOperation(IMIExecutionDMContext threadContext, String bpId, String fileLoc, String addr, boolean skipBreakpoints) {
            this.fThreadContext = threadContext;
            this.fBpId = bpId;
            this.fFileLocation = fileLoc;
            this.fAddrLocation = addr;
            this.fSkipBreakpoints = skipBreakpoints;
        }

        public IMIExecutionDMContext getThreadContext() {
            return this.fThreadContext;
        }

        public String getBreakointId() {
            return this.fBpId;
        }

        public String getFileLocation() {
            return this.fFileLocation;
        }

        public String getAddrLocation() {
            return this.fAddrLocation;
        }

        public boolean shouldSkipBreakpoints() {
            return this.fSkipBreakpoints;
        }
    }
}

