/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.extensions;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.corrosion.extensions.ImplementationsSearchQuery;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class Implementations
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List infos;
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (part instanceof ITextEditor && !(infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)LSPEclipseUtils.getDocument((ITextEditor)((ITextEditor)part)), capabilities -> Boolean.TRUE.equals(capabilities.getReferencesProvider()))).isEmpty()) {
            LanguageServiceAccessor.LSPDocumentInfo info = (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
            ISelection sel = ((AbstractTextEditor)part).getSelectionProvider().getSelection();
            if (sel instanceof TextSelection) {
                try {
                    int offset = ((TextSelection)sel).getOffset();
                    ImplementationsSearchQuery query = new ImplementationsSearchQuery(offset, info);
                    NewSearchUI.runQueryInBackground((ISearchQuery)query);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError((Throwable)e);
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof ITextEditor) {
            List infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)LSPEclipseUtils.getDocument((ITextEditor)((ITextEditor)part)), capabilities -> Boolean.TRUE.equals(capabilities.getReferencesProvider()));
            ISelection selection = ((ITextEditor)part).getSelectionProvider().getSelection();
            return !infos.isEmpty() && !selection.isEmpty() && selection instanceof ITextSelection;
        }
        return false;
    }

    public boolean isHandled() {
        return true;
    }
}

