/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.callstack;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.callstack.TmfResolvedSizedSymbol;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;

public final class FunctionNameMapper {
    private static final int DIFF_LIMIT = 10;
    private static final Pattern REMOVE_ZEROS_PATTERN = Pattern.compile("^0+(?!$)");
    private static final Pattern NM_PATTERN = Pattern.compile("([0-9a-f]+)([\\s][a-zA-Z][\\s])(.+)");
    private static final Pattern MAP_WITH_SIZE_PATTERN = Pattern.compile("([0-9a-f]+)[\\s]([a-f0-9]+)[\\s](.+)");

    private FunctionNameMapper() {
    }

    /*
     * Unable to fully structure code
     */
    public static @Nullable Map<@NonNull Long, @NonNull TmfResolvedSymbol> mapFromNmTextFile(File mappingFile) {
        block31: {
            map = new TreeMap<Long, TmfResolvedSymbol>();
            cppFilt = null;
            try {
                var3_3 = null;
                var4_7 = null;
                try {
                    fr = new FileReader(mappingFile);
                    try {
                        reader = new BufferedReader(fr);
                        try {
                            try {
                                cppFilt = new CPPFilt();
                            }
                            catch (IOException e) {
                                Activator.logError("Error to instantiate the c++filt", e);
                            }
                            line = reader.readLine();
                            while (line != null) {
                                matcher = FunctionNameMapper.NM_PATTERN.matcher(line);
                                if (matcher.find()) {
                                    address = Long.parseUnsignedLong(FunctionNameMapper.stripLeadingZeros(Objects.requireNonNull(matcher.group(1))), 16);
                                    name = Objects.requireNonNull(matcher.group(3));
                                    name = cppFilt == null ? name : FunctionNameMapper.nameFromCppFilt(cppFilt, name);
                                    map.put(address, new TmfResolvedSymbol(address, Objects.requireNonNull(name)));
                                }
                                line = reader.readLine();
                            }
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        ** if (fr == null) goto lbl-1000
                    }
                    catch (Throwable var4_8) {
                        if (var3_3 == null) {
                            var3_3 = var4_8;
                        } else if (var3_3 != var4_8) {
                            var3_3.addSuppressed(var4_8);
                        }
                        if (fr != null) {
                            fr.close();
                        }
                        throw var3_3;
                    }
lbl-1000:
                    // 1 sources

                    {
                        fr.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable var4_9) {
                    if (var3_3 == null) {
                        var3_3 = var4_9;
                    } else if (var3_3 != var4_9) {
                        var3_3.addSuppressed(var4_9);
                    }
                    throw var3_3;
                }
            }
            catch (FileNotFoundException e) {
                if (cppFilt != null) {
                    cppFilt.dispose();
                }
                return null;
            }
            catch (IOException var3_6) {
                if (cppFilt != null) {
                    cppFilt.dispose();
                }
                break block31;
                catch (Throwable var12_17) {
                    if (cppFilt != null) {
                        cppFilt.dispose();
                    }
                    throw var12_17;
                }
            }
            if (cppFilt == null) break block31;
            cppFilt.dispose();
        }
        return map.isEmpty() != false ? null : ImmutableMap.copyOf(map);
    }

    /*
     * Unable to fully structure code
     */
    public static @Nullable Map<@NonNull Long, @NonNull TmfResolvedSymbol> mapFromSizedTextFile(File mappingFile) {
        block31: {
            map = new TreeMap<Long, TmfResolvedSizedSymbol>();
            cppFilt = null;
            try {
                var3_3 = null;
                var4_7 = null;
                try {
                    fr = new FileReader(mappingFile);
                    try {
                        reader = new BufferedReader(fr);
                        try {
                            try {
                                cppFilt = new CPPFilt();
                            }
                            catch (IOException e) {
                                Activator.logError("Error to instantiate the c++filt", e);
                            }
                            line = reader.readLine();
                            while (line != null) {
                                matcher = FunctionNameMapper.MAP_WITH_SIZE_PATTERN.matcher(line);
                                if (matcher.find()) {
                                    address = Long.parseUnsignedLong(FunctionNameMapper.stripLeadingZeros(Objects.requireNonNull(matcher.group(1))), 16);
                                    size = Long.parseUnsignedLong(FunctionNameMapper.stripLeadingZeros(Objects.requireNonNull(matcher.group(2))), 16);
                                    name = Objects.requireNonNull(matcher.group(3));
                                    name = cppFilt == null ? name : FunctionNameMapper.nameFromCppFilt(cppFilt, name);
                                    map.put(address, new TmfResolvedSizedSymbol(address, Objects.requireNonNull(name), size));
                                }
                                line = reader.readLine();
                            }
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        ** if (fr == null) goto lbl-1000
                    }
                    catch (Throwable var4_8) {
                        if (var3_3 == null) {
                            var3_3 = var4_8;
                        } else if (var3_3 != var4_8) {
                            var3_3.addSuppressed(var4_8);
                        }
                        if (fr != null) {
                            fr.close();
                        }
                        throw var3_3;
                    }
lbl-1000:
                    // 1 sources

                    {
                        fr.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable var4_9) {
                    if (var3_3 == null) {
                        var3_3 = var4_9;
                    } else if (var3_3 != var4_9) {
                        var3_3.addSuppressed(var4_9);
                    }
                    throw var3_3;
                }
            }
            catch (FileNotFoundException e) {
                if (cppFilt != null) {
                    cppFilt.dispose();
                }
                return null;
            }
            catch (IOException var3_6) {
                if (cppFilt != null) {
                    cppFilt.dispose();
                }
                break block31;
                catch (Throwable var14_18) {
                    if (cppFilt != null) {
                        cppFilt.dispose();
                    }
                    throw var14_18;
                }
            }
            if (cppFilt == null) break block31;
            cppFilt.dispose();
        }
        return map.isEmpty() != false ? null : ImmutableMap.copyOf(map);
    }

    public static @Nullable String nameFromCppFilt(CPPFilt cppFilt, String symbol) {
        try {
            String functionName = cppFilt.getFunction(symbol);
            return functionName != null ? functionName : symbol;
        }
        catch (IOException e) {
            Activator.logError("Error getting function name from c++filt", e);
            return symbol;
        }
    }

    /*
     * Exception decompiling
     */
    public static MappingType guessMappingType(File mappingFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<@NonNull Long, @NonNull TmfResolvedSymbol> mapFromBinaryFile(File file) {
        TreeMap<@NonNull Long, @NonNull TmfResolvedSymbol> map = new TreeMap<Long, TmfResolvedSymbol>();
        IBinaryParser.IBinaryObject binaryObject = FunctionNameMapper.getBinaryObject(file);
        if (binaryObject != null) {
            IBinaryParser.ISymbol[] symbols;
            IBinaryParser.ISymbol[] iSymbolArray = symbols = binaryObject.getSymbols();
            int n = symbols.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryParser.ISymbol symbol = iSymbolArray[n2];
                String address = symbol.getAddress().toHexAddressString();
                Long decodedAddr = Long.decode(address);
                map.put(decodedAddr, new TmfResolvedSymbol(decodedAddr, Objects.requireNonNull(symbol.getName())));
                ++n2;
            }
        }
        return ImmutableMap.copyOf(map);
    }

    private static String stripLeadingZeros(String address) {
        return Objects.requireNonNull(REMOVE_ZEROS_PATTERN.matcher(address).replaceFirst(""));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IBinaryParser.IBinaryObject getBinaryObject(File file) {
        Path filePath = new Path(file.toString());
        final ArrayList binaryParsers = new ArrayList();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.core.BinaryParser");
        Object object = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement element = object[n2];
            IConfigurationElement[] iConfigurationElementArray = children = element.getChildren("run");
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                final IConfigurationElement run = iConfigurationElementArray[n4];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        IBinaryParser binaryParser = (IBinaryParser)run.createExecutableExtension("class");
                        binaryParsers.add(Objects.requireNonNull(binaryParser));
                    }

                    public void handleException(@Nullable Throwable exception) {
                        Activator.logError("Error creating binary parser", exception);
                    }
                });
                ++n4;
            }
            ++n2;
        }
        int hintBufferSize = 0;
        for (IBinaryParser parser : binaryParsers) {
            if (parser.getHintBufferSize() <= hintBufferSize) continue;
            hintBufferSize = Math.max(hintBufferSize, parser.getHintBufferSize());
        }
        byte[] hintBuffer = new byte[hintBufferSize];
        if (hintBufferSize > 0) {
            try {
                Object object2 = null;
                object = null;
                try (FileInputStream is = new FileInputStream(file);){
                    int count = 0;
                    while (count < hintBufferSize) {
                        int bytesRead = ((InputStream)is).read(hintBuffer, count, hintBufferSize - count);
                        if (bytesRead < 0) break;
                        count += bytesRead;
                    }
                    if (count > 0 && count < hintBuffer.length) {
                        byte[] array = new byte[count];
                        System.arraycopy(hintBuffer, 0, array, 0, count);
                        hintBuffer = array;
                    }
                }
                catch (Throwable throwable) {
                    if (object2 == null) {
                        object2 = throwable;
                    } else if (object2 != throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                    throw object2;
                }
            }
            catch (IOException e) {
                Activator.logError("Error reading initial bytes of binary file", e);
                return null;
            }
        }
        for (IBinaryParser parser : binaryParsers) {
            if (!parser.isBinary(hintBuffer, (IPath)filePath)) continue;
            try {
                IBinaryParser.IBinaryFile binFile = parser.getBinary(hintBuffer, (IPath)filePath);
                if (!(binFile instanceof IBinaryParser.IBinaryObject)) continue;
                return (IBinaryParser.IBinaryObject)binFile;
            }
            catch (IOException e) {
                Activator.logError("Error parsing binary file", e);
            }
        }
        return null;
    }

    public static enum MappingType {
        NM,
        MAP_WITH_SIZE,
        UNKNOWN;

    }
}

