/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.model.TreeParent;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PerfPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.perf";
    public static final String VIEW_ID = "org.eclipse.linuxtools.perf.ui.ProfileView";
    public static final String SOURCE_DISASSEMBLY_VIEW_ID = "org.eclipse.linuxtools.perf.ui.SourceDisassemblyView";
    public static final String STAT_VIEW_ID = "org.eclipse.linuxtools.perf.ui.StatView";
    public static final String STAT_DIFF_VIEW_ID = "org.eclipse.linuxtools.perf.ui.StatViewDiff";
    public static final String REPORT_DIFF_VIEW_ID = "org.eclipse.linuxtools.perf.ui.ReportViewDiff";
    public static final String LAUNCHCONF_ID = "org.eclipse.linuxtools.perf.launch.profile";
    public static final String ATTR_Kernel_Location = "org.eclipse.linuxtools.internal.perf.attr.Kernel.Location";
    public static final String ATTR_Kernel_Location_default = "";
    public static final String ATTR_Record_Realtime = "org.eclipse.linuxtools.internal.perf.attr.Record.Realtime";
    public static final boolean ATTR_Record_Realtime_default = false;
    public static final String ATTR_Record_Realtime_Priority = "org.eclipse.linuxtools.internal.perf.attr.Record.Realtime.Priority";
    public static final int ATTR_Record_Realtime_Priority_default = 1;
    public static final String ATTR_Record_Verbose = "org.eclipse.linuxtools.internal.perf.attr.Record.Verbose";
    public static final boolean ATTR_Record_Verbose_default = false;
    public static final String ATTR_SourceLineNumbers = "org.eclipse.linuxtools.internal.perf.attr.SourceLineNumbers";
    public static final boolean ATTR_SourceLineNumbers_default = true;
    public static final String ATTR_Kernel_SourceLineNumbers = "org.eclipse.linuxtools.internal.perf.attr.Kernel.SourceLineNumbers";
    public static final boolean ATTR_Kernel_SourceLineNumbers_default = false;
    public static final String ATTR_Multiplex = "org.eclipse.linuxtools.internal.perf.attr.Multiplex";
    public static final boolean ATTR_Multiplex_default = false;
    public static final String ATTR_ModuleSymbols = "org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols";
    public static final boolean ATTR_ModuleSymbols_default = false;
    public static final String ATTR_HideUnresolvedSymbols = "org.eclipse.linuxtools.internal.perf.attr.HideUnresolvedSymbols";
    public static final boolean ATTR_HideUnresolvedSymbols_default = true;
    public static final String ATTR_ShowSourceDisassembly = "org.eclipse.linuxtools.internal.perf.attr.ShowSourceDisassembly";
    public static final boolean ATTR_ShowSourceDisassembly_default = false;
    public static final String ATTR_ShowStat = "org.eclipse.linuxtools.internal.perf.attr.ShowStat";
    public static final boolean ATTR_ShowStat_default = false;
    public static final String ATTR_StatRunCount = "org.eclipse.linuxtools.internal.perf.attr.StatRunCount";
    public static final int ATTR_StatRunCount_default = 1;
    public static final String ATTR_DefaultEvent = "org.eclipse.linuxtools.internal.perf.attr.DefaultEvent";
    public static final boolean ATTR_DefaultEvent_default = true;
    public static final String ATTR_MultipleEvents = "org.eclipse.linuxtools.internal.perf.attr.MultipleEvents";
    public static final boolean ATTR_MultipleEvents_default = false;
    public static final String ATTR_SelectedEvents = "org.eclipse.linuxtools.internal.perf.attr.SelectedEvents";
    public static final List<String> ATTR_SelectedEvents_default = null;
    public static final String ATTR_RawHwEvents = "org.eclipse.linuxtools.internal.perf.attr.RawHwEvents";
    public static final List<String> ATTR_RawHwEvents_default = null;
    public static final String ATTR_HwBreakpointEvents = "org.eclipse.linuxtools.internal.perf.attr.HwBreakpointEvents";
    public static final List<String> ATTR_HwBreakpointEvents_default = null;
    public static final String STRINGS_Kernel_Location = "Location of kernel image file (optional): ";
    public static final String STRINGS_Record_Realtime = "Record with realtime priority (RT SCHED_FIFO)";
    public static final String STRINGS_Record_Verbose = "Record with verbose output";
    public static final String STRINGS_ModuleSymbols = "Load Module Symbols";
    public static final String STRINGS_HideUnresolvedSymbols = "Hide Unresolved Symbols";
    public static final String STRINGS_SourceLineNumbers = "Obtain source line numbers from profile data";
    public static final String STRINGS_Kernel_SourceLineNumbers = "Obtain kernel source line numbers from profile data (Warning: May be very slow)";
    public static final String STRINGS_Multiplex = "Multiplex counter output in a single channel";
    public static final String STRINGS_RAWHWEvents = "Raw hardware event descriptor";
    public static final String STRINGS_HWBREAKPOINTS = "Hardware breakpoint";
    public static final String STRINGS_UnfiledSymbols = "Unfiled Symbols";
    public static final String STRINGS_MultipleFilesForSymbol = "Symbols conflicting in multiple files";
    public static final String STRINGS_ShowSourceDisassembly = "Show Source Disassembly View";
    public static final String STRINGS_ShowStat = "Show Stat View";
    public static final String STRINGS_SearchSourceDisassembly = "Search Source Disassembly";
    public static final String PERF_COMMAND = "perf";
    public static final String PERF_DEFAULT_DATA = "perf.data";
    public static final String PERF_DEFAULT_STAT = "perf.stat";
    public static final String PERF_DEAFULT_OLD_STAT = "perf.old.stat";
    public static final boolean DEBUG_ON = false;
    private static PerfPlugin plugin;
    private TreeParent _modelRoot;
    private IPerfData sourceDisassemblyData;
    private IPerfData statData;
    private IPath curProfileData;
    private IPath curWorkingDir;
    private IProject profiledProject;

    public TreeParent getModelRoot() {
        return this._modelRoot;
    }

    public IPerfData getSourceDisassemblyData() {
        return this.sourceDisassemblyData;
    }

    public IPerfData getStatData() {
        return this.statData;
    }

    public IPath getPerfProfileData() {
        return this.curProfileData;
    }

    public IPath getWorkingDir() {
        return this.curWorkingDir;
    }

    public URI getWorkingDirURI() {
        IPath wd;
        IRemoteFileProxy fileProxy;
        block3: {
            try {
                fileProxy = RemoteProxyManager.getInstance().getFileProxy(this.getProfiledProject());
                wd = this.getWorkingDir();
                if (wd != null && fileProxy != null) break block3;
                return null;
            }
            catch (CoreException e) {
                return null;
            }
        }
        IFileStore fs = fileProxy.getResource(wd.toOSString());
        return fs.toURI();
    }

    public IPath getPerfFile(String fileName) {
        if (this.curWorkingDir != null) {
            return this.curWorkingDir.append(fileName);
        }
        return null;
    }

    public TreeParent clearModelRoot() {
        if (this._modelRoot == null) {
            this._modelRoot = new TreeParent(ATTR_Kernel_Location_default);
        } else {
            this._modelRoot.clear();
        }
        return this._modelRoot;
    }

    public void setModelRoot(TreeParent rootnode) {
        this._modelRoot = rootnode;
    }

    public void setSourceDisassemblyData(IPerfData sourceDisassemblyData) {
        this.sourceDisassemblyData = sourceDisassemblyData;
    }

    public void setStatData(IPerfData statData) {
        this.statData = statData;
    }

    public void setPerfProfileData(IPath perfProfileData) {
        this.curProfileData = perfProfileData;
    }

    public void setWorkingDir(IPath workingDir) {
        this.curWorkingDir = workingDir;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static PerfPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)path).get();
    }

    public void openError(Exception ex, String title) {
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        String message = ex.getMessage();
        String formattedMessage = "org.eclipse.linuxtools.perf : " + message;
        Status status = new Status(4, PLUGIN_ID, formattedMessage, new Throwable(writer.toString()));
        this.getLog().log((IStatus)status);
        Display.getDefault().asyncExec(() -> {
            int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message, (IStatus)status);
        });
    }

    public IProject getProfiledProject() {
        return this.profiledProject;
    }

    public void setProfiledProject(IProject project) {
        this.profiledProject = project;
    }
}

