// Generated by CoffeeScript 2.5.0
(function() {
  var CoffeeScript, Module, binary, child_process, ext, findExtension, fork, getRootModule, helpers, i, len, loadFile, path, ref;

  CoffeeScript = require('./');

  child_process = require('child_process');

  helpers = require('./helpers');

  path = require('path');

  // Load and run a CoffeeScript file for Node, stripping any `BOM`s.
  loadFile = function(module, filename) {
    var answer, options;
    options = module.options || getRootModule(module).options;
    answer = CoffeeScript._compileFile(filename, options);
    return module._compile(answer, filename);
  };

  // If the installed version of Node supports `require.extensions`, register
  // CoffeeScript as an extension.
  if (require.extensions) {
    ref = CoffeeScript.FILE_EXTENSIONS;
    for (i = 0, len = ref.length; i < len; i++) {
      ext = ref[i];
      require.extensions[ext] = loadFile;
    }
    // Patch Node's module loader to be able to handle multi-dot extensions.
    // This is a horrible thing that should not be required.
    Module = require('module');
    findExtension = function(filename) {
      var curExtension, extensions;
      extensions = path.basename(filename).split('.');
      if (extensions[0] === '') {
        // Remove the initial dot from dotfiles.
        extensions.shift();
      }
      // Start with the longest possible extension and work our way shortwards.
      while (extensions.shift()) {
        curExtension = '.' + extensions.join('.');
        if (Module._extensions[curExtension]) {
          return curExtension;
        }
      }
      return '.js';
    };
    Module.prototype.load = function(filename) {
      var extension;
      this.filename = filename;
      this.paths = Module._nodeModulePaths(path.dirname(filename));
      extension = findExtension(filename);
      Module._extensions[extension](this, filename);
      return this.loaded = true;
    };
  }

  // If we're on Node, patch `child_process.fork` so that Coffee scripts are able
  // to fork both CoffeeScript files, and JavaScript files, directly.
  if (child_process) {
    ({fork} = child_process);
    binary = require.resolve('../../bin/coffee');
    child_process.fork = function(path, args, options) {
      if (helpers.isCoffee(path)) {
        if (!Array.isArray(args)) {
          options = args || {};
          args = [];
        }
        args = [path].concat(args);
        path = binary;
      }
      return fork(path, args, options);
    };
  }

  // Utility function to find the `options` object attached to the topmost module.
  getRootModule = function(module) {
    if (module.parent) {
      return getRootModule(module.parent);
    } else {
      return module;
    }
  };

}).call(this);
