/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.write;

import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.write.XMLRenderingVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLCatalogWriter {
    public static String XML_CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    private XMLCatalog catalog;
    private Writer out;

    public XMLCatalogWriter(XMLCatalog catalog, Writer out) {
        this.catalog = catalog;
        this.out = out;
    }

    public void write() throws IOException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElementNS(XML_CATALOG_NS, "catalog");
        if (this.catalog.getXmlBase() != null) {
            root.setAttribute("xml:base", this.catalog.getXmlBase().toString());
        }
        if (this.catalog.getPrefer() != null) {
            root.setAttribute("prefer", this.catalog.getPrefer().getName());
        }
        document.appendChild(root);
        XMLRenderingVisitor renderer = new XMLRenderingVisitor(document, root, CatalogUtilities.resolveXmlBase(this.catalog));
        for (Entry entry : this.catalog.getEntries()) {
            entry.accept(renderer);
        }
        this.save(document);
    }

    private void save(Document document) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(this.out);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", 4);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Transformer xformer = factory.newTransformer();
        xformer.setOutputProperty("method", "xml");
        xformer.setOutputProperty("indent", "yes");
        xformer.transform(source, result);
    }
}

