/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPixel;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.g2d.DriverCenteredCharacterG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverDotPathG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverEllipseG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverImageG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPathG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPixelG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverPolygonG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverTextAsPathG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverTextG2d;

public class UGraphicG2d
extends AbstractUGraphic<Graphics2D>
implements EnsureVisible,
UGraphic2 {
    private BufferedImage bufferedImage;
    private final double dpiFactor;
    private UAntiAliasing antiAliasing = UAntiAliasing.ANTI_ALIASING_ON;
    private List<Url> urls = new ArrayList<Url>();
    private Set<Url> allUrls = new HashSet<Url>();
    private final boolean hasAffineTransform;

    public final Set<Url> getAllUrlsEncountered() {
        return Collections.unmodifiableSet(this.allUrls);
    }

    @Override
    public UGraphic apply(UChange change) {
        UGraphicG2d copy = (UGraphicG2d)super.apply(change);
        if (change instanceof UAntiAliasing) {
            copy.antiAliasing = (UAntiAliasing)change;
        }
        return copy;
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicG2d(this);
    }

    private UGraphicG2d(UGraphicG2d other) {
        super(other);
        this.hasAffineTransform = other.hasAffineTransform;
        this.dpiFactor = other.dpiFactor;
        this.bufferedImage = other.bufferedImage;
        this.urls = other.urls;
        this.allUrls = other.allUrls;
        this.antiAliasing = other.antiAliasing;
        this.register(this.dpiFactor);
    }

    public UGraphicG2d(ColorMapper colorMapper, Graphics2D g2d, double dpiFactor) {
        this(colorMapper, g2d, dpiFactor, null, 0.0, 0.0);
    }

    public UGraphicG2d(ColorMapper colorMapper, Graphics2D g2d, double dpiFactor, AffineTransformation affineTransform, double dx, double dy) {
        super(colorMapper, g2d);
        this.hasAffineTransform = affineTransform != null;
        this.dpiFactor = dpiFactor;
        if (dpiFactor != 1.0) {
            g2d.scale(dpiFactor, dpiFactor);
        }
        if (this.hasAffineTransform) {
            if (dx != 0.0 || dy != 0.0) {
                ((Graphics2D)this.getGraphicObject()).transform(AffineTransform.getTranslateInstance(dx, dy));
            }
            ((Graphics2D)this.getGraphicObject()).transform(affineTransform.getAffineTransform());
        }
        this.register(dpiFactor);
    }

    private void register(double dpiFactor) {
        this.registerDriver(URectangle.class, new DriverRectangleG2d(dpiFactor, this));
        if (this.hasAffineTransform || dpiFactor != 1.0) {
            this.registerDriver(UText.class, new DriverTextAsPathG2d(this, TextBlockUtils.getFontRenderContext()));
        } else {
            this.registerDriver(UText.class, new DriverTextG2d(this));
        }
        this.registerDriver(ULine.class, new DriverLineG2d(dpiFactor));
        this.registerDriver(UPixel.class, new DriverPixelG2d());
        this.registerDriver(UPolygon.class, new DriverPolygonG2d(dpiFactor, this));
        this.registerDriver(UEllipse.class, new DriverEllipseG2d(dpiFactor, this));
        this.registerDriver(UImageSvg.class, new DriverImageG2d(dpiFactor, this));
        this.registerDriver(UImage.class, new DriverImageG2d(dpiFactor, this));
        this.registerDriver(DotPath.class, new DriverDotPathG2d(this));
        this.registerDriver(UPath.class, new DriverPathG2d(dpiFactor));
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterG2d());
    }

    @Override
    public StringBounder getStringBounder() {
        return FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault());
    }

    @Override
    protected void beforeDraw() {
        super.beforeDraw();
        this.applyClip();
        this.antiAliasing.apply((Graphics2D)this.getGraphicObject());
    }

    private void applyClip() {
        UClip uclip = this.getClip();
        if (uclip == null) {
            ((Graphics2D)this.getGraphicObject()).setClip(null);
        } else {
            Rectangle2D.Double clip = new Rectangle2D.Double(uclip.getX(), uclip.getY(), uclip.getWidth(), uclip.getHeight());
            ((Graphics2D)this.getGraphicObject()).setClip(clip);
        }
    }

    protected final double getDpiFactor() {
        return this.dpiFactor;
    }

    @Override
    public void startUrl(Url url) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        this.urls.add(url);
        this.allUrls.add(url);
    }

    @Override
    public void closeAction() {
        this.urls.remove(this.urls.size() - 1);
    }

    @Override
    public void ensureVisible(double x, double y) {
        for (Url u : this.urls) {
            if (this.getClip() != null && !this.getClip().isInside(x, y)) continue;
            u.ensureVisible(x, y);
        }
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public Graphics2D getGraphics2D() {
        return (Graphics2D)this.getGraphicObject();
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream os, String metadata, int dpi) throws IOException {
        BufferedImage im = this.getBufferedImage();
        PngIO.write((RenderedImage)im, os, metadata, dpi);
    }

    @Override
    public double dpiFactor() {
        return this.dpiFactor;
    }
}

