/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.cute.Balloon;
import net.sourceforge.plantuml.cute.CrossingSimple;
import net.sourceforge.plantuml.cute.InfiniteLine;
import net.sourceforge.plantuml.geom.LineSegmentDouble;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CrossingSegment {
    private final Balloon balloon;
    private final LineSegmentDouble segment;

    public CrossingSegment(Balloon balloon, LineSegmentDouble segment) {
        this.balloon = balloon;
        this.segment = segment;
    }

    public List<Point2D> intersection() {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        UTranslate tr = new UTranslate(this.balloon.getCenter());
        UTranslate trInverse = tr.reverse();
        CrossingSimple simple = new CrossingSimple(this.balloon.getRadius(), new InfiniteLine(this.segment).translate(trInverse));
        for (Point2D pt : simple.intersection()) {
            if (!this.segment.isPointOnSegment(pt = tr.getTranslated(pt))) continue;
            result.add(pt);
        }
        return result;
    }
}

