'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

exports.encodeRecoveryKey = encodeRecoveryKey;
exports.decodeRecoveryKey = decodeRecoveryKey;

var _bs = require('bs58');

var _bs2 = _interopRequireDefault(_bs);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// picked arbitrarily but to try & avoid clashing with any bitcoin ones
// (which are also base58 encoded, but bitcoin's involve a lot more hashing)
var OLM_RECOVERY_KEY_PREFIX = [0x8B, 0x01]; /*
                                            Copyright 2018 New Vector Ltd
                                            
                                            Licensed under the Apache License, Version 2.0 (the "License");
                                            you may not use this file except in compliance with the License.
                                            You may obtain a copy of the License at
                                            
                                                http://www.apache.org/licenses/LICENSE-2.0
                                            
                                            Unless required by applicable law or agreed to in writing, software
                                            distributed under the License is distributed on an "AS IS" BASIS,
                                            WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                            See the License for the specific language governing permissions and
                                            limitations under the License.
                                            */

function encodeRecoveryKey(key) {
    var buf = new Buffer(OLM_RECOVERY_KEY_PREFIX.length + key.length + 1);
    buf.set(OLM_RECOVERY_KEY_PREFIX, 0);
    buf.set(key, OLM_RECOVERY_KEY_PREFIX.length);

    var parity = 0;
    for (var i = 0; i < buf.length - 1; ++i) {
        parity ^= buf[i];
    }
    buf[buf.length - 1] = parity;
    var base58key = _bs2.default.encode(buf);

    return base58key.match(/.{1,4}/g).join(" ");
}

function decodeRecoveryKey(recoverykey) {
    var result = _bs2.default.decode(recoverykey.replace(/ /g, ''));

    var parity = 0;
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
        for (var _iterator = (0, _getIterator3.default)(result), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var b = _step.value;

            parity ^= b;
        }
    } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
            }
        } finally {
            if (_didIteratorError) {
                throw _iteratorError;
            }
        }
    }

    if (parity !== 0) {
        throw new Error("Incorrect parity");
    }

    for (var i = 0; i < OLM_RECOVERY_KEY_PREFIX.length; ++i) {
        if (result[i] !== OLM_RECOVERY_KEY_PREFIX[i]) {
            throw new Error("Incorrect prefix");
        }
    }

    if (result.length !== OLM_RECOVERY_KEY_PREFIX.length + global.Olm.PRIVATE_KEY_LENGTH + 1) {
        throw new Error("Incorrect length");
    }

    return result.slice(OLM_RECOVERY_KEY_PREFIX.length, OLM_RECOVERY_KEY_PREFIX.length + global.Olm.PRIVATE_KEY_LENGTH);
}
//# sourceMappingURL=recoverykey.js.map