/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedClassConstructorDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedFieldDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedValueParameterDescriptor;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.descriptors.JvmDeclarationFactory;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer$WhenMappings;
import org.jetbrains.kotlin.backend.jvm.lower.EnumClassLowering$EnumClassTransformer$findFunctionForMemberWithSyntheticBodyKind$;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBodyKind;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrMemberAccessExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EnumClassTransformer", "EnumConstructorCallTransformer", "backend.jvm"})
final class EnumClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        if (!IrUtilsKt.isEnumClass(irClass)) {
            return;
        }
        new EnumClassTransformer(irClass).run();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public EnumClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumConstructorCallTransformer;", "", "transform", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "delegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "enumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend.jvm"})
    private static interface EnumConstructorCallTransformer {
        @NotNull
        public IrExpression transform(@NotNull IrEnumConstructorCall var1);

        @NotNull
        public IrExpression transform(@NotNull IrDelegatingConstructorCall var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\u0004\u0018\u00002\u00020\u0001:\u000534567B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\bH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001bH\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010'\u001a\u00020\u001bH\u0002J\u0014\u0010(\u001a\u0004\u0018\u00010\u00032\b\u0010)\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u0010.\u001a\u00020\u001bJ\b\u0010/\u001a\u00020\u001bH\u0002J\u0018\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "enumEntriesByField", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "enumEntryClassToEntry", "enumEntryFields", "Ljava/util/ArrayList;", "enumEntryOrdinals", "Lgnu/trove/TObjectIntHashMap;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "loweredEnumConstructorParameters", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "loweredEnumConstructors", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrConstructorImpl;", "valueOfFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "valuesField", "valuesFunction", "assignOrdinalsToEnumEntries", "", "createFieldForEnumEntry", "enumEntry", "createSyntheticValuesFieldDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrFieldImpl;", "createSyntheticValuesFieldInitializerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "findFunctionForMemberWithSyntheticBodyKind", "kind", "Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBodyKind;", "lowerEnumClassBody", "lowerEnumConstructors", "lowerEnumEntries", "lowerEnumEntryClass", "enumEntryClass", "makeNameValueParameter", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "makeOrdinalValueParameter", "run", "setupSynthesizedEnumClassMembers", "transformEnumConstructor", "enumConstructor", "enumClass", "EnumClassBodyTransformer", "InEnumClassConstructor", "InEnumEntry", "InEnumEntryClassConstructor", "InEnumEntryInitializer", "backend.jvm"})
    private final class EnumClassTransformer {
        private final TObjectIntHashMap<IrEnumEntry> enumEntryOrdinals;
        private final HashMap<IrClass, IrEnumEntry> enumEntryClassToEntry;
        private final HashMap<IrConstructorSymbol, IrConstructorImpl> loweredEnumConstructors;
        private final HashMap<IrValueParameterSymbol, IrValueParameter> loweredEnumConstructorParameters;
        private final HashMap<IrField, IrEnumEntry> enumEntriesByField;
        private final ArrayList<IrField> enumEntryFields;
        private IrField valuesField;
        private IrFunction valuesFunction;
        private IrFunction valueOfFunction;
        @NotNull
        private final IrClass irClass;

        public final void run() {
            this.assignOrdinalsToEnumEntries();
            this.lowerEnumConstructors(this.irClass);
            this.lowerEnumEntries();
            this.setupSynthesizedEnumClassMembers();
            this.lowerEnumClassBody();
        }

        private final void assignOrdinalsToEnumEntries() {
            int ordinal = 0;
            Iterable $this$forEach$iv = this.irClass.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrEnumEntry)) continue;
                this.enumEntryOrdinals.put((Object)it, ordinal);
                if (((IrEnumEntry)it).getCorrespondingClass() != null) {
                    IrClass irClass;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    IrClass $this$run = irClass;
                    boolean bl4 = false;
                    this.enumEntryClassToEntry.put($this$run, (IrEnumEntry)it);
                }
                int n = ordinal;
                ordinal = n + 1;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void lowerEnumConstructors(IrClass irClass) {
            List<IrDeclaration> $this$transform$iv = irClass.getDeclarations();
            boolean $i$f$transform = false;
            Iterable $this$forEachIndexed$iv$iv = $this$transform$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                void declaration2;
                IrElement irElement;
                void item$iv;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                IrElement irElement2 = (IrElement)item$iv$iv;
                int i$iv = n2;
                boolean bl2 = false;
                IrDeclaration irDeclaration2 = (IrDeclaration)item$iv;
                int n3 = i$iv;
                List<IrDeclaration> list2 = $this$transform$iv;
                boolean bl3 = false;
                IrElement irElement3 = irElement = (IrElement)(declaration2 instanceof IrConstructor ? (IrDeclaration)this.transformEnumConstructor((IrConstructor)declaration2, irClass) : declaration2);
                if (irElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                }
                list2.set(n3, (IrDeclaration)irElement3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor transformEnumConstructor(IrConstructor enumConstructor, IrClass enumClass2) {
            Collection<IrValueParameter> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Annotations annotations2 = enumConstructor.getDescriptor().getAnnotations();
            SourceElement sourceElement = enumConstructor.getDescriptor().getSource();
            Intrinsics.checkExpressionValueIsNotNull(sourceElement, "enumConstructor.descriptor.source");
            WrappedClassConstructorDescriptor descriptor2 = new WrappedClassConstructorDescriptor(annotations2, sourceElement);
            int n = enumConstructor.getStartOffset();
            int n2 = enumConstructor.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = enumConstructor.getOrigin();
            IrConstructorSymbol irConstructorSymbol = new IrConstructorSymbolImpl(descriptor2);
            Name name = enumConstructor.getName();
            Visibility visibility = Visibilities.PRIVATE;
            Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PRIVATE");
            IrConstructorImpl irConstructorImpl = new IrConstructorImpl(n, n2, irDeclarationOrigin, irConstructorSymbol, name, visibility, enumConstructor.getReturnType(), enumConstructor.isInline(), enumConstructor.isExternal(), enumConstructor.isPrimary());
            boolean bl = false;
            boolean bl2 = false;
            IrConstructorImpl $this$apply = irConstructorImpl;
            boolean bl3 = false;
            IrConstructorImpl newConstructor = $this$apply;
            descriptor2.bind((IrDeclaration)$this$apply);
            $this$apply.setParent(enumClass2);
            IrValueParameter nameParameter = this.makeNameValueParameter(newConstructor);
            IrValueParameter ordinalParameter = this.makeOrdinalValueParameter(newConstructor);
            $this$apply.getValueParameters().add(0, nameParameter);
            $this$apply.getValueParameters().add(1, ordinalParameter);
            Iterable iterable = enumConstructor.getValueParameters();
            List<IrValueParameter> list2 = $this$apply.getValueParameters();
            boolean $i$f$map = false;
            void var15_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void param;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                IrValueParameter irValueParameter2 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)param, newConstructor, null, param.getIndex() + 2, 0, 0, null, null, null, null, false, false, 2042, null);
                boolean bl5 = false;
                boolean bl6 = false;
                IrValueParameter newParam = irValueParameter2;
                boolean bl7 = false;
                ((Map)this.loweredEnumConstructorParameters).put(param.getSymbol(), newParam);
                IrValueParameter irValueParameter3 = irValueParameter2;
                collection.add(irValueParameter3);
            }
            collection = (List)destination$iv$iv;
            list2.addAll(collection);
            IrBody irBody = enumConstructor.getBody();
            $this$apply.setBody(irBody != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBody, $this$apply) : null);
            ((Map)this.loweredEnumConstructors).put(enumConstructor.getSymbol(), $this$apply);
            $this$apply.setMetadata(enumConstructor.getMetadata());
            return irConstructorImpl;
        }

        private final IrValueParameter makeNameValueParameter(IrConstructor constructor) {
            WrappedValueParameterDescriptor descriptor2 = new WrappedValueParameterDescriptor(null, null, 3, null);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
            IrValueParameterSymbol irValueParameterSymbol = new IrValueParameterSymbolImpl(descriptor2);
            Name name = Name.identifier("name");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"name\")");
            IrValueParameterImpl irValueParameterImpl = new IrValueParameterImpl(-1, -1, irDeclarationOrigin, irValueParameterSymbol, name, 0, EnumClassLowering.this.getContext().getIrBuiltIns().getStringType(), null, false, false);
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameterImpl $this$apply = irValueParameterImpl;
            boolean bl3 = false;
            descriptor2.bind((IrDeclaration)$this$apply);
            $this$apply.setParent(constructor);
            return irValueParameterImpl;
        }

        private final IrValueParameter makeOrdinalValueParameter(IrConstructor constructor) {
            WrappedValueParameterDescriptor descriptor2 = new WrappedValueParameterDescriptor(null, null, 3, null);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
            IrValueParameterSymbol irValueParameterSymbol = new IrValueParameterSymbolImpl(descriptor2);
            Name name = Name.identifier("ordinal");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"ordinal\")");
            IrValueParameterImpl irValueParameterImpl = new IrValueParameterImpl(-1, -1, irDeclarationOrigin, irValueParameterSymbol, name, 1, EnumClassLowering.this.getContext().getIrBuiltIns().getIntType(), null, false, false);
            boolean bl = false;
            boolean bl2 = false;
            IrValueParameterImpl $this$apply = irValueParameterImpl;
            boolean bl3 = false;
            descriptor2.bind((IrDeclaration)$this$apply);
            $this$apply.setParent(constructor);
            return irValueParameterImpl;
        }

        private final void lowerEnumEntries() {
            TransformKt.transformDeclarationsFlat(this.irClass, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
                final /* synthetic */ EnumClassTransformer this$0;

                @Nullable
                public final List<IrDeclaration> invoke(@NotNull IrDeclaration declaration2) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    return declaration2 instanceof IrEnumEntry ? CollectionsKt.listOfNotNull(EnumClassTransformer.access$createFieldForEnumEntry(this.this$0, (IrEnumEntry)declaration2), EnumClassTransformer.access$lowerEnumEntryClass(this.this$0, ((IrEnumEntry)declaration2).getCorrespondingClass())) : null;
                }
                {
                    this.this$0 = enumClassTransformer;
                    super(1);
                }
            });
        }

        private final IrClass lowerEnumEntryClass(IrClass enumEntryClass) {
            if (enumEntryClass == null) {
                return null;
            }
            this.lowerEnumConstructors(enumEntryClass);
            return enumEntryClass;
        }

        private final IrField createFieldForEnumEntry(IrEnumEntry enumEntry) {
            JvmDeclarationFactory jvmDeclarationFactory = EnumClassLowering.this.getContext().getDeclarationFactory();
            IrClass irClass = enumEntry.getCorrespondingClass();
            if (irClass == null) {
                irClass = IrUtilsKt.getParentAsClass(enumEntry);
            }
            IrField irField = jvmDeclarationFactory.getFieldForEnumEntry(enumEntry, IrUtilsKt.getDefaultType(irClass));
            boolean bl = false;
            boolean bl2 = false;
            IrField it = irField;
            boolean bl3 = false;
            IrExpression irExpression = enumEntry.getInitializerExpression();
            if (irExpression == null) {
                Intrinsics.throwNpe();
            }
            it.setInitializer(new IrExpressionBodyImpl((IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irExpression, it)));
            it.getAnnotations().addAll((Collection<IrConstructorCall>)enumEntry.getAnnotations());
            this.enumEntryFields.add(it);
            ((Map)this.enumEntriesByField).put(it, enumEntry);
            return irField;
        }

        private final void setupSynthesizedEnumClassMembers() {
            IrFieldImpl irField = this.createSyntheticValuesFieldDeclaration();
            this.irClass.getDeclarations().add(irField);
            this.valuesFunction = this.findFunctionForMemberWithSyntheticBodyKind(IrSyntheticBodyKind.ENUM_VALUES);
            this.valueOfFunction = this.findFunctionForMemberWithSyntheticBodyKind(IrSyntheticBodyKind.ENUM_VALUEOF);
        }

        private final IrFunction findFunctionForMemberWithSyntheticBodyKind(IrSyntheticBodyKind kind) {
            Object element$iv;
            block2: {
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.irClass.getDeclarations());
                boolean $i$f$filterIsInstance = false;
                Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, EnumClassTransformer$findFunctionForMemberWithSyntheticBodyKind$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                Sequence $this$first$iv = sequence2;
                boolean $i$f$first = false;
                Iterator iterator2 = $this$first$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    IrFunction it = (IrFunction)element$iv;
                    boolean bl = false;
                    IrBody irBody = it.getBody();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    IrBody body2 = irBody;
                    boolean bl4 = false;
                    boolean bl5 = body2 instanceof IrSyntheticBody && ((IrSyntheticBody)body2).getKind() == kind;
                    if (!bl5) continue;
                    break block2;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            return (IrFunction)element$iv;
        }

        private final IrFieldImpl createSyntheticValuesFieldDeclaration() {
            IrSimpleType valuesArrayType = IrTypesKt.typeWith((IrClassifierSymbol)EnumClassLowering.this.getContext().getIrBuiltIns().getArrayClass(), IrUtilsKt.getDefaultType(this.irClass));
            IrExpression irValuesInitializer = this.createSyntheticValuesFieldInitializerExpression();
            WrappedFieldDescriptor descriptor2 = new WrappedFieldDescriptor(null, null, 3, null);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.FIELD_FOR_ENUM_VALUES.INSTANCE;
            IrFieldSymbol irFieldSymbol = new IrFieldSymbolImpl(descriptor2);
            Name name = Name.identifier("$VALUES");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"\\$VALUES\")");
            IrType irType = valuesArrayType;
            Visibility visibility = Visibilities.PRIVATE;
            Intrinsics.checkExpressionValueIsNotNull(visibility, "Visibilities.PRIVATE");
            IrFieldImpl irFieldImpl = new IrFieldImpl(-1, -1, irDeclarationOrigin, irFieldSymbol, name, irType, visibility, true, false, true);
            boolean bl = false;
            boolean bl2 = false;
            IrFieldImpl it = irFieldImpl;
            boolean bl3 = false;
            descriptor2.bind((IrDeclaration)it);
            it.setParent(this.irClass);
            it.setInitializer(new IrExpressionBodyImpl(-1, -1, irValuesInitializer));
            this.valuesField = it;
            return irFieldImpl;
        }

        /*
         * WARNING - void declaration
         */
        private final IrExpression createSyntheticValuesFieldInitializerExpression() {
            void $this$irArray$iv;
            JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder$default(EnumClassLowering.this.getContext(), this.irClass.getSymbol(), 0, 0, 6, null);
            IrType arrayType$iv = IrTypesKt.typeWith((IrClassifierSymbol)EnumClassLowering.this.getContext().getIrBuiltIns().getArrayClass(), IrUtilsKt.getDefaultType(this.irClass));
            boolean $i$f$irArray = false;
            IrArrayBuilder irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
            boolean bl = false;
            boolean bl2 = false;
            IrArrayBuilder $this$apply$iv = irArrayBuilder;
            boolean bl3 = false;
            IrArrayBuilder $this$irArray = $this$apply$iv;
            boolean bl4 = false;
            Iterable $this$forEach$iv = this.enumEntryFields;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrField irField = (IrField)element$iv;
                boolean bl5 = false;
                $this$irArray.unaryPlus(new IrGetFieldImpl(-1, -1, (IrFieldSymbol)irField.getSymbol(), irField.getType(), null, null, 48, null));
            }
            return irArrayBuilder.build();
        }

        private final void lowerEnumClassBody() {
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new EnumClassBodyTransformer());
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        public EnumClassTransformer(IrClass irClass) {
            Intrinsics.checkParameterIsNotNull(irClass, "irClass");
            this.irClass = irClass;
            this.enumEntryOrdinals = new TObjectIntHashMap();
            this.enumEntryClassToEntry = new HashMap();
            this.loweredEnumConstructors = new HashMap();
            this.loweredEnumConstructorParameters = new HashMap();
            this.enumEntriesByField = new HashMap();
            this.enumEntryFields = new ArrayList();
        }

        public static final /* synthetic */ IrField access$getValuesField$p(EnumClassTransformer $this) {
            IrField irField = $this.valuesField;
            if (irField == null) {
                Intrinsics.throwUninitializedPropertyAccessException("valuesField");
            }
            return irField;
        }

        public static final /* synthetic */ void access$setValuesField$p(EnumClassTransformer $this, IrField irField) {
            $this.valuesField = irField;
        }

        public static final /* synthetic */ IrFunction access$getValueOfFunction$p(EnumClassTransformer $this) {
            IrFunction irFunction = $this.valueOfFunction;
            if (irFunction == null) {
                Intrinsics.throwUninitializedPropertyAccessException("valueOfFunction");
            }
            return irFunction;
        }

        public static final /* synthetic */ void access$setValueOfFunction$p(EnumClassTransformer $this, IrFunction irFunction) {
            $this.valueOfFunction = irFunction;
        }

        public static final /* synthetic */ IrFunction access$getValuesFunction$p(EnumClassTransformer $this) {
            IrFunction irFunction = $this.valuesFunction;
            if (irFunction == null) {
                Intrinsics.throwUninitializedPropertyAccessException("valuesFunction");
            }
            return irFunction;
        }

        public static final /* synthetic */ void access$setValuesFunction$p(EnumClassTransformer $this, IrFunction irFunction) {
            $this.valuesFunction = irFunction;
        }

        public static final /* synthetic */ IrField access$createFieldForEnumEntry(EnumClassTransformer $this, IrEnumEntry enumEntry) {
            return $this.createFieldForEnumEntry(enumEntry);
        }

        public static final /* synthetic */ IrClass access$lowerEnumEntryClass(EnumClassTransformer $this, IrClass enumEntryClass) {
            return $this.lowerEnumEntryClass(enumEntryClass);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumClassConstructor;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumConstructorCallTransformer;", "irEnumConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)V", "getIrEnumConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "transform", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "delegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "enumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend.jvm"})
        private final class InEnumClassConstructor
        implements EnumConstructorCallTransformer {
            @NotNull
            private final IrConstructor irEnumConstructor;

            @Override
            @NotNull
            public IrExpression transform(@NotNull IrEnumConstructorCall enumConstructorCall) {
                Intrinsics.checkParameterIsNotNull(enumConstructorCall, "enumConstructorCall");
                int startOffset = enumConstructorCall.getStartOffset();
                int endOffset = enumConstructorCall.getEndOffset();
                IrStatementOrigin origin = enumConstructorCall.getOrigin();
                IrDelegatingConstructorCallImpl result2 = new IrDelegatingConstructorCallImpl(startOffset, endOffset, EnumClassLowering.this.getContext().getIrBuiltIns().getUnitType(), enumConstructorCall.getSymbol(), enumConstructorCall.getDescriptor(), enumConstructorCall.getTypeArgumentsCount());
                boolean bl = enumConstructorCall.getTypeArgumentsCount() == 1;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-EnumClassLowering$EnumClassTransformer$InEnumClassConstructor$transform$32 = false;
                    String $i$a$-assert-EnumClassLowering$EnumClassTransformer$InEnumClassConstructor$transform$32 = "Enum<T> call expected:\n" + DumpIrTreeKt.dump(result2);
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-EnumClassLowering$EnumClassTransformer$InEnumClassConstructor$transform$32));
                }
                result2.putTypeArgument(0, enumConstructorCall.getTypeArgument(0));
                bl = ((IrConstructor)result2.getSymbol().getOwner()).getValueParameters().size() == 2;
                bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Enum(String, Int) constructor call expected:\n" + DumpIrTreeKt.dump(result2);
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                List<IrValueParameter> list2 = this.irEnumConstructor.getValueParameters();
                int n = 0;
                int n2 = 0;
                if (n > CollectionsKt.getLastIndex(list2)) {
                    int it = n;
                    boolean bl4 = false;
                    throw (Throwable)((Object)new AssertionError((Object)("No 'name' parameter in enum constructor: " + DumpIrTreeKt.dump(this.irEnumConstructor))));
                }
                IrValueParameter nameParameter = list2.get(n);
                List<IrValueParameter> list3 = this.irEnumConstructor.getValueParameters();
                n2 = 1;
                boolean bl5 = false;
                if (n2 > CollectionsKt.getLastIndex(list3)) {
                    int it = n2;
                    boolean bl6 = false;
                    throw (Throwable)((Object)new AssertionError((Object)("No 'ordinal' parameter in enum constructor: " + DumpIrTreeKt.dump(this.irEnumConstructor))));
                }
                IrValueParameter ordinalParameter = list3.get(n2);
                result2.putValueArgument(0, new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)nameParameter.getSymbol(), origin));
                result2.putValueArgument(1, new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)ordinalParameter.getSymbol(), origin));
                return result2;
            }

            @Override
            @NotNull
            public IrExpression transform(@NotNull IrDelegatingConstructorCall delegatingConstructorCall) {
                Intrinsics.checkParameterIsNotNull(delegatingConstructorCall, "delegatingConstructorCall");
                int startOffset = delegatingConstructorCall.getStartOffset();
                int endOffset = delegatingConstructorCall.getEndOffset();
                Map map2 = EnumClassTransformer.this.loweredEnumConstructors;
                IrConstructorSymbol irConstructorSymbol = delegatingConstructorCall.getSymbol();
                boolean bl = false;
                Object v = map2.get(irConstructorSymbol);
                if (v == null) {
                    boolean bl2 = false;
                    throw (Throwable)((Object)new AssertionError((Object)("Constructor called in enum entry initializer should've been lowered: " + delegatingConstructorCall.getSymbol())));
                }
                IrConstructorImpl loweredDelegatedConstructor = (IrConstructorImpl)v;
                IrDelegatingConstructorCallImpl result2 = new IrDelegatingConstructorCallImpl(startOffset, endOffset, EnumClassLowering.this.getContext().getIrBuiltIns().getUnitType(), loweredDelegatedConstructor.getSymbol(), loweredDelegatedConstructor.getDescriptor(), loweredDelegatedConstructor.getTypeParameters().size());
                boolean bl3 = loweredDelegatedConstructor.getTypeParameters().size() == 0;
                bl = false;
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl4 = false;
                    String string2 = "Enum delegating call expected:\n" + DumpIrTreeKt.dump(result2);
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                result2.putValueArgument(0, new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)this.irEnumConstructor.getValueParameters().get(0).getSymbol(), null, 8, null));
                result2.putValueArgument(1, new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)this.irEnumConstructor.getValueParameters().get(1).getSymbol(), null, 8, null));
                Iterable $this$forEach$iv = ((IrConstructor)delegatingConstructorCall.getSymbol().getOwner()).getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter valueParameter = (IrValueParameter)element$iv;
                    boolean bl5 = false;
                    int i = valueParameter.getIndex();
                    result2.putValueArgument(i + 2, delegatingConstructorCall.getValueArgument(i));
                }
                return result2;
            }

            @NotNull
            public final IrConstructor getIrEnumConstructor() {
                return this.irEnumConstructor;
            }

            public InEnumClassConstructor(IrConstructor irEnumConstructor) {
                Intrinsics.checkParameterIsNotNull(irEnumConstructor, "irEnumConstructor");
                this.irEnumConstructor = irEnumConstructor;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntry;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumConstructorCallTransformer;", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;)V", "createConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "startOffset", "", "endOffset", "loweredConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "transform", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "delegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "enumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "backend.jvm"})
        private abstract class InEnumEntry
        implements EnumConstructorCallTransformer {
            private final IrEnumEntry enumEntry;

            @Override
            @NotNull
            public IrExpression transform(@NotNull IrEnumConstructorCall enumConstructorCall) {
                Intrinsics.checkParameterIsNotNull(enumConstructorCall, "enumConstructorCall");
                String string2 = this.enumEntry.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "enumEntry.name.asString()");
                String name = string2;
                int ordinal = EnumClassTransformer.this.enumEntryOrdinals.get((Object)this.enumEntry);
                int startOffset = enumConstructorCall.getStartOffset();
                int endOffset = enumConstructorCall.getEndOffset();
                Map map2 = EnumClassTransformer.this.loweredEnumConstructors;
                IrConstructorSymbol irConstructorSymbol = enumConstructorCall.getSymbol();
                boolean bl = false;
                Object v = map2.get(irConstructorSymbol);
                if (v == null) {
                    boolean bl2 = false;
                    throw (Throwable)((Object)new AssertionError((Object)("Constructor called in enum entry initializer should've been lowered:\n" + DumpIrTreeKt.dump(enumConstructorCall))));
                }
                IrConstructorImpl loweredConstructor = (IrConstructorImpl)v;
                IrMemberAccessExpression result2 = this.createConstructorCall(startOffset, endOffset, loweredConstructor);
                result2.putValueArgument(0, IrConstImpl.Companion.string(startOffset, endOffset, EnumClassLowering.this.getContext().getIrBuiltIns().getStringType(), name));
                result2.putValueArgument(1, IrConstImpl.Companion.int(startOffset, endOffset, EnumClassLowering.this.getContext().getIrBuiltIns().getIntType(), ordinal));
                Iterable $this$forEach$iv = ((IrConstructor)enumConstructorCall.getSymbol().getOwner()).getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter valueParameter = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    int i = valueParameter.getIndex();
                    result2.putValueArgument(i + 2, enumConstructorCall.getValueArgument(i));
                }
                return result2;
            }

            @Override
            @NotNull
            public IrExpression transform(@NotNull IrDelegatingConstructorCall delegatingConstructorCall) {
                Intrinsics.checkParameterIsNotNull(delegatingConstructorCall, "delegatingConstructorCall");
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected delegating constructor call within enum entry: " + this.enumEntry)));
            }

            @NotNull
            public abstract IrMemberAccessExpression createConstructorCall(int var1, int var2, @NotNull IrConstructor var3);

            public InEnumEntry(IrEnumEntry enumEntry) {
                Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
                this.enumEntry = enumEntry;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntryClassConstructor;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntry;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;)V", "createConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrDelegatingConstructorCallImpl;", "startOffset", "", "endOffset", "loweredConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.jvm"})
        private final class InEnumEntryClassConstructor
        extends InEnumEntry {
            @Override
            @NotNull
            public IrDelegatingConstructorCallImpl createConstructorCall(int startOffset, int endOffset, @NotNull IrConstructor loweredConstructor) {
                Intrinsics.checkParameterIsNotNull(loweredConstructor, "loweredConstructor");
                return new IrDelegatingConstructorCallImpl(startOffset, endOffset, EnumClassLowering.this.getContext().getIrBuiltIns().getUnitType(), (IrConstructorSymbol)loweredConstructor.getSymbol(), loweredConstructor.getDescriptor(), loweredConstructor.getTypeParameters().size());
            }

            public InEnumEntryClassConstructor(IrEnumEntry enumEntry) {
                Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
                super(enumEntry);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntryInitializer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$InEnumEntry;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering;", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;)V", "createConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstructorCallImpl;", "startOffset", "", "endOffset", "loweredConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.jvm"})
        private final class InEnumEntryInitializer
        extends InEnumEntry {
            @Override
            @NotNull
            public IrConstructorCallImpl createConstructorCall(int startOffset, int endOffset, @NotNull IrConstructor loweredConstructor) {
                Intrinsics.checkParameterIsNotNull(loweredConstructor, "loweredConstructor");
                return IrConstructorCallImpl.Companion.fromSymbolDescriptor$default(IrConstructorCallImpl.Companion, startOffset, endOffset, IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass((IrDeclaration)((IrConstructorSymbol)loweredConstructor.getSymbol()).getOwner())), (IrConstructorSymbol)loweredConstructor.getSymbol(), null, 16, null);
            }

            public InEnumEntryInitializer(IrEnumEntry enumEntry) {
                Intrinsics.checkParameterIsNotNull(enumEntry, "enumEntry");
                super(enumEntry);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumClassTransformer;)V", "enumConstructorCallTransformer", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumClassLowering$EnumConstructorCallTransformer;", "createEnumValueOfBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "createEnumValuesBody", "valuesField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitField", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSyntheticBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrSyntheticBody;", "backend.jvm"})
        private final class EnumClassBodyTransformer
        extends IrElementTransformerVoid {
            private EnumConstructorCallTransformer enumConstructorCallTransformer;

            @Override
            @NotNull
            public IrStatement visitField(@NotNull IrField declaration2) {
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                IrEnumEntry enumEntry = (IrEnumEntry)EnumClassTransformer.this.enumEntriesByField.get(declaration2);
                if (enumEntry == null) {
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                    return declaration2;
                }
                boolean bl = this.enumConstructorCallTransformer == null;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Nested enum entry initialization:\n" + DumpIrTreeKt.dump(declaration2);
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                this.enumConstructorCallTransformer = new InEnumEntryInitializer(enumEntry);
                IrStatement result2 = super.visitField(declaration2);
                this.enumConstructorCallTransformer = null;
                return result2;
            }

            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration2) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                IrDeclarationParent irDeclarationParent = declaration2.getParent();
                if (irDeclarationParent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                }
                IrClass containingClass = (IrClass)irDeclarationParent;
                EnumConstructorCallTransformer previous = this.enumConstructorCallTransformer;
                if (IrUtilsKt.isEnumEntry(containingClass)) {
                    bl = this.enumConstructorCallTransformer == null;
                    boolean bl2 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer$visitConstructor$32 = false;
                        String $i$a$-assert-EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer$visitConstructor$32 = "Nested enum entry initialization:\n" + DumpIrTreeKt.dump(declaration2);
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer$visitConstructor$32));
                    }
                    Object v = EnumClassTransformer.this.enumEntryClassToEntry.get(containingClass);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(v, "enumEntryClassToEntry[containingClass]!!");
                    this.enumConstructorCallTransformer = new InEnumEntryClassConstructor((IrEnumEntry)v);
                } else if (IrUtilsKt.isEnumClass(containingClass)) {
                    bl = this.enumConstructorCallTransformer == null;
                    boolean bl3 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl4 = false;
                        String string2 = "Nested enum entry initialization:\n" + DumpIrTreeKt.dump(declaration2);
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    this.enumConstructorCallTransformer = new InEnumClassConstructor(declaration2);
                }
                IrStatement result2 = super.visitConstructor(declaration2);
                this.enumConstructorCallTransformer = previous;
                return result2;
            }

            @Override
            @NotNull
            public IrExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                EnumConstructorCallTransformer enumConstructorCallTransformer = this.enumConstructorCallTransformer;
                if (enumConstructorCallTransformer == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Enum constructor call outside of enum entry initialization or enum class constructor:\n" + DumpIrTreeKt.dump(EnumClassTransformer.this.getIrClass()))));
                }
                EnumConstructorCallTransformer callTransformer = enumConstructorCallTransformer;
                return callTransformer.transform(expression2);
            }

            @Override
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                if (IrUtilsKt.getParentAsClass((IrDeclaration)expression2.getSymbol().getOwner()).getKind() == ClassKind.ENUM_CLASS) {
                    EnumConstructorCallTransformer enumConstructorCallTransformer = this.enumConstructorCallTransformer;
                    if (enumConstructorCallTransformer == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Enum constructor call outside of enum entry initialization or enum class constructor:\n" + DumpIrTreeKt.dump(EnumClassTransformer.this.getIrClass()))));
                    }
                    EnumConstructorCallTransformer callTransformer = enumConstructorCallTransformer;
                    return callTransformer.transform(expression2);
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                Map map2 = EnumClassTransformer.this.loweredEnumConstructorParameters;
                IrValueSymbol irValueSymbol = expression2.getSymbol();
                boolean bl = false;
                IrValueParameter loweredParameter = (IrValueParameter)map2.get(irValueSymbol);
                return loweredParameter != null ? (IrGetValue)new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrValueSymbol)loweredParameter.getSymbol(), expression2.getOrigin()) : expression2;
            }

            @Override
            @NotNull
            public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrBody irBody;
                Intrinsics.checkParameterIsNotNull(body2, "body");
                switch (EnumClassLowering$EnumClassTransformer$EnumClassBodyTransformer$WhenMappings.$EnumSwitchMapping$0[body2.getKind().ordinal()]) {
                    case 1: {
                        irBody = this.createEnumValuesBody(EnumClassTransformer.access$getValuesField$p(EnumClassTransformer.this));
                        break;
                    }
                    case 2: {
                        irBody = this.createEnumValueOfBody();
                        break;
                    }
                    default: {
                        irBody = body2;
                    }
                }
                return irBody;
            }

            private final IrBody createEnumValueOfBody() {
                IrSimpleFunctionSymbol enumValueOf = EnumClassLowering.this.getContext().getIrBuiltIns().getEnumValueOfSymbol();
                IrSimpleType returnType2 = IrUtilsKt.getDefaultType(EnumClassTransformer.this.getIrClass());
                Object unsubstitutedValueOfDescriptor = enumValueOf.getDescriptor();
                TypeParameterDescriptor typeParameter0 = unsubstitutedValueOfDescriptor.getTypeParameters().get(0);
                SimpleType simpleType2 = EnumClassTransformer.this.getIrClass().getDescriptor().getDefaultType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "irClass.descriptor.defaultType");
                SimpleType enumClassType = simpleType2;
                TypeParameterDescriptor typeParameterDescriptor = typeParameter0;
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter0");
                TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(MapsKt.mapOf(TuplesKt.to(typeParameterDescriptor.getTypeConstructor(), new TypeProjectionImpl(enumClassType))));
                Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor2, "TypeSubstitutor.create(m\u2026tionImpl(enumClassType)))");
                TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
                FunctionDescriptor functionDescriptor = unsubstitutedValueOfDescriptor.substitute(typeSubstitutor3);
                if (functionDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "unsubstitutedValueOfDesc\u2026titute(typeSubstitutor)!!");
                FunctionDescriptor substitutedValueOfDescriptor = functionDescriptor;
                IrCallImpl irValueOfCall = new IrCallImpl(-1, -1, returnType2, enumValueOf, substitutedValueOfDescriptor, ((IrSimpleFunction)enumValueOf.getOwner()).getTypeParameters().size(), null, null, 192, null);
                irValueOfCall.putTypeArgument(0, IrUtilsKt.getDefaultType(EnumClassTransformer.this.getIrClass()));
                irValueOfCall.putValueArgument(0, new IrGetValueImpl(-1, -1, (IrValueSymbol)EnumClassTransformer.access$getValueOfFunction$p(EnumClassTransformer.this).getValueParameters().get(0).getSymbol(), null, 8, null));
                return new IrBlockBodyImpl(-1, -1, CollectionsKt.listOf(new IrReturnImpl(-1, -1, returnType2, EnumClassTransformer.access$getValueOfFunction$p(EnumClassTransformer.this).getSymbol(), irValueOfCall)));
            }

            private final IrBody createEnumValuesBody(IrField valuesField) {
                IrSimpleFunction irSimpleFunction;
                boolean bl;
                Object object;
                block2: {
                    Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions((IrClass)EnumClassLowering.this.getContext().getIrBuiltIns().getArrayClass().getOwner());
                    boolean bl2 = false;
                    object = sequence2;
                    bl = false;
                    Iterator<IrSimpleFunction> iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        IrSimpleFunction irSimpleFunction2;
                        IrSimpleFunction it = irSimpleFunction2 = iterator2.next();
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getName().asString(), "clone")) continue;
                        irSimpleFunction = irSimpleFunction2;
                        break block2;
                    }
                    irSimpleFunction = null;
                }
                if (irSimpleFunction == null) {
                    Intrinsics.throwNpe();
                }
                IrSimpleFunction cloneFun = irSimpleFunction;
                IrType returnType2 = EnumClassTransformer.access$getValuesFunction$p(EnumClassTransformer.this).getSymbol().getOwner().getReturnType();
                object = new IrCallImpl(-1, -1, returnType2, cloneFun.getSymbol(), cloneFun.getDescriptor(), 0, null, null, 192, null);
                bl = false;
                boolean bl4 = false;
                Object $this$apply = object;
                boolean bl5 = false;
                ((IrMemberAccessExpressionBase)$this$apply).setDispatchReceiver(new IrGetFieldImpl(-1, -1, (IrFieldSymbol)valuesField.getSymbol(), ((IrField)((IrFieldSymbol)valuesField.getSymbol()).getOwner()).getType(), null, null, 48, null));
                Object irCloneValues = object;
                return new IrBlockBodyImpl(-1, -1, CollectionsKt.listOf(new IrReturnImpl(-1, -1, returnType2, EnumClassTransformer.access$getValuesFunction$p(EnumClassTransformer.this).getSymbol(), (IrExpression)irCloneValues)));
            }
        }
    }
}

