/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentContentProvider;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentUpdate;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementContentProvider;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementContentUpdate;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;

public class DocumentContentUpdate
extends DocumentUpdate
implements IDocumentElementContentUpdate {
    private DocumentContentProvider fContentProvider;
    private IDocumentElementContentProvider fElementContentProvider;
    private int fLineCount = 0;
    private int fOriginalOffset = 0;
    private int fOffset = 0;
    private Object[] fElements;
    boolean fReveal = true;

    public DocumentContentUpdate(DocumentContentProvider contentProvider, IDocumentElementContentProvider elementContentProvider, IDocumentPresentation presentationContext, Object rootElement, Object baseElement, Object input, int lineCount, int offset, boolean reveal) {
        super(presentationContext, rootElement, baseElement, input);
        this.fContentProvider = contentProvider;
        this.fElementContentProvider = elementContentProvider;
        this.fLineCount = lineCount;
        this.fOriginalOffset = offset;
        this.fOffset = offset;
        this.fElements = new Object[lineCount];
        this.fReveal = reveal;
    }

    @Override
    public void setLineCount(int lineCount) {
        this.fElements = new Object[lineCount];
    }

    @Override
    public void addElement(int line, Object element) throws IndexOutOfBoundsException {
        if (line < 0 || line >= this.fElements.length) {
            throw new IndexOutOfBoundsException(Integer.toString(line));
        }
        this.fElements[line] = element;
    }

    @Override
    public int getOriginalOffset() {
        return this.fOriginalOffset;
    }

    @Override
    public int getRequestedLineCount() {
        return this.fLineCount;
    }

    @Override
    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    @Override
    public boolean reveal() {
        return this.fReveal;
    }

    @Override
    public void done() {
        super.done();
        this.getContentProvider().updateCompleted(this);
    }

    protected Object[] getElements() {
        return this.fElements;
    }

    protected int getLineCount() {
        return this.fElements.length;
    }

    protected int getOffset() {
        return this.fOffset;
    }

    protected DocumentContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    protected IDocumentElementContentProvider getElementContentProvider() {
        return this.fElementContentProvider;
    }

    @Override
    void startRequest() {
        this.getElementContentProvider().updateContent(this);
    }
}

