# _ProcessClient
<span class="source-link">[[Source]](src/process/_test.md#L369)</span>

Notifications for Process connections.


```pony
class ref _ProcessClient is
  ProcessNotify ref
```

#### Implements

* [ProcessNotify](process-ProcessNotify.md) ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/process/_test.md#L382)</span>


```pony
new iso create(
  out: USize val,
  err: String val,
  exit_code: I32 val,
  h: TestHelper val)
: _ProcessClient iso^
```
#### Parameters

*   out: [USize](builtin-USize.md) val
*   err: [String](builtin-String.md) val
*   exit_code: [I32](builtin-I32.md) val
*   h: [TestHelper](ponytest-TestHelper.md) val

#### Returns

* [_ProcessClient](process-_ProcessClient.md) iso^

---

## Public Functions

### stdout
<span class="source-link">[[Source]](src/process/_test.md#L394)</span>


Called when new data is received on STDOUT of the forked process


```pony
fun ref stdout(
  process: ProcessMonitor ref,
  data: Array[U8 val] iso)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   data: [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] iso

#### Returns

* [None](builtin-None.md) val

---

### stderr
<span class="source-link">[[Source]](src/process/_test.md#L410)</span>


Called when new data is received on STDERR of the forked process


```pony
fun ref stderr(
  process: ProcessMonitor ref,
  data: Array[U8 val] iso)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   data: [Array](builtin-Array.md)\[[U8](builtin-U8.md) val\] iso

#### Returns

* [None](builtin-None.md) val

---

### failed
<span class="source-link">[[Source]](src/process/_test.md#L417)</span>


ProcessMonitor calls this if we run into errors with the
forked process.


```pony
fun ref failed(
  process: ProcessMonitor ref,
  err: (ExecveError val | ForkError val | KillError val | 
    PipeError val | Unsupported val | WaitpidError val | 
    WriteError val | CapError val))
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   err: ([ExecveError](process-ExecveError.md) val | [ForkError](process-ForkError.md) val | [KillError](process-KillError.md) val | 
    [PipeError](process-PipeError.md) val | [Unsupported](process-Unsupported.md) val | [WaitpidError](process-WaitpidError.md) val | 
    [WriteError](process-WriteError.md) val | [CapError](process-CapError.md) val)

#### Returns

* [None](builtin-None.md) val

---

### dispose
<span class="source-link">[[Source]](src/process/_test.md#L433)</span>


Called when ProcessMonitor terminates to cleanup ProcessNotify
We receive the exit code of the child process from ProcessMonitor.


```pony
fun ref dispose(
  process: ProcessMonitor ref,
  child_exit_code: I32 val)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   child_exit_code: [I32](builtin-I32.md) val

#### Returns

* [None](builtin-None.md) val

---

### created
<span class="source-link">[[Source]](src/process/process_notify.md#L6)</span>


```pony
fun ref created(
  process: ProcessMonitor ref)
: None val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref

#### Returns

* [None](builtin-None.md) val

---

### expect
<span class="source-link">[[Source]](src/process/process_notify.md#L29)</span>


```pony
fun ref expect(
  process: ProcessMonitor ref,
  qty: USize val)
: USize val
```
#### Parameters

*   process: [ProcessMonitor](process-ProcessMonitor.md) ref
*   qty: [USize](builtin-USize.md) val

#### Returns

* [USize](builtin-USize.md) val

---

