/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.attributeactors;

import freemind.controller.filter.util.SortedListModel;
import freemind.main.Resources;
import freemind.main.Tools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ListDialog
extends JDialog {
    private static ListDialog dialog;
    private JList list;
    private JButton addButton;
    private JButton renameButton;
    private JButton deleteButton;
    private JTextField textField;
    private SortedListModel data = null;

    public static void showDialog(Component frameComp, Component locationComp, String labelText, String title, SortedListModel possibleValues, String longValue) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        dialog = new ListDialog(frame, locationComp, labelText, title, possibleValues, longValue);
        Tools.addEscapeActionToDialog(dialog);
        dialog.show();
    }

    private void updateButtons() {
        String text = this.getCurrentText();
        boolean isNewText = -1 == this.getIndexOf(text);
        this.addButton.setEnabled(isNewText);
        int minSelectionIndex = this.list.getMinSelectionIndex();
        this.renameButton.setEnabled(minSelectionIndex != -1);
        this.deleteButton.setEnabled(minSelectionIndex != -1);
    }

    private String getCurrentText() {
        Document document = this.textField.getDocument();
        try {
            String text = document.getText(0, document.getLength());
            return text;
        }
        catch (BadLocationException e) {
            Resources.getInstance().logException(e);
            return "";
        }
    }

    private void selectText() {
        this.textField.requestFocus();
        this.textField.select(0, this.textField.getDocument().getLength());
    }

    private ListDialog(Frame frame, Component locationComp, String labelText, String title, SortedListModel data, String longValue) {
        super(frame, title, true);
        this.data = data;
        JButton closeButton = new JButton();
        Tools.setLabelAndMnemonic(closeButton, Resources.getInstance().getResourceString("close"));
        closeButton.addActionListener(new CloseAction());
        this.getRootPane().setDefaultButton(closeButton);
        this.addButton = new JButton();
        Tools.setLabelAndMnemonic(this.addButton, Resources.getInstance().getResourceString("add"));
        AddAction addAction = new AddAction();
        this.addButton.addActionListener(addAction);
        this.renameButton = new JButton();
        Tools.setLabelAndMnemonic(this.renameButton, Resources.getInstance().getResourceString("rename"));
        this.renameButton.addActionListener(new RenameAction());
        this.deleteButton = new JButton();
        Tools.setLabelAndMnemonic(this.deleteButton, Resources.getInstance().getResourceString("delete"));
        this.deleteButton.addActionListener(new DeleteAction());
        this.textField = new JTextField(20);
        this.textField.getDocument().addDocumentListener(new TextChangeListener());
        this.list = new JList(data){

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                int row;
                if (orientation == 1 && direction < 0 && (row = this.getFirstVisibleIndex()) != -1) {
                    Rectangle r = this.getCellBounds(row, row);
                    if (r.y == visibleRect.y && row != 0) {
                        Point loc = r.getLocation();
                        --loc.y;
                        int prevIndex = this.locationToIndex(loc);
                        Rectangle prevR = this.getCellBounds(prevIndex, prevIndex);
                        if (prevR == null || prevR.y >= r.y) {
                            return 0;
                        }
                        return prevR.height;
                    }
                }
                return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            }
        };
        this.list.setSelectionMode(1);
        if (longValue != null) {
            this.list.setPrototypeCellValue(longValue);
        }
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(-1);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListDialog.this.addButton.doClick();
                }
            }
        });
        this.list.setModel(data);
        this.list.addListSelectionListener(new ListSelectionChangeListener());
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(250, 80));
        listScroller.setAlignmentX(0.0f);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        JLabel label = new JLabel(labelText);
        label.setLabelFor(this.list);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(closeButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.addButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.renameButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(this.deleteButton);
        JPanel textPane = new JPanel();
        textPane.setLayout(new BoxLayout(textPane, 2));
        textPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        textPane.add(this.textField);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)textPane, "First");
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.updateButtons();
        this.pack();
        this.setLocationRelativeTo(locationComp);
    }

    private int getIndexOf(String text) {
        for (int i = 0; i < this.data.getSize(); ++i) {
            if (!this.data.getElementAt(i).toString().equals(text)) continue;
            return i;
        }
        return -1;
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            dialog.dispose();
        }
    }

    private class DeleteAction
    implements ActionListener {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues = ListDialog.this.list.getSelectedValues();
            for (int i = 0; i < selectedValues.length; ++i) {
                ListDialog.this.data.remove(selectedValues[i]);
            }
            if (ListDialog.this.data.getSize() == 0) {
                ListDialog.this.data.add("");
            }
            ListDialog.this.list.clearSelection();
        }
    }

    private class RenameAction
    implements ActionListener {
        private RenameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues = ListDialog.this.list.getSelectedValues();
            for (int i = 0; i < selectedValues.length; ++i) {
                if (selectedValues[i].equals(ListDialog.this.getCurrentText())) continue;
                ListDialog.this.data.replace(selectedValues[i], ListDialog.this.getCurrentText());
            }
            ListDialog.this.renameButton.setEnabled(false);
            ListDialog.this.list.clearSelection();
            ListDialog.this.selectText();
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListDialog.this.data.add(ListDialog.this.getCurrentText());
            ListDialog.this.addButton.setEnabled(false);
            ListDialog.this.selectText();
        }
    }

    private final class ListSelectionChangeListener
    implements ListSelectionListener {
        private ListSelectionChangeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int maxIndex;
            int minIndex = ListDialog.this.list.getMinSelectionIndex();
            if (minIndex == (maxIndex = ListDialog.this.list.getMaxSelectionIndex()) && minIndex != -1) {
                ListDialog.this.textField.setText(ListDialog.this.data.getElementAt(minIndex).toString());
                ListDialog.this.selectText();
            }
            ListDialog.this.updateButtons();
        }
    }

    private final class TextChangeListener
    implements DocumentListener {
        private TextChangeListener() {
        }

        private void update() {
            ListDialog.this.updateButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }
    }
}

