/*
 * Decompiled with CFR 0.152.
 */
package firrtl.passes;

import firrtl.CircuitForm;
import firrtl.CircuitState;
import firrtl.DuplexFlow$;
import firrtl.Flow;
import firrtl.InstanceKind$;
import firrtl.Kind;
import firrtl.PortKind$;
import firrtl.SinkFlow$;
import firrtl.SourceFlow$;
import firrtl.Transform;
import firrtl.UnknownFlow$;
import firrtl.Utils$;
import firrtl.WDefInstance;
import firrtl.WRef;
import firrtl.WSubAccess;
import firrtl.WSubField;
import firrtl.WSubIndex;
import firrtl.ir.BundleType;
import firrtl.ir.Circuit;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefMemory;
import firrtl.ir.DefModule;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Default$;
import firrtl.ir.DoPrim;
import firrtl.ir.Expression;
import firrtl.ir.Field;
import firrtl.ir.Flip$;
import firrtl.ir.Info;
import firrtl.ir.Mux;
import firrtl.ir.NoInfo$;
import firrtl.ir.Orientation;
import firrtl.ir.PartialConnect;
import firrtl.ir.Port;
import firrtl.ir.Print;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.Type;
import firrtl.ir.VectorType;
import firrtl.passes.CheckFlows;
import firrtl.passes.Errors;
import firrtl.passes.Pass;
import firrtl.traversals.Foreachers;
import firrtl.traversals.Foreachers$;
import firrtl.traversals.Foreachers$ExprForMagnet$;
import firrtl.traversals.Foreachers$ExprForeach$;
import firrtl.traversals.Foreachers$ModuleForMagnet$;
import firrtl.traversals.Foreachers$ModuleForeach$;
import firrtl.traversals.Foreachers$StmtForMagnet$;
import firrtl.traversals.Foreachers$StmtForeach$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CheckFlows$
extends Transform
implements Pass {
    public static CheckFlows$ MODULE$;

    static {
        new CheckFlows$();
    }

    @Override
    public CircuitForm inputForm() {
        return Pass.inputForm$(this);
    }

    @Override
    public CircuitForm outputForm() {
        return Pass.outputForm$(this);
    }

    @Override
    public CircuitState execute(CircuitState state) {
        return Pass.execute$(this, state);
    }

    public String toStr(Flow g) {
        String string;
        Flow flow = g;
        if (SourceFlow$.MODULE$.equals(flow)) {
            string = "source";
        } else if (SinkFlow$.MODULE$.equals(flow)) {
            string = "sink";
        } else if (UnknownFlow$.MODULE$.equals(flow)) {
            string = "unknown";
        } else if (DuplexFlow$.MODULE$.equals(flow)) {
            string = "duplex";
        } else {
            throw new MatchError(flow);
        }
        return string;
    }

    @Override
    public Circuit run(Circuit c) {
        Errors errors = new Errors();
        c.modules().foreach((Function1<DefModule, Object> & Serializable & scala.Serializable)m -> {
            CheckFlows$.$anonfun$run$72(this, errors, m);
            return BoxedUnit.UNIT;
        });
        errors.trigger();
        return c;
    }

    public static final /* synthetic */ boolean $anonfun$run$60(WSubField x5$1, Field x$12) {
        String string = x$12.name();
        String string2 = x5$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Flow get_flow$1(Expression e, HashMap flows) {
        Flow flow;
        block6: {
            Expression expression;
            while (true) {
                if ((expression = e) instanceof WRef) {
                    WRef wRef = (WRef)expression;
                    flow = (Flow)flows.apply(wRef.name());
                    break block6;
                }
                if (expression instanceof WSubIndex) {
                    WSubIndex wSubIndex = (WSubIndex)expression;
                    e = wSubIndex.expr();
                    continue;
                }
                if (!(expression instanceof WSubAccess)) break;
                WSubAccess wSubAccess = (WSubAccess)expression;
                e = wSubAccess.expr();
            }
            if (expression instanceof WSubField) {
                WSubField wSubField = (WSubField)expression;
                Type type = wSubField.expr().tpe();
                if (!(type instanceof BundleType)) {
                    throw new MatchError(type);
                }
                BundleType bundleType = (BundleType)type;
                Field f = (Field)bundleType.fields().find((Function1<Field, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean(CheckFlows$.$anonfun$run$60(wSubField, x$12))).get();
                Flow flow2 = Utils$.MODULE$.times(this.get_flow$1(wSubField.expr(), flows), f.flip());
                flow = flow2;
            } else {
                flow = SourceFlow$.MODULE$;
            }
        }
        return flow;
    }

    private final boolean flip_rec$1(Type t, Orientation f) {
        boolean bl;
        block2: {
            while (true) {
                Type type;
                if ((type = t) instanceof BundleType) {
                    BundleType bundleType = (BundleType)type;
                    bl = bundleType.fields().exists((Function1<Field, Object> & Serializable & scala.Serializable)field2 -> BoxesRunTime.boxToBoolean(this.flip_rec$1(field2.tpe(), Utils$.MODULE$.times(f, field2.flip()))));
                    break block2;
                }
                if (!(type instanceof VectorType)) break;
                VectorType vectorType = (VectorType)type;
                t = vectorType.tpe();
            }
            Orientation orientation = f;
            Flip$ flip$ = Flip$.MODULE$;
            bl = !(orientation != null ? !orientation.equals(flip$) : flip$ != null);
        }
        return bl;
    }

    private final boolean flip_q$1(Type t) {
        return this.flip_rec$1(t, Default$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void check_flow$1(Info info, String mname, HashMap flows, Flow desired, Expression e, Errors errors$3) {
        Flow flow = this.get_flow$1(e, flows);
        Tuple2<Flow, Flow> tuple2 = new Tuple2<Flow, Flow>(flow, desired);
        if (tuple2 != null) {
            Flow flow2 = tuple2._1();
            Flow flow3 = tuple2._2();
            if (SourceFlow$.MODULE$.equals(flow2) && SinkFlow$.MODULE$.equals(flow3)) {
                errors$3.append(new CheckFlows.WrongFlow(info, mname, e.serialize(), desired, flow));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            Flow flow4 = tuple2._1();
            Flow flow5 = tuple2._2();
            if (SinkFlow$.MODULE$.equals(flow4) && SourceFlow$.MODULE$.equals(flow5)) {
                Kind kind = Utils$.MODULE$.kind(e);
                boolean bl = PortKind$.MODULE$.equals(kind) ? true : InstanceKind$.MODULE$.equals(kind);
                if (bl && !this.flip_q$1(e.tpe())) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    errors$3.append(new CheckFlows.WrongFlow(info, mname, e.serialize(), desired, flow));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void check_flows_e$1(Info info, String mname, HashMap flows, Expression e2, Errors errors$3) {
        Expression expression = e2;
        if (expression instanceof Mux) {
            Mux mux = (Mux)expression;
            Foreachers$ExprForeach$.MODULE$.foreach$extension(Foreachers$.MODULE$.ExprForeach(mux), (Function1<Expression, Object> & Serializable & scala.Serializable)e -> {
                this.check_flow$1(info, mname, flows, SourceFlow$.MODULE$, e, errors$3);
                return BoxedUnit.UNIT;
            }, (Function1<Function1, Foreachers.ExprForMagnet> & Serializable & scala.Serializable)f -> Foreachers$ExprForMagnet$.MODULE$.forExpr((Function1<Expression, BoxedUnit>)f));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (expression instanceof DoPrim) {
            DoPrim doPrim = (DoPrim)expression;
            doPrim.args().foreach((Function1<Expression, Object> & Serializable & scala.Serializable)e -> {
                this.check_flow$1(info, mname, flows, SourceFlow$.MODULE$, e, errors$3);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Foreachers$ExprForeach$.MODULE$.foreach$extension(Foreachers$.MODULE$.ExprForeach(e2), (Function1<Expression, Object> & Serializable & scala.Serializable)e -> {
            this.check_flows_e$1(info, mname, flows, e, errors$3);
            return BoxedUnit.UNIT;
        }, (Function1<Function1, Foreachers.ExprForMagnet> & Serializable & scala.Serializable)f -> Foreachers$ExprForMagnet$.MODULE$.forExpr((Function1<Expression, BoxedUnit>)f));
    }

    private final void check_flows_s$1(Info minfo, String mname, HashMap flows, Statement s2, Errors errors$3) {
        Info info = Utils$.MODULE$.get_info(s2);
        Info info2 = NoInfo$.MODULE$.equals(info) ? minfo : info;
        Info info3 = info2;
        Statement statement = s2;
        if (statement instanceof DefWire) {
            DefWire defWire = (DefWire)statement;
            flows.update(defWire.name(), DuplexFlow$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            flows.update(defRegister.name(), DuplexFlow$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefMemory) {
            DefMemory defMemory = (DefMemory)statement;
            flows.update(defMemory.name(), SourceFlow$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof WDefInstance) {
            WDefInstance wDefInstance = (WDefInstance)statement;
            flows.update(wDefInstance.name(), SourceFlow$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefNode) {
            DefNode defNode = (DefNode)statement;
            this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, defNode.value(), errors$3);
            flows.update(defNode.name(), SourceFlow$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Connect) {
            Connect connect = (Connect)statement;
            this.check_flow$1(info3, mname, flows, SinkFlow$.MODULE$, connect.loc(), errors$3);
            this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, connect.expr(), errors$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Print) {
            Print print = (Print)statement;
            print.args().foreach((Function1<Expression, Object> & Serializable & scala.Serializable)e -> {
                this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, e, errors$3);
                return BoxedUnit.UNIT;
            });
            this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, print.en(), errors$3);
            this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, print.clk(), errors$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof PartialConnect) {
            PartialConnect partialConnect = (PartialConnect)statement;
            this.check_flow$1(info3, mname, flows, SinkFlow$.MODULE$, partialConnect.loc(), errors$3);
            this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, partialConnect.expr(), errors$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Conditionally) {
            Conditionally conditionally = (Conditionally)statement;
            this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, conditionally.pred(), errors$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Stop) {
            Stop stop = (Stop)statement;
            this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, stop.en(), errors$3);
            this.check_flow$1(info3, mname, flows, SourceFlow$.MODULE$, stop.clk(), errors$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Foreachers$StmtForeach$.MODULE$.foreach$extension(Foreachers$.MODULE$.StmtForeach(s2), (Function1<Expression, Object> & Serializable & scala.Serializable)e -> {
            this.check_flows_e$1(info3, mname, flows, e, errors$3);
            return BoxedUnit.UNIT;
        }, (Function1<Function1, Foreachers.StmtForMagnet> & Serializable & scala.Serializable)f -> Foreachers$StmtForMagnet$.MODULE$.forExp((Function1<Expression, BoxedUnit>)f));
        Foreachers$StmtForeach$.MODULE$.foreach$extension(Foreachers$.MODULE$.StmtForeach(s2), (Function1<Statement, Object> & Serializable & scala.Serializable)s -> {
            this.check_flows_s$1(minfo, mname, flows, s, errors$3);
            return BoxedUnit.UNIT;
        }, (Function1<Function1, Foreachers.StmtForMagnet> & Serializable & scala.Serializable)f -> Foreachers$StmtForMagnet$.MODULE$.forStmt((Function1<Statement, BoxedUnit>)f));
    }

    public static final /* synthetic */ void $anonfun$run$72(CheckFlows$ $this, Errors errors$3, DefModule m) {
        HashMap flows = new HashMap();
        flows.$plus$plus$eq(m.ports().map((Function1<Port, Tuple2> & Serializable & scala.Serializable)p -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p.name()), Utils$.MODULE$.to_flow(p.direction())), Seq$.MODULE$.canBuildFrom()));
        Foreachers$ModuleForeach$.MODULE$.foreach$extension(Foreachers$.MODULE$.ModuleForeach(m), (Function1<Statement, Object> & Serializable & scala.Serializable)s -> {
            $this.check_flows_s$1(m.info(), m.name(), flows, s, errors$3);
            return BoxedUnit.UNIT;
        }, (Function1<Function1, Foreachers.ModuleForMagnet> & Serializable & scala.Serializable)f -> Foreachers$ModuleForMagnet$.MODULE$.forStmt((Function1<Statement, BoxedUnit>)f));
    }

    private CheckFlows$() {
        MODULE$ = this;
        Pass.$init$(this);
    }
}

