/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.ExceptionData;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.processor.BacktraceProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.processor.V8EventProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8Protocol;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.BreakEventBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.EventNotification;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.SomeHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ExceptionDataImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoaderImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;

public class BreakpointProcessor
extends V8EventProcessor {
    private static final String EXCEPTION_NAME = "exception";

    public BreakpointProcessor(DebugSession debugSession) {
        super(debugSession);
    }

    @Override
    public void messageReceived(EventNotification eventMessage) {
        ContextBuilder.ExpectingBacktraceStep step2;
        BreakEventBody breakEventBody;
        String event = eventMessage.event();
        DebugSession debugSession = this.getDebugSession();
        ContextBuilder contextBuilder = debugSession.getContextBuilder();
        ContextBuilder.ExpectingBreakEventStep step1 = contextBuilder.buildNewContext();
        InternalContext internalContext = step1.getInternalContext();
        try {
            breakEventBody = eventMessage.body().asBreakEventBody();
        }
        catch (JsonProtocolParseException e) {
            throw new RuntimeException(e);
        }
        if (V8Protocol.EVENT_BREAK.key.equals(event)) {
            Collection<Breakpoint> breakpointsHit = this.getBreakpointsHit(eventMessage, breakEventBody);
            step2 = step1.setContextState(breakpointsHit, null);
        } else if (V8Protocol.EVENT_EXCEPTION.key.equals(event)) {
            ExceptionData exception = this.createException(eventMessage, breakEventBody, internalContext);
            step2 = step1.setContextState(Collections.<Breakpoint>emptySet(), exception);
        } else {
            contextBuilder.buildSequenceFailure();
            throw new RuntimeException();
        }
        this.processNextStep(step2);
    }

    public void processNextStep(ContextBuilder.ExpectingBacktraceStep step2) {
        BacktraceProcessor backtraceProcessor = new BacktraceProcessor(step2);
        InternalContext internalContext = step2.getInternalContext();
        DebuggerMessage message = DebuggerMessageFactory.backtrace(null, null, true);
        try {
            internalContext.sendV8CommandAsync(message, false, (V8CommandProcessor.V8HandlerCallback)backtraceProcessor, (SyncCallback)null);
        }
        catch (InternalContext.ContextDismissedCheckedException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<Breakpoint> getBreakpointsHit(EventNotification response, BreakEventBody breakEventBody) {
        List<Long> breakpointIdsArray = breakEventBody.breakpoints();
        BreakpointManager breakpointManager = this.getDebugSession().getBreakpointManager();
        if (breakpointIdsArray == null) {
            return Collections.emptySet();
        }
        ArrayList<Breakpoint> breakpointsHit = new ArrayList<Breakpoint>(breakpointIdsArray.size());
        int i = 0;
        int size = breakpointIdsArray.size();
        while (i < size) {
            Breakpoint existingBp = breakpointManager.getBreakpoint(breakpointIdsArray.get(i));
            if (existingBp != null) {
                breakpointsHit.add(existingBp);
            }
            ++i;
        }
        return breakpointsHit;
    }

    private ExceptionData createException(EventNotification response, BreakEventBody body, InternalContext internalContext) {
        List<SomeHandle> refs = response.refs();
        ValueHandle exception = body.exception();
        ValueLoaderImpl valueLoader = internalContext.getValueLoader();
        for (SomeHandle handle : refs) {
            valueLoader.addHandleFromRefs(handle);
        }
        valueLoader.addHandleFromRefs((SomeHandle)exception.getSuper());
        String sourceText = body.sourceLineText();
        ValueMirror mirror = valueLoader.addDataToMap(exception);
        return new ExceptionDataImpl(internalContext, mirror, EXCEPTION_NAME, body.uncaught(), sourceText, exception.text());
    }
}

