/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDModelDelayedReconciler {
    private ReconcilerJob reconcilerJob;
    private static final int DELAY = 300;
    private List elementsToReconcile = new ArrayList();

    public boolean shouldDelay(XSDSchema schema) {
        IEditorPart editorPart;
        boolean shouldDelay = false;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        IEditorPart iEditorPart = editorPart = workbenchPage != null ? workbenchPage.getActiveEditor() : null;
        if (editorPart != null && editorPart instanceof InternalXSDMultiPageEditor) {
            InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
            shouldDelay = xsdEditor.isSourcePageActive();
        }
        return shouldDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementChanged(Element element, XSDSchema schema) {
        List list = this.elementsToReconcile;
        synchronized (list) {
            if (!this.elementsToReconcile.contains(element)) {
                this.elementsToReconcile.add(element);
            }
            if (this.reconcilerJob == null) {
                this.reconcilerJob = new ReconcilerJob(schema);
            }
            this.reconcilerJob.schedule(300L);
        }
    }

    class ReconcilerJob
    extends UIJob {
        private XSDSchema schema;
        private static final int MAX_INACTIVE_COUNT = 10;
        private int timesAwakeAndIdle;

        public ReconcilerJob(XSDSchema schema) {
            super("Reconciling the XSD EMF model");
            this.timesAwakeAndIdle = 0;
            this.setSystem(true);
            this.setPriority(30);
            this.schema = schema;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Element[] elements = null;
            List list = XSDModelDelayedReconciler.this.elementsToReconcile;
            synchronized (list) {
                if (!XSDModelDelayedReconciler.this.elementsToReconcile.isEmpty()) {
                    elements = new Element[XSDModelDelayedReconciler.this.elementsToReconcile.size()];
                    XSDModelDelayedReconciler.this.elementsToReconcile.toArray(elements);
                    XSDModelDelayedReconciler.this.elementsToReconcile.clear();
                } else if (this.shouldTerminate()) {
                    XSDModelDelayedReconciler.this.reconcilerJob = null;
                    return Status.CANCEL_STATUS;
                }
            }
            this.reconcile(elements);
            this.schedule(300L);
            return Status.OK_STATUS;
        }

        private void reconcile(Element[] modifiedElements) {
            if (modifiedElements != null) {
                int index = 0;
                while (index < modifiedElements.length) {
                    Element modifiedElement = modifiedElements[index];
                    this.reconcile(modifiedElement);
                    ++index;
                }
            }
        }

        private void reconcile(Element modifiedElement) {
            if (modifiedElement != null) {
                XSDConcreteComponent concreteComponent = this.schema.getCorrespondingComponent((Node)modifiedElement);
                concreteComponent.elementChanged(modifiedElement);
            }
        }

        private boolean shouldTerminate() {
            return this.timesAwakeAndIdle++ == 10;
        }
    }
}

