/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.P2Utils;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.InvalidTargetBundle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetDefinition;

public class ProfileBundleContainer
extends AbstractBundleContainer {
    private static final String CONFIG_INI = "config.ini";
    private static final String PROP_AGENT_DATA_AREA = "eclipse.p2.data.area";
    private static final String PROP_PROFILE = "eclipse.p2.profile";
    private static final String PROP_CONFIG_DIR = "osgi.configuration.area";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_USER_HOME = "user.home";
    private static final String VAR_CONFIG_DIR = "@config.dir";
    private static final String VAR_USER_DIR = "@user.dir";
    private static final String VAR_USER_HOME = "@user.home";
    public static final String TYPE = "Profile";
    private final String fHome;
    private final String fConfiguration;

    public ProfileBundleContainer(String home, String configurationLocation) {
        this.fHome = home;
        this.fConfiguration = configurationLocation;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.resolveHomeLocation().toOSString();
        }
        return this.fHome;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getConfigurationLocation() {
        return this.fConfiguration;
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        String home = this.resolveHomeLocation().toOSString();
        if (!new File(home).isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_0, (Object)home)));
        }
        URL configUrl = this.getConfigurationArea();
        if (configUrl != null && !new File(configUrl.getFile()).isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_2, (Object)home)));
        }
        BundleInfo[] infos = P2Utils.readBundles(home, configUrl);
        if (infos == null) {
            TargetBundle[] platformXML;
            if (configUrl != null) {
                try {
                    TargetBundle[] osgiBundles = this.readBundleInfosFromConfigIni(configUrl.toURI());
                    if (osgiBundles != null && osgiBundles.length > 0) {
                        return osgiBundles;
                    }
                }
                catch (URISyntaxException ex) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", ex.getMessage(), (Throwable)ex));
                }
            }
            if ((platformXML = this.resolvePlatformXML(definition, home, monitor)) != null) {
                return platformXML;
            }
            infos = new BundleInfo[]{};
        }
        if (monitor.isCanceled()) {
            return new TargetBundle[0];
        }
        BundleInfo[] source = P2Utils.readSourceBundles(home, configUrl);
        if (source == null) {
            source = new BundleInfo[]{};
        }
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)(infos.length + source.length));
        return (TargetBundle[])((Stream)Stream.concat(Arrays.stream(infos), Arrays.stream(source)).parallel()).map(info -> {
            URI location = info.getLocation();
            try {
                if (monitor.isCanceled()) {
                    return null;
                }
                TargetBundle targetBundle = new TargetBundle(URIUtil.toFile((URI)location));
                return targetBundle;
            }
            catch (CoreException e) {
                InvalidTargetBundle invalidTargetBundle = new InvalidTargetBundle(new BundleInfo(location), e.getStatus());
                return invalidTargetBundle;
            }
            finally {
                localMonitor.split(1);
            }
        }).filter(Objects::nonNull).toArray(TargetBundle[]::new);
    }

    private TargetBundle[] readBundleInfosFromConfigIni(URI configArea) {
        File configIni = new File(configArea);
        if (!(configIni = new File(configIni, CONFIG_INI)).isFile()) {
            return null;
        }
        Properties configProps = new Properties();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream fis = new FileInputStream(configIni);){
                configProps.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.log(e);
            return null;
        }
        String osgiBundles = configProps.getProperty("osgi.bundles");
        if (osgiBundles == null || osgiBundles.isEmpty()) {
            return null;
        }
        String osgiFramework = configProps.getProperty("osgi.framework");
        if (osgiFramework != null && !osgiFramework.isEmpty()) {
            osgiBundles = String.valueOf(osgiFramework) + ',' + osgiBundles;
        }
        return (TargetBundle[])Arrays.stream(osgiBundles.split(",")).map(entry -> entry.split("@")[0]).map(location -> location.startsWith("reference:") ? location.substring("reference:".length()) : location).map(URI::create).filter(URI::isAbsolute).map(File::new).map(file -> {
            try {
                return new TargetBundle((File)file);
            }
            catch (CoreException e) {
                return new InvalidTargetBundle(new BundleInfo(file.toURI()), e.getStatus());
            }
        }).filter(Objects::nonNull).toArray(TargetBundle[]::new);
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        if (definition instanceof TargetDefinition) {
            return ((TargetDefinition)definition).resolveFeatures(this.getLocation(false), monitor);
        }
        return new TargetFeature[0];
    }

    protected TargetBundle[] resolvePlatformXML(ITargetDefinition definition, String home, IProgressMonitor monitor) throws CoreException {
        URL[] files = PluginPathFinder.getPlatformXMLPaths(home, false);
        if (files.length > 0) {
            ArrayList<TargetBundle> all = new ArrayList<TargetBundle>(files.length);
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DirectoryBundleContainer_0, (int)files.length);
            URL[] uRLArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                URL file = uRLArray[n2];
                if (localMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    File plugin = new File(file.getFile());
                    all.add(new TargetBundle(plugin));
                }
                catch (CoreException coreException) {}
                localMonitor.split(1);
                ++n2;
            }
            if (!all.isEmpty()) {
                return all.toArray(new TargetBundle[all.size()]);
            }
        }
        return null;
    }

    private IPath resolveHomeLocation() throws CoreException {
        return new Path(this.resolveVariables(this.fHome));
    }

    private URL getConfigurationArea() throws CoreException {
        IPath home = this.resolveHomeLocation();
        Object configuration = null;
        configuration = this.fConfiguration == null ? home.append("configuration") : new Path(this.resolveVariables(this.fConfiguration));
        File file = configuration.toFile();
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_1, (Object)home.toOSString()), (Throwable)e));
            }
        }
        if (this.fConfiguration != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_2, (Object)configuration.toOSString())));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof ProfileBundleContainer) {
            ProfileBundleContainer pbc = (ProfileBundleContainer)o;
            return this.fHome.equals(pbc.fHome) && this.isNullOrEqual(pbc.fConfiguration, this.fConfiguration);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.fHome.hashCode();
        if (this.fConfiguration != null) {
            hash += this.fConfiguration.hashCode();
        }
        return hash;
    }

    public File getProfileFileLocation() throws CoreException {
        String home = this.resolveHomeLocation().toOSString();
        if (!new File(home).isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_0, (Object)home)));
        }
        File configArea = null;
        URL configURL = this.getConfigurationArea();
        configArea = configURL != null ? new File(configURL.getFile()) : new File(home);
        if (!configArea.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.ProfileBundleContainer_2, (Object)configArea)));
        }
        File p2DataArea = null;
        String profileName = null;
        File configIni = new File(configArea, CONFIG_INI);
        if (configIni.isFile()) {
            Properties configProps = new Properties();
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (FileInputStream fis = new FileInputStream(configIni);){
                    configProps.load(fis);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                PDECore.log(e);
            }
            String p2Area = configProps.getProperty(PROP_AGENT_DATA_AREA);
            if (p2Area != null) {
                String base;
                if (p2Area.startsWith(VAR_USER_HOME)) {
                    base = this.substituteVar(configProps, p2Area, VAR_USER_HOME, PROP_USER_HOME, configArea);
                    p2Area = new Path(base).toFile().getAbsolutePath();
                } else if (p2Area.startsWith(VAR_USER_DIR)) {
                    base = this.substituteVar(configProps, p2Area, VAR_USER_DIR, PROP_USER_DIR, configArea);
                    p2Area = new Path(base).toFile().getAbsolutePath();
                } else if (p2Area.startsWith(VAR_CONFIG_DIR)) {
                    base = this.substituteVar(configProps, p2Area, VAR_CONFIG_DIR, PROP_CONFIG_DIR, configArea);
                    p2Area = new Path(base).toFile().getAbsolutePath();
                }
                p2DataArea = new File(p2Area);
            }
            profileName = configProps.getProperty(PROP_PROFILE);
        }
        if (p2DataArea == null || !p2DataArea.isDirectory()) {
            p2DataArea = new File(configArea, "p2");
        }
        if (profileName == null || profileName.length() == 0) {
            profileName = "SDKProfile";
        }
        Path profilePath = new Path(p2DataArea.getAbsolutePath());
        File profile = (profilePath = profilePath.append("org.eclipse.equinox.p2.engine").append("profileRegistry").append(String.valueOf(profileName) + ".profile")).toFile();
        if (profile.exists()) {
            return profile;
        }
        return null;
    }

    private String substituteVar(Properties props, String source, String var, String prop, File defaultValue) {
        String value = props.getProperty(prop);
        if (value == null) {
            value = defaultValue.getAbsolutePath();
        }
        return String.valueOf(value) + source.substring(var.length());
    }

    private boolean isNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public String toString() {
        return "Installation " + this.fHome + ' ' + (this.fConfiguration == null ? "Default Configuration" : this.fConfiguration);
    }
}

