/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class CElementIncludeResolver {
    public static List<IPath> resolveInclude(IInclude include) throws CoreException {
        IResource res = include.getUnderlyingResource();
        ArrayList<IPath> filesFound = new ArrayList<IPath>(4);
        String fullFileName = include.getFullFileName();
        if (fullFileName != null) {
            IFileStore store;
            Path fullPath = new Path(fullFileName);
            if (fullPath.isAbsolute() && fullPath.toFile().exists()) {
                filesFound.add((IPath)fullPath);
            } else if (fullPath.isUNC() && (store = EFS.getStore((URI)UNCPathConverter.getInstance().toURI((IPath)fullPath))).fetchInfo().exists()) {
                filesFound.add((IPath)fullPath);
            }
        }
        if (filesFound.isEmpty() && res != null) {
            IProject proj = res.getProject();
            String includeName = include.getElementName();
            IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(proj);
            if (provider != null) {
                IScannerInfo info = provider.getScannerInformation(res);
                if (info == null) {
                    info = provider.getScannerInformation((IResource)proj);
                }
                if (info != null) {
                    ExtendedScannerInfo scanInfo = new ExtendedScannerInfo(info);
                    boolean isSystemInclude = include.isStandard();
                    if (!isSystemInclude) {
                        IPath location = include.getTranslationUnit().getLocation();
                        if (location != null) {
                            String currentDir = location.removeLastSegments(1).toOSString();
                            CElementIncludeResolver.findFile(new String[]{currentDir}, includeName, filesFound);
                        }
                        if (filesFound.isEmpty()) {
                            String[] localIncludePaths = scanInfo.getLocalIncludePath();
                            CElementIncludeResolver.findFile(localIncludePaths, includeName, filesFound);
                        }
                    }
                    if (filesFound.isEmpty()) {
                        String[] includePaths = scanInfo.getIncludePaths();
                        CElementIncludeResolver.findFile(includePaths, includeName, filesFound);
                    }
                }
                if (filesFound.isEmpty()) {
                    CElementIncludeResolver.findFile((IContainer)proj, (IPath)new Path(includeName), filesFound);
                }
            }
        }
        return filesFound;
    }

    private static void findFile(String[] includePaths, String name, ArrayList<IPath> list) throws CoreException {
        Path includeFile = new Path(name);
        if (includeFile.isAbsolute() && (includeFile = PathUtil.getCanonicalPathWindows((IPath)includeFile)).toFile().exists()) {
            list.add((IPath)includeFile);
            return;
        }
        HashSet<IPath> foundSet = new HashSet<IPath>();
        String[] stringArray = includePaths;
        int n = includePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String includePath = stringArray[n2];
            IPath path = PathUtil.getCanonicalPathWindows((IPath)new Path(includePath).append((IPath)includeFile));
            File file = path.toFile();
            if (file.exists()) {
                IPath[] paths;
                IPath[] iPathArray = paths = CElementIncludeResolver.resolveIncludeLink(path);
                int n3 = paths.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath p = iPathArray[n4];
                    if (foundSet.add(p)) {
                        list.add(p);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static void findFile(IContainer parent, final IPath name, final ArrayList<IPath> list) throws CoreException {
        parent.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IPath rPath;
                if (proxy.getType() == 1 && proxy.getName().equalsIgnoreCase(name.lastSegment()) && (rPath = proxy.requestResource().getLocation()) != null) {
                    int numSegToRemove = rPath.segmentCount() - name.segmentCount();
                    IPath sPath = rPath.removeFirstSegments(numSegToRemove);
                    sPath = sPath.setDevice(name.getDevice());
                    if (Platform.getOS().equals("win32") ? sPath.toOSString().equalsIgnoreCase(name.toOSString()) : sPath.equals((Object)name)) {
                        list.add(rPath);
                    }
                    return false;
                }
                return true;
            }
        }, 0);
    }

    private static IPath[] resolveIncludeLink(IPath path) {
        IFile[] files;
        if (!CElementIncludeResolver.isInProject(path) && (files = ResourceLookup.findFilesForLocation((IPath)path)).length > 0) {
            IPath[] paths = new IPath[files.length];
            int i = 0;
            while (i < files.length) {
                paths[i] = files[i].getFullPath();
                ++i;
            }
            return paths;
        }
        return new IPath[]{path};
    }

    private static boolean isInProject(IPath path) {
        return CElementIncludeResolver.getWorkspaceRoot().getFileForLocation(path) != null;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

