/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DB2TableManager
extends SQLTableManager<DB2Table, DB2Schema>
implements DBEObjectRenamer<DB2Table> {
    private static final String NEW_TABLE_NAME = "NEW_TABLE";
    private static final String SQL_ALTER = "ALTER TABLE ";
    private static final String SQL_RENAME_TABLE = "RENAME TABLE %s TO %s";
    private static final String SQL_COMMENT = "COMMENT ON TABLE %s IS '%s'";
    private static final String CLAUSE_IN_TS = "IN ";
    private static final String CLAUSE_IN_TS_IX = "INDEX IN ";
    private static final String CLAUSE_IN_TS_LONG = "LONG IN ";
    private static final String CMD_ALTER = "Alter Table";
    private static final String CMD_COMMENT = "Comment on Table";
    private static final String CMD_RENAME = "Rename Table";
    private static final String LINE_SEPARATOR = GeneralUtils.getDefaultLineSeparator();
    private static final Class<?>[] CHILD_TYPES = new Class[]{DB2TableColumn.class, DB2TableUniqueKey.class, DB2TableForeignKey.class, DB2Index.class};

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public DBSObjectCache<DB2Schema, DB2Table> getObjectsCache(DB2Table object) {
        return object.getSchema().getTableCache();
    }

    public DB2Table createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object db2Schema, Object copyFrom, Map<String, Object> options) {
        DB2Table table = new DB2Table((DB2Schema)db2Schema, NEW_TABLE_NAME);
        this.setNewObjectName(monitor, (DB2Schema)db2Schema, table);
        return table;
    }

    public void appendTableModifiers(DBRProgressMonitor monitor, DB2Table db2Table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
        try {
            if (db2Table.getTablespace(monitor) != null) {
                ddl.append(LINE_SEPARATOR);
                ddl.append(CLAUSE_IN_TS);
                ddl.append(DB2TableManager.getTablespaceName(db2Table.getTablespace(monitor)));
            }
            if (db2Table.getIndexTablespace(monitor) != null) {
                ddl.append(LINE_SEPARATOR);
                ddl.append(CLAUSE_IN_TS_IX);
                ddl.append(DB2TableManager.getTablespaceName(db2Table.getIndexTablespace(monitor)));
            }
            if (db2Table.getLongTablespace(monitor) != null) {
                ddl.append(LINE_SEPARATOR);
                ddl.append(CLAUSE_IN_TS_LONG);
                ddl.append(DB2TableManager.getTablespaceName(db2Table.getLongTablespace(monitor)));
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
    }

    private static String getTablespaceName(Object tablespace) {
        if (tablespace instanceof DB2Tablespace) {
            return ((DB2Tablespace)tablespace).getName();
        }
        if (tablespace != null) {
            return String.valueOf(tablespace);
        }
        return null;
    }

    public void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        super.addStructObjectCreateActions(monitor, actions, command, options);
        DBEPersistAction commentAction = this.buildCommentAction((DB2Table)command.getObject());
        if (commentAction != null) {
            actions.add(commentAction);
        }
    }

    public void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        DBEPersistAction commentAction;
        DB2Table db2Table = (DB2Table)command.getObject();
        if (command.getProperties().size() > 1) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(SQL_ALTER);
            sb.append(db2Table.getFullyQualifiedName(DBPEvaluationContext.DDL));
            sb.append(" ");
            this.appendTableModifiers(monitor, (DB2Table)command.getObject(), (SQLObjectEditor.NestedObjectCommand)command, sb, true);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_ALTER, sb.toString()));
        }
        if ((commentAction = this.buildCommentAction(db2Table)) != null) {
            actionList.add(commentAction);
        }
    }

    public void addObjectRenameActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        String sql = String.format(SQL_RENAME_TABLE, String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)((DB2Table)command.getObject()).getSchema())) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)((DB2Table)command.getObject()).getDataSource(), (String)command.getOldName()), DBUtils.getQuotedIdentifier((DBPDataSource)((DB2Table)command.getObject()).getDataSource(), (String)command.getNewName()));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(CMD_RENAME, sql));
    }

    public void renameObject(DBECommandContext commandContext, DB2Table object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    private DBEPersistAction buildCommentAction(DB2Table db2Table) {
        if (CommonUtils.isNotEmpty((String)db2Table.getDescription())) {
            String commentSQL = String.format(SQL_COMMENT, db2Table.getFullyQualifiedName(DBPEvaluationContext.DDL), db2Table.getDescription());
            return new SQLDatabasePersistAction(CMD_COMMENT, commentSQL);
        }
        return null;
    }
}

