/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class ListCache<OWNER extends DBSObject, OBJECT extends DBSObject>
implements DBSObjectCache<OWNER, OBJECT> {
    @NotNull
    private final List<OBJECT> objectList;

    public ListCache(List<OBJECT> objectList) {
        this.objectList = objectList == null ? new ArrayList() : objectList;
    }

    @Override
    public Collection<OBJECT> getAllObjects(DBRProgressMonitor monitor, OWNER owner) throws DBException {
        return this.objectList;
    }

    @Override
    @NotNull
    public List<OBJECT> getCachedObjects() {
        return this.objectList;
    }

    @Override
    public OBJECT getObject(DBRProgressMonitor monitor, OWNER owner, String name) throws DBException {
        return (OBJECT)((DBSObject)DBUtils.findObject(this.objectList, name));
    }

    @Override
    @Nullable
    public OBJECT getCachedObject(@NotNull String name) {
        return (OBJECT)((DBSObject)DBUtils.findObject(this.objectList, name));
    }

    @Override
    public void cacheObject(@NotNull OBJECT object) {
        this.objectList.add(object);
    }

    @Override
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        this.objectList.remove(object);
    }

    @Override
    public void renameObject(@NotNull OBJECT object, @NotNull String oldName, @NotNull String newName) {
    }

    @Override
    public boolean isFullyCached() {
        return true;
    }

    @Override
    public void clearCache() {
        this.objectList.clear();
    }

    @Override
    public void setCache(List<OBJECT> objects) {
        this.objectList.clear();
        this.objectList.addAll(objects);
    }
}

