/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public abstract class JDBCStructureAssistant
implements DBSStructureAssistant {
    protected static final Log log = Log.getLog(JDBCStructureAssistant.class);

    protected abstract JDBCDataSource getDataSource();

    @Override
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    @Override
    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @Override
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    @Override
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    @Override
    @NotNull
    public List<DBSObjectReference> findObjectsByMask(DBRProgressMonitor monitor, DBSObject parentObject, DBSObjectType[] objectTypes, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults) throws DBException {
        ArrayList<DBSObjectReference> references = new ArrayList<DBSObjectReference>();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession(monitor, this.getDataSource(), ModelMessages.model_jdbc_find_objects_by_name);){
                DBSObjectType[] dBSObjectTypeArray = objectTypes;
                int n = objectTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSObjectType type = dBSObjectTypeArray[n2];
                    this.findObjectsByMask(session, type, parentObject, objectNameMask, caseSensitive, globalSearch, maxResults - references.size(), references);
                    if (references.size() >= maxResults) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException(ex, this.getDataSource());
        }
        return references;
    }

    protected abstract void findObjectsByMask(JDBCSession var1, DBSObjectType var2, DBSObject var3, String var4, boolean var5, boolean var6, int var7, List<DBSObjectReference> var8) throws DBException, SQLException;
}

